/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ExecTool;
import com.sun.javatest.exec.InterviewEditor;
import com.sun.javatest.exec.Session;
import com.sun.javatest.exec.SessionExt;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class BasicSession
implements SessionExt {
    public static final String CONFIG_NAME_PROP = "Configuration";
    public static final String WD_PROP = "WorkDir";
    static final String EL_FILTER = "ExcludeList";
    static final String PRIOR_FILTER = "PriorStatus";
    static final String KWD_FILTER = "Keywords";
    static final String RELEVANT_FILTER = "Relevant";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(BasicSession.class);
    private static int debug = Debug.getInt(ExecTool.class);
    protected final List<Session.Observer> observers = new ArrayList<Session.Observer>();
    protected final List<String> filterNames = new ArrayList<String>();
    protected final List<String> props = new ArrayList<String>();
    private final InterviewParameters config;
    private final ArrayList<Pair> queue = new ArrayList();
    private WorkDirectory wd;
    private boolean isSorted = false;
    private boolean isNotifying = false;

    public BasicSession(TestSuite ts) throws Session.Fault {
        this.initFilterList();
        this.initPropertyList();
        try {
            this.config = ts.createInterview();
        }
        catch (Exception e) {
            throw new Session.Fault(e);
        }
    }

    private static void logLoadTime(String res, long time, WorkDirectory wd, String msg) {
        if (wd == null) {
            return;
        }
        Logger log = null;
        try {
            log = wd.getTestSuite().createLog(wd, null, i18n.getString("exec.log.name"));
        }
        catch (TestSuite.DuplicateLogNameFault f) {
            try {
                log = wd.getTestSuite().getLog(wd, i18n.getString("exec.log.name"));
            }
            catch (TestSuite.NoSuchLogFault f2) {
                return;
            }
        }
        if (log != null) {
            Integer loadTime = (int)(time / 1000L);
            Object[] params = new Object[]{loadTime, msg};
            String output = i18n.getString(res, params);
            log.info(output);
            if (debug > 0) {
                Debug.println(output);
            }
        }
    }

    @Override
    public void update(Session.Update u) throws Session.Fault {
        this.update(u, true);
    }

    @Override
    public void update(Session.Update u, boolean updateConfig) throws Session.Fault {
        if (u instanceof U_NewWD) {
            this.updateWorkDir(((U_NewWD)u).wd, updateConfig);
        } else if (u instanceof U_NewConfig) {
            this.updateNewConfig(((U_NewConfig)u).ip);
        }
    }

    @Override
    public void addObserver(Session.Observer obs) {
        if (obs != null && !this.observers.contains(obs)) {
            this.observers.add(obs);
            this.isSorted = false;
        }
    }

    @Override
    public void removeObserver(Session.Observer obs) {
        if (obs != null && this.observers.contains(obs)) {
            this.observers.remove(obs);
        }
    }

    @Override
    public void notifyObservers(Session.Event evn) {
        if (!this.isSorted) {
            this.sortObservers();
        }
        for (Session.Observer obs : this.observers) {
            this.queue.add(new Pair(obs, evn));
        }
        this.notifyQueue();
    }

    private void notifyQueue() {
        boolean cont;
        if (this.isNotifying) {
            return;
        }
        this.isNotifying = true;
        boolean bl = cont = !this.queue.isEmpty();
        while (cont) {
            Pair pair = this.queue.remove(0);
            pair.obs.updated(pair.evn);
            cont = !this.queue.isEmpty();
        }
        this.isNotifying = false;
    }

    private void sortObservers() {
        this.observers.sort((o1, o2) -> {
            long order1 = 0L;
            if (o1 instanceof OrderedObserver) {
                order1 = ((OrderedObserver)o1).order();
            }
            long order2 = 0L;
            if (o2 instanceof OrderedObserver) {
                order2 = ((OrderedObserver)o2).order();
            }
            return (int)(order1 - order2);
        });
        this.isSorted = true;
    }

    public TestFilter getTestFilter(String name) {
        TestFilter tf;
        if (this.config == null) {
            throw new IllegalStateException(i18n.getString("bc.configNotReady.err"));
        }
        if (this.filterNames.contains(name) && (tf = this.findFilter(name)) != null) {
            return tf;
        }
        throw new IllegalArgumentException(i18n.getString("bc.unknownFilter.err", (Object)name));
    }

    protected TestFilter findFilter(String name) {
        if (EL_FILTER.equals(name)) {
            return this.config.getExcludeListFilter();
        }
        if (KWD_FILTER.equals(name)) {
            return this.config.getKeywordsFilter();
        }
        if (PRIOR_FILTER.equals(name)) {
            return this.config.getPriorStatusFilter();
        }
        if (RELEVANT_FILTER.equals(name)) {
            return this.config.getRelevantTestFilter();
        }
        return null;
    }

    public List<String> getTestFilterNames() {
        return this.filterNames;
    }

    @Override
    public void save(Map<String, String> map) {
        if (this.wd != null) {
            map.put("workDir", this.wd.getPath());
        }
        if (this.config != null && this.config.getFile() != null) {
            map.put("config", this.config.getFile().getPath());
        }
    }

    @Override
    public void restore(Map<String, String> map) throws Session.Fault {
        if (map == null) {
            return;
        }
        String wdPath = map.get("workDir");
        if (wdPath == null) {
            return;
        }
        try {
            WorkDirectory workDir = WorkDirectory.open(new File(wdPath), this.config.getTestSuite());
            this.updateWorkDir(workDir, false);
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (Exception e) {
            throw new Session.Fault(e);
        }
        String ipPath = map.get("config");
        if (ipPath == null) {
            return;
        }
        try {
            this.loadInterviewFromFile(this.wd, new File(ipPath));
        }
        catch (Exception e) {
            throw new Session.Fault(e);
        }
    }

    @Override
    public void loadInterviewFromFile(WorkDirectory wd, File cfgFile) throws Session.Fault {
        try {
            long start = System.currentTimeMillis();
            this.config.load(cfgFile);
            BasicSession.logLoadTime("exec.log.iload", System.currentTimeMillis() - start, wd, cfgFile.getAbsolutePath());
            this.config.setWorkDirectory(wd);
            this.notifyObservers(new E_NewConfig(this.config));
        }
        catch (Exception e) {
            throw new Session.Fault(e);
        }
    }

    @Override
    public void dispose() {
        this.config.dispose();
    }

    @Override
    public List<String> getPropertyNames() {
        return this.props;
    }

    @Override
    public String getValue(String name) {
        if (this.props.contains(name)) {
            if (WD_PROP.equals(name)) {
                return this.wd == null ? null : this.wd.getPath();
            }
            if (CONFIG_NAME_PROP.equals(name)) {
                if (this.config == null) {
                    return null;
                }
                File f = this.config.getFile();
                return f == null ? null : f.getPath();
            }
        }
        throw new IllegalArgumentException(i18n.getString("bc.unknownProperty.err", (Object)name));
    }

    @Override
    public WorkDirectory getWorkDirectory() {
        return this.wd;
    }

    @Override
    public InterviewParameters getInterviewParameters() {
        return this.config;
    }

    @Override
    public Parameters getParameters() {
        return this.getInterviewParameters();
    }

    @Override
    public boolean isReady() {
        return this.config != null && this.config.isFinishable() && this.config.getFile() != null;
    }

    protected void initFilterList() {
        this.filterNames.add(EL_FILTER);
        this.filterNames.add(PRIOR_FILTER);
        this.filterNames.add(KWD_FILTER);
        this.filterNames.add(RELEVANT_FILTER);
    }

    protected void initPropertyList() {
        this.props.add(WD_PROP);
        this.props.add(CONFIG_NAME_PROP);
    }

    protected void updateWorkDir(WorkDirectory wd, boolean doRestoreConfig) {
        if (this.wd == wd) {
            return;
        }
        if (this.wd != null) {
            throw new IllegalStateException(i18n.getString("bc.resetWorkDir.err"));
        }
        this.wd = wd;
        this.applyWorkDir(wd);
        this.notifyObservers(new E_NewWD(wd, doRestoreConfig));
    }

    protected void applyWorkDir(WorkDirectory wd) {
        if (this.config != null) {
            this.config.setWorkDirectory(wd);
        }
    }

    protected void updateNewConfig(InterviewParameters ip) throws Session.Fault {
        if (InterviewEditor.equal(ip, this.config) && ip.getFile() != null && ip.getFile().equals(this.config.getFile())) {
            return;
        }
        try {
            InterviewEditor.copy(ip, this.config);
        }
        catch (Exception e) {
            throw new Session.Fault(e);
        }
        this.notifyObservers(new E_NewConfig(this.config));
    }

    @Override
    public void reloadInterview() throws Session.Fault {
        this.ensureInterviewUpToDate();
    }

    void ensureInterviewUpToDate() throws Session.Fault {
        try {
            if (this.config.isFileNewer()) {
                this.config.load();
            }
        }
        catch (Exception e) {
            throw new Session.Fault(e);
        }
    }

    static class U_NewWD
    implements Session.Update {
        public final WorkDirectory wd;

        public U_NewWD(WorkDirectory wd) {
            this.wd = wd;
        }
    }

    public static class U_NewConfig
    implements Session.Update {
        public final InterviewParameters ip;

        public U_NewConfig(InterviewParameters ip) {
            this.ip = ip;
        }
    }

    private static class Pair {
        final Session.Observer obs;
        final Session.Event evn;

        Pair(Session.Observer obs, Session.Event evn) {
            this.obs = obs;
            this.evn = evn;
        }
    }

    public static class E_NewConfig
    implements Session.Event {
        public final InterviewParameters ip;

        public E_NewConfig(InterviewParameters ip) {
            this.ip = ip;
        }
    }

    public static class E_NewWD
    implements Session.Event {
        public final WorkDirectory wd;
        public final boolean doRestoreConfig;

        E_NewWD(WorkDirectory wd, boolean doRestoreConfig) {
            this.wd = wd;
            this.doRestoreConfig = doRestoreConfig;
        }
    }

    public static interface OrderedObserver
    extends Session.Observer {
        public int order();
    }
}

