/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.exec.MultiFormatPane;
import com.sun.javatest.tool.StringFitter;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URL;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class NavigationPane
extends JPanel {
    private static final int MAX_ROWS_DISPLAY = 20;
    private UIFactory uif;
    private String uiKey;
    private History history;
    private Action homeAction;
    private Action browseAction;
    private Action backAction;
    private Action forwardAction;
    private JButton homeBtn;
    private JButton backBtn;
    private JButton forwardBtn;
    private JComboBox<Object> selectBox;
    private DefaultComboBoxModel<Object> model;
    private Listener listener = new Listener();
    private JToolBar toolBar;
    private MultiFormatPane mediaPane;
    private URL homeURL;

    public NavigationPane(UIFactory uif, MultiFormatPane mediaPane) {
        if (mediaPane == null) {
            throw new IllegalArgumentException("Corresponding media pane should exist");
        }
        this.mediaPane = mediaPane;
        this.uif = uif;
        this.history = new History();
        this.initActions();
        this.initGUI();
        mediaPane.setNavigationPane(this);
    }

    public URL getHomeURL() {
        return this.homeURL;
    }

    public void setHomeURL(URL url) {
        this.homeURL = url;
        this.homeAction.setEnabled(true);
    }

    public void setURLs(URL ... urls) {
        if (this.model != null) {
            this.model.removeAllElements();
            this.homeURL = urls[0];
            this.homeAction.setEnabled(this.homeURL != null);
            for (URL url : urls) {
                this.model.addElement(url);
            }
            this.model.setSelectedItem(this.homeURL);
        }
    }

    public void processURL(URL url) {
        this.history.add(url);
        this.backAction.setEnabled(this.history.hasPrev());
        this.forwardAction.setEnabled(this.history.hasNext());
        this.updateCombo(url);
    }

    public void clear() {
        if (this.model != null) {
            this.model.removeAllElements();
        }
        this.history.clear();
        this.backAction.setEnabled(false);
        this.forwardAction.setEnabled(false);
        this.homeAction.setEnabled(false);
        this.homeURL = null;
    }

    private void initGUI() {
        this.uif.initPanel(this, "np", false);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        c.gridx = 0;
        c.gridy = 0;
        JLabel fileLbl = this.uif.createLabel("np.file", true);
        fileLbl.setFont(new Font("Monospaced", UIFactory.getBaseFont().getStyle(), UIFactory.getBaseFont().getSize()));
        this.add((Component)fileLbl, c);
        this.selectBox = this.uif.createChoice("np.choice", fileLbl);
        this.selectBox.setFont(new Font("Monospaced", UIFactory.getBaseFont().getStyle(), UIFactory.getBaseFont().getSize()));
        this.selectBox.setRenderer(new Renderer(this.selectBox));
        this.selectBox.setModel(this.createModel());
        this.selectBox.addItemListener(this.listener);
        this.selectBox.setMaximumRowCount(20);
        this.selectBox.setUI(new BasicComboBoxUI(){

            @Override
            protected ComboPopup createPopup() {
                return new BasicComboPopup(NavigationPane.this.selectBox){

                    @Override
                    protected JScrollPane createScroller() {
                        return new JScrollPane(this.list, 20, 30);
                    }
                };
            }
        });
        this.uif.setAccessibleName(this.selectBox, "np.choice");
        c.gridx = 1;
        c.weightx = 2.0;
        c.fill = 2;
        this.add(this.selectBox, c);
        this.browseAction.setEnabled(Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE));
        Action[] actions = new Action[]{this.backAction, this.forwardAction, null, this.homeAction, null, this.browseAction};
        this.toolBar = this.uif.createToolBar("np.toolbar", actions);
        this.toolBar.setFloatable(false);
        c.weightx = 0.0;
        c.gridx = 2;
        c.insets.left = 5;
        this.add((Component)this.toolBar, c);
    }

    private void initActions() {
        this.homeAction = new ToolAction(this.uif, "np.home", true){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NavigationPane.this.homeURL == null) {
                    NavigationPane.this.mediaPane.setDefaultView();
                } else {
                    NavigationPane.this.mediaPane.stopAudio();
                    NavigationPane.this.mediaPane.loadPage(NavigationPane.this.homeURL);
                }
            }
        };
        this.browseAction = new ToolAction(this.uif, "np.browse", true){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(((URL)NavigationPane.this.model.getSelectedItem()).toURI());
                }
                catch (Exception ex) {
                    NavigationPane.this.uif.showError("np.browse", NavigationPane.this.model.getSelectedItem());
                }
            }
        };
        this.backAction = new ToolAction(this.uif, "np.back", true){

            @Override
            public void actionPerformed(ActionEvent e) {
                URL url = NavigationPane.this.history.prev();
                if (url != null) {
                    NavigationPane.this.mediaPane.stopAudio();
                    NavigationPane.this.mediaPane.loadPage(url);
                }
            }
        };
        this.forwardAction = new ToolAction(this.uif, "np.forward", true){

            @Override
            public void actionPerformed(ActionEvent e) {
                URL url = NavigationPane.this.history.next();
                if (url != null) {
                    NavigationPane.this.mediaPane.stopAudio();
                    NavigationPane.this.mediaPane.loadPage(url);
                }
            }
        };
    }

    private DefaultComboBoxModel<Object> createModel() {
        if (this.model == null) {
            this.model = new DefaultComboBoxModel();
        }
        return this.model;
    }

    private void updateCombo(URL s) {
        if (this.model.getIndexOf(s) < 0) {
            this.model.addElement(s);
        }
        URL item = (URL)this.selectBox.getSelectedItem();
        if (s != null && !item.toString().equals(s.toString())) {
            this.selectBox.setSelectedItem(s);
        }
    }

    private static class History {
        private Vector<URL> entries = new Vector();
        private int index;

        private History() {
        }

        boolean hasPrev() {
            return this.index > 0;
        }

        URL prev() {
            if (this.index == 0) {
                return null;
            }
            return this.entries.get(--this.index);
        }

        boolean hasNext() {
            return this.index < this.entries.size() - 1;
        }

        URL next() {
            if (this.index == this.entries.size() - 1) {
                return null;
            }
            return this.entries.get(++this.index);
        }

        void add(URL u) {
            if (u == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.entries.size() && this.entries.get(this.index).equals(u)) {
                return;
            }
            if (this.index < this.entries.size() - 1) {
                this.entries.setSize(this.index + 1);
            }
            this.entries.add(u);
            this.index = this.entries.size() - 1;
        }

        void clear() {
            this.entries.clear();
            this.index = -1;
        }
    }

    private class Listener
    implements ItemListener {
        private Listener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                NavigationPane.this.mediaPane.stopAudio();
                URL url = (URL)e.getItem();
                NavigationPane.this.mediaPane.loadPage(url);
            }
        }
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private Container container;
        private StringFitter sf;

        public Renderer() {
            this.setPreferredSize(new JLabel("MinSize").getPreferredSize());
        }

        public Renderer(Container container) {
            this.setPreferredSize(new JLabel("MinSize").getPreferredSize());
            this.container = container;
            this.sf = new StringFitter(this.getFontMetrics(this.getFont()));
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object o, int index, boolean isSelected, boolean cellHasFocus) {
            String name = null;
            if (o instanceof URL) {
                URL url = (URL)o;
                if (!url.getProtocol().equals("file")) {
                    name = url.toString();
                } else {
                    name = this.extractPrefix(url.toString(), "file:");
                    String baseName = null;
                    name = new File(name).getAbsolutePath();
                    File baseDir = NavigationPane.this.mediaPane.getBaseDirectory();
                    if (baseDir != null && baseDir.getParentFile() != null) {
                        baseName = baseDir.getParentFile().getAbsolutePath();
                    }
                    if (baseName != null && name.startsWith(baseName) && name.length() > baseName.length() && (name = name.substring(baseName.length())).startsWith(File.separator)) {
                        name = name.substring(1);
                    }
                }
            } else {
                name = String.valueOf(o);
            }
            JLabel cell = (JLabel)super.getListCellRendererComponent(list, name, index, isSelected, cellHasFocus);
            if (this.container != null) {
                cell.setText(this.sf.truncateBeginning(name, this.container.getWidth() - 17));
            }
            cell.setToolTipText(name);
            return cell;
        }

        private String extractPrefix(String origStr, String target) {
            return !origStr.startsWith(target) ? origStr : origStr.substring(target.length());
        }
    }
}

