/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.asmutils;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.openjdk.asmtools.Main;
import org.openjdk.asmtools.asmutils.HexUtils;

public class StringUtils {
    public static final char[] hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static BiFunction<String, List<String>, Boolean> endWith = (str, list) -> {
        for (String suffix : list) {
            if (!str.endsWith(suffix)) continue;
            return true;
        }
        return false;
    };
    public static BiFunction<String, List<String>, Boolean> contains = (str, list) -> {
        for (String substr : list) {
            if (!str.contains(substr)) continue;
            return true;
        }
        return false;
    };

    public static String removeCommentFrom(String str) {
        String[] list;
        int idx = ((String)str).indexOf("//");
        if (idx != -1 && ((String)(str = ((String)str).substring(0, idx--))).charAt(idx) == ' ') {
            str = ((String)str).substring(0, idx);
        }
        if ((list = ((String)str).split("\\/\\*.*?\\*\\/")).length > 1) {
            str = "";
            for (int i = 0; i < list.length; ++i) {
                idx = list[i].length() - 1;
                if (list[i].charAt(idx) == ' ') {
                    str = (String)str + list[i].substring(0, idx);
                    continue;
                }
                str = (String)str + list[i];
                idx = i + 1;
                if (idx >= list.length || list[idx].charAt(0) != ' ') continue;
                list[idx] = list[idx].substring(1);
            }
        }
        return str;
    }

    public static String Utf8ToString(String utf8, String ... enclosingString) {
        String leftBracket = enclosingString.length > 0 ? enclosingString[0] : "";
        String rightBracket = enclosingString.length > 1 ? enclosingString[1] : leftBracket;
        StringBuilder sb = new StringBuilder(leftBracket);
        block10: for (int k = 0; k < utf8.length(); ++k) {
            char c = utf8.charAt(k);
            switch (c) {
                case '\t': {
                    sb.append('\\').append('t');
                    continue block10;
                }
                case '\n': {
                    sb.append('\\').append('n');
                    continue block10;
                }
                case '\r': {
                    sb.append('\\').append('r');
                    continue block10;
                }
                case '\b': {
                    sb.append('\\').append('b');
                    continue block10;
                }
                case '\f': {
                    sb.append('\\').append('f');
                    continue block10;
                }
                case '\"': {
                    sb.append('\\').append('\"');
                    continue block10;
                }
                case '\'': {
                    sb.append('\\').append('\'');
                    continue block10;
                }
                case '\\': {
                    sb.append('\\').append('\\');
                    continue block10;
                }
                default: {
                    sb.append(Character.isISOControl(c) ? String.format("\\u%04x", c) : Character.valueOf(c));
                }
            }
        }
        return sb.append(rightBracket).toString();
    }

    public static boolean isOneOf(int i, char ... list) {
        char ch = (char)i;
        for (char c : list) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readUtf8String(DataInputStream in, int length, int CHARS_IN_LINE) throws IOException {
        ArrayList<String> list;
        block16: {
            int BYTES_IN_LINE = CHARS_IN_LINE / 6 + 1;
            list = new ArrayList<String>();
            ArrayList byteLines = new ArrayList(){
                {
                    this.add(new StringBuilder());
                }
            };
            StringBuilder sb = (StringBuilder)byteLines.get(0);
            byte[] buffer = new byte[length];
            String utfString = null;
            int count = 0;
            try {
                for (int i = 0; i < length; ++i) {
                    byte b;
                    buffer[i] = b = in.readByte();
                    ++count;
                    sb.append("0x").append(hexTable[b >> 4 & 0xF]).append(hexTable[b & 0xF]);
                    if (i % BYTES_IN_LINE == BYTES_IN_LINE - 1) {
                        sb = new StringBuilder();
                        byteLines.add(sb);
                        continue;
                    }
                    if (i + 1 == length) continue;
                    sb.append(" ");
                }
                if (count <= 0) break block16;
                try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buffer));){
                    utfString = DataInputStream.readUTF(dis);
                }
                catch (UTFDataFormatException utfDataFormatException) {
                    byteLines.add(0, new StringBuilder(String.format("// == %s ==", Main.sharedI18n.getString("main.error.wrong.utf8"))));
                }
                catch (IOException utfDataFormatException) {
                    // empty catch block
                }
            }
            finally {
                if (count > 0) {
                    List<String> utf8Lines = StringUtils.getPrintable(utfString, CHARS_IN_LINE);
                    if (utf8Lines != null) {
                        utf8Lines.stream().forEach(s -> list.add(s.startsWith("// ==") ? s : String.format("\"%s\";", s)));
                    } else {
                        byteLines.stream().map(s -> s.toString()).forEach(s -> list.add(s.startsWith("// ==") ? s : String.format("%s;", s)));
                    }
                }
            }
        }
        return list;
    }

    public static List<String> getPrintable(byte[] buffer, int CHARS_IN_LINE) {
        List<String> list = null;
        try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buffer));){
            String str = dis.readUTF();
            list = StringUtils.getPrintable(str, CHARS_IN_LINE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    public static List<String> getPrintable(String rawString, int CHARS_IN_LINE) {
        String formattedStr;
        ArrayList<String> list = null;
        if (rawString != null && (formattedStr = StringUtils.Utf8ToString(rawString, new String[0])).chars().filter(c -> !StringUtils.isPrintableChar((char)c)).findAny().isEmpty()) {
            int length = formattedStr.length();
            list = new ArrayList<String>();
            for (int i = 0; i < length; i += CHARS_IN_LINE) {
                int idx = Math.min(length, i + CHARS_IN_LINE);
                String item = formattedStr.substring(i, idx);
                if (item.endsWith("\\") && !item.endsWith("\\\\")) {
                    item = item.concat(formattedStr.substring(idx, idx + 1));
                    ++i;
                }
                list.add(item);
            }
        }
        return list;
    }

    public static String mapToHexString(int[] array) {
        return String.format("{%s}", Arrays.stream(array).mapToObj(HexUtils::toHex).collect(Collectors.joining(", ")));
    }

    public static String repeat(String str, int count) {
        return count <= 0 ? "" : new String(new char[count]).replace("\u0000", str);
    }

    public static boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }
}

