/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.asmutils.StringUtils;
import org.openjdk.asmtools.common.EMessageKind;
import org.openjdk.asmtools.common.ILogger;
import org.openjdk.asmtools.common.ToolLogger;
import org.openjdk.asmtools.common.inputs.ToolInput;
import org.openjdk.asmtools.common.outputs.ToolOutput;
import org.openjdk.asmtools.common.outputs.log.DualStreamToolOutput;

public class CompilerLogger
extends ToolLogger
implements ILogger {
    private final Map<Integer, Set<ToolLogger.Message>> container = new HashMap<Integer, Set<ToolLogger.Message>>();
    private final List<String> fileContent = new ArrayList<String>();

    public CompilerLogger(String programName, Class<?> cls, DualStreamToolOutput outerLog) {
        super(programName, cls, outerLog);
    }

    @Override
    public void warning(int where, String id, Object ... args) {
        ToolLogger.Message message = this.getResourceString(EMessageKind.WARNING, id, args);
        if (message.notFound()) {
            if (EMessageKind.isFromResourceBundle(id)) {
                this.insert(Integer.MAX_VALUE, new ToolLogger.Message(EMessageKind.ERROR, "(I18NResourceBundle) The warning message '%s' not found", id));
            } else {
                this.insert(where, new ToolLogger.Message(this.strictWarnings ? EMessageKind.ERROR : EMessageKind.WARNING, args.length == 0 ? id : String.format(id, args)));
            }
        } else {
            this.insert(where, this.strictWarnings ? new ToolLogger.Message(EMessageKind.ERROR, message.text()) : message);
        }
    }

    @Override
    public void error(int where, String id, Object ... args) {
        ToolLogger.Message message = this.getResourceString(EMessageKind.ERROR, id, args);
        if (message.notFound()) {
            if (EMessageKind.isFromResourceBundle(id)) {
                this.insert(Integer.MAX_VALUE, new ToolLogger.Message(EMessageKind.ERROR, "(I18NResourceBundle) The error message '%s' not found", id));
            } else {
                this.insert(where, new ToolLogger.Message(EMessageKind.ERROR, args.length == 0 ? id : String.format(id, args)));
            }
        } else {
            this.insert(where, message);
        }
    }

    @Override
    public String getInfo(String id, Object ... args) {
        String message = this.getResourceString(id, args);
        if (message == null) {
            if (EMessageKind.isFromResourceBundle(id)) {
                this.printErrorLn("(I18NResourceBundle) The info message '%s' not found", id);
            } else {
                this.println(id, args);
            }
        }
        return message;
    }

    @Override
    public void usage(List<String> usageIDs) {
        for (String id : usageIDs) {
            String s = id.equals("info.opt.cv") ? this.getInfo(id, 45, 3) : this.getInfo(id, new Object[0]);
            if (s == null) continue;
            Matcher m = usagePattern.matcher(s);
            if (m.find()) {
                this.println(String.format("  %-35s %s", m.group(1).trim(), m.group(2).trim()), new Object[0]);
                continue;
            }
            this.println(s, new Object[0]);
        }
    }

    @Override
    public void setInputFileName(ToolInput inputFileName) throws IOException {
        super.setInputFileName(inputFileName);
        this.fileContent.clear();
        this.fileContent.addAll(inputFileName.readAllLines());
    }

    Pair<Integer, Integer> filePosition(int where) {
        if (where == Integer.MAX_VALUE || this.fileContent.isEmpty()) {
            return null;
        }
        int lineNumber = this.lineNumber(where);
        int absPos = where & 0x7FFFF;
        int lineOffset = absPos - (this.fileContent.subList(0, lineNumber - 1).stream().mapToInt(String::length).sum() + lineNumber - 1);
        return new Pair<Integer, Integer>(lineNumber, lineOffset);
    }

    public int lineNumber(int where) {
        return where >>> 19;
    }

    public long getCount(EMessageKind kind) {
        return this.noMessages() ? 0L : this.container.values().stream().flatMap(Collection::stream).filter(m -> m.kind() == kind).count();
    }

    public boolean noMessages() {
        return this.container.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int flush(boolean printTotals) {
        DualStreamToolOutput totalOutput;
        if (this.noMessages()) {
            return 0;
        }
        int nErrors = 0;
        int nWarnings = 0;
        ArrayList<Map.Entry<Integer, Set<ToolLogger.Message>>> list = new ArrayList<Map.Entry<Integer, Set<ToolLogger.Message>>>(this.container.entrySet());
        list.sort(Map.Entry.comparingByKey());
        ToolOutput output = this.getOutputs().getSToolObject();
        for (Map.Entry toolOutput : list) {
            int where = (Integer)toolOutput.getKey();
            Pair<Integer, Integer> filePosition = this.filePosition(where);
            for (ToolLogger.Message msg : (Set)toolOutput.getValue()) {
                if (msg.kind() == EMessageKind.WARNING && this.ignoreWarnings) continue;
                if (msg.kind() == EMessageKind.ERROR) {
                    output = this.getOutputs().getEToolObject();
                    ++nErrors;
                }
                nWarnings += msg.kind() == EMessageKind.WARNING ? 1 : 0;
                if (where == Integer.MAX_VALUE) {
                    output.printlns(msg.text());
                    continue;
                }
                output.printlns(String.format("%s (%d:%d) %s", this.getSimpleInputFileName(), filePosition.first, filePosition.second, msg.text()));
                this.printAffectedSourceLine(output, filePosition);
            }
        }
        DualStreamToolOutput dualStreamToolOutput = totalOutput = printTotals ? this.getOutputs() : null;
        if (printTotals) {
            if (nWarnings != 0) {
                totalOutput.printe(String.format("%d warning(s)%s", nWarnings, nErrors != 0 ? ", " : "\n"));
            }
            if (nErrors != 0) {
                totalOutput.printlne(String.format("%d error(s)", nErrors));
            }
        }
        ToolOutput toolOutput = output;
        synchronized (toolOutput) {
            output.flush();
            if (totalOutput != null) {
                totalOutput.flush();
            }
            this.container.clear();
        }
        return nErrors;
    }

    private void printAffectedSourceLine(ToolOutput output, Pair<Integer, Integer> filePosition) {
        String line = this.fileContent.get((Integer)filePosition.first - 1);
        long countOfExtraSpaces = line.chars().filter(ch -> ch == 9).count();
        long linePosition = (long)((Integer)filePosition.second).intValue() + countOfExtraSpaces * (long)TAB_REPLACEMENT.length() - countOfExtraSpaces;
        line = line.replace("\t", TAB_REPLACEMENT);
        output.printlns(line);
        output.printlns(StringUtils.repeat(" ", (int)linePosition) + "^");
    }

    private void insert(int where, ToolLogger.Message message) {
        if (where != Integer.MAX_VALUE && this.fileContent.isEmpty()) {
            this.addToContainer(Integer.MAX_VALUE, new ToolLogger.Message(EMessageKind.ERROR, ToolLogger.EMessageFormatter.LONG.apply(EMessageKind.ERROR, this.getProgramName(), "Content of the file %s not found", this.getSimpleInputFileName())));
            where = Integer.MAX_VALUE;
        }
        this.addToContainer(where, new ToolLogger.Message(message.kind(), where == Integer.MAX_VALUE ? ToolLogger.EMessageFormatter.VERBOSE.apply(this.getProgramName(), message) : ToolLogger.EMessageFormatter.LONG.apply(this.getProgramName(), message)));
    }

    private void addToContainer(int where, ToolLogger.Message msg) {
        Set<ToolLogger.Message> messages = this.container.get(where);
        if (messages != null) {
            messages.add(msg);
        } else {
            HashSet<ToolLogger.Message> msgSet = new HashSet<ToolLogger.Message>(1);
            msgSet.add(msg);
            this.container.put(where, msgSet);
        }
    }
}

