/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common;

import java.util.List;
import java.util.regex.Matcher;
import org.openjdk.asmtools.common.EMessageKind;
import org.openjdk.asmtools.common.ILogger;
import org.openjdk.asmtools.common.ToolLogger;
import org.openjdk.asmtools.common.outputs.log.DualStreamToolOutput;

public class DecompilerLogger
extends ToolLogger
implements ILogger {
    public DecompilerLogger(String programName, Class cls, DualStreamToolOutput outerLog) {
        super(programName, cls, outerLog);
    }

    @Override
    public void usage(List<String> usageIDs) {
        for (String id : usageIDs) {
            String s = this.getInfo(id, new Object[0]);
            if (s == null) continue;
            Matcher m = usagePattern.matcher(s);
            if (m.find()) {
                this.println(String.format("  %-21s %s", m.group(1).trim(), m.group(2).trim()), new Object[0]);
                continue;
            }
            this.println(s, new Object[0]);
        }
    }

    @Override
    public void printErrorLn(String format, Object ... args) {
        super.printErrorLn(args == null || args.length == 0 ? format : String.format(format, args), new Object[0]);
    }

    @Override
    public void error(Throwable exception) {
        super.printErrorLn(ToolLogger.EMessageFormatter.VERBOSE.apply(super.getProgramName(), new ToolLogger.Message(EMessageKind.ERROR, super.getProgramName(), exception.getMessage())), new Object[0]);
    }

    @Override
    public void warning(String id, Object ... args) {
        String message = this.getResourceString(id, args);
        if (message == null) {
            if (EMessageKind.isFromResourceBundle(id)) {
                this.printErrorLn(ToolLogger.EMessageFormatter.VERBOSE.apply(EMessageKind.ERROR, "(I18NResourceBundle) The warning message '%s' not found", id, new Object[0]), new Object[0]);
            } else {
                this.println(ToolLogger.EMessageFormatter.LONG.apply(EMessageKind.WARNING, super.getProgramName(), String.format(id, args), new Object[0]), new Object[0]);
            }
        } else {
            this.println(ToolLogger.EMessageFormatter.LONG.apply(EMessageKind.WARNING, super.getProgramName(), message, new Object[0]), new Object[0]);
        }
    }

    @Override
    public void error(String id, Object ... args) {
        String message = this.getResourceString(id, args);
        if (message == null) {
            if (EMessageKind.isFromResourceBundle(id)) {
                this.printErrorLn(ToolLogger.EMessageFormatter.VERBOSE.apply(EMessageKind.ERROR, super.getProgramName(), "(I18NResourceBundle) The error message '%s' not found", id), new Object[0]);
            } else {
                this.printErrorLn(ToolLogger.EMessageFormatter.VERBOSE.apply(EMessageKind.ERROR, super.getProgramName(), String.format(id, args), new Object[0]), new Object[0]);
            }
        } else {
            this.printErrorLn(ToolLogger.EMessageFormatter.VERBOSE.apply(EMessageKind.ERROR, super.getProgramName(), message, new Object[0]), new Object[0]);
        }
    }

    @Override
    public String getInfo(String id, Object ... args) {
        String message = this.getResourceString(id, args);
        if (message == null) {
            if (EMessageKind.isFromResourceBundle(id)) {
                this.printErrorLn(ToolLogger.EMessageFormatter.VERBOSE.apply(EMessageKind.ERROR, super.getProgramName(), "(I18NResourceBundle) The error message '%s' not found", id), new Object[0]);
            } else {
                this.println(id, args);
            }
        }
        return message;
    }
}

