/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.openjdk.asmtools.Main;
import org.openjdk.asmtools.common.EMessageKind;
import org.openjdk.asmtools.common.ILogger;
import org.openjdk.asmtools.common.inputs.ToolInput;
import org.openjdk.asmtools.common.outputs.log.DualStreamToolOutput;
import org.openjdk.asmtools.util.I18NResourceBundle;

public abstract class ToolLogger
implements ILogger {
    protected boolean ignoreWarnings = false;
    protected boolean strictWarnings = false;
    private final String programName;
    private ToolResources toolResources;
    DualStreamToolOutput outerLog;
    private String inputFileName;
    private String simpleInputFileName;

    public ToolLogger(String programName, Class cls, DualStreamToolOutput outerLog) {
        this.toolResources = new ToolResources(programName, cls);
        this.programName = programName;
        this.outerLog = outerLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getResourceString(String id, Object ... args) {
        String resString;
        this.toolResources.setWarn(false);
        try {
            resString = this.toolResources.getString(id, args);
        }
        finally {
            this.toolResources.setWarn(true);
        }
        if (resString == null || resString.equals(id)) {
            resString = Main.sharedI18n.getString(id, args);
        }
        if (resString == null || resString.equals(id)) {
            resString = this.toolResources.getString(id, args);
        }
        return resString;
    }

    public void setInputFileName(ToolInput inputFileName) throws IOException {
        this.inputFileName = inputFileName.getFileName();
        this.simpleInputFileName = Paths.get(inputFileName.getFileName(), new String[0]).getFileName().toString();
    }

    public Message getResourceString(EMessageKind kind, String id, Object ... args) {
        for (String prefix : Set.of("", kind.prefix)) {
            String str;
            if (!this.toolResources.containsKey(prefix + id) && !Main.sharedI18n.containsKey(prefix + id) || (str = this.getResourceString(id, args)) == null) continue;
            return new Message(kind, str);
        }
        return new Message(EMessageKind.ERROR, null);
    }

    @Override
    public DualStreamToolOutput getOutputs() {
        return this.outerLog;
    }

    @Override
    public void setOutputs(DualStreamToolOutput nwoutput) {
        this.outerLog = nwoutput;
    }

    public String getSimpleInputFileName() {
        return this.simpleInputFileName;
    }

    @Override
    public void printException(Throwable throwable) {
        this.getOutputs().stacktrace(throwable);
    }

    public String getProgramName() {
        return this.programName;
    }

    public abstract void usage(List<String> var1);

    static {
        Main.sharedI18n.setWarn(false);
    }

    class ToolResources {
        private static final HashMap<String, I18NResourceBundle> resources = new HashMap();

        public ToolResources(String programName, Class cls) {
            if (!resources.containsKey(programName)) {
                resources.put(programName, I18NResourceBundle.getBundleForClass(cls));
            }
        }

        public void setWarn(boolean value) {
            resources.get(ToolLogger.this.programName).setWarn(value);
        }

        public String getString(String id, Object ... args) {
            return resources.get(ToolLogger.this.programName).getString(id, args);
        }

        public boolean containsKey(String key) {
            return resources.get(ToolLogger.this.programName).containsKey(key);
        }
    }

    public record Message(EMessageKind kind, String text) {
        Message(EMessageKind kind, String format, Object ... args) {
            this(kind, String.format(format, args));
        }

        public boolean notFound() {
            return this.kind == EMessageKind.ERROR && this.text == null;
        }
    }

    public static enum EMessageFormatter {
        SHORT((severity, name, message) -> String.format("%s", message)),
        LONG((severity, name, message) -> String.format("%s: %s", severity.longForm(), message)),
        VERBOSE((severity, name, message) -> severity == EMessageKind.INFO ? message : String.format("%-7s-%6s: %s", name, severity.shortForm(), message));

        private final TriFunction<EMessageKind, String, String, String> triFunc;

        private EMessageFormatter(TriFunction<EMessageKind, String, String, String> func) {
            this.triFunc = func;
        }

        public String apply(EMessageKind kind, String name, String format, Object ... args) {
            return this.triFunc.apply(kind, name, String.format(format, args));
        }

        public String apply(String name, Message message) {
            return message.notFound() ? "" : this.triFunc.apply(message.kind(), name, message.text());
        }
    }

    @FunctionalInterface
    private static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }
}

