/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common.inputs;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.openjdk.asmtools.common.Environment;
import org.openjdk.asmtools.common.inputs.ToolInput;

public class ByteInput
implements ToolInput {
    protected byte[] bytes;

    public ByteInput(byte[] bytes) {
        this.bytes = bytes;
    }

    protected ByteInput() {
    }

    @Override
    public String getFileName() {
        return "bytes/bytes";
    }

    public String toString() {
        return this.getFileName();
    }

    protected void init() {
    }

    @Override
    public DataInputStream getDataInputStream(Optional<Environment> logger) throws URISyntaxException, IOException {
        this.init();
        return new DataInputStream(new ByteArrayInputStream(this.bytes));
    }

    @Override
    public Collection<String> readAllLines() throws IOException {
        this.init();
        ArrayList<String> resultingLines = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.bytes), "utf-8"));){
            String l;
            while ((l = br.readLine()) != null) {
                resultingLines.add(l);
            }
        }
        return resultingLines;
    }
}

