/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common.inputs;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Optional;
import org.openjdk.asmtools.common.Environment;
import org.openjdk.asmtools.common.inputs.ToolInput;

public class FileInput
implements ToolInput {
    private final String file;

    public FileInput(String file) {
        this.file = file;
    }

    @Override
    public String getFileName() {
        return this.file;
    }

    @Override
    public Collection<String> readAllLines() throws IOException {
        return Files.readAllLines(Paths.get(this.getFileName(), new String[0]));
    }

    @Override
    public DataInputStream getDataInputStream(Optional<Environment> logger) throws URISyntaxException, IOException {
        try {
            return new DataInputStream(new FileInputStream(this.getFileName()));
        }
        catch (IOException ex) {
            if (this.getFileName().matches("^[A-Za-z]+:.*")) {
                try {
                    URI uri = new URI(this.getFileName());
                    URL url = uri.toURL();
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    return new DataInputStream(conn.getInputStream());
                }
                catch (IOException | URISyntaxException exception) {
                    if (logger.isPresent()) {
                        logger.get().error("err.cannot.read", this.getFileName());
                    }
                    throw exception;
                }
            }
            throw ex;
        }
    }

    public String toString() {
        return this.getFileName();
    }
}

