/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common.outputs;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.FileSystems;
import java.util.Optional;
import org.openjdk.asmtools.common.Environment;
import org.openjdk.asmtools.common.outputs.NamedToolOutput;

public class DirOutput
extends NamedToolOutput {
    private final File dir;
    private File outfile;
    private FileOutputStream fos;
    private PrintWriter pw;

    public DirOutput(File dir) {
        this.dir = dir;
    }

    public String toString() {
        return super.toString() + " to " + this.dir;
    }

    @Override
    public void printlns(String line) {
        this.pw.println(line);
    }

    @Override
    public void prints(String line) {
        this.pw.print(line);
    }

    @Override
    public void prints(char line) {
        this.pw.print(line);
    }

    @Override
    public void startClass(String fqn, Optional<String> fileExtension, Environment environment) throws IOException {
        super.startClass(fqn, fileExtension, environment);
        String fileSeparator = FileSystems.getDefault().getSeparator();
        if (this.dir == null) {
            int startOfName = fqn.lastIndexOf(fileSeparator);
            if (startOfName != -1) {
                fqn = fqn.substring(startOfName + 1);
            }
            this.outfile = new File(fqn + fileExtension.orElseGet(() -> ""));
        } else {
            environment.traceln("writing -d " + this.dir.getPath(), new Object[0]);
            fqn = fqn.replace("/", fileSeparator);
            this.outfile = new File(this.dir, fqn + fileExtension.orElseGet(() -> ""));
            File outDir = new File(this.outfile.getParent());
            if (!outDir.exists() && !outDir.mkdirs()) {
                environment.error("err.cannot.write", outDir.getPath());
                return;
            }
        }
        this.fos = new FileOutputStream(this.outfile);
        this.pw = new PrintWriter(new OutputStreamWriter(this.fos));
    }

    @Override
    public void finishClass(String fqn) throws IOException {
        super.finishClass(fqn);
        this.flush();
        try {
            this.pw.close();
        }
        finally {
            this.fos.close();
        }
    }

    @Override
    public void flush() {
        try {
            this.fos.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public DataOutputStream getDataOutputStream() throws FileNotFoundException {
        return new DataOutputStream(new BufferedOutputStream(this.fos));
    }
}

