/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common.structure;

public class CFVersion {
    public static final int DEFAULT_MAJOR_VERSION = 45;
    public static final int DEFAULT_MINOR_VERSION = 3;
    public static final int DEFAULT_MODULE_MAJOR_VERSION = 53;
    public static final int DEFAULT_MODULE_MINOR_VERSION = 0;
    public static final int UNDEFINED_VERSION = -1;
    public static final int SPLIT_VERIFIER_CFV = 50;
    private int major_version;
    private int minor_version;
    private int threshold_major_version;
    private int threshold_minor_version;
    private boolean frozen = false;
    private boolean isSetByParameter;

    public CFVersion() {
        this.isSetByParameter = false;
        this.major_version = -1;
        this.minor_version = -1;
        this.threshold_major_version = -1;
        this.threshold_minor_version = -1;
    }

    public CFVersion(int major_version, int minor_version) {
        this.major_version = major_version;
        this.minor_version = minor_version;
    }

    public CFVersion setFrozen(boolean frozen) {
        this.frozen = frozen;
        return this;
    }

    public CFVersion setThreshold(int major_version, int minor_version) {
        this.threshold_major_version = major_version;
        this.threshold_minor_version = minor_version;
        return this;
    }

    public CFVersion setVersion(int major_version, int minor_version) {
        this.major_version = major_version;
        this.minor_version = minor_version;
        return this;
    }

    public CFVersion setFileVersion(int major_version, int minor_version) {
        if (this.isSet() && this.isFrozen()) {
            if (this.isThresholdSet()) {
                if (major_version < this.threshold_major_version || major_version == this.threshold_major_version && minor_version < this.threshold_minor_version) {
                    return this;
                }
            } else {
                return this;
            }
        }
        this.major_version = major_version;
        this.minor_version = minor_version;
        return this;
    }

    public CFVersion setMajorVersion(int major_version) {
        if (!this.frozen) {
            this.major_version = major_version;
        }
        return this;
    }

    public CFVersion setMinorVersion(int minor_version) {
        if (!this.frozen) {
            this.minor_version = minor_version;
        }
        return this;
    }

    public CFVersion setByParameter(boolean parameter) {
        this.isSetByParameter = parameter;
        return this;
    }

    public boolean isSet() {
        return this.major_version != -1 && this.minor_version != -1;
    }

    public boolean isThresholdSet() {
        return this.threshold_major_version != -1 && this.threshold_minor_version != -1;
    }

    public boolean isSetByParameter() {
        return this.isSetByParameter;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public String asString() {
        return String.format("%s:%s", this.major_version == -1 ? "(undef)" : Integer.valueOf(this.major_version), this.minor_version == -1 ? "(undef)" : Integer.valueOf(this.minor_version));
    }

    public String asThresholdString() {
        return String.format("%s:%s-%s:%s", this.threshold_major_version == -1 ? "(undef)" : Integer.valueOf(this.threshold_major_version), this.threshold_minor_version == -1 ? "(undef)" : Integer.valueOf(this.threshold_minor_version), this.major_version == -1 ? "(undef)" : Integer.valueOf(this.major_version), this.minor_version == -1 ? "(undef)" : Integer.valueOf(this.minor_version));
    }

    public boolean isTypeCheckingVerifier() {
        return this.isSet() ? this.major_version >= 50 : false;
    }

    public CFVersion initModuleDefaultVersion() {
        this.major_version = this.major_version == -1 ? 53 : this.major_version;
        this.minor_version = this.minor_version == -1 ? 0 : this.minor_version;
        return this;
    }

    public CFVersion initClassDefaultVersion() {
        this.major_version = this.major_version == -1 ? 45 : this.major_version;
        this.minor_version = this.minor_version == -1 ? 3 : this.minor_version;
        return this;
    }

    public static CFVersion copyOf(CFVersion cfv) {
        CFVersion cfVersion = new CFVersion();
        cfVersion.major_version = cfv.major_version;
        cfVersion.minor_version = cfv.minor_version;
        cfVersion.threshold_major_version = cfv.threshold_major_version;
        cfVersion.threshold_minor_version = cfv.threshold_minor_version;
        cfVersion.isSetByParameter = cfv.isSetByParameter;
        cfVersion.frozen = cfv.frozen;
        return cfVersion;
    }

    public int minor_version() {
        return this.minor_version;
    }

    public int major_version() {
        return this.major_version;
    }
}

