/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common.structure;

import org.openjdk.asmtools.common.structure.EModifier;

public enum ClassFileContext {
    NONE(0, "n/a"),
    CLASS(1, "class"),
    FIELD(2, "field"),
    METHOD(4, "method"),
    INNER_CLASS(8, "inner-class"),
    MODULE(16, "module"),
    REQUIRES(32, "requires"),
    EXPORTS(64, "exports"),
    OPENS(128, "opens"),
    METHOD_PARAMETERS(256, "method parameters"),
    MODULE_DIRECTIVES(224, "module directives");

    private final int id;
    private final String printVal;

    private ClassFileContext(int id, String print) {
        this.id = id;
        this.printVal = print;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.printVal;
    }

    public boolean isOneOf(ClassFileContext ... contexts) {
        for (ClassFileContext cfc : contexts) {
            if ((cfc.id & this.id) == 0) continue;
            return true;
        }
        return false;
    }

    public boolean belongToContextOf(EModifier modifier) {
        return (this.id & modifier.getAllovedContextMask()) != 0;
    }
}

