/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common.structure;

import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openjdk.asmtools.jasm.ClassFileConst;

public enum EAttribute {
    ATT_Unrecognized(-1, "ATT_Unrecognized", "", ClassFileConst.ConstType.CONSTANT_UNKNOWN),
    ATT_StackMap(1, "ATT_StackMap", "StackMap", ClassFileConst.ConstType.CONSTANT_UNKNOWN),
    ATT_ConstantValue(2, "ATT_ConstantValue", "ConstantValue", ClassFileConst.ConstType.CONSTANT_UTF8),
    ATT_Code(3, "ATT_Code", "Code", ClassFileConst.ConstType.CONSTANT_UNKNOWN),
    ATT_StackMapTable(4, "ATT_StackMapTable", "StackMapTable", ClassFileConst.ConstType.CONSTANT_UNKNOWN),
    ATT_Exceptions(5, "ATT_Exceptions", "Exceptions", ClassFileConst.ConstType.CONSTANT_UNKNOWN),
    ATT_InnerClasses(6, "ATT_InnerClasses", "InnerClasses", ClassFileConst.ConstType.CONSTANT_CLASS),
    ATT_EnclosingMethod(7, "ATT_EnclosingMethod", "EnclosingMethod", ClassFileConst.ConstType.CONSTANT_CLASS),
    ATT_Synthetic(8, "ATT_Synthetic", "Synthetic", ClassFileConst.ConstType.CONSTANT_UNKNOWN),
    ATT_Signature(9, "ATT_Signature", "Signature", ClassFileConst.ConstType.CONSTANT_UTF8),
    ATT_SourceFile(10, "ATT_SourceFile", "SourceFile", ClassFileConst.ConstType.CONSTANT_UTF8),
    ATT_SourceDebugExtension(11, "ATT_SourceDebugExtension", "SourceDebugExtension", ClassFileConst.ConstType.CONSTANT_UTF8),
    ATT_LineNumberTable(12, "ATT_LineNumberTable", "LineNumberTable", ClassFileConst.ConstType.CONSTANT_UNKNOWN),
    ATT_LocalVariableTable(13, "ATT_LocalVariableTable", "LocalVariableTable", ClassFileConst.ConstType.CONSTANT_UNKNOWN),
    ATT_LocalVariableTypeTable(14, "ATT_LocalVariableTypeTable", "LocalVariableTypeTable", ClassFileConst.ConstType.CONSTANT_UNKNOWN),
    ATT_Deprecated(15, "ATT_Deprecated", "Deprecated", ClassFileConst.ConstType.CONSTANT_UNKNOWN),
    ATT_RuntimeVisibleAnnotations(16, "ATT_RuntimeVisibleAnnotations", "RuntimeVisibleAnnotations", ClassFileConst.ConstType.CONSTANT_UNKNOWN),
    ATT_RuntimeInvisibleAnnotations(17, "ATT_RuntimeInvisibleAnnotations", "RuntimeInvisibleAnnotations", ClassFileConst.ConstType.CONSTANT_UNKNOWN),
    ATT_RuntimeVisibleParameterAnnotations(18, "ATT_RuntimeVisibleParameterAnnotations", "RuntimeVisibleParameterAnnotations", ClassFileConst.ConstType.CONSTANT_UNKNOWN),
    ATT_RuntimeInvisibleParameterAnnotations(19, "ATT_RuntimeInvisibleParameterAnnotations", "RuntimeInvisibleParameterAnnotations", ClassFileConst.ConstType.CONSTANT_UNKNOWN),
    ATT_AnnotationDefault(20, "ATT_AnnotationDefault", "AnnotationDefault", ClassFileConst.ConstType.CONSTANT_UNKNOWN),
    ATT_BootstrapMethods(21, "ATT_BootstrapMethods", "BootstrapMethods", ClassFileConst.ConstType.CONSTANT_METHODHANDLE),
    ATT_RuntimeVisibleTypeAnnotations(22, "ATT_RuntimeVisibleTypeAnnotations", "RuntimeVisibleTypeAnnotations", ClassFileConst.ConstType.CONSTANT_UNKNOWN),
    ATT_RuntimeInvisibleTypeAnnotations(23, "ATT_RuntimeInvisibleTypeAnnotations", "RuntimeInvisibleTypeAnnotations", ClassFileConst.ConstType.CONSTANT_UNKNOWN),
    ATT_MethodParameters(24, "ATT_MethodParameters", "MethodParameters", ClassFileConst.ConstType.CONSTANT_UTF8),
    ATT_Module(25, "ATT_Module", "Module", ClassFileConst.ConstType.CONSTANT_MODULE),
    ATT_Version(26, "ATT_Version", "Version", ClassFileConst.ConstType.CONSTANT_UTF8),
    ATT_TargetPlatform(27, "ATT_TargetPlatform", "TargetPlatform", ClassFileConst.ConstType.CONSTANT_UTF8),
    ATT_MainClass(28, "ATT_MainClass", "MainClass", ClassFileConst.ConstType.CONSTANT_CLASS),
    ATT_ModulePackages(29, "ATT_ModulePackages", "ModulePackages", ClassFileConst.ConstType.CONSTANT_PACKAGE),
    ATT_ModuleMainClass(30, "ATT_ModuleMainClass", "ModuleMainClass", ClassFileConst.ConstType.CONSTANT_CLASS),
    ATT_NestHost(32, "ATT_NestHost", "NestHost", ClassFileConst.ConstType.CONSTANT_CLASS),
    ATT_NestMembers(33, "ATT_NestMembers", "NestMembers", ClassFileConst.ConstType.CONSTANT_CLASS),
    ATT_Record(34, "ATT_Record", "Record", ClassFileConst.ConstType.CONSTANT_UTF8),
    ATT_PermittedSubclasses(35, "ATT_PermittedSubclasses", "PermittedSubclasses", ClassFileConst.ConstType.CONSTANT_CLASS),
    ATT_Preload(36, "ATT_Preload", "Preload", ClassFileConst.ConstType.CONSTANT_CLASS);

    private final Integer value;
    private final String printVal;
    private final String parseKey;
    private final ClassFileConst.ConstType constType;
    private static HashMap<String, EAttribute> parseKeyToTags;
    private static HashMap<Integer, EAttribute> valueToTags;

    private EAttribute(Integer value, String printValue, String parseKey, ClassFileConst.ConstType constType) {
        this.value = value;
        this.printVal = printValue;
        this.parseKey = parseKey;
        this.constType = constType;
    }

    public String printValue() {
        return this.printVal;
    }

    public String parseKey() {
        return this.parseKey;
    }

    public ClassFileConst.ConstType getCPTypeOfIndex() {
        return this.constType;
    }

    public int value() {
        return this.value;
    }

    public static EAttribute get(int value) {
        EAttribute tg;
        if (valueToTags == null) {
            valueToTags = (HashMap)Stream.of(EAttribute.values()).collect(Collectors.toMap(EAttribute::value, Function.identity()));
        }
        if ((tg = valueToTags.get(value)) == null) {
            tg = ATT_Unrecognized;
        }
        return tg;
    }

    public static EAttribute get(String parseKey) {
        EAttribute tg;
        if (parseKeyToTags == null) {
            parseKeyToTags = (HashMap)Stream.of(EAttribute.values()).collect(Collectors.toMap(EAttribute::parseKey, Function.identity()));
        }
        if ((tg = parseKeyToTags.get(parseKey)) == null) {
            tg = ATT_Unrecognized;
        }
        return tg;
    }
}

