/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openjdk.asmtools.common.structure.ClassFileContext;

public enum EModifier {
    ACC_NONE(0, "", ClassFileContext.NONE),
    ACC_PUBLIC(1, "public", ClassFileContext.CLASS, ClassFileContext.INNER_CLASS, ClassFileContext.FIELD, ClassFileContext.METHOD),
    ACC_PRIVATE(2, "private", ClassFileContext.INNER_CLASS, ClassFileContext.FIELD, ClassFileContext.METHOD),
    ACC_PROTECTED(4, "protected", ClassFileContext.INNER_CLASS, ClassFileContext.FIELD, ClassFileContext.METHOD),
    ACC_STATIC(8, "static", ClassFileContext.INNER_CLASS, ClassFileContext.FIELD, ClassFileContext.METHOD),
    ACC_FINAL(16, "final", ClassFileContext.CLASS, ClassFileContext.INNER_CLASS, ClassFileContext.FIELD, ClassFileContext.METHOD, ClassFileContext.METHOD_PARAMETERS),
    ACC_SUPER(32, "super", ClassFileContext.CLASS),
    ACC_TRANSITIVE(32, "transitive", ClassFileContext.REQUIRES),
    ACC_SYNCHRONIZED(32, "synchronized", ClassFileContext.METHOD),
    ACC_OPEN(32, "open", ClassFileContext.MODULE),
    ACC_VOLATILE(64, "volatile", ClassFileContext.FIELD),
    ACC_BRIDGE(64, "bridge", ClassFileContext.METHOD),
    ACC_STATIC_PHASE(64, "static", ClassFileContext.REQUIRES),
    ACC_PERMITS_VALUE(64, "permits_value", ClassFileContext.CLASS, ClassFileContext.INNER_CLASS),
    ACC_TRANSIENT(128, "transient", ClassFileContext.FIELD),
    ACC_VARARGS(128, "varargs", ClassFileContext.METHOD),
    ACC_NATIVE(256, "native", ClassFileContext.METHOD),
    ACC_VALUE(256, "value", ClassFileContext.CLASS, ClassFileContext.INNER_CLASS),
    ACC_INTERFACE(512, "interface", ClassFileContext.CLASS, ClassFileContext.INNER_CLASS),
    ACC_ABSTRACT(1024, "abstract", ClassFileContext.CLASS, ClassFileContext.INNER_CLASS, ClassFileContext.METHOD),
    ACC_STRICT(2048, "strict", ClassFileContext.METHOD),
    ACC_PRIMITIVE(2048, "primitive", ClassFileContext.CLASS, ClassFileContext.INNER_CLASS),
    ACC_SYNTHETIC(4096, "synthetic", ClassFileContext.CLASS, ClassFileContext.INNER_CLASS, ClassFileContext.FIELD, ClassFileContext.METHOD, ClassFileContext.MODULE, ClassFileContext.REQUIRES, ClassFileContext.EXPORTS, ClassFileContext.OPENS, ClassFileContext.METHOD_PARAMETERS),
    ACC_ANNOTATION(8192, "annotation", ClassFileContext.CLASS, ClassFileContext.INNER_CLASS),
    ACC_ENUM(16384, "enum", ClassFileContext.CLASS, ClassFileContext.INNER_CLASS, ClassFileContext.FIELD),
    ACC_MODULE(32768, "module", ClassFileContext.CLASS),
    ACC_MANDATED(32768, "mandated", ClassFileContext.MODULE, ClassFileContext.REQUIRES, ClassFileContext.EXPORTS, ClassFileContext.OPENS, ClassFileContext.METHOD_PARAMETERS),
    SYNTHETIC_ATTRIBUTE(65536, "Synthetic(Pseudo)", ClassFileContext.CLASS, ClassFileContext.INNER_CLASS, ClassFileContext.FIELD, ClassFileContext.METHOD),
    DEPRECATED_ATTRIBUTE(131072, "Deprecated(Pseudo)", ClassFileContext.CLASS, ClassFileContext.INNER_CLASS, ClassFileContext.FIELD, ClassFileContext.METHOD);

    public static final EModifier[] MM_METHOD;
    public static final EModifier[] MM_CLASS;
    public static final EModifier[] MM_INTERFACE;
    public static final EModifier[] MM_FIELD;
    public static final EModifier[] MM_ABSTRACT_METHOD;
    public static final EModifier[] MM_INIT_METHOD;
    public static final EModifier[] MM_NESTED_CLASS;
    private static final EModifier[] MM_INTERFACE_METHOD;
    private static final EModifier[] MM_MODULE;
    private static final EModifier[] MM_MODULE_REQUIRES;
    private static final EModifier[] MM_MODULE_EXPORTS;
    private static final EModifier[] MM_MODULE_OPENS;
    public static String NAMES_DELIMITER;
    public static String NAMES_SUFFIX;
    public static String KEYWORDS_DELIMITER;
    public static String KEYWORDS_SUFFIX;
    private final int flag;
    private final String keyword;
    private final Set<ClassFileContext> contexts;
    private int contextMask = 0;

    private EModifier(int flag, String keyword, ClassFileContext ... contexts) {
        this.flag = flag;
        this.keyword = keyword;
        this.contexts = new HashSet<ClassFileContext>(10);
        if (contexts != null) {
            for (ClassFileContext c : contexts) {
                this.contexts.add(c);
                this.contextMask |= c.getID();
            }
        }
    }

    public static boolean isPublic(int flags) {
        return (flags & EModifier.ACC_PUBLIC.flag) != 0;
    }

    public static boolean isPrivate(int flags) {
        return (flags & EModifier.ACC_PRIVATE.flag) != 0;
    }

    public static boolean isProtected(int flags) {
        return (flags & EModifier.ACC_PROTECTED.flag) != 0;
    }

    public static boolean isStatic(int flags) {
        return (flags & EModifier.ACC_STATIC.flag) != 0;
    }

    public static boolean isFinal(int flags) {
        return (flags & EModifier.ACC_FINAL.flag) != 0;
    }

    public static boolean isTransitive(int flags) {
        return EModifier.isFinal(flags);
    }

    public static boolean isSuper(int flags) {
        return (flags & EModifier.ACC_SUPER.flag) != 0;
    }

    public static boolean isSynchronized(int flags) {
        return EModifier.isSuper(flags);
    }

    public static boolean isVolatile(int flags) {
        return (flags & EModifier.ACC_VOLATILE.flag) != 0;
    }

    public static boolean isBridge(int flags) {
        return EModifier.isVolatile(flags);
    }

    public static boolean isStaticPhase(int flags) {
        return EModifier.isVolatile(flags);
    }

    public static boolean isTransient(int flags) {
        return (flags & EModifier.ACC_TRANSIENT.flag) != 0;
    }

    public static boolean isVarArgs(int flags) {
        return EModifier.isTransient(flags);
    }

    public static boolean isNative(int flags) {
        return (flags & EModifier.ACC_NATIVE.flag) != 0;
    }

    public static boolean isInterface(int flags) {
        return (flags & EModifier.ACC_INTERFACE.flag) != 0;
    }

    public static boolean isAbstract(int flags) {
        return (flags & EModifier.ACC_ABSTRACT.flag) != 0;
    }

    public static boolean isStrict(int flags) {
        return (flags & EModifier.ACC_STRICT.flag) != 0;
    }

    public static boolean isSynthetic(int flags) {
        return (flags & EModifier.ACC_SYNTHETIC.flag) != 0;
    }

    public static boolean isAnnotation(int flags) {
        return (flags & EModifier.ACC_ANNOTATION.flag) != 0;
    }

    public static boolean isEnum(int flags) {
        return (flags & EModifier.ACC_ENUM.flag) != 0;
    }

    public static boolean isModule(int flags) {
        return (flags & EModifier.ACC_MODULE.flag) != 0;
    }

    public static boolean isMandated(int flags) {
        return EModifier.isModule(flags);
    }

    public static boolean isSyntheticPseudoMod(int flags) {
        return (flags & EModifier.SYNTHETIC_ATTRIBUTE.flag) != 0;
    }

    public static boolean isDeprecatedPseudoMod(int flags) {
        return (flags & EModifier.DEPRECATED_ATTRIBUTE.flag) != 0;
    }

    public static boolean isValue(int flags) {
        return (flags & EModifier.ACC_VALUE.flag) != 0;
    }

    public static boolean isPermitsValue(int flags) {
        return (flags & EModifier.ACC_PERMITS_VALUE.flag) != 0;
    }

    public static boolean isPrimitive(int flags) {
        return (flags & EModifier.ACC_PRIMITIVE.flag) != 0;
    }

    public static boolean hasPseudoMod(int flags) {
        return EModifier.isSyntheticPseudoMod(flags) || EModifier.isDeprecatedPseudoMod(flags);
    }

    public static boolean onlyOneOfFlags(int flag, EModifier ... modifiers) {
        if (modifiers.length >= 2) {
            int mask = flag & EModifier.getFlags(modifiers);
            return Arrays.stream(modifiers).mapToInt(EModifier::getFlag).anyMatch(f -> (f | mask) == f);
        }
        return modifiers.length != 0 && flag == modifiers[0].getFlag();
    }

    public static boolean anyOf(int flag, EModifier ... modifiers) {
        if (modifiers.length > 0) {
            return (flag & EModifier.getFlags(modifiers)) != 0;
        }
        return false;
    }

    public static int cleanFlags(int flag, EModifier ... modifiers) {
        if (modifiers.length > 0) {
            for (EModifier m : modifiers) {
                flag &= ~m.flag;
            }
        }
        return flag;
    }

    public static boolean both(int flags, EModifier modifierA, EModifier modifierB) {
        int bothFlags = modifierA.getFlag() | modifierB.getFlag();
        return (flags & bothFlags) == bothFlags;
    }

    public static boolean noFlagsExcept(int flags, EModifier ... modifiers) {
        return (flags & EModifier.getFlags(modifiers)) == flags;
    }

    public static int getFlags(EModifier ... modifiers) {
        int flag = 0;
        if (modifiers.length > 0) {
            for (EModifier m : modifiers) {
                flag |= m.flag;
            }
        }
        return flag;
    }

    public static int getFlags(ClassFileContext context, EModifier ... modifiers) {
        int flag = 0;
        if (modifiers.length == 0) {
            modifiers = EModifier.values();
        }
        for (EModifier m : modifiers) {
            if (!m.contexts.contains((Object)context)) continue;
            flag |= m.flag;
        }
        return flag;
    }

    private static int addTo(ArrayList<String> list, int flags, boolean isName, EModifier modifier) {
        list.add(isName ? modifier.getFlagName() : modifier.getJavaFlagModifier());
        return EModifier.clearIfSet(flags, modifier);
    }

    public static String asKeywords(int modifiers, ClassFileContext context) {
        return EModifier.flagsToString(modifiers, false, context, KEYWORDS_DELIMITER, KEYWORDS_SUFFIX);
    }

    public static String asNames(int modifiers, ClassFileContext context) {
        return EModifier.flagsToString(modifiers, true, context, NAMES_DELIMITER, NAMES_SUFFIX);
    }

    private static String flagsToString(int modifiers, boolean isName, ClassFileContext context, String delimiter, String suffix) {
        String s = String.join((CharSequence)delimiter, EModifier.flagsToList(modifiers, isName, context));
        return s.isBlank() ? "" : s + suffix;
    }

    private static ArrayList<String> flagsToList(int flags, boolean isName, ClassFileContext context) {
        ArrayList<String> list = new ArrayList<String>();
        if (EModifier.isPublic(flags) && context.belongToContextOf(ACC_PUBLIC)) {
            flags = EModifier.addTo(list, flags, isName, ACC_PUBLIC);
        } else if (EModifier.isPrivate(flags) && context.belongToContextOf(ACC_PRIVATE)) {
            flags = EModifier.addTo(list, flags, isName, ACC_PRIVATE);
        } else if (EModifier.isProtected(flags) && context.belongToContextOf(ACC_PROTECTED)) {
            flags = EModifier.addTo(list, flags, isName, ACC_PROTECTED);
        }
        if (EModifier.isStatic(flags) && context.belongToContextOf(ACC_STATIC)) {
            flags = EModifier.addTo(list, flags, isName, ACC_STATIC);
        }
        if (EModifier.isFinal(flags) && context.isOneOf(ClassFileContext.CLASS, ClassFileContext.INNER_CLASS, ClassFileContext.FIELD, ClassFileContext.METHOD, ClassFileContext.METHOD_PARAMETERS)) {
            flags = EModifier.addTo(list, flags, isName, ACC_FINAL);
        }
        if (EModifier.isSuper(flags)) {
            switch (context) {
                case CLASS: {
                    flags = EModifier.addTo(list, flags, isName, ACC_SUPER);
                    break;
                }
                case REQUIRES: {
                    flags = EModifier.addTo(list, flags, isName, ACC_TRANSITIVE);
                    break;
                }
                case METHOD: {
                    flags = EModifier.addTo(list, flags, isName, ACC_SYNCHRONIZED);
                    break;
                }
                case MODULE: {
                    flags = EModifier.addTo(list, flags, isName, ACC_OPEN);
                }
            }
        }
        if (EModifier.isVolatile(flags)) {
            switch (context) {
                case FIELD: {
                    flags = EModifier.addTo(list, flags, isName, ACC_VOLATILE);
                    break;
                }
                case METHOD: {
                    flags = EModifier.addTo(list, flags, isName, ACC_BRIDGE);
                    break;
                }
                case REQUIRES: {
                    flags = EModifier.addTo(list, flags, isName, ACC_STATIC_PHASE);
                    break;
                }
                case CLASS: 
                case INNER_CLASS: {
                    flags = EModifier.addTo(list, flags, isName, ACC_PERMITS_VALUE);
                }
            }
        }
        if (EModifier.isTransient(flags)) {
            switch (context) {
                case FIELD: {
                    flags = EModifier.addTo(list, flags, isName, ACC_TRANSIENT);
                    break;
                }
                case METHOD: {
                    flags = EModifier.addTo(list, flags, isName, ACC_VARARGS);
                }
            }
        }
        if (EModifier.isNative(flags)) {
            switch (context) {
                case METHOD: {
                    flags = EModifier.addTo(list, flags, isName, ACC_NATIVE);
                    break;
                }
                case CLASS: 
                case INNER_CLASS: {
                    flags = EModifier.addTo(list, flags, isName, ACC_VALUE);
                }
            }
        }
        if (EModifier.isInterface(flags) && context.isOneOf(ClassFileContext.CLASS, ClassFileContext.INNER_CLASS)) {
            flags = isName ? EModifier.addTo(list, flags, true, ACC_INTERFACE) : EModifier.clearIfSet(flags, ACC_INTERFACE);
        }
        if (EModifier.isAbstract(flags) && context.isOneOf(ClassFileContext.CLASS, ClassFileContext.INNER_CLASS, ClassFileContext.METHOD)) {
            flags = EModifier.addTo(list, flags, isName, ACC_ABSTRACT);
        }
        if (EModifier.isStrict(flags)) {
            switch (context) {
                case METHOD: {
                    flags = EModifier.addTo(list, flags, isName, ACC_STRICT);
                    break;
                }
                case CLASS: 
                case INNER_CLASS: {
                    flags = EModifier.addTo(list, flags, isName, ACC_PRIMITIVE);
                }
            }
        }
        if (EModifier.isSynthetic(flags) && context.belongToContextOf(ACC_SYNTHETIC)) {
            flags = EModifier.addTo(list, flags, isName, ACC_SYNTHETIC);
        }
        if (EModifier.isAnnotation(flags) && context.isOneOf(ClassFileContext.CLASS, ClassFileContext.INNER_CLASS)) {
            flags = EModifier.addTo(list, flags, isName, ACC_ANNOTATION);
        }
        if (EModifier.isEnum(flags) && context.isOneOf(ClassFileContext.CLASS, ClassFileContext.INNER_CLASS, ClassFileContext.FIELD)) {
            flags = EModifier.addTo(list, flags, isName, ACC_ENUM);
        }
        if (EModifier.isModule(flags)) {
            if (context == ClassFileContext.CLASS) {
                flags = isName ? EModifier.addTo(list, flags, true, ACC_MODULE) : EModifier.clearIfSet(flags, ACC_MODULE);
            } else if (context.isOneOf(ClassFileContext.MODULE, ClassFileContext.REQUIRES, ClassFileContext.EXPORTS, ClassFileContext.OPENS, ClassFileContext.METHOD_PARAMETERS)) {
                flags = EModifier.addTo(list, flags, isName, ACC_MANDATED);
            }
        }
        if (flags != 0) {
            list.add(String.format("0x%04X", flags));
        }
        return list;
    }

    private static int clearIfSet(int flag, EModifier ... modifiers) {
        for (EModifier m : modifiers) {
            if ((flag & m.flag) == 0) continue;
            flag &= ~m.flag;
        }
        return flag;
    }

    public Set<ClassFileContext> getClassFileContext() {
        return this.contexts;
    }

    public int getAllovedContextMask() {
        return this.contextMask;
    }

    public int getFlag() {
        return this.flag;
    }

    public String getJavaFlagModifier() {
        return this.keyword;
    }

    public String getFlagName() {
        return this.toString();
    }

    static {
        MM_METHOD = new EModifier[]{ACC_PUBLIC, ACC_PRIVATE, ACC_PROTECTED, ACC_STATIC, ACC_FINAL, ACC_SYNCHRONIZED, ACC_BRIDGE, ACC_VARARGS, ACC_NATIVE, ACC_ABSTRACT, ACC_STRICT, ACC_SYNTHETIC};
        MM_CLASS = new EModifier[]{ACC_PUBLIC, ACC_FINAL, ACC_SUPER, ACC_PRIMITIVE, ACC_INTERFACE, ACC_ABSTRACT, ACC_SYNTHETIC, ACC_ANNOTATION, ACC_ENUM, ACC_MODULE, ACC_VALUE, ACC_PERMITS_VALUE, ACC_PRIMITIVE};
        MM_INTERFACE = new EModifier[]{ACC_PUBLIC, ACC_INTERFACE, ACC_ABSTRACT, ACC_SYNTHETIC, ACC_ANNOTATION};
        MM_FIELD = new EModifier[]{ACC_PUBLIC, ACC_PRIVATE, ACC_PROTECTED, ACC_STATIC, ACC_FINAL, ACC_VOLATILE, ACC_TRANSIENT, ACC_SYNTHETIC, ACC_ENUM};
        MM_ABSTRACT_METHOD = new EModifier[]{ACC_PUBLIC, ACC_PROTECTED, ACC_BRIDGE, ACC_VARARGS, ACC_ABSTRACT, ACC_SYNTHETIC};
        MM_INIT_METHOD = new EModifier[]{ACC_PUBLIC, ACC_PRIVATE, ACC_PROTECTED, ACC_VARARGS, ACC_SYNTHETIC, ACC_STRICT, ACC_STATIC};
        MM_NESTED_CLASS = new EModifier[]{ACC_PUBLIC, ACC_PRIVATE, ACC_PROTECTED, ACC_STATIC, ACC_FINAL, ACC_INTERFACE, ACC_ABSTRACT, ACC_SYNTHETIC, ACC_ANNOTATION, ACC_ENUM};
        MM_INTERFACE_METHOD = new EModifier[]{ACC_PUBLIC, ACC_PRIVATE, ACC_STATIC, ACC_BRIDGE, ACC_VARARGS, ACC_ABSTRACT, ACC_STRICT, ACC_SYNTHETIC};
        MM_MODULE = new EModifier[]{ACC_OPEN, ACC_SYNTHETIC, ACC_MANDATED};
        MM_MODULE_REQUIRES = new EModifier[]{ACC_TRANSITIVE, ACC_STATIC_PHASE, ACC_SYNTHETIC, ACC_MANDATED};
        MM_MODULE_EXPORTS = new EModifier[]{ACC_SYNTHETIC, ACC_MANDATED};
        MM_MODULE_OPENS = new EModifier[]{ACC_SYNTHETIC, ACC_MANDATED};
        NAMES_DELIMITER = ", ";
        NAMES_SUFFIX = " ";
        KEYWORDS_DELIMITER = " ";
        KEYWORDS_SUFFIX = " ";
    }
}

