/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common.structure;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openjdk.asmtools.asmutils.Range;

public class StackMap {
    public static VerificationType getVerificationType(int verificationTypeID, Optional<Consumer<String>> errorConsumer) {
        if (VerificationType.isValidVerificationType(verificationTypeID)) {
            return VerificationType.get(verificationTypeID);
        }
        errorConsumer.ifPresent(c -> c.accept(String.format("Unknown StackMap verification type %d", verificationTypeID)));
        return VerificationType.ITEM_UNKNOWN;
    }

    public static VerificationType getVerificationType(String printName) {
        return VerificationType.getByPrintName(printName);
    }

    public static FrameType stackMapFrameType(int tag) {
        FrameType frameType = FrameType.getByTag(tag);
        return frameType;
    }

    public static int getFrameTypeTag(String frameTypeName) {
        return FrameType.getByTagName(frameTypeName).fromTag();
    }

    public static boolean isValidFrameType(int tag) {
        return FrameType.isValid(tag);
    }

    public static enum VerificationType {
        ITEM_UNKNOWN(-1, "UNKNOWN", "UNKNOWN"),
        ITEM_Bogus(0, "bogus", "B"),
        ITEM_Integer(1, "int", "I"),
        ITEM_Float(2, "float", "F"),
        ITEM_Double(3, "double", "D"),
        ITEM_Long(4, "long", "L"),
        ITEM_Null(5, "null", "N"),
        ITEM_InitObject(6, "this", "IO"),
        ITEM_Object(7, "CP", "O"),
        ITEM_NewObject(8, "at", "NO");

        private static HashMap<String, VerificationType> printNameToType;
        private static HashMap<String, VerificationType> parseKeyToType;
        private static HashMap<Integer, VerificationType> tagToType;
        private final String printName;
        private final String parseKey;
        private Integer tag;

        private VerificationType(Integer tag, String printName, String parseKey) {
            this.tag = tag;
            this.printName = printName;
            this.parseKey = parseKey;
        }

        static boolean isValidVerificationType(int tag) {
            return tag >= VerificationType.ITEM_Bogus.tag && tag <= VerificationType.ITEM_NewObject.tag;
        }

        public static VerificationType getByPrintName(String printName) {
            if (printNameToType == null) {
                printNameToType = (HashMap)Arrays.stream(VerificationType.values()).collect(Collectors.toMap(VerificationType::printName, Function.identity()));
            }
            return printNameToType.get(printName);
        }

        public static VerificationType getByParseKey(String parseKey) {
            VerificationType verificationType;
            if (parseKeyToType == null) {
                parseKeyToType = (HashMap)Arrays.stream(VerificationType.values()).collect(Collectors.toMap(VerificationType::parseKey, Function.identity()));
            }
            return (verificationType = parseKeyToType.get(parseKey)) == null ? ITEM_UNKNOWN : verificationType;
        }

        public static VerificationType get(int tag) {
            if (tagToType == null) {
                tagToType = (HashMap)Arrays.stream(VerificationType.values()).collect(Collectors.toMap(VerificationType::tag, Function.identity()));
            }
            return tagToType.get(tag);
        }

        public String parseKey() {
            return this.parseKey;
        }

        public String printName() {
            return this.printName;
        }

        public Integer tag() {
            return this.tag;
        }
    }

    public static enum FrameType {
        UNKNOWN_TYPE(-1, -1, "unknown"),
        SAME_FRAME(0, 63, "same"),
        SAME_LOCALS_1_STACK_ITEM_FRAME(64, 127, "stack1"),
        RESERVED(128, 246, "reserved"),
        SAME_LOCALS_1_STACK_ITEM_EXTENDED_FRAME(247, 247, "stack1_ex"),
        CHOP_1_FRAME(250, 250, "chop1"),
        CHOP_2_FRAME(249, 249, "chop2"),
        CHOP_3_FRAME(248, 248, "chop3"),
        SAME_FRAME_EX(251, 251, "same_ex"),
        APPEND_FRAME(252, 254, "append"),
        FULL_FRAME(255, 255, "full");

        private static HashMap<String, FrameType> tagNameToFrameType;
        private final Range<Integer> tagRange;
        private final String tagName;

        private FrameType(int from, int to, String tagName) {
            this.tagRange = new Range<Integer>(from, to);
            this.tagName = tagName;
        }

        public static FrameType getByTagName(String tagName) {
            FrameType type;
            if (tagNameToFrameType == null) {
                tagNameToFrameType = (HashMap)Arrays.stream(FrameType.values()).collect(Collectors.toMap(FrameType::tagName, Function.identity()));
            }
            return (type = tagNameToFrameType.get(tagName)) == null ? UNKNOWN_TYPE : type;
        }

        public static FrameType getByTag(int tag) {
            for (FrameType type : FrameType.values()) {
                if (!type.inRange(tag)) continue;
                return type;
            }
            return UNKNOWN_TYPE;
        }

        public int fromTag() {
            return this.tagRange.from();
        }

        public String tagName() {
            return this.tagName;
        }

        public String printName() {
            return this.name().toLowerCase();
        }

        public Range<Integer> tagRange() {
            return this.tagRange;
        }

        public boolean inRange(int tag) {
            return this.tagRange.in(tag);
        }

        public static boolean isValid(int tag) {
            for (FrameType frameType : Set.of(UNKNOWN_TYPE, RESERVED)) {
                if (!frameType.inRange(tag)) continue;
                return false;
            }
            return true;
        }
    }
}

