/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.IntStream;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.ConstantPoolDataVisitor;
import org.openjdk.asmtools.jasm.DataWriter;
import org.openjdk.asmtools.jasm.Indexer;

class AnnotationData
implements ConstantPoolDataVisitor {
    boolean invisible;
    Indexer typeCPX;
    ArrayList<ElemValuePair> elemValuePairs;

    @Override
    public <T extends DataWriter> T visit(ConstantPool pool) {
        for (ElemValuePair pair : this.elemValuePairs) {
            pair.visit(pool);
        }
        return (T)this;
    }

    public AnnotationData(Indexer typeCPX, boolean invisible) {
        this.typeCPX = typeCPX;
        this.elemValuePairs = new ArrayList();
        this.invisible = invisible;
    }

    public void add(ElemValuePair elemValuePair) {
        this.elemValuePairs.add(elemValuePair);
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeShort(this.typeCPX.cpIndex);
        out.writeShort(this.elemValuePairs.size());
        for (DataWriter dataWriter : this.elemValuePairs) {
            dataWriter.write(out);
        }
    }

    @Override
    public int getLength() {
        return 4 + this.elemValuePairs.stream().flatMapToInt(elem -> IntStream.of(elem.getLength())).sum();
    }

    public static class ElemValuePair
    implements ConstantPoolDataVisitor {
        ConstCell name;
        DataWriter value;

        public ElemValuePair(ConstCell name, DataWriter value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            this.name.write(out);
            this.value.write(out);
        }

        @Override
        public int getLength() {
            return 2 + this.value.getLength();
        }

        @Override
        public <T extends DataWriter> T visit(ConstantPool pool) {
            this.name = (ConstCell)this.visitConstCell(this.name, pool);
            this.value = this.visitData(this.value, pool);
            return (T)this;
        }
    }
}

