/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.Optional;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.jasm.CPXAttr;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassFileConst;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstValue;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.ConstantPoolDataVisitor;
import org.openjdk.asmtools.jasm.DataWriter;

class AttrData
implements ConstantPoolDataVisitor {
    private final EAttribute attribute;
    private final ConstCell attributeNameConstantCell;

    AttrData(ConstantPool pool, EAttribute attribute) {
        this.attribute = attribute;
        this.attributeNameConstantCell = pool.findUTF8Cell(attribute.parseKey());
    }

    @Override
    public <T extends DataWriter> T visit(ConstantPool pool) {
        AttrData attrData = this;
        if (attrData instanceof CPXAttr) {
            CPXAttr cpxAttr = (CPXAttr)attrData;
            ConstCell<?> cell = cpxAttr.cell;
            if (!cell.isSet() && cell.getType() == ClassFileConst.ConstType.CONSTANT_STRING && this.attribute.getCPTypeOfIndex() == ClassFileConst.ConstType.CONSTANT_UTF8) {
                Optional<ConstCell> strCell = pool.ConstantPoolHashByValue.values().stream().filter(v -> v.isSet() && v.getType() == ClassFileConst.ConstType.CONSTANT_STRING && v.equalsByValue(cell)).findAny();
                cpxAttr.cell = strCell.isPresent() ? strCell.get() : pool.findCell(new ConstantPool.ConstValue_String((ConstCell)((ConstValue)cell.ref).value));
            }
        }
        return (T)this;
    }

    protected ConstCell<?> classifyConstCell(ConstantPool pool, ConstCell<?> cell) {
        switch (cell.getType()) {
            case CONSTANT_CLASS: {
                return cell;
            }
            case CONSTANT_UTF8: {
                if (this.attribute.getCPTypeOfIndex() != ClassFileConst.ConstType.CONSTANT_CLASS) break;
                Optional<ConstCell> clsCell = pool.ConstantPoolHashByValue.values().stream().filter(v -> v.getType() == ClassFileConst.ConstType.CONSTANT_CLASS && ((ConstValue)v.ref).value.equals(cell)).findAny();
                if (clsCell.isPresent()) {
                    return clsCell.get();
                }
                return pool.findCell(new ConstantPool.ConstValue_Class(cell));
            }
        }
        return cell;
    }

    @Override
    public int getLength() {
        return 6 + this.attrLength();
    }

    public int attrLength() {
        return 0;
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeShort(this.attributeNameConstantCell.cpIndex);
        out.writeInt(this.attrLength());
    }
}

