/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.DataWriter;
import org.openjdk.asmtools.jasm.Indexer;

class BootstrapMethodData
extends Indexer
implements DataWriter {
    ConstCell bootstrapMethodHandle;
    ArrayList<ConstCell<?>> arguments;

    public BootstrapMethodData(ConstCell bsmHandle, ArrayList<ConstCell<?>> arguments) {
        this.bootstrapMethodHandle = bsmHandle;
        this.arguments = arguments;
    }

    public BootstrapMethodData(int methodAttrIndex) {
        this.bootstrapMethodHandle = null;
        this.arguments = null;
        this.cpIndex = methodAttrIndex;
    }

    @Override
    public int getLength() {
        return 4 + this.arguments.size() * 2;
    }

    public boolean hasMethodAttrIndex() {
        return super.isSet();
    }

    public void setMethodAttrIndex(int methodAttrIndex) {
        this.cpIndex = methodAttrIndex;
    }

    public int getMethodAttrIndex() {
        return this.cpIndex;
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeShort(this.bootstrapMethodHandle.cpIndex);
        out.writeShort(this.arguments.size());
        for (ConstCell<?> argument : this.arguments) {
            out.writeShort(argument.cpIndex);
        }
    }

    public String toString() {
        return String.format("{MethodHandle:%s Arguments:%s}", this.bootstrapMethodHandle == null || this.bootstrapMethodHandle.cpIndex == -1 ? " n/a" : " #" + this.bootstrapMethodHandle.cpIndex, this.arguments == null || this.arguments.isEmpty() ? "{}" : "{ " + this.arguments.stream().map(a -> String.format("#%d", a.cpIndex)).collect(Collectors.joining(", ")) + " }");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BootstrapMethodData)) {
            return false;
        }
        BootstrapMethodData that = (BootstrapMethodData)o;
        if (!Objects.equals(this.bootstrapMethodHandle, that.bootstrapMethodHandle)) {
            return false;
        }
        return this.cpIndex == that.cpIndex & Objects.equals(this.arguments, that.arguments);
    }

    @Override
    public int hashCode() {
        int result = 31 * (this.bootstrapMethodHandle != null ? this.bootstrapMethodHandle.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        return result;
    }

    public boolean equalsByValue(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BootstrapMethodData)) {
            return false;
        }
        BootstrapMethodData that = (BootstrapMethodData)o;
        if (!Objects.equals(this.bootstrapMethodHandle, that.bootstrapMethodHandle)) {
            return false;
        }
        if (this.arguments == that.arguments) {
            return true;
        }
        if (this.arguments != null && this.arguments.size() == that.arguments.size()) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                if (this.arguments.get(i).equalsByValue(that.arguments.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

