/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import org.openjdk.asmtools.common.CompilerConstants;
import org.openjdk.asmtools.jasm.ClassFileConst;

public abstract class CPTagVisitor<R>
implements CompilerConstants {
    public final R visit(ClassFileConst.ConstType tag) {
        switch (tag) {
            case CONSTANT_UTF8: 
            case CONSTANT_ASCIZ: {
                return this.visitUTF8();
            }
            case CONSTANT_INTEGER: 
            case CONSTANT_INTEGER_BYTE: 
            case CONSTANT_INTEGER_BOOLEAN: 
            case CONSTANT_INTEGER_CHAR: 
            case CONSTANT_INTEGER_SHORT: {
                return this.visitInteger(tag);
            }
            case CONSTANT_FLOAT: {
                return this.visitFloat();
            }
            case CONSTANT_DOUBLE: {
                return this.visitDouble();
            }
            case CONSTANT_LONG: {
                return this.visitLong();
            }
            case CONSTANT_METHODTYPE: {
                return this.visitMethodType();
            }
            case CONSTANT_STRING: {
                return this.visitString();
            }
            case CONSTANT_CLASS: {
                return this.visitClass();
            }
            case CONSTANT_METHODREF: {
                return this.visitMethod();
            }
            case CONSTANT_FIELDREF: {
                return this.visitField();
            }
            case CONSTANT_INTERFACEMETHODREF: {
                return this.visitInterfaceMethod();
            }
            case CONSTANT_NAMEANDTYPE: {
                return this.visitNameAndType();
            }
            case CONSTANT_METHODHANDLE: {
                return this.visitMethodHandle();
            }
            case CONSTANT_DYNAMIC: {
                return this.visitDynamic();
            }
            case CONSTANT_INVOKEDYNAMIC: {
                return this.visitInvokeDynamic();
            }
            case CONSTANT_PACKAGE: {
                return this.visitPackage();
            }
            case CONSTANT_MODULE: {
                return this.visitModule();
            }
        }
        throw new RuntimeException(String.format("The Constant Type \"%s\" does not have a corresponding visitor function.", tag.printVal()));
    }

    public abstract R visitUTF8();

    public abstract R visitInteger(ClassFileConst.ConstType var1);

    public abstract R visitFloat();

    public abstract R visitDouble();

    public abstract R visitLong();

    public abstract R visitMethodType();

    public abstract R visitString();

    public abstract R visitClass();

    public abstract R visitMethod();

    public abstract R visitField();

    public abstract R visitInterfaceMethod();

    public abstract R visitNameAndType();

    public abstract R visitMethodHandle();

    public abstract R visitDynamic();

    public abstract R visitInvokeDynamic();

    public abstract R visitModule();

    public abstract R visitPackage();
}

