/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import org.openjdk.asmtools.common.structure.ClassFileContext;
import org.openjdk.asmtools.common.structure.EModifier;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.JasmEnvironment;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.Scanner;

public class Checker {
    private Checker() {
    }

    private static boolean validAccess(int mod) {
        return EModifier.onlyOneOfFlags(mod, EModifier.ACC_PUBLIC, EModifier.ACC_PRIVATE, EModifier.ACC_PROTECTED);
    }

    public static boolean validNestedClass(int flags) {
        return (flags & ~EModifier.getFlags(EModifier.MM_NESTED_CLASS)) == 0;
    }

    public static boolean validField(int flags) {
        return (flags & ~EModifier.getFlags(EModifier.MM_FIELD)) == 0;
    }

    private static boolean validMethod(int mod) {
        return EModifier.noFlagsExcept(mod, EModifier.MM_METHOD);
    }

    public static boolean validAbstractMethod(int flags) {
        return (flags & ~EModifier.getFlags(EModifier.MM_ABSTRACT_METHOD)) == 0;
    }

    public static boolean validInitMethod(int flags) {
        return (flags & ~EModifier.getFlags(EModifier.MM_INIT_METHOD)) == 0;
    }

    public static boolean validInterfaceField(int mod) {
        int flags = EModifier.isSynthetic(mod) ? mod & ~EModifier.ACC_SYNTHETIC.getFlag() : mod;
        return EModifier.noFlagsExcept(flags, EModifier.ACC_PUBLIC, EModifier.ACC_STATIC, EModifier.ACC_FINAL);
    }

    public static boolean validInterface(int mod) {
        return EModifier.noFlagsExcept(mod, EModifier.MM_INTERFACE);
    }

    public static boolean validClass(int mod) {
        return EModifier.noFlagsExcept(mod, EModifier.MM_CLASS);
    }

    public static void checkClassModifiers(int mod, Scanner scanner) {
        if (scanner.token != JasmTokens.Token.CLASS && !EModifier.isInterface(mod)) {
            scanner.environment.warning(scanner.pos, "warn.one.of.two.token.expected", JasmTokens.Token.CLASS.parseKey(), JasmTokens.Token.INTERFACE.parseKey());
        }
        if (EModifier.isInterface(mod = EModifier.cleanFlags(mod, EModifier.DEPRECATED_ATTRIBUTE, EModifier.SYNTHETIC_ATTRIBUTE))) {
            if (!EModifier.isAbstract(mod)) {
                scanner.environment.warning(scanner.pos, "warn.invalid.modifier.int.abs", EModifier.asNames(mod, ClassFileContext.CLASS));
            }
            if (EModifier.anyOf(mod, EModifier.ACC_FINAL, EModifier.ACC_PRIMITIVE, EModifier.ACC_ENUM, EModifier.ACC_MODULE)) {
                scanner.environment.warning(scanner.pos, "warn.invalid.modifier.interface.set", EModifier.asNames(mod, ClassFileContext.CLASS));
            }
            if (!Checker.validInterface(mod)) {
                scanner.environment.warning(scanner.pos, "warn.invalid.modifier.int", EModifier.asNames(mod & ~EModifier.getFlags(EModifier.MM_INTERFACE), ClassFileContext.CLASS));
            }
            if (EModifier.isEnum(mod)) {
                scanner.environment.warning(scanner.pos, "warn.invalid.modifier.class.intenum", EModifier.asNames(mod, ClassFileContext.CLASS));
            }
        } else if (!Checker.validClass(mod)) {
            scanner.environment.warning(scanner.pos, "warn.invalid.modifier.class", EModifier.asNames(mod & ~EModifier.getFlags(EModifier.MM_CLASS), ClassFileContext.CLASS));
        }
        if (EModifier.both(mod, EModifier.ACC_ABSTRACT, EModifier.ACC_FINAL)) {
            scanner.environment.warning(scanner.pos, "warn.invalid.modifier.class.finabs", EModifier.asNames(mod, ClassFileContext.CLASS));
        }
    }

    public static void checkFieldModifiers(ClassData classData, int mod, int pos) {
        JasmEnvironment environment = (JasmEnvironment)classData.getEnvironment();
        mod = EModifier.cleanFlags(mod, EModifier.DEPRECATED_ATTRIBUTE, EModifier.SYNTHETIC_ATTRIBUTE);
        if (classData.isInterface()) {
            if (!Checker.validInterfaceField(mod)) {
                environment.warning(pos, "warn.invalid.modifier.intfield", EModifier.asNames(mod, ClassFileContext.FIELD));
            }
        } else {
            if (!Checker.validField(mod)) {
                environment.warning(pos, "warn.invalid.modifier.field", EModifier.asNames(mod & ~EModifier.getFlags(EModifier.MM_FIELD), ClassFileContext.FIELD));
            }
            if (!Checker.validAccess(mod)) {
                environment.warning(pos, "warn.invalid.modifier.acc", EModifier.asNames(mod, ClassFileContext.FIELD));
            }
            if (EModifier.both(mod, EModifier.ACC_FINAL, EModifier.ACC_VOLATILE)) {
                environment.warning(pos, "warn.invalid.modifier.fiva", EModifier.asNames(mod, ClassFileContext.FIELD));
            }
            if (classData.isPrimitive()) {
                if (!EModifier.anyOf(mod, EModifier.ACC_STATIC, EModifier.ACC_FINAL) || !EModifier.both(mod, EModifier.ACC_STATIC, EModifier.ACC_FINAL)) {
                    environment.warning(pos, "warn.invalid.modifier.primitive.flags", EModifier.asNames(mod, ClassFileContext.FIELD));
                }
                if (classData.isAbstract() && !EModifier.isStatic(mod)) {
                    environment.warning(pos, "warn.invalid.modifier.primitive.abstract", EModifier.asNames(mod, ClassFileContext.FIELD));
                }
            }
        }
    }

    public static void checkMethodModifiers(ClassData classData, int mod, int pos, boolean isInit, boolean isClinit) {
        int wrongFlags;
        JasmEnvironment environment = (JasmEnvironment)classData.getEnvironment();
        int cfvMajorVersion = classData.cfv.major_version();
        if (!Checker.validMethod(mod = EModifier.cleanFlags(mod, EModifier.DEPRECATED_ATTRIBUTE, EModifier.SYNTHETIC_ATTRIBUTE))) {
            wrongFlags = mod & ~EModifier.getFlags(EModifier.MM_METHOD);
            environment.warning(pos, "warn.invalid.modifier.mth", EModifier.asNames(wrongFlags, ClassFileContext.METHOD));
        }
        if (!Checker.validAccess(mod)) {
            environment.warning(pos, "warn.invalid.modifier.mth.acc", EModifier.asNames(mod, ClassFileContext.METHOD));
        }
        if (isClinit) {
            if (classData.cfv.major_version() > 51 && !EModifier.isStatic(mod)) {
                environment.warning(pos, "warn.clinit.static", EModifier.asNames(mod, ClassFileContext.METHOD));
            }
        } else if (classData.isInterface()) {
            if (isInit) {
                environment.warning(pos, "warn.init.in_int", new Object[0]);
            } else {
                Checker.validateInterfaceMethod(mod, classData, pos);
            }
        } else if (isInit && !Checker.validInitMethod(mod)) {
            wrongFlags = mod & ~EModifier.getFlags(EModifier.MM_INIT_METHOD);
            environment.warning(pos, "warn.invalid.modifier.init", EModifier.asNames(wrongFlags, ClassFileContext.METHOD));
        } else if (EModifier.isAbstract(mod)) {
            if (!Checker.validAbstractMethod(mod)) {
                wrongFlags = mod & ~EModifier.getFlags(EModifier.MM_ABSTRACT_METHOD);
                environment.warning(pos, "warn.invalid.modifier.abst", EModifier.asNames(wrongFlags, ClassFileContext.METHOD));
            } else if (EModifier.isStrict(mod) && cfvMajorVersion >= 46 && cfvMajorVersion <= 60) {
                environment.warning(pos, "warn.invalid.modifier.strict", new Object[0]);
            }
        }
    }

    public static void checkInnerClassModifiers(ClassData classData, int mod, int pos) {
        JasmEnvironment environment = (JasmEnvironment)classData.getEnvironment();
        if (!Checker.validNestedClass(mod = EModifier.cleanFlags(mod, EModifier.DEPRECATED_ATTRIBUTE, EModifier.SYNTHETIC_ATTRIBUTE))) {
            int wrongFlags = mod & ~EModifier.getFlags(EModifier.MM_NESTED_CLASS);
            environment.warning(pos, "warn.invalid.modifier.innerclass", EModifier.asNames(wrongFlags, ClassFileContext.INNER_CLASS));
        }
    }

    public static void validateInterfaceMethod(int mod, ClassData cd, int pos) {
        int cfvMajorVersion = cd.cfv.major_version();
        JasmEnvironment environment = (JasmEnvironment)cd.getEnvironment();
        if (EModifier.anyOf(mod, EModifier.ACC_PROTECTED, EModifier.ACC_FINAL, EModifier.ACC_SYNCHRONIZED, EModifier.ACC_NATIVE)) {
            environment.warning(pos, "warn.invalid.modifier.method", EModifier.asNames(mod, ClassFileContext.METHOD));
        }
        if (cfvMajorVersion < 52) {
            if (!EModifier.both(mod, EModifier.ACC_PUBLIC, EModifier.ACC_ABSTRACT)) {
                environment.warning(pos, "warn.invalid.modifier.intmth.less.52", EModifier.asNames(mod, ClassFileContext.METHOD));
            } else if (!EModifier.onlyOneOfFlags(mod, EModifier.ACC_PUBLIC, EModifier.ACC_PRIVATE)) {
                environment.warning(pos, "warn.invalid.modifier.intmth.is.52", EModifier.asNames(mod, ClassFileContext.METHOD));
            }
        }
    }
}

