/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstantPool;

public class ClassArrayAttr
extends AttrData {
    List<ConstCell> classes = new ArrayList<ConstCell>();

    public ClassArrayAttr(ConstantPool pool, EAttribute attribute, List<ConstCell> constCellList) {
        super(pool, attribute);
        for (ConstCell cell : constCellList) {
            this.classes.add(this.classifyConstCell(pool, cell));
        }
    }

    @Override
    public int attrLength() {
        return 2 + this.classes.size() * 2;
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        super.write(out);
        out.writeShort(this.classes.size());
        for (ConstCell c : this.classes) {
            out.writeShort(c.cpIndex);
        }
    }
}

