/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.common.outputs.ToolOutput;
import org.openjdk.asmtools.common.structure.CFVersion;
import org.openjdk.asmtools.common.structure.ClassFileContext;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.common.structure.EModifier;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.BootstrapMethodData;
import org.openjdk.asmtools.jasm.CPXAttr;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassFileConst;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstValue;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.ConstantPoolDataVisitor;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.DataVectorAttr;
import org.openjdk.asmtools.jasm.DataWriter;
import org.openjdk.asmtools.jasm.FieldData;
import org.openjdk.asmtools.jasm.Indexer;
import org.openjdk.asmtools.jasm.InnerClassData;
import org.openjdk.asmtools.jasm.JasmEnvironment;
import org.openjdk.asmtools.jasm.MemberData;
import org.openjdk.asmtools.jasm.MethodData;
import org.openjdk.asmtools.jasm.ModuleAttr;
import org.openjdk.asmtools.jasm.NestMembersAttr;
import org.openjdk.asmtools.jasm.PermittedSubclassesAttr;
import org.openjdk.asmtools.jasm.PreloadAttr;
import org.openjdk.asmtools.jasm.RecordData;
import org.openjdk.asmtools.jasm.SourceDebugExtensionAttr;

class ClassData
extends MemberData<JasmEnvironment> {
    private static final String DEFAULT_EXTENSION = ".class";
    private final JasmEnvironment environment;
    public CDOutputStream cdos;
    String fileExtension = ".class";
    MethodData curMethod;
    CFVersion cfv;
    String myClassName;
    CoreClasses coreClasses = new CoreClasses();
    AttrData sourceFileAttr;
    SourceDebugExtensionAttr sourceDebugExtensionAttr;
    ArrayList<Indexer> interfaces;
    ArrayList<FieldData> fields = new ArrayList();
    ArrayList<MethodData> methods = new ArrayList();
    DataVectorAttr<InnerClassData> innerClasses = null;
    DataVectorAttr<BootstrapMethodData> bootstrapMethodsAttr = null;
    CPXAttr nestHostAttr;
    NestMembersAttr nestMembersAttr;
    ModuleAttr moduleAttribute = null;
    private RecordData recordData;
    private PermittedSubclassesAttr permittedSubclassesAttr;
    private PreloadAttr preloadAttr;

    public ClassData(JasmEnvironment environment, CFVersion cfv) {
        super(new ConstantPool(environment), environment);
        this.environment = environment;
        this.cdos = new CDOutputStream();
        this.cfv = cfv;
    }

    public final void init(int access, ConstCell<?> this_class, ConstCell<?> super_class, ArrayList<Indexer> interfaces) {
        this.access = access;
        if (EModifier.hasPseudoMod(access)) {
            this.createPseudoMod();
        }
        this.coreClasses.this_class(CoreClasses.PLACE.HEADER, this_class);
        this.coreClasses.super_class(CoreClasses.PLACE.HEADER, super_class);
        this.interfaces = interfaces;
        this.cfv.initClassDefaultVersion();
    }

    public final void initAsPackageInfo(int access, String className) {
        this.access = access;
        this.myClassName = className;
        this.cfv.initClassDefaultVersion();
    }

    public final void initAsModule() {
        this.access = EModifier.ACC_MODULE.getFlag();
        this.coreClasses.super_class(CoreClasses.PLACE.HEADER, new ConstCell(0));
        this.cfv.initModuleDefaultVersion();
    }

    public final boolean isInterface() {
        return EModifier.isInterface(this.access);
    }

    public final boolean isPrimitive() {
        return EModifier.isPrimitive(this.access);
    }

    public final boolean isAbstract() {
        return EModifier.isAbstract(this.access);
    }

    protected void relinkBootstrapMethods() {
        if (this.bootstrapMethodsAttr != null) {
            ArrayList<ConstCell<?>> cells = this.pool.getPoolValuesByRefType(ClassFileConst.ConstType.CONSTANT_INVOKEDYNAMIC, ClassFileConst.ConstType.CONSTANT_DYNAMIC);
            this.environment.traceln("relinkBSMs: %d items", cells.size());
            for (ConstCell<?> cell : cells) {
                ConstantPool.ConstValue_BootstrapMethod refVal = (ConstantPool.ConstValue_BootstrapMethod)cell.ref;
                BootstrapMethodData bsmData = refVal.bsmData();
                if (refVal.isSet() & ((ConstCell)refVal.value).ref == null) {
                    ConstCell c = this.pool.getCell(((ConstCell)refVal.value).cpIndex);
                    refVal.setValue(c);
                }
                if (bsmData == null || !bsmData.hasMethodAttrIndex()) continue;
                int methodAttrIndex = bsmData.getMethodAttrIndex();
                if (methodAttrIndex < 0 || methodAttrIndex > this.bootstrapMethodsAttr.size()) {
                    this.environment.warning("warn.bootstrapmethod.attr.bad", methodAttrIndex);
                    bsmData.setMethodAttrIndex(methodAttrIndex);
                    continue;
                }
                refVal.setBsmData(this.bootstrapMethodsAttr.get(methodAttrIndex), methodAttrIndex);
            }
        }
    }

    private <T extends Collection<BootstrapMethodData>> int getFirstIndex(T collection, BootstrapMethodData bsmData) {
        if (!collection.isEmpty()) {
            BootstrapMethodData[] array = (BootstrapMethodData[])collection.toArray(BootstrapMethodData[]::new);
            for (int i = 0; i < array.length; ++i) {
                if (!bsmData.equalsByValue(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private void uniquifyBootstrapMethods() {
        if (this.bootstrapMethodsAttr != null) {
            int index = 0;
            List<BootstrapMethodData> cpBsmList = this.getPool().getPoolCellsByType(ClassFileConst.ConstType.CONSTANT_DYNAMIC, ClassFileConst.ConstType.CONSTANT_INVOKEDYNAMIC).stream().map(item -> ((ConstantPool.ConstValue_BootstrapMethod)item.ref).bsmData()).toList();
            if (cpBsmList.stream().anyMatch(item -> !item.hasMethodAttrIndex())) {
                this.environment.traceln("numberBSM: %d items", cpBsmList.size());
                ArrayList<BootstrapMethodData> newBsmList = new ArrayList<BootstrapMethodData>(cpBsmList.size());
                for (int i = 0; i < cpBsmList.size(); ++i) {
                    BootstrapMethodData bsmData = cpBsmList.get(i);
                    int cachedIndex = this.getFirstIndex(newBsmList, bsmData);
                    if (cachedIndex != -1) {
                        bsmData.setMethodAttrIndex(cachedIndex);
                        continue;
                    }
                    if (this.getFirstIndex(this.bootstrapMethodsAttr, bsmData) == -1) {
                        this.environment.warning("warn.bootstrapmethod.attr.expected", bsmData.toString());
                    } else {
                        bsmData.setMethodAttrIndex(index++);
                    }
                    newBsmList.add(bsmData);
                }
                this.bootstrapMethodsAttr.replaceAll(newBsmList);
            }
        }
    }

    public AttrData setSourceFileAttr(ConstCell value_cpx) {
        this.sourceFileAttr = new CPXAttr(this.pool, EAttribute.ATT_SourceFile, value_cpx);
        return this.sourceFileAttr;
    }

    public SourceDebugExtensionAttr setSourceDebugExtensionAttr() {
        this.sourceDebugExtensionAttr = new SourceDebugExtensionAttr(this.pool);
        return this.sourceDebugExtensionAttr;
    }

    public RecordData setRecord(int where) {
        if (this.recordAttributeExists()) {
            this.environment.warning(where, "warn.record.repeated", new Object[0]);
        }
        this.recordData = new RecordData(this);
        return this.recordData;
    }

    public void rejectRecord() {
        this.recordData = null;
    }

    public ConstantPool.ConstValue_FieldRef makeFieldRef(ConstCell name, ConstCell descriptor) {
        return new ConstantPool.ConstValue_FieldRef(name, descriptor);
    }

    public FieldData addFieldIfAbsent(int access, ConstCell name, ConstCell descriptor) {
        ConstantPool.ConstValue_FieldRef fieldRef = this.makeFieldRef(name, descriptor);
        this.environment.traceln(" [ClassData.addFieldIfAbsent]:  #" + ((ConstCell)((Pair)fieldRef.value).first).cpIndex + ":#" + ((ConstCell)((Pair)fieldRef.value).second).cpIndex, new Object[0]);
        FieldData fd = this.getField(fieldRef);
        if (fd == null) {
            this.environment.traceln(" [ClassData.addFieldIfAbsent]:  new field.", new Object[0]);
            fd = this.addField(access, fieldRef);
        }
        return fd;
    }

    private FieldData getField(ConstantPool.ConstValue_FieldRef nameAndType) {
        for (FieldData fd : this.fields) {
            if (!fd.getNameDesc().equals(nameAndType)) continue;
            return fd;
        }
        return null;
    }

    public FieldData addField(int access, ConstantPool.ConstValue_FieldRef fieldRef) {
        this.environment.traceln(" [ClassData.addField]:  #" + ((ConstCell)((Pair)fieldRef.value).first).cpIndex + ":#" + ((ConstCell)((Pair)fieldRef.value).second).cpIndex, new Object[0]);
        FieldData res = new FieldData(this, access, fieldRef);
        this.fields.add(res);
        return res;
    }

    public FieldData addField(int access, ConstCell name, ConstCell sig) {
        return this.addField(access, this.makeFieldRef(name, sig));
    }

    public MethodData StartMethod(int access, ConstCell name, ConstCell sig, ArrayList exc_table) {
        this.EndMethod();
        this.environment.traceln(" [ClassData.StartMethod]:  #" + name.cpIndex + ":#" + sig.cpIndex, new Object[0]);
        this.curMethod = new MethodData(this, access, name, sig, exc_table);
        this.methods.add(this.curMethod);
        return this.curMethod;
    }

    public void EndMethod() {
        this.curMethod = null;
    }

    public ConstCell LocalMethodRef(ConstValue nape) {
        return this.pool.findCell(ClassFileConst.ConstType.CONSTANT_METHODREF, this.coreClasses.this_class(), this.pool.findCell(nape));
    }

    public ConstCell LocalMethodRef(ConstCell name, ConstCell sig) {
        return this.LocalMethodRef(this.makeFieldRef(name, sig));
    }

    void addLocVarData(int opc, Indexer arg) {
    }

    public void addInnerClass(int access, ConstCell name, ConstCell innerClass, ConstCell outerClass) {
        this.environment.traceln("addInnerClass (with indexes: Name (" + name.toString() + "), Inner (" + innerClass.toString() + "), Outer (" + outerClass.toString() + ").", new Object[0]);
        if (this.innerClasses == null) {
            this.innerClasses = new DataVectorAttr(this.pool, EAttribute.ATT_InnerClasses);
        }
        this.innerClasses.add(new InnerClassData(access, name, innerClass, outerClass));
    }

    public void addBootstrapMethod(BootstrapMethodData bsmData) {
        if (this.bootstrapMethodsAttr == null) {
            this.bootstrapMethodsAttr = new DataVectorAttr(this.pool, EAttribute.ATT_BootstrapMethods);
        }
        this.bootstrapMethodsAttr.add(bsmData);
        this.environment.traceln("addBootstrapMethod: " + bsmData.toString(), new Object[0]);
    }

    public void addNestHost(ConstCell hostClass) {
        this.environment.traceln("addNestHost", new Object[0]);
        this.nestHostAttr = new CPXAttr(this.pool, EAttribute.ATT_NestHost, hostClass);
    }

    public void addNestMembers(List<ConstCell> classes) {
        this.environment.traceln("addNestMembers", new Object[0]);
        this.nestMembersAttr = new NestMembersAttr(this.pool, classes);
    }

    public void addPermittedSubclasses(List<ConstCell> classes) {
        this.environment.traceln("addPermittedSubclasses", new Object[0]);
        this.permittedSubclassesAttr = new PermittedSubclassesAttr(this.pool, classes);
    }

    public void addPreloads(List<ConstCell> classes) {
        this.environment.traceln("addPreloads", new Object[0]);
        this.preloadAttr = new PreloadAttr(this.pool, classes);
    }

    public void endClass() {
        if (this.coreClasses.super_class() == null) {
            this.coreClasses.super_class(this.pool.findClassCell("java/lang/Object"));
        }
        this.pool.itemizePool();
        this.coreClasses.specifyClasses(this.pool);
        this.coreClasses.cleanConstantPool(this.pool);
        this.pool.checkGlobals();
        this.pool.fixIndexesInPool();
        this.itemizeAttributes(new DataVectorAttr[]{new DataVectorAttr<DataWriter>(this.pool, EAttribute.ATT_ConstantValue).addAll(this.fields.stream().map(f -> f.getInitialValue())), this.annotAttrInv, this.annotAttrVis});
        this.uniquifyBootstrapMethods();
        try {
            this.myClassName = this.coreClasses.getFileName();
            this.environment.traceln("ClassFileName = " + this.myClassName, new Object[0]);
            this.environment.traceln("this_class    = " + this.coreClasses.this_class(), new Object[0]);
            this.environment.traceln("super_class   = " + this.coreClasses.super_class(), new Object[0]);
            this.environment.traceln("-- Constant Pool ---", new Object[0]);
            this.environment.traceln("--------------------", new Object[0]);
            this.pool.printPool();
            this.environment.traceln("--------------------", new Object[0]);
            this.environment.traceln("-- Inner Classes ---", new Object[0]);
            this.environment.traceln("--------------------", new Object[0]);
            this.printInnerClasses();
            this.environment.traceln("--------------------", new Object[0]);
        }
        catch (Throwable e) {
            this.environment.traceln("check name:" + e, new Object[0]);
            this.environment.error("err.no.classname", new Object[0]);
            e.printStackTrace();
        }
    }

    public void endPackageInfo() {
        this.coreClasses.this_class(this.pool.findClassCell(this.myClassName));
        this.coreClasses.super_class(this.pool.findClassCell("java/lang/Object"));
        this.pool.itemizePool();
        this.coreClasses.super_class(this.pool.specifyCell(this.coreClasses.super_class()));
        this.coreClasses.this_class(this.pool.specifyCell(this.coreClasses.this_class()));
        this.pool.checkGlobals();
    }

    public void endModule(ModuleAttr moduleAttr) {
        this.moduleAttribute = moduleAttr.build();
        this.myClassName = "module-info";
        this.coreClasses.this_class(this.pool.findClassCell(this.myClassName));
        this.pool.itemizePool();
        this.coreClasses.this_class(this.pool.specifyCell(this.coreClasses.this_class()));
        this.pool.checkGlobals();
        this.itemizeAttributes(new DataVectorAttr[]{this.annotAttrInv, this.annotAttrVis});
    }

    private <A extends AttrData> void itemizeAttributes(A ... attributeList) {
        for (A attributes : attributeList) {
            if (attributes == null) continue;
            if (attributes instanceof DataVectorAttr) {
                ((DataVectorAttr)attributes).getElements().stream().map(e -> (ConstantPoolDataVisitor)e).forEach(v -> v.visit(this.pool));
                continue;
            }
            if (!(attributes instanceof AttrData)) continue;
            ((AttrData)attributes).visit(this.pool);
        }
    }

    private void printInnerClasses() {
        if (this.innerClasses != null) {
            int i = 1;
            for (InnerClassData entry : this.innerClasses) {
                this.environment.trace(" InnerClass[" + i++ + "]: (" + EModifier.asNames(entry.access, ClassFileContext.INNER_CLASS) + "), ", new Object[0]);
                this.environment.trace("Name:  " + entry.name.toString() + " ", new Object[0]);
                this.environment.trace("InnerClass_info:  " + entry.innerClass.toString() + " ", new Object[0]);
                this.environment.traceln("OuterClass_info:  " + entry.outerClass.toString() + " ", new Object[0]);
            }
        } else {
            this.environment.traceln("<< NO INNER CLASSES >>", new Object[0]);
        }
    }

    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeInt(-889275714);
        out.writeShort(this.cfv.minor_version());
        out.writeShort(this.cfv.major_version());
        this.pool.write(out);
        out.writeShort(this.access);
        out.writeShort(this.coreClasses.this_class().cpIndex);
        out.writeShort(this.coreClasses.super_class().cpIndex);
        if (this.interfaces != null) {
            out.writeShort(this.interfaces.size());
            for (Indexer intf : this.interfaces) {
                out.writeShort(intf.cpIndex);
            }
        } else {
            out.writeShort(0);
        }
        if (this.fields != null) {
            out.writeShort(this.fields.size());
            for (FieldData field : this.fields) {
                field.write(out);
            }
        } else {
            out.writeShort(0);
        }
        if (this.methods != null) {
            out.writeShort(this.methods.size());
            for (MethodData method : this.methods) {
                method.write(out);
            }
        } else {
            out.writeShort(0);
        }
        DataVector attrs = this.getAttrVector();
        attrs.write(out);
    }

    @Override
    protected DataVector getAttrVector() {
        if (this.moduleAttribute != null) {
            return this.populateAttributesList(new AttrData[]{this.annotAttrVis, this.annotAttrInv, this.moduleAttribute});
        }
        return this.populateAttributesList(new AttrData[]{this.sourceFileAttr, this.sourceDebugExtensionAttr, this.recordData, this.innerClasses, this.syntheticAttr, this.deprecatedAttr, this.signatureAttr, this.annotAttrVis, this.annotAttrInv, this.type_annotAttrVis, this.type_annotAttrInv, this.bootstrapMethodsAttr, this.nestHostAttr, this.nestMembersAttr, this.permittedSubclassesAttr, this.preloadAttr});
    }

    private <T extends DataWriter> DataVector populateAttributesList(T ... attributes) {
        DataVector<T> attrVector = new DataVector<T>();
        for (T attribute : attributes) {
            if (attribute == null) continue;
            attrVector.add(attribute);
        }
        return attrVector;
    }

    public void write(ToolOutput toolOutput) throws IOException {
        try (DataOutputStream dos = toolOutput.getDataOutputStream();){
            this.cdos.setDataOutputStream(dos);
            this.write(this.cdos);
        }
        catch (Exception ex) {
            this.environment.error("err.cannot.write", ex.getMessage());
            throw ex;
        }
    }

    public void setByteLimit(int bytelimit) {
        this.cdos.enable();
        this.cdos.setLimit(bytelimit);
    }

    public boolean nestHostAttributeExists() {
        return this.nestHostAttr != null;
    }

    public boolean nestMembersAttributesExist() {
        return this.nestMembersAttr != null;
    }

    public boolean recordAttributeExists() {
        return this.recordData != null;
    }

    public boolean preloadAttributeExists() {
        return this.preloadAttr != null;
    }

    public static class CoreClasses {
        private String fileName;
        Pair<ConstCell<?>, ConstCell<?>> header = new Pair<Object, Object>(null, null);
        Pair<ConstCell<?>, ConstCell<?>> classfile = new Pair<Object, Object>(null, null);

        public void this_class(PLACE where, ConstCell<?> this_class) {
            if (where == PLACE.CLASSFILE) {
                this.classfile.first = this_class;
            } else {
                this.header.first = this_class;
            }
        }

        public void super_class(PLACE where, ConstCell<?> super_class) {
            if (where == PLACE.CLASSFILE) {
                this.classfile.second = super_class;
            } else {
                this.header.second = super_class;
            }
        }

        public void this_class(ConstCell<?> this_class) {
            if (this.classfile.first != null) {
                this.classfile.first = this_class;
            } else {
                this.header.first = this_class;
            }
        }

        public void super_class(ConstCell<?> super_class) {
            if (this.classfile.second != null) {
                this.classfile.second = super_class;
            } else {
                this.header.second = super_class;
            }
        }

        public ConstCell<?> this_class() {
            return this.classfile.first != null ? (ConstCell)this.classfile.first : (ConstCell)this.header.first;
        }

        public ConstCell<?> super_class() {
            return this.classfile.second != null ? (ConstCell)this.classfile.second : (ConstCell)this.header.second;
        }

        public String getFileName() {
            if (this.fileName == null) {
                this.fileName = this.calculateFileName();
            }
            return this.fileName;
        }

        private String calculateFileName() {
            if (this.header.first != null) {
                ConstantPool.ConstValue_Class this_class_value = (ConstantPool.ConstValue_Class)((ConstCell)this.header.first).ref;
                ConstantPool.ConstValue_UTF8 this_class_name = (ConstantPool.ConstValue_UTF8)((ConstCell)this_class_value.value).ref;
                this.fileName = (String)this_class_name.value;
                return (String)this_class_name.value;
            }
            return null;
        }

        public void cleanConstantPool(ConstantPool constantPool) {
            if (this.classfile.first != null && ((ConstCell)this.classfile.first).cpIndex != ((ConstCell)this.header.first).cpIndex) {
                this.calculateFileName();
                constantPool.removeClassCell((ConstCell)this.header.first);
            }
            if (this.classfile.second != null && this.header.second != null && ((ConstCell)this.classfile.second).cpIndex != ((ConstCell)this.header.second).cpIndex) {
                constantPool.removeClassCell((ConstCell)this.header.second);
            }
        }

        public void specifyClasses(ConstantPool constantPool) {
            if (this.header.first != null) {
                this.header.first = constantPool.specifyCell((ConstCell)this.header.first);
            }
            if (this.header.second != null) {
                this.header.second = constantPool.specifyCell((ConstCell)this.header.second);
            }
            if (this.classfile.first != null) {
                this.classfile.first = constantPool.specifyCell((ConstCell)this.classfile.first);
            }
            if (this.classfile.second != null) {
                this.classfile.second = constantPool.specifyCell((ConstCell)this.classfile.second);
            }
        }

        public static enum PLACE {
            HEADER,
            CLASSFILE;

        }
    }

    private static class CDOutputStream
    implements CheckedDataOutputStream {
        public boolean enabled = false;
        private int byteLimit;
        private DataOutputStream dos;

        public CDOutputStream() {
            this.dos = null;
        }

        public CDOutputStream(OutputStream out) {
            this.setOutputStream(out);
        }

        public final void setOutputStream(OutputStream out) {
            this.dos = new DataOutputStream(out);
        }

        public void setDataOutputStream(DataOutputStream dos) {
            this.dos = dos;
        }

        public void setLimit(int limit) {
            this.byteLimit = limit;
        }

        public void enable() {
            this.enabled = true;
        }

        private synchronized void check(String loc) throws IOException {
            if (this.enabled && this.dos.size() >= this.byteLimit) {
                throw new IOException(loc);
            }
        }

        @Override
        public synchronized void write(int b) throws IOException {
            this.dos.write(b);
            this.check("Writing byte: " + b);
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            this.dos.write(b, off, len);
            this.check("Writing byte-array: " + b);
        }

        @Override
        public final void writeBoolean(boolean v) throws IOException {
            this.dos.writeBoolean(v);
            this.check("Writing writeBoolean: " + (v ? "true" : "false"));
        }

        @Override
        public final void writeByte(int v) throws IOException {
            this.dos.writeByte(v);
            this.check("Writing writeByte: " + v);
        }

        @Override
        public void writeShort(int v) throws IOException {
            this.dos.writeShort(v);
            this.check("Writing writeShort: " + v);
        }

        @Override
        public void writeChar(int v) throws IOException {
            this.dos.writeChar(v);
            this.check("Writing writeChar: " + v);
        }

        @Override
        public void writeInt(int v) throws IOException {
            this.dos.writeInt(v);
            this.check("Writing writeInt: " + v);
        }

        @Override
        public void writeLong(long v) throws IOException {
            this.dos.writeLong(v);
            this.check("Writing writeLong: " + v);
        }

        @Override
        public void writeFloat(float v) throws IOException {
            this.dos.writeFloat(v);
            this.check("Writing writeFloat: " + v);
        }

        @Override
        public void writeDouble(double v) throws IOException {
            this.dos.writeDouble(v);
            this.check("Writing writeDouble: " + v);
        }

        @Override
        public void writeBytes(String s) throws IOException {
            this.dos.writeBytes(s);
            this.check("Writing writeBytes: " + s);
        }

        @Override
        public void writeChars(String s) throws IOException {
            this.dos.writeChars(s);
            this.check("Writing writeChars: " + s);
        }

        @Override
        public void writeUTF(String s) throws IOException {
            this.dos.writeUTF(s);
            this.check("Writing writeUTF: " + s);
        }
    }
}

