/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.openjdk.asmtools.common.SyntaxError;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.jasm.AnnotationData;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.DataVectorAttr;
import org.openjdk.asmtools.jasm.DataWriter;
import org.openjdk.asmtools.jasm.ExceptionData;
import org.openjdk.asmtools.jasm.FieldType;
import org.openjdk.asmtools.jasm.Indexer;
import org.openjdk.asmtools.jasm.Instr;
import org.openjdk.asmtools.jasm.JasmEnvironment;
import org.openjdk.asmtools.jasm.LineNumberData;
import org.openjdk.asmtools.jasm.LocVarData;
import org.openjdk.asmtools.jasm.MethodData;
import org.openjdk.asmtools.jasm.OpcodeTables;
import org.openjdk.asmtools.jasm.Parser;
import org.openjdk.asmtools.jasm.StackMapData;
import org.openjdk.asmtools.jasm.SwitchTable;
import org.openjdk.asmtools.jasm.TypeAnnotationData;

class CodeAttr
extends AttrData {
    protected final List<LocVarData> locVarSlots;
    private final LocVarData VACANT = null;
    protected ClassData classData;
    protected MethodData methodData;
    protected JasmEnvironment environment;
    protected Indexer max_stack;
    protected Indexer max_locals;
    protected Instr zeroInstr;
    protected Instr lastInstr;
    protected int curPC = 0;
    protected DataVector<ExceptionData> exceptionTable;
    protected DataVectorAttr<LineNumberData> lineNumberTable;
    protected int lastLineNumber = 0;
    protected DataVectorAttr<LocVarData> localVariableTable;
    protected DataVector<DataVectorAttr<? extends DataWriter>> attributes;
    protected HashMap<String, Label> labelsHash;
    protected HashMap<String, RangePC> trapsHash;
    protected StackMapData curMapEntry = null;
    protected DataVectorAttr<StackMapData> stackMap;
    protected DataVectorAttr<TypeAnnotationData> visTypeAnnotations = null;
    protected DataVectorAttr<TypeAnnotationData> inVisTypeAnnotations = null;

    public CodeAttr(MethodData methodData, int paramCount, Indexer max_stack, Indexer max_locals) {
        super(methodData.pool, EAttribute.ATT_Code);
        this.methodData = methodData;
        this.classData = methodData.classData;
        this.environment = (JasmEnvironment)methodData.getEnvironment();
        this.max_stack = max_stack;
        this.max_locals = max_locals;
        this.locVarSlots = new ArrayList<LocVarData>(Collections.nCopies(max_locals != null ? max_locals.value() : paramCount, this.VACANT));
        this.lastInstr = this.zeroInstr = new Instr(methodData, this.environment);
        this.exceptionTable = new DataVector(0);
        this.attributes = new DataVector();
        if (this.environment.getVerboseFlag()) {
            this.lineNumberTable = new DataVectorAttr(methodData.pool, EAttribute.ATT_LineNumberTable);
            this.attributes.add(this.lineNumberTable);
        }
    }

    void endCode() {
        this.checkTraps();
        this.checkLocVars();
        this.checkLabels();
        if (this.visTypeAnnotations != null) {
            this.attributes.add(this.visTypeAnnotations);
        }
        if (this.inVisTypeAnnotations != null) {
            this.attributes.add(this.inVisTypeAnnotations);
        }
    }

    public void addAnnotations(ArrayList<AnnotationData> list) {
        for (AnnotationData item : list) {
            boolean invisible = item.invisible;
            if (!(item instanceof TypeAnnotationData)) continue;
            TypeAnnotationData typeAnnotationData = (TypeAnnotationData)item;
            if (invisible) {
                if (this.inVisTypeAnnotations == null) {
                    this.inVisTypeAnnotations = new DataVectorAttr(this.methodData.pool, EAttribute.ATT_RuntimeInvisibleTypeAnnotations);
                }
                this.inVisTypeAnnotations.add(typeAnnotationData);
                continue;
            }
            if (this.visTypeAnnotations == null) {
                this.visTypeAnnotations = new DataVectorAttr(this.methodData.pool, EAttribute.ATT_RuntimeVisibleTypeAnnotations);
            }
            this.visTypeAnnotations.add(typeAnnotationData);
        }
    }

    RangePC trapDecl(int pos, String name) {
        RangePC local;
        if (this.trapsHash == null) {
            this.trapsHash = new HashMap(10);
            local = null;
        } else {
            local = this.trapsHash.get(name);
        }
        if (local == null) {
            local = new RangePC(pos, name);
            this.trapsHash.put(name, local);
        }
        return local;
    }

    void beginTrap(int pos, String name) {
        RangePC rangePC = this.trapDecl(pos, name);
        if (rangePC.start_pc != -1) {
            this.environment.error("err.trap.tryredecl", name);
            return;
        }
        rangePC.start_pc = this.curPC;
    }

    void endTrap(int pos, String name) {
        RangePC rangePC = this.trapDecl(pos, name);
        if (rangePC.end_pc != -1) {
            this.environment.error("err.trap.endtryredecl", name);
            return;
        }
        rangePC.end_pc = this.curPC;
    }

    void trapHandler(int pos, String name, Indexer type) {
        RangePC rangePC = this.trapDecl(pos, name);
        rangePC.isReferred = true;
        ExceptionData exceptionData = new ExceptionData(pos, rangePC, this.curPC, type);
        this.exceptionTable.addElement(exceptionData);
    }

    void checkTraps() {
        if (this.trapsHash == null) {
            return;
        }
        for (RangePC rangePC : this.trapsHash.values()) {
            if (rangePC.isReferred) continue;
            this.environment.warning(rangePC.pos, "warn.trap.notref", rangePC.name);
        }
        for (ExceptionData exceptionData : this.exceptionTable) {
            RangePC rangePCLabel = exceptionData.rangePC;
            if (rangePCLabel.start_pc == -1) {
                this.environment.error(exceptionData.pos, "err.trap.notry", rangePCLabel.name);
            }
            if (rangePCLabel.end_pc != -1) continue;
            this.environment.error(exceptionData.pos, "err.trap.noendtry", rangePCLabel.name);
        }
    }

    Label labelDecl(String name) {
        Label local;
        if (this.labelsHash == null) {
            this.labelsHash = new HashMap(10);
            local = null;
        } else {
            local = this.labelsHash.get(name);
        }
        if (local == null) {
            local = new Label(name);
            this.labelsHash.put(name, local);
        }
        return local;
    }

    public Label LabelDef(int pos, String name) {
        Label label = this.labelDecl(name);
        if (label.isDefined) {
            this.environment.error(pos, "err.label.redecl", name);
            return null;
        }
        label.isDefined = true;
        label.cpIndex = this.curPC;
        return label;
    }

    public Label LabelRef(String name) {
        Label label = this.labelDecl(name);
        label.isReferred = true;
        return label;
    }

    void checkLabels() {
        if (this.labelsHash == null) {
            return;
        }
        for (Label local : this.labelsHash.values()) {
            if (local.isDefined) continue;
            this.environment.error("err.label.undecl", local.name);
        }
    }

    public void LocVarDataDef(int position, int index, ConstCell<?> nameCell, ConstCell<?> descriptorCell) {
        LocVarData locVarData = new LocVarData((short)index, (short)this.curPC, nameCell, descriptorCell);
        FieldType fieldType = locVarData.getFieldType();
        for (int i = 0; i < fieldType.getSlotsCount(); ++i) {
            if (!this.max_locals.inRange(index + i)) {
                this.environment.error(position, "err.locvar.wrong.index", index + i, this.max_locals.value() - 1);
                throw new SyntaxError();
            }
            if (this.locVarSlots.get(index + i) != this.VACANT) {
                this.environment.error(position, "err.locvar.slot.occupied", index + i);
                throw new SyntaxError();
            }
            this.locVarSlots.set(index + i, locVarData);
        }
        if (this.localVariableTable == null) {
            this.localVariableTable = new DataVectorAttr(this.methodData.pool, EAttribute.ATT_LocalVariableTable);
            this.attributes.add(this.localVariableTable);
        }
        this.localVariableTable.add(locVarData);
    }

    public void LocVarDataEnd(short slot, int position) {
        if (!this.max_locals.inRange(slot)) {
            this.environment.error(position, "err.locvar.wrong.index", slot, this.max_locals.value() - 1);
            throw new SyntaxError();
        }
        LocVarData locVarData = this.locVarSlots.get(slot);
        if (locVarData == this.VACANT) {
            this.environment.error(position, "err.locvar.undecl", slot);
            throw new SyntaxError();
        }
        locVarData.setLength(this.curPC);
        for (int i = 0; i < locVarData.getSlotsCount(); ++i) {
            if (i > 0 && !this.max_locals.inRange(slot + i)) {
                this.environment.error(position, "err.locvar.wrong.index", slot + i, this.max_locals.value() - 1);
                throw new SyntaxError();
            }
            if (i > 0 && this.locVarSlots.get(slot + i) == this.VACANT) {
                this.environment.error(position, "err.locvar.undecl", slot + i);
                throw new SyntaxError();
            }
            this.locVarSlots.set(slot + i, this.VACANT);
        }
    }

    void checkLocVars() {
        for (int i = 0; i < this.locVarSlots.size(); ++i) {
            if (this.locVarSlots.get(i) == this.VACANT) continue;
            this.locVarSlots.get(i).setLength(this.curPC);
            this.environment.warning(this.environment.getPosition(), "warn.locvar.ambiqous", i);
        }
    }

    public StackMapData getStackMap() {
        if (this.curMapEntry == null) {
            this.curMapEntry = new StackMapData(this.environment);
            this.curMapEntry.setIsStackMapTable(this.classData.cfv.isTypeCheckingVerifier());
        }
        return this.curMapEntry;
    }

    void addInstr(int mnenoc_pos, OpcodeTables.Opcode opcode, Indexer arg, Object arg2) {
        int ln;
        Instr newInstr;
        this.lastInstr.next = newInstr = new Instr(this.methodData, this.environment).set(this.curPC, this.environment.getPosition(), opcode, arg, arg2);
        this.lastInstr = newInstr;
        int len = opcode.length();
        switch (opcode) {
            case opc_tableswitch: {
                len = ((SwitchTable)arg2).recalcTableSwitch(this.curPC);
                break;
            }
            case opc_lookupswitch: {
                len = ((SwitchTable)arg2).calcLookupSwitch(this.curPC);
                break;
            }
            case opc_ldc: {
                ((ConstCell)arg).setRank(ConstantPool.ReferenceRank.LDC);
                break;
            }
            default: {
                ConstantPool.ReferenceRank rank;
                if (!(arg instanceof ConstCell) || (rank = ((ConstCell)arg).rank) == ConstantPool.ReferenceRank.LDC) break;
                ((ConstCell)arg).setRank(ConstantPool.ReferenceRank.ANY);
            }
        }
        if (this.environment.getVerboseFlag() && (ln = this.environment.lineNumber(mnenoc_pos)) != this.lastLineNumber) {
            this.lineNumberTable.add(new LineNumberData(this.curPC, ln));
            this.lastLineNumber = ln;
        }
        if (this.curMapEntry != null) {
            this.curMapEntry.setPC(this.curPC);
            StackMapData prevStackFrame = null;
            if (this.stackMap == null) {
                this.stackMap = this.classData.cfv.isTypeCheckingVerifier() ? new DataVectorAttr(this.classData.pool, EAttribute.ATT_StackMapTable) : new DataVectorAttr(this.classData.pool, EAttribute.ATT_StackMap);
                this.attributes.add(this.stackMap);
            } else if (this.stackMap.size() > 0) {
                prevStackFrame = this.stackMap.get(this.stackMap.size() - 1);
            }
            this.curMapEntry.setOffset(prevStackFrame);
            this.stackMap.add(this.curMapEntry);
            this.curMapEntry = null;
        }
        this.curPC += len;
    }

    @Override
    public int attrLength() {
        return 8 + this.curPC + this.exceptionTable.getLength() + this.attributes.getLength();
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException, Parser.CompilerError {
        int maxStack = this.max_stack != null ? this.max_stack.cpIndex : 0;
        int maxLocals = this.max_locals != null ? this.max_locals.cpIndex : this.locVarSlots.size();
        super.write(out);
        out.writeShort(maxStack);
        out.writeShort(maxLocals);
        out.writeInt(this.curPC);
        Instr instr = this.zeroInstr.next;
        while (instr != null) {
            instr.write(out);
            instr = instr.next;
        }
        this.exceptionTable.write(out);
        this.attributes.write(out);
    }

    static class RangePC
    extends Local {
        int start_pc = -1;
        int end_pc = -1;
        int pos;

        RangePC(int pos, String name) {
            super(name);
            this.pos = pos;
        }
    }

    public static class Label
    extends Local {
        public Label(String name) {
            super(name);
        }
    }

    public static class Local
    extends Indexer {
        String name;
        boolean isDefined = false;
        boolean isReferred = false;

        public Local(String name) {
            this.name = name;
        }
    }
}

