/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassFileConst;
import org.openjdk.asmtools.jasm.ConstValue;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.ConstantPoolDataVisitor;
import org.openjdk.asmtools.jasm.DataWriter;
import org.openjdk.asmtools.jasm.Indexer;

public class ConstCell<V extends ConstValue>
extends Indexer
implements ConstantPoolDataVisitor {
    V ref;
    ConstantPool.ReferenceRank rank = ConstantPool.ReferenceRank.NO;
    private int flag;

    ConstCell(int id, V ref) {
        this.cpIndex = id;
        this.ref = ref;
    }

    ConstCell(V ref) {
        this(-1, ref);
    }

    ConstCell(int id) {
        this(id, null);
    }

    public int getFlag() {
        return this.flag;
    }

    public ConstCell<V> setFlag(int flag) {
        this.flag = flag;
        return this;
    }

    @Override
    public final boolean isSet() {
        return super.isSet() && (this.ref != null && ((ConstValue)this.ref).value != null || this.ref instanceof ConstantPool.ConstValue_Zero);
    }

    public ClassFileConst.ConstType getType() {
        return this.ref == null ? ClassFileConst.ConstType.CONSTANT_UNKNOWN : ((ConstValue)this.ref).tag;
    }

    public char getAnnotationElementTypeValue() {
        return this.ref == null ? ClassFileConst.AnnotationElementType.AE_NOT_APPLICABLE.tag() : ((ConstValue)this.ref).tag.getAnnotationElementTypeValue();
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeShort(this.cpIndex);
    }

    public void setRank(ConstantPool.ReferenceRank rank) {
        if (this.rank.priority > rank.priority) {
            this.rank = rank;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConstCell)) {
            return false;
        }
        ConstCell constCell = (ConstCell)obj;
        return Objects.equals(this.ref, constCell.ref) && this.rank == constCell.rank && this.cpIndex == constCell.cpIndex;
    }

    public boolean equalsByValue(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConstCell)) {
            return false;
        }
        ConstCell constCell = (ConstCell)obj;
        if (this.ref == constCell.ref) {
            return true;
        }
        if (this.ref != null && this.ref instanceof ConstValue) {
            if (constCell.ref instanceof ConstValue) {
                return ((ConstValue)this.ref).equalsByValue(constCell.ref);
            }
            return false;
        }
        return Objects.equals(this.ref, constCell.ref);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * (result + (this.ref != null ? ((ConstValue)this.ref).hashCode() : 0));
        return result;
    }

    public String toString() {
        return "#" + (Serializable)(this.cpIndex == -1 ? "?" : Integer.valueOf(this.cpIndex)) + "=" + this.ref;
    }

    @Override
    public <T extends DataWriter> T visit(ConstantPool pool) {
        return this.visitConstCell(this, pool);
    }
}

