/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassFileConst;
import org.openjdk.asmtools.jasm.ConstCell;

public abstract class ConstValue<T> {
    protected T value;
    protected final ClassFileConst.ConstType tag;

    public ConstValue(ClassFileConst.ConstType tag, T value) {
        this.tag = tag;
        this.value = value;
    }

    public int size() {
        return 1;
    }

    public boolean isSet() {
        return this.value != null;
    }

    public ConstValue<T> setValue(T value) {
        this.value = value;
        return this;
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.tag.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConstValue)) {
            return false;
        }
        ConstValue that = (ConstValue)obj;
        return this.value.equals(that.value) && this.tag == that.tag;
    }

    public boolean equalsByValue(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConstValue)) {
            return false;
        }
        ConstValue that = (ConstValue)obj;
        if (this.value instanceof ConstCell) {
            if (that.value instanceof ConstCell) {
                return ((ConstCell)this.value).equalsByValue(that.value) && this.tag == that.tag;
            }
            return false;
        }
        return this.value.equals(that.value) && this.tag == that.tag;
    }

    public String toString() {
        return String.format("[%s : '%s']", this.tag.toString(), this.asString());
    }

    public String asString() {
        return this.value == null ? "?" : this.value.toString();
    }

    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeByte(this.tag.getTag());
    }
}

