/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.asmutils.Range;
import org.openjdk.asmtools.jasm.BootstrapMethodData;
import org.openjdk.asmtools.jasm.CPVisitor;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassFileConst;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstValue;
import org.openjdk.asmtools.jasm.JasmEnvironment;
import org.openjdk.asmtools.jasm.NameInfo;

public class ConstantPool
implements Iterable<ConstCell<?>> {
    static final int PROCESSED = 2;
    static final int NON_PROCESSED = 0;
    private final ConstValue_UTF8 emptyConstValue = new ConstValue_UTF8("");
    private final ConstCell<?> nullConst = new ConstCell<Object>(null);
    private final ConstCell<?> zeroConst = new ConstCell<ConstValue_Zero>(new ConstValue_Zero());
    private final ArrayList<ConstCell<?>> pool = new ArrayList(40);
    public JasmEnvironment environment;
    Hashtable<ConstValue<?>, ConstCell<?>> ConstantPoolHashByValue = new Hashtable(40);
    private final CPVisitor indexFixerConstantPool = new CPVisitor(){

        public void visitConstValueCell(ConstValue_Cell constValue) {
            ConstantPool.this.handleClassIndex(constValue);
        }

        public void visitConstValueRefCell(ConstValue_Pair constValue) {
            ConstantPool.this.handleMemberIndex(constValue);
        }

        @Override
        public void visitMethodHandle(ConstValue_MethodHandle constValue) {
            ConstantPool.this.handleIndexCell((ConstCell)constValue.value);
        }
    };
    private final CPVisitor referenceFixerConstantPool = new CPVisitor(){

        public void visitConstValueCell(ConstValue_Cell constValue) {
            ConstantPool.this.handleClassRef(constValue);
        }

        public void visitConstValueRefCell(ConstValue_Pair constValue) {
            ConstantPool.this.handleMemberRef(constValue);
        }

        @Override
        public void visitMethodHandle(ConstValue_MethodHandle constValue) {
            ConstantPool.this.handleRefCell((ConstCell)constValue.value);
        }
    };

    public ConstantPool(JasmEnvironment environment) {
        this.environment = environment;
        this.pool.add(this.zeroConst);
    }

    @Override
    public Iterator<ConstCell<?>> iterator() {
        return this.pool.iterator();
    }

    protected void handleClassRef(ConstValue_Cell cell) {
        ConstCell refCell = (ConstCell)cell.value;
        if (this.handleRefCell(refCell)) {
            this.environment.traceln("FIXED ConstPool[" + refCell.cpIndex + "](" + cell.tag.toString() + ") = " + cell.value, new Object[0]);
        }
    }

    protected void handleMemberRef(ConstValue_Pair cv) {
        Pair pair = (Pair)cv.value;
        if (this.handleRefCell((ConstCell)pair.first)) {
            this.environment.traceln("FIXED Left:ConstPool[" + ((ConstCell)pair.first).cpIndex + "](" + cv.tag.toString() + ") = " + ((ConstCell)pair.first).ref, new Object[0]);
        }
        if (this.handleRefCell((ConstCell)pair.second)) {
            this.environment.traceln("FIXED Right:ConstPool[" + ((ConstCell)pair.second).cpIndex + "](" + cv.tag.toString() + ") = " + ((ConstCell)pair.second).ref, new Object[0]);
        }
    }

    private boolean handleRefCell(ConstCell refCell) {
        ConstCell refVal;
        if (refCell.ref == null && (refVal = this.getConstPollCellByIndex(refCell.cpIndex)) != null) {
            this.checkAndFixCPRef(refVal);
            refCell.ref = refVal.ref;
            return true;
        }
        return false;
    }

    protected void handleClassIndex(ConstValue_Cell cell) {
        ConstCell refCell = (ConstCell)cell.value;
        if (this.handleIndexCell(refCell)) {
            this.environment.traceln("FIXED Index of ConstPool[" + refCell.cpIndex + "](" + cell.tag.toString() + ") = " + cell.value, new Object[0]);
        }
    }

    protected void handleMemberIndex(ConstValue_Pair cv) {
        Pair pair = (Pair)cv.value;
        if (this.handleIndexCell((ConstCell)pair.first)) {
            this.environment.traceln("FIXED Index of Left:ConstPool[" + ((ConstCell)pair.first).cpIndex + "](" + cv.tag.toString() + ") = " + ((ConstCell)pair.first).ref, new Object[0]);
        }
        if (this.handleIndexCell((ConstCell)pair.second)) {
            this.environment.traceln("FIXED Index of Right:ConstPool[" + ((ConstCell)pair.second).cpIndex + "](" + cv.tag.toString() + ") = " + ((ConstCell)pair.second).ref, new Object[0]);
        }
    }

    private boolean handleIndexCell(ConstCell refCell) {
        Optional<ConstCell<?>> cell;
        if (refCell.ref != null && !refCell.isSet() && (cell = this.getItemizedCell(refCell)).isPresent()) {
            refCell.cpIndex = cell.get().cpIndex;
            return true;
        }
        return false;
    }

    public void fixRefsInPool() {
        this.environment.traceln("fixRefsInPool: Fixing CP for %d explicit Constant Entries", this.pool.size());
        for (ConstCell<?> item : this.pool) {
            this.checkAndFixCPRef(item);
        }
    }

    public void fixIndexesInPool() {
        this.environment.traceln("fixIndexesInPool: Fixing CP for %d explicit Constant Entries.", this.pool.size());
        for (ConstCell<?> item : this.pool) {
            this.checkAndFixCPIndexes(item);
        }
    }

    protected void checkGlobals() {
        this.environment.traceln("Checking Globals", new Object[0]);
        for (int cpx = 1; cpx < this.pool.size(); ++cpx) {
            ConstCell<Object> cell = this.pool.get(cpx);
            if (cell == this.nullConst) {
                cell = new ConstCell<ConstValue_UTF8>(cpx, this.emptyConstValue);
                this.pool.set(cpx, cell);
            }
            if (cell.isSet()) continue;
            String name = Integer.toString(cpx);
            this.environment.error("err.const.undecl", name);
        }
    }

    private void checkAndFixCPRef(ConstCell item) {
        Object cv = item.ref;
        if (cv != null) {
            this.referenceFixerConstantPool.visit((ConstValue)cv);
        }
    }

    private void checkAndFixCPIndexes(ConstCell item) {
        Object cv = item.ref;
        if (cv != null) {
            this.indexFixerConstantPool.visit((ConstValue)cv);
        }
    }

    public void printPool() {
        int i = 0;
        for (ConstCell<?> item : this.pool) {
            this.environment.traceln("^^^^^^^^^^^^^  const #" + i + ": " + item, new Object[0]);
            ++i;
        }
    }

    public Range<Integer> getBounds() {
        return new Range<Integer>(1, this.pool.size() - 1);
    }

    public ConstCell getConstPollCellByIndex(int cpIndex) {
        if (cpIndex >= this.pool.size()) {
            return null;
        }
        return this.pool.get(cpIndex);
    }

    private void cpool_set(int cpx, ConstCell cell, int sz) {
        this.environment.traceln("cpool_set1: " + cpx + " " + cell, new Object[0]);
        this.environment.traceln("param_size: " + sz, new Object[0]);
        this.environment.traceln("pool_size : " + this.pool.size(), new Object[0]);
        cell.cpIndex = cpx;
        if (cpx + sz >= this.pool.size()) {
            this.environment.traceln("calling ensureCapacity( " + (cpx + sz + 1) + " )", new Object[0]);
            int low = this.pool.size();
            int high = cpx + sz;
            for (int i = 0; i < high - low; ++i) {
                this.pool.add(this.nullConst);
            }
        }
        this.pool.set(cpx, cell);
        if (sz == 2) {
            this.pool.set(cpx + 1, new ConstCell<ConstValue_UTF8>(cpx + 1, this.emptyConstValue));
        }
        this.environment.traceln("cpool_set2: " + cpx + " " + cell, new Object[0]);
    }

    private void delete(int cpx) {
        this.environment.traceln("delete cell(" + cpx + ")", new Object[0]);
        Consumer<ConstCell<?>> op = cell -> {
            if (cell.getFlag() == 0) {
                if (cell.cpIndex > cpx) {
                    --cell.cpIndex;
                    this.environment.traceln("\tcell from " + (cell.cpIndex + 1) + " to " + cell, new Object[0]);
                }
                cell.setFlag(2);
            }
        };
        for (int i = 1; i < this.pool.size(); ++i) {
            if (i == cpx) continue;
            ConstCell constCell = this.uncheckedGetCell(i);
            this.traverseConstantCell(constCell, op);
        }
        this.pool.remove(cpx);
        this.pool.forEach((Consumer<ConstCell<?>>)((Consumer<ConstCell>)cell -> cell.setFlag(0)));
    }

    private void traverseConstantCell(ConstCell<?> constCell, Consumer<ConstCell<?>> op) {
        if (constCell != null && constCell instanceof ConstCell && constCell instanceof ConstCell) {
            Object constValue;
            if (op != null) {
                op.accept(constCell);
            }
            if ((constValue = constCell.ref) != null) {
                switch (((ConstValue)constValue).tag) {
                    case CONSTANT_CLASS: 
                    case CONSTANT_STRING: 
                    case CONSTANT_MODULE: 
                    case CONSTANT_PACKAGE: 
                    case CONSTANT_METHODTYPE: 
                    case CONSTANT_DYNAMIC: 
                    case CONSTANT_INVOKEDYNAMIC: {
                        this.traverseConstantCell((ConstCell)((ConstValue)constValue).value, op);
                        break;
                    }
                    case CONSTANT_METHODHANDLE: 
                    case CONSTANT_NAMEANDTYPE: 
                    case CONSTANT_FIELDREF: 
                    case CONSTANT_METHODREF: 
                    case CONSTANT_INTERFACEMETHODREF: {
                        Pair pair = (Pair)((ConstValue)constValue).value;
                        this.traverseConstantCell((ConstCell)pair.first, op);
                        this.traverseConstantCell((ConstCell)pair.second, op);
                    }
                }
            }
        }
    }

    protected ConstCell uncheckedGetCell(int cpx) {
        return this.pool.get(cpx);
    }

    public ConstCell getCell(int cpx) {
        ConstCell<Object> cell = this.getConstPollCellByIndex(cpx);
        if (cell != null) {
            return cell;
        }
        cell = new ConstCell<Object>(cpx, null);
        return cell;
    }

    public void setCell(int cpx, ConstCell cell) {
        Object value = cell.ref;
        if (value == null) {
            this.environment.throwErrorException("err.constcell.null.val", cpx);
        }
        int sz = ((ConstValue)value).size();
        if (cpx == 0) {
            this.environment.warning("warn.const0.redecl", new Object[0]);
        } else {
            if (this.getConstPollCellByIndex(cpx) != null || sz == 2 && this.getConstPollCellByIndex(cpx + 1) != null) {
                String name = "#" + cpx;
                this.environment.error("err.const.redecl", name);
                return;
            }
            if (cell.isSet() && cell.cpIndex != cpx) {
                cell = new ConstCell(value);
                this.environment.traceln("setCell: new ConstCell %s", cell.toString());
            }
        }
        this.cpool_set(cpx, cell, sz);
    }

    public Optional<ConstCell<?>> getItemizedCell(ConstCell<?> cell) {
        Object value = cell.ref;
        if (value == null) {
            if (this.getBounds().in(cell.cpIndex)) {
                return Optional.ofNullable(this.getConstPollCellByIndex(cell.cpIndex));
            }
            if (cell.isSet()) {
                this.environment.throwErrorException("err.constcell.null.val", cell.cpIndex);
            } else {
                this.environment.throwErrorException("err.constcell.is.undef", new Object[0]);
            }
        }
        return this.ConstantPoolHashByValue.values().stream().filter(v -> v.isSet() && v.getType() == value.tag && ((ConstValue)v.ref).equalsByValue(value)).findAny();
    }

    private ConstCell<?> itemizeCell(ConstCell<?> cell) {
        Optional<ConstCell<?>> optionalCell = this.getItemizedCell(cell);
        if (optionalCell.isPresent()) {
            ConstCell<?> cpCell = optionalCell.get();
            if (cpCell.rank != cell.rank) {
                cpCell.setRank(cell.rank);
            }
            return cpCell;
        }
        int cellSize = ((ConstValue)cell.ref).size();
        int cpIndex = this.findVacantSlot(cellSize);
        this.cpool_set(cpIndex, cell, cellSize);
        return this.uncheckedGetCell(cpIndex);
    }

    protected void itemizePool() {
        this.environment.traceln("itemizePool", new Object[0]);
        for (ReferenceRank rank : ReferenceRank.values()) {
            for (ConstCell cell : this.ConstantPoolHashByValue.values().stream().filter(v -> !v.isSet() && rank.equals((Object)v.rank)).toList()) {
                this.itemizeCell(cell);
            }
        }
        ConstCell firstCell = this.getConstPollCellByIndex(0);
        firstCell.cpIndex = 0;
    }

    protected ConstCell<?> specifyCell(ConstCell<?> cell) {
        this.environment.traceln("itemizeCell", new Object[0]);
        return cell.isSet() ? cell : this.itemizeCell(cell);
    }

    private int findVacantSlot(int cellSize) {
        int index;
        for (index = 1; index < this.pool.size() && (this.pool.get(index) != this.nullConst || cellSize != 1 && this.pool.get(index + 1) != this.nullConst); ++index) {
        }
        return index;
    }

    public <T extends ConstValue> ConstCell<T> findCell(T ref) {
        ConstCell<Object> cell;
        if (ref == null) {
            this.environment.throwErrorException("err.constcell.is.null", new Object[0]);
        }
        if ((cell = this.ConstantPoolHashByValue.get(ref)) != null) {
            Object value = cell.ref;
            if (!((ConstValue)value).equals(ref)) {
                this.environment.throwErrorException("err.values.not.eq", ref.toString(), ((ConstValue)value).toString());
            }
            this.environment.traceln(String.format("ConstantPoolHashByValue.got ('%s') for '%s'", cell, ref), new Object[0]);
        } else {
            cell = new ConstCell<T>(ref);
            this.ConstantPoolHashByValue.put(ref, cell);
            this.environment.traceln("ConstantPoolHashByValue.put ('%s','%s')", ref, cell);
        }
        return cell;
    }

    public ConstCell findIntegerCell(Integer value) {
        return this.findCell(new ConstValue_Integer(ClassFileConst.ConstType.CONSTANT_INTEGER, value));
    }

    public ConstCell findFloatCell(Integer value) {
        return this.findCell(new ConstValue_Float(value));
    }

    public ConstCell findLongCell(Long value) {
        return this.findCell(new ConstValue_Long(value));
    }

    public ConstCell findDoubleCell(Long value) {
        return this.findCell(new ConstValue_Long(value));
    }

    public ConstCell findUTF8Cell(String value) {
        return this.findCell(new ConstValue_UTF8(value));
    }

    public ConstCell lookupUTF8Cell(Function<String, Boolean> rule) {
        return this.ConstantPoolHashByValue.entrySet().stream().filter(entry -> ((ConstValue)entry.getKey()).tag == ClassFileConst.ConstType.CONSTANT_UTF8 && (Boolean)rule.apply((String)((ConstValue)entry.getKey()).value) != false).findAny().map(entry -> (ConstCell)entry.getValue()).orElse(null);
    }

    public ConstCell findClassCell(NameInfo nameInfo) {
        return this.findCell(ClassFileConst.ConstType.CONSTANT_CLASS, nameInfo);
    }

    public ConstCell findClassCell(String name) {
        return this.findCell(ClassFileConst.ConstType.CONSTANT_CLASS, this.findUTF8Cell(name));
    }

    public ConstCell findModuleCell(NameInfo nameInfo) {
        return this.findCell(ClassFileConst.ConstType.CONSTANT_MODULE, nameInfo);
    }

    public ConstCell findModuleCell(String name) {
        return this.findCell(ClassFileConst.ConstType.CONSTANT_MODULE, this.findUTF8Cell(name));
    }

    public ConstCell findPackageCell(String name) {
        return this.findCell(ClassFileConst.ConstType.CONSTANT_PACKAGE, this.findUTF8Cell(name));
    }

    public ConstCell findPackageCell(NameInfo nameInfo) {
        return this.findCell(ClassFileConst.ConstType.CONSTANT_PACKAGE, nameInfo);
    }

    public ConstCell findCell(ClassFileConst.ConstType tag, ConstCell value) {
        return this.findCell(new ConstValue_Cell(tag, value));
    }

    public ConstCell findCell(ClassFileConst.ConstType tag, ConstCell left, ConstCell right) {
        return this.findCell(new ConstValue_Pair(tag, left, right));
    }

    public ConstCell findCell(ClassFileConst.ConstType tag, NameInfo nameInfo) {
        if (nameInfo.isEmpty()) {
            this.environment.throwErrorException("err.constcell.empty.nameInfo", "ConstantPool::FindCell");
        } else if (nameInfo.cpIndex() > 0) {
            ConstCell cell = this.getConstPollCellByIndex(nameInfo.cpIndex());
            if (cell != null && ((ConstValue)cell.ref).tag == tag) {
                return cell;
            }
            this.environment.throwErrorException("err.cpindex.notfound", nameInfo.cpIndex());
        }
        return this.findCell(tag, this.findUTF8Cell(nameInfo.name()));
    }

    public void write(CheckedDataOutputStream out) throws IOException {
        Object value;
        int length = this.pool.size();
        out.writeShort(length);
        this.environment.traceln("wr.pool:size=" + length, new Object[0]);
        for (int i = 1; i < length; i += ((ConstValue)value).size()) {
            ConstCell<?> cell = this.pool.get(i);
            value = cell.ref;
            if (cell.cpIndex != i) {
                this.environment.throwErrorException("err.constcell.invarg", Integer.toString(i), cell.cpIndex);
            }
            ((ConstValue)value).write(out);
        }
    }

    public ArrayList<ConstCell<?>> getPoolCellsByType(ClassFileConst.ConstType ... types) {
        return this.pool.stream().filter(c -> c.getType().oneOf(types)).collect(Collectors.toCollection(ArrayList::new));
    }

    public ArrayList<ConstCell<?>> getPoolValuesByRefType(ClassFileConst.ConstType ... types) {
        return this.pool.stream().filter(c -> c.ref != null && c.getType().oneOf(types)).collect(Collectors.toCollection(ArrayList::new));
    }

    public void removeClassCell(ConstCell<ConstValue_Class> cell) {
        int indUtf8 = 0;
        if (cell != null) {
            if (cell.getType() == ClassFileConst.ConstType.CONSTANT_CLASS) {
                if (cell.ref != null) {
                    ConstCell utf8Cell = (ConstCell)((ConstValue_Class)cell.ref).value;
                    if (!this.isAllowedToBeDelete(utf8Cell)) {
                        return;
                    }
                    indUtf8 = utf8Cell.cpIndex;
                }
                int indCls = cell.cpIndex;
                this.delete(indCls);
                this.delete(indCls > indUtf8 ? indUtf8 : indUtf8 - 1);
            } else {
                this.environment.warning("warn.cannot.delete.class.cell", cell);
            }
        }
    }

    private boolean isAllowedToBeDelete(ConstCell<ConstValue_UTF8> utf8Cell) {
        String className;
        return ((ConstValue_UTF8)utf8Cell.ref).value == null || !(className = (String)((ConstValue_UTF8)utf8Cell.ref).value).startsWith("java/") && !className.startsWith("javax/");
    }

    public static class ConstValue_UTF8
    extends ConstValue<String> {
        public ConstValue_UTF8(String value) {
            super(ClassFileConst.ConstType.CONSTANT_UTF8, value);
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            super.write(out);
            out.writeUTF((String)this.value);
        }
    }

    public static class ConstValue_Zero
    extends ConstValue<Void> {
        public ConstValue_Zero() {
            super(ClassFileConst.ConstType.CONSTANT_ZERO, null);
        }

        @Override
        public boolean isSet() {
            return true;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            throw new RuntimeException("Trying to write Constant 0.");
        }
    }

    public static class ConstValue_Cell<T extends ConstValue<?>>
    extends ConstValue<ConstCell<T>> {
        public ConstValue_Cell(ClassFileConst.ConstType tag, ConstCell<T> constCell) {
            super(tag, constCell);
        }

        @Override
        public String toString() {
            return String.format("[%s %s]", this.tag.toString(), ((ConstCell)this.value).toString());
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            super.write(out);
            ((ConstCell)this.value).write(out);
        }

        @Override
        public boolean isSet() {
            return super.isSet() && ((ConstCell)this.value).isSet() && ((ConstValue)((ConstCell)this.value).ref).isSet();
        }

        @Override
        public int hashCode() {
            int result = this.value != null ? ((ConstCell)this.value).hashCode() : 0;
            result = 31 * result + this.tag.hashCode();
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConstValue_Cell)) {
                return false;
            }
            ConstValue_Cell that = (ConstValue_Cell)obj;
            return Objects.equals(this.value, that.value) && this.tag == that.tag;
        }
    }

    public static class ConstValue_Pair<L extends ConstValue, R extends ConstValue>
    extends ConstValue<Pair<ConstCell<L>, ConstCell<R>>> {
        public ConstValue_Pair(ClassFileConst.ConstType tag, Pair<ConstCell<L>, ConstCell<R>> pair) {
            super(tag, pair);
        }

        public ConstValue_Pair(ClassFileConst.ConstType tag, ConstCell<L> left, ConstCell<R> right) {
            this(tag, new Pair<ConstCell<L>, ConstCell<R>>(left, right));
        }

        @Override
        public boolean isSet() {
            return super.isSet() && ((ConstCell)((Pair)this.value).first).isSet() & ((ConstCell)((Pair)this.value).second).isSet();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConstValue_Pair)) {
                return false;
            }
            ConstValue_Pair that = (ConstValue_Pair)obj;
            return this.tag == that.tag && ((ConstCell)((Pair)this.value).first).equals(((Pair)that.value).first) && ((ConstCell)((Pair)this.value).second).equals(((Pair)that.value).second);
        }

        @Override
        public boolean equalsByValue(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConstValue_Pair)) {
                return false;
            }
            ConstValue_Pair that = (ConstValue_Pair)obj;
            return this.tag == that.tag && ((ConstCell)((Pair)this.value).first).equalsByValue(((Pair)that.value).first) && ((ConstCell)((Pair)this.value).second).equalsByValue(((Pair)that.value).second);
        }

        @Override
        public String toString() {
            return String.format("%s[%s,%s]", this.tag.toString(), ((ConstCell)((Pair)this.value).first).toString(), ((ConstCell)((Pair)this.value).second).toString());
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            super.write(out);
            if (this.tag == ClassFileConst.ConstType.CONSTANT_METHODHANDLE) {
                out.writeByte(((ConstCell)((Pair)this.value).first).cpIndex);
            } else {
                out.writeShort(((ConstCell)((Pair)this.value).first).cpIndex);
            }
            out.writeShort(((ConstCell)((Pair)this.value).second).cpIndex);
        }
    }

    public static enum ReferenceRank {
        LDC(0),
        ANY(1),
        NO(2);

        final int priority;

        private ReferenceRank(int priority) {
            this.priority = priority;
        }
    }

    public static class ConstValue_Integer
    extends ConstValue<Integer> {
        public ConstValue_Integer(ClassFileConst.ConstType tag, Integer value) {
            super(tag, value);
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            super.write(out);
            out.writeInt((Integer)this.value);
        }
    }

    public static class ConstValue_Float
    extends ConstValue<Integer> {
        public ConstValue_Float(Integer value) {
            super(ClassFileConst.ConstType.CONSTANT_FLOAT, value);
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            super.write(out);
            out.writeInt((Integer)this.value);
        }
    }

    public static class ConstValue_Long
    extends ConstValue<Long> {
        public ConstValue_Long(Long value) {
            super(ClassFileConst.ConstType.CONSTANT_LONG, value);
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            super.write(out);
            out.writeLong((Long)this.value);
        }
    }

    public static class ConstValue_Class
    extends ConstValue_Cell<ConstValue_UTF8> {
        public ConstValue_Class(ConstCell<ConstValue_UTF8> value) {
            super(ClassFileConst.ConstType.CONSTANT_CLASS, value);
        }
    }

    public static class ConstValue_InvokeDynamic
    extends ConstValue_BootstrapMethod {
        public ConstValue_InvokeDynamic(BootstrapMethodData bsmData, ConstCell napeCell) {
            super(ClassFileConst.ConstType.CONSTANT_INVOKEDYNAMIC, bsmData, napeCell);
        }
    }

    public static class ConstValue_Dynamic
    extends ConstValue_BootstrapMethod {
        public ConstValue_Dynamic(BootstrapMethodData bsmData, ConstCell napeCell) {
            super(ClassFileConst.ConstType.CONSTANT_DYNAMIC, bsmData, napeCell);
            assert (this.tag == ClassFileConst.ConstType.CONSTANT_DYNAMIC && ConstValue_Dynamic.class.isAssignableFrom(this.getClass()) || this.tag == ClassFileConst.ConstType.CONSTANT_INVOKEDYNAMIC && ConstValue_InvokeDynamic.class.isAssignableFrom(this.getClass()));
        }
    }

    public static class ConstValue_BootstrapMethod
    extends ConstValue<ConstCell> {
        private BootstrapMethodData bsmData;

        public ConstValue_BootstrapMethod(ClassFileConst.ConstType tag, BootstrapMethodData bsmdata, ConstCell value) {
            super(tag, value);
            this.bsmData = bsmdata;
        }

        public BootstrapMethodData bsmData() {
            return this.bsmData;
        }

        public void setBsmData(BootstrapMethodData bsmData, int methodAttrIndex) {
            this.bsmData = bsmData;
            this.bsmData.cpIndex = methodAttrIndex;
        }

        public void setBsmData(BootstrapMethodData bsmData) {
            this.bsmData = bsmData;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConstValue_BootstrapMethod)) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            ConstValue_BootstrapMethod that = (ConstValue_BootstrapMethod)obj;
            return this.bsmData.equals(that.bsmData);
        }

        @Override
        public boolean equalsByValue(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConstValue_BootstrapMethod)) {
                return false;
            }
            if (!super.equalsByValue(obj)) {
                return false;
            }
            ConstValue_BootstrapMethod that = (ConstValue_BootstrapMethod)obj;
            return this.bsmData.equalsByValue(that.bsmData);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.bsmData.hashCode();
            return result;
        }

        @Override
        public boolean isSet() {
            return super.isSet() && this.bsmData != null;
        }

        @Override
        public String toString() {
            return super.toString() + "{" + this.bsmData + "," + this.value + "}";
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            super.write(out);
            out.writeShort(this.bsmData.cpIndex);
            out.writeShort(((ConstCell)this.value).cpIndex);
        }
    }

    public static class ConstValue_MethodHandle<P extends ConstValue_Pair<ConstValue_Class, ConstValue_NameAndType>>
    extends ConstValue<ConstCell<P>> {
        final ClassFileConst.SubTag kind;

        public ConstValue_MethodHandle(ClassFileConst.SubTag kind, ConstCell<P> value) {
            super(ClassFileConst.ConstType.CONSTANT_METHODHANDLE, value);
            this.kind = kind;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            super.write(out);
            out.writeByte(this.kind.value());
            ((ConstCell)this.value).write(out);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConstValue_MethodHandle)) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            ConstValue_MethodHandle that = (ConstValue_MethodHandle)obj;
            return this.kind == that.kind;
        }

        @Override
        public boolean equalsByValue(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConstValue_MethodHandle)) {
                return false;
            }
            if (!super.equalsByValue(obj)) {
                return false;
            }
            ConstValue_MethodHandle that = (ConstValue_MethodHandle)obj;
            return this.kind == that.kind;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.kind.hashCode();
            return result;
        }
    }

    public static class ConstValue_FieldRef
    extends ConstValue_Pair<ConstValue_Class, ConstValue_NameAndType> {
        public ConstValue_FieldRef(ConstCell<ConstValue_Class> classCell, ConstCell<ConstValue_NameAndType> nameAndType) {
            super(ClassFileConst.ConstType.CONSTANT_FIELDREF, classCell, nameAndType);
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            super.write(out);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public boolean equalsByValue(Object obj) {
            return super.equalsByValue(obj);
        }
    }

    public static class ConstValue_InterfaceMethodRef
    extends ConstValue_Pair<ConstValue_Class, ConstValue_NameAndType> {
        public ConstValue_InterfaceMethodRef(ConstCell<ConstValue_Class> interfaceCell, ConstCell<ConstValue_NameAndType> nameAndType) {
            super(ClassFileConst.ConstType.CONSTANT_INTERFACEMETHODREF, interfaceCell, nameAndType);
        }
    }

    public static class ConstValue_MethodRef
    extends ConstValue_Pair<ConstValue_Class, ConstValue_NameAndType> {
        public ConstValue_MethodRef(ConstCell<ConstValue_Class> classCell, ConstCell<ConstValue_NameAndType> nameAndType) {
            super(ClassFileConst.ConstType.CONSTANT_METHODREF, classCell, nameAndType);
        }
    }

    public static class ConstValue_NameAndType
    extends ConstValue_Pair<ConstValue_UTF8, ConstValue_UTF8> {
        public ConstValue_NameAndType(ConstCell<ConstValue_UTF8> name, ConstCell<ConstValue_UTF8> descriptor) {
            super(ClassFileConst.ConstType.CONSTANT_NAMEANDTYPE, name, descriptor);
        }
    }

    public static class ConstValue_MethodType
    extends ConstValue_Cell<ConstValue_UTF8> {
        public ConstValue_MethodType(ConstCell<ConstValue_UTF8> value) {
            super(ClassFileConst.ConstType.CONSTANT_METHODTYPE, value);
        }
    }

    public static class ConstValue_String
    extends ConstValue_Cell<ConstValue_UTF8> {
        public ConstValue_String(ConstCell<ConstValue_UTF8> value) {
            super(ClassFileConst.ConstType.CONSTANT_STRING, value);
        }
    }

    public static class ConstValue_Package
    extends ConstValue_Cell<ConstValue_UTF8> {
        public ConstValue_Package(ConstCell<ConstValue_UTF8> value) {
            super(ClassFileConst.ConstType.CONSTANT_PACKAGE, value);
        }
    }

    public static class ConstValue_Module
    extends ConstValue_Cell<ConstValue_UTF8> {
        public ConstValue_Module(ConstCell<ConstValue_UTF8> value) {
            super(ClassFileConst.ConstType.CONSTANT_MODULE, value);
        }
    }

    public static class ConstValue_Double
    extends ConstValue<Long> {
        public ConstValue_Double(Long value) {
            super(ClassFileConst.ConstType.CONSTANT_DOUBLE, value);
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            super.write(out);
            out.writeLong((Long)this.value);
        }
    }
}

