/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import org.openjdk.asmtools.jasm.ClassFileConst;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.DataWriter;
import org.openjdk.asmtools.jasm.ParserAnnotation;

public interface ConstantPoolDataVisitor
extends DataWriter {
    public <T extends DataWriter> T visit(ConstantPool var1);

    default public <T extends DataWriter> T visitData(T cpData, ConstantPool pool) {
        Object data = ((ConstantPoolDataVisitor)cpData).visit(pool);
        if (data.getClass().isAssignableFrom(ConstCell.class)) {
            ConstCell cell = (ConstCell)data;
            ClassFileConst.ConstType type = cell.getType();
            data = type.oneOf(ClassFileConst.ConstType.CONSTANT_INTEGER, ClassFileConst.ConstType.CONSTANT_FLOAT, ClassFileConst.ConstType.CONSTANT_LONG, ClassFileConst.ConstType.CONSTANT_DOUBLE, ClassFileConst.ConstType.CONSTANT_UTF8) ? new ParserAnnotation.ConstElemValue(type.getAnnotationElementTypeValue(), cell) : new ParserAnnotation.ClassElemValue(cell);
        }
        return data;
    }

    default public <T extends DataWriter> T visitConstCell(ConstCell cell, ConstantPool pool) {
        ConstCell refCell = !cell.isSet() ? pool.uncheckedGetCell(cell.cpIndex) : new ConstCell(cell.cpIndex, cell.ref);
        cell.ref = refCell.ref;
        return (T)cell;
    }
}

