/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.DataWriter;

class DataVectorAttr<T extends DataWriter>
extends AttrData
implements Collection<T> {
    private ArrayList<T> elements;
    private boolean byteIndex;

    private DataVectorAttr(ConstantPool pool, EAttribute eAttribute, boolean byteIndex, ArrayList<T> initialData) {
        super(pool, eAttribute);
        this.elements = initialData;
        this.byteIndex = byteIndex;
    }

    DataVectorAttr(ConstantPool pool, EAttribute attribute, ArrayList<T> initialData) {
        this(pool, attribute, false, initialData);
    }

    DataVectorAttr(ConstantPool pool, EAttribute attribute) {
        this(pool, attribute, false, new ArrayList());
    }

    DataVectorAttr(ConstantPool pool, EAttribute attribute, boolean byteIndex) {
        this(pool, attribute, byteIndex, new ArrayList());
    }

    public T get(int index) {
        return (T)((DataWriter)this.elements.get(index));
    }

    @Override
    public boolean add(T element) {
        return this.elements.add(element);
    }

    @Override
    public boolean remove(Object o) {
        return this.elements.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.elements.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.elements.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.elements.retainAll(c);
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    public DataVectorAttr<T> addAll(Stream<T> s) {
        s.filter(e -> e != null).forEach(this.elements::add);
        return this;
    }

    public T set(int i, T element) {
        return (T)((DataWriter)this.elements.set(i, element));
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    public void replaceAll(Collection<T> collection) {
        this.elements.clear();
        this.elements.addAll(collection);
    }

    public ArrayList<T> getElements() {
        return this.elements;
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <V> V[] toArray(V[] a) {
        return this.elements.toArray(a);
    }

    @Override
    public Stream<T> stream() {
        return this.elements.stream();
    }

    @Override
    public int attrLength() {
        int length = this.elements.stream().mapToInt(e -> e.getLength()).sum();
        return length += this.byteIndex ? 1 : 2;
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        super.write(out);
        if (this.byteIndex) {
            out.writeByte(this.elements.size());
        } else {
            out.writeShort(this.elements.size());
        }
        for (DataWriter elem : this.elements) {
            elem.write(out);
        }
    }
}

