/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.CodeAttr;
import org.openjdk.asmtools.jasm.DataWriter;
import org.openjdk.asmtools.jasm.Indexer;

class ExceptionData
implements DataWriter {
    int pos;
    CodeAttr.RangePC rangePC;
    int handler_pc;
    Indexer catchType;

    public ExceptionData(int pos, CodeAttr.RangePC rangePC, int handler_pc, Indexer catchType) {
        this.pos = pos;
        this.rangePC = rangePC;
        this.handler_pc = handler_pc;
        this.catchType = catchType;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeShort(this.rangePC.start_pc);
        out.writeShort(this.rangePC.end_pc);
        out.writeShort(this.handler_pc);
        if (this.catchType.isSet()) {
            out.writeShort(this.catchType.cpIndex);
        } else {
            out.writeShort(0);
        }
    }
}

