/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.common.structure.EModifier;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CPXAttr;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.JasmEnvironment;
import org.openjdk.asmtools.jasm.MemberData;
import org.openjdk.asmtools.jasm.Parser;

class FieldData
extends MemberData<JasmEnvironment> {
    private ConstantPool.ConstValue_FieldRef fieldRef;
    private AttrData initialValue;

    public FieldData(ClassData classData, int access, ConstantPool.ConstValue_FieldRef fieldRef) {
        super(classData.pool, (JasmEnvironment)classData.getEnvironment(), access);
        this.fieldRef = fieldRef;
        if (EModifier.hasPseudoMod(access)) {
            this.createPseudoMod();
        }
    }

    public ConstantPool.ConstValue_FieldRef getNameDesc() {
        return this.fieldRef;
    }

    public void SetInitialValue(ConstCell<?> cell) {
        this.initialValue = new CPXAttr(this.pool, EAttribute.ATT_ConstantValue, cell);
    }

    public AttrData getInitialValue() {
        return this.initialValue;
    }

    @Override
    protected DataVector getAttrVector() {
        return this.getDataVector(new AttrData[]{this.initialValue, this.syntheticAttr, this.deprecatedAttr, this.signatureAttr});
    }

    public void write(CheckedDataOutputStream out) throws IOException, Parser.CompilerError {
        out.writeShort(this.access);
        out.writeShort(((ConstCell)((Pair)this.fieldRef.value).first).cpIndex);
        out.writeShort(((ConstCell)((Pair)this.fieldRef.value).second).cpIndex);
        DataVector attrs = this.getAttrVector();
        attrs.write(out);
    }
}

