/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.DataWriter;

class InnerClassData
implements DataWriter {
    int access;
    ConstCell name;
    ConstCell innerClass;
    ConstCell outerClass;

    public InnerClassData(int access, ConstCell name, ConstCell innerClass, ConstCell outerClass) {
        this.access = access;
        this.name = name;
        this.innerClass = innerClass;
        this.outerClass = outerClass;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeShort(this.innerClass.cpIndex);
        if (this.outerClass.isSet()) {
            out.writeShort(this.outerClass.cpIndex);
        } else {
            out.writeShort(0);
        }
        if (this.name.isSet()) {
            out.writeShort(this.name.cpIndex);
        } else {
            out.writeShort(0);
        }
        out.writeShort(this.access);
    }
}

