/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.Optional;
import org.openjdk.asmtools.asmutils.HexUtils;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstValue;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.Indexer;
import org.openjdk.asmtools.jasm.JasmEnvironment;
import org.openjdk.asmtools.jasm.MethodData;
import org.openjdk.asmtools.jasm.OpcodeTables;
import org.openjdk.asmtools.jasm.SwitchTable;

class Instr {
    private final JasmEnvironment environment;
    private final ConstantPool pool;
    private final ConstCell<?> nameCell;
    private final ConstCell<?> sigCell;
    private int pos;
    Instr next = null;
    int pc;
    OpcodeTables.Opcode opc;
    Indexer arg;
    Object arg2;

    public Instr(MethodData methodData, JasmEnvironment environment) {
        this.environment = environment;
        this.pool = methodData.getPool();
        this.nameCell = methodData.nameCell;
        this.sigCell = methodData.sigCell;
    }

    public Instr set(int pc, int pos, OpcodeTables.Opcode opc, Indexer arg, Object arg2) {
        this.pc = pc;
        this.pos = pos;
        this.opc = opc;
        this.arg = arg;
        this.arg2 = arg2;
        return this;
    }

    private Indexer fixReference(Indexer arg) {
        if (arg != null && arg instanceof ConstCell) {
            ConstCell cell = (ConstCell)arg;
            if (cell.ref == null || arg.cpIndex == 0) {
                this.environment.warning(this.pos - String.valueOf(arg.cpIndex).length() - 1, "warn.instr.wrong.arg", this.opc.parseKey(), arg.cpIndex);
                return arg;
            }
            if (!arg.isSet()) {
                Optional<ConstCell<?>> optionalCell = this.pool.getItemizedCell((ConstCell)arg);
                if (optionalCell.isPresent()) {
                    arg = optionalCell.get();
                } else {
                    this.environment.throwErrorException(this.pos - String.valueOf(arg.cpIndex).length() - 1, "err.instr.wrong.arg", this.opc.parseKey(), arg.cpIndex);
                }
            }
        }
        return arg;
    }

    public void write(CheckedDataOutputStream out) throws IOException {
        OpcodeTables.OpcodeType type = this.opc.type();
        this.arg = this.fixReference(this.arg);
        switch (type) {
            case NORMAL: {
                if (this.opc == OpcodeTables.Opcode.opc_bytecode) {
                    out.writeByte(this.arg.cpIndex);
                    return;
                }
                out.writeByte(this.opc.value());
                int opcLen = this.opc.length();
                if (opcLen == 1) {
                    return;
                }
                switch (this.opc) {
                    case opc_tableswitch: {
                        ((SwitchTable)this.arg2).writeTableSwitch(out);
                        return;
                    }
                    case opc_lookupswitch: {
                        ((SwitchTable)this.arg2).writeLookupSwitch(out);
                        return;
                    }
                }
                int iarg = 0;
                try {
                    iarg = this.arg.cpIndex;
                }
                catch (NullPointerException e) {
                    this.environment.throwErrorException("err.instr.null.arg", this.opc.parseKey());
                }
                switch (this.opc) {
                    case opc_jsr: 
                    case opc_goto: 
                    case opc_ifeq: 
                    case opc_ifge: 
                    case opc_ifgt: 
                    case opc_ifle: 
                    case opc_iflt: 
                    case opc_ifne: 
                    case opc_if_icmpeq: 
                    case opc_if_icmpne: 
                    case opc_if_icmpge: 
                    case opc_if_icmpgt: 
                    case opc_if_icmple: 
                    case opc_if_icmplt: 
                    case opc_if_acmpeq: 
                    case opc_if_acmpne: 
                    case opc_ifnull: 
                    case opc_ifnonnull: 
                    case opc_jsr_w: 
                    case opc_goto_w: {
                        iarg -= this.pc;
                        break;
                    }
                    case opc_iinc: {
                        iarg = iarg << 8 | ((Indexer)this.arg2).cpIndex & 0xFF;
                        break;
                    }
                    case opc_invokeinterface: {
                        iarg = (iarg << 8 | ((Indexer)this.arg2).cpIndex & 0xFF) << 8;
                        break;
                    }
                    case opc_invokedynamic: {
                        iarg <<= 16;
                        break;
                    }
                    case opc_ldc: {
                        if ((iarg & 0xFFFFFF00) == 0) break;
                        this.environment.throwErrorException("err.instr.arg.long", this.opc.parseKey(), iarg);
                    }
                }
                switch (opcLen) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        if (iarg > 255) {
                            this.environment.warning("warn.instruction.operand.value.overflow", this.getMethodSignature(), this.opc.parseKey(), HexUtils.toHex(iarg), "unsigned 8-bit value 0xFF");
                        }
                        out.writeByte(iarg);
                        return;
                    }
                    case 3: {
                        if (iarg > Short.MAX_VALUE) {
                            this.environment.warning("warn.instruction.operand.value.overflow", this.getMethodSignature(), this.opc.parseKey(), HexUtils.toHex(iarg), "signed 16-bit value " + HexUtils.toHex(Short.MAX_VALUE));
                        }
                        out.writeShort(iarg);
                        return;
                    }
                    case 4: {
                        if (iarg > Short.MAX_VALUE) {
                            this.environment.warning("warn.instruction.operand.value.overflow", this.getMethodSignature(), this.opc.parseKey(), HexUtils.toHex(iarg), "signed 16-bit value " + HexUtils.toHex(Short.MAX_VALUE));
                        }
                        out.writeShort(iarg);
                        iarg = ((Indexer)this.arg2).cpIndex;
                        out.writeByte(iarg);
                        return;
                    }
                    case 5: {
                        if (iarg > Integer.MAX_VALUE) {
                            this.environment.warning("warn.instruction.operand.value.overflow", this.getMethodSignature(), this.opc.parseKey(), HexUtils.toHex(iarg), "signed 32-bit value " + HexUtils.toHex(Integer.MAX_VALUE));
                        }
                        out.writeInt(iarg);
                        return;
                    }
                }
                this.environment.throwErrorException("err.instr.opc.len", this.opc.parseKey(), opcLen);
            }
            case WIDE: {
                out.writeByte(OpcodeTables.Opcode.opc_wide.value());
                out.writeByte((int)(this.opc.value() & 0xFF));
                out.writeShort(this.arg.cpIndex);
                if (this.opc == OpcodeTables.Opcode.opc_iinc_w) {
                    out.writeShort(((Indexer)this.arg2).cpIndex);
                }
                return;
            }
            case PRIVELEGED: 
            case NONPRIVELEGED: {
                out.writeByte(this.opc.value() >> 8);
                out.writeByte((int)(this.opc.value() & 0xFF));
                return;
            }
        }
        this.environment.throwErrorException("err.instr.opc.unknown", this.opc.parseKey());
    }

    private String getMethodSignature() {
        Object res = ((ConstValue)this.nameCell.ref).value != null ? ((ConstValue)this.nameCell.ref).value.toString() : "#" + this.nameCell.cpIndex;
        return (String)res + (String)(((ConstValue)this.sigCell.ref).value != null ? ((ConstValue)this.sigCell.ref).value.toString() : ":#" + this.sigCell.cpIndex);
    }
}

