/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import org.openjdk.asmtools.jasm.TypeAnnotationTypes;

public class JasmTokens {
    public static Token keyword_token_ident(String idValue) {
        return Token.get(idValue, KeywordType.KEYWORD).orElse(Token.IDENT);
    }

    public static enum KeywordType {
        TOKEN(0, "TOKEN"),
        VALUE(1, "VALUE"),
        JASMIDENTIFIER(2, "JASM"),
        KEYWORD(3, "KEYWORD");

        private final Integer value;
        private final String printValue;

        private KeywordType(Integer val, String printValue) {
            this.value = val;
            this.printValue = printValue;
        }

        public String printValue() {
            return this.printValue;
        }
    }

    public static enum Token {
        EOF(-1, "EOF", "EOF", EnumSet.of(TokenType.MISC, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        COMMA(0, "COMMA", ",", EnumSet.of(TokenType.OPERATOR)),
        ASSIGN(1, "ASSIGN", "=", EnumSet.of(TokenType.OPERATOR)),
        ASGMUL(2, "ASGMUL", "*=", EnumSet.of(TokenType.OPERATOR)),
        ASGDIV(3, "ASGDIV", "/=", EnumSet.of(TokenType.OPERATOR)),
        ASGREM(4, "ASGREM", "%=", EnumSet.of(TokenType.OPERATOR)),
        ASGADD(5, "ASGADD", "+=", EnumSet.of(TokenType.OPERATOR)),
        ASGSUB(6, "ASGSUB", "-=", EnumSet.of(TokenType.OPERATOR)),
        ASGLSHIFT(7, "ASGLSHIFT", "<<=", EnumSet.of(TokenType.OPERATOR)),
        ASGRSHIFT(8, "ASGRSHIFT", ">>=", EnumSet.of(TokenType.OPERATOR)),
        ASGURSHIFT(9, "ASGURSHIFT", "<<<=", EnumSet.of(TokenType.OPERATOR)),
        ASGBITAND(10, "ASGBITAND", "&=", EnumSet.of(TokenType.OPERATOR)),
        ASGBITOR(11, "ASGBITOR", "|=", EnumSet.of(TokenType.OPERATOR)),
        ASGBITXOR(12, "ASGBITXOR", "^=", EnumSet.of(TokenType.OPERATOR)),
        COND(13, "COND", "?:", EnumSet.of(TokenType.OPERATOR)),
        OR(14, "OR", "||", EnumSet.of(TokenType.OPERATOR)),
        AND(15, "AND", "&&", EnumSet.of(TokenType.OPERATOR)),
        BITOR(16, "BITOR", "|", EnumSet.of(TokenType.OPERATOR)),
        BITXOR(17, "BITXOR", "^", EnumSet.of(TokenType.OPERATOR)),
        BITAND(18, "BITAND", "&", EnumSet.of(TokenType.OPERATOR)),
        NE(19, "NE", "!=", EnumSet.of(TokenType.OPERATOR)),
        EQ(20, "EQ", "==", EnumSet.of(TokenType.OPERATOR)),
        GE(21, "GE", ">=", EnumSet.of(TokenType.OPERATOR)),
        GT(22, "GT", ">", EnumSet.of(TokenType.OPERATOR)),
        LE(23, "LE", "<=", EnumSet.of(TokenType.OPERATOR)),
        LT(24, "LT", "<", EnumSet.of(TokenType.OPERATOR)),
        INSTANCEOF(25, "INSTANCEOF", "instanceof", EnumSet.of(TokenType.OPERATOR)),
        LSHIFT(26, "LSHIFT", "<<", EnumSet.of(TokenType.OPERATOR)),
        RSHIFT(27, "RSHIFT", ">>", EnumSet.of(TokenType.OPERATOR)),
        URSHIFT(28, "URSHIFT", "<<<", EnumSet.of(TokenType.OPERATOR)),
        ADD(29, "ADD", "+", EnumSet.of(TokenType.OPERATOR)),
        SUB(30, "SUB", "-", EnumSet.of(TokenType.OPERATOR)),
        DIV(31, "DIV", "/", EnumSet.of(TokenType.OPERATOR)),
        REM(32, "REM", "%", EnumSet.of(TokenType.OPERATOR)),
        MUL(33, "MUL", "*", EnumSet.of(TokenType.OPERATOR)),
        CAST(34, "CAST", "cast", EnumSet.of(TokenType.OPERATOR, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        POS(35, "POS", "+", EnumSet.of(TokenType.OPERATOR)),
        NEG(36, "NEG", "-", EnumSet.of(TokenType.OPERATOR)),
        NOT(37, "NOT", "!", EnumSet.of(TokenType.OPERATOR)),
        BITNOT(38, "BITNOT", "~", EnumSet.of(TokenType.OPERATOR)),
        PREINC(39, "PREINC", "++", EnumSet.of(TokenType.OPERATOR)),
        PREDEC(40, "PREDEC", "--", EnumSet.of(TokenType.OPERATOR)),
        NEWARRAY(41, "NEWARRAY", "new", EnumSet.of(TokenType.OPERATOR)),
        NEWINSTANCE(42, "NEWINSTANCE", "new", EnumSet.of(TokenType.OPERATOR)),
        NEWFROMNAME(43, "NEWFROMNAME", "new", EnumSet.of(TokenType.OPERATOR)),
        POSTINC(44, "POSTINC", "++", EnumSet.of(TokenType.OPERATOR)),
        POSTDEC(45, "POSTDEC", "--", EnumSet.of(TokenType.OPERATOR)),
        FIELD(46, "FIELD", "field", EnumSet.of(TokenType.OPERATOR, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        METHOD(47, "METHOD", "method", EnumSet.of(TokenType.OPERATOR, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        ARRAYACCESS(48, "ARRAYACCESS", "[]", EnumSet.of(TokenType.OPERATOR)),
        NEW(49, "NEW", "new", EnumSet.of(TokenType.OPERATOR)),
        INC(50, "INC", "++", EnumSet.of(TokenType.OPERATOR)),
        DEC(51, "DEC", "--", EnumSet.of(TokenType.OPERATOR)),
        CONVERT(55, "CONVERT", "convert", EnumSet.of(TokenType.OPERATOR, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        EXPR(56, "EXPR", "expr", EnumSet.of(TokenType.OPERATOR, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        ARRAY(57, "ARRAY", "array", EnumSet.of(TokenType.OPERATOR, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        GOTO(58, "GOTO", "goto", EnumSet.of(TokenType.OPERATOR)),
        IDENT((Integer)60, "IDENT", "Identifier", EnumSet.of(TokenType.VALUE, TokenType.CLASS_NAME, TokenType.MODULE_NAME, TokenType.JASM_IDENT), KeywordType.VALUE),
        BOOLEANVAL((Integer)61, "BOOLEANVAL", "Boolean", EnumSet.of(TokenType.VALUE, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.VALUE),
        BYTEVAL(62, "BYTEVAL", "Byte", EnumSet.of(TokenType.VALUE, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        CHARVAL(63, "CHARVAL", "Char", EnumSet.of(TokenType.VALUE, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        SHORTVAL(64, "SHORTVAL", "Short", EnumSet.of(TokenType.VALUE, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        INTVAL((Integer)65, "INTVAL", "Integer", EnumSet.of(TokenType.VALUE, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.VALUE),
        LONGVAL((Integer)66, "LONGVAL", "Long", EnumSet.of(TokenType.VALUE, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.VALUE),
        FLOATVAL((Integer)67, "FLOATVAL", "Float", EnumSet.of(TokenType.VALUE, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.VALUE),
        DOUBLEVAL((Integer)68, "DOUBLEVAL", "Double", EnumSet.of(TokenType.VALUE, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.VALUE),
        STRINGVAL((Integer)69, "STRINGVAL", "String", EnumSet.of(TokenType.VALUE, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.VALUE),
        BYTE(70, "BYTE", "byte", EnumSet.of(TokenType.TYPE)),
        CHAR(71, "CHAR", "char", EnumSet.of(TokenType.TYPE)),
        SHORT(72, "SHORT", "short", EnumSet.of(TokenType.TYPE)),
        INT(73, "INT", "int", EnumSet.of(TokenType.TYPE)),
        LONG(74, "LONG", "long", EnumSet.of(TokenType.TYPE)),
        FLOAT(75, "FLOAT", "float", EnumSet.of(TokenType.TYPE)),
        DOUBLE(76, "DOUBLE", "double", EnumSet.of(TokenType.TYPE)),
        VOID(77, "VOID", "void", EnumSet.of(TokenType.TYPE)),
        BOOLEAN(78, "BOOLEAN", "boolean", EnumSet.of(TokenType.TYPE)),
        TRUE(80, "TRUE", "true", EnumSet.of(TokenType.EXPRESSION, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        FALSE(81, "FALSE", "false", EnumSet.of(TokenType.EXPRESSION, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        THIS(82, "THIS", "this", EnumSet.of(TokenType.EXPRESSION)),
        SUPER((Integer)83, "SUPER", "super", EnumSet.of(TokenType.MODIFIER), KeywordType.KEYWORD),
        NULL(84, "NULL", "null", EnumSet.of(TokenType.EXPRESSION, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        THIS_CLASS((Integer)85, "this_class", "this_class", EnumSet.of(TokenType.DECLARATION, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        SUPER_CLASS((Integer)86, "super_class", "super_class", EnumSet.of(TokenType.DECLARATION, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        IF(90, "IF", "if", EnumSet.of(TokenType.STATEMENT)),
        ELSE(91, "ELSE", "else", EnumSet.of(TokenType.STATEMENT)),
        FOR(92, "FOR", "for", EnumSet.of(TokenType.STATEMENT)),
        WHILE(93, "WHILE", "while", EnumSet.of(TokenType.STATEMENT)),
        DO(94, "DO", "do", EnumSet.of(TokenType.STATEMENT)),
        SWITCH(95, "SWITCH", "switch", EnumSet.of(TokenType.STATEMENT)),
        CASE(96, "CASE", "case", EnumSet.of(TokenType.STATEMENT)),
        DEFAULT((Integer)97, "DEFAULT", "default", EnumSet.of(TokenType.STATEMENT), KeywordType.KEYWORD),
        BREAK(98, "BREAK", "break", EnumSet.of(TokenType.STATEMENT)),
        CONTINUE(99, "CONTINUE", "continue", EnumSet.of(TokenType.STATEMENT)),
        RETURN(100, "RETURN", "return", EnumSet.of(TokenType.STATEMENT)),
        TRY(101, "TRY", "try", EnumSet.of(TokenType.STATEMENT)),
        CATCH(102, "CATCH", "catch", EnumSet.of(TokenType.STATEMENT)),
        FINALLY(103, "FINALLY", "finally", EnumSet.of(TokenType.STATEMENT)),
        THROW(104, "THROW", "throw", EnumSet.of(TokenType.STATEMENT)),
        STAT(105, "STAT", "stat", EnumSet.of(TokenType.STATEMENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        EXPRESSION(106, "EXPRESSION", "expression", EnumSet.of(TokenType.STATEMENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        DECLARATION(107, "DECLARATION", "declaration", EnumSet.of(TokenType.STATEMENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        VARDECLARATION(108, "VARDECLARATION", "vdeclaration", EnumSet.of(TokenType.STATEMENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        IMPORT(110, "IMPORT", "import", EnumSet.of(TokenType.DECLARATION, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        CLASS((Integer)111, "CLASS", "class", EnumSet.of(TokenType.DECLARATION, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        EXTENDS((Integer)112, "EXTENDS", "extends", EnumSet.of(TokenType.DECLARATION, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        IMPLEMENTS((Integer)113, "IMPLEMENTS", "implements", EnumSet.of(TokenType.DECLARATION, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        INTERFACE((Integer)114, "INTERFACE", "interface", EnumSet.of(TokenType.DECLARATION, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        PACKAGE((Integer)115, "PACKAGE", "package", EnumSet.of(TokenType.DECLARATION), KeywordType.KEYWORD),
        ENUM((Integer)116, "ENUM", "enum", EnumSet.of(TokenType.DECLARATION), KeywordType.KEYWORD),
        MANDATED((Integer)117, "MANDATED", "mandated", EnumSet.of(TokenType.DECLARATION, TokenType.CLASS_NAME), KeywordType.KEYWORD),
        THROWS((Integer)118, "THROWS", "throws", EnumSet.of(TokenType.DECLARATION), KeywordType.KEYWORD),
        ANNOTATION_ACCESS((Integer)119, "ANNOTATION_ACCESS", "annotation", EnumSet.of(TokenType.MODIFIER, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        PRIVATE((Integer)120, "PRIVATE", "private", EnumSet.of(TokenType.MODIFIER), KeywordType.KEYWORD),
        PUBLIC((Integer)121, "PUBLIC", "public", EnumSet.of(TokenType.MODIFIER), KeywordType.KEYWORD),
        PROTECTED((Integer)122, "PROTECTED", "protected", EnumSet.of(TokenType.MODIFIER), KeywordType.KEYWORD),
        CONST((Integer)123, "CONST", "const", EnumSet.of(TokenType.DECLARATION), KeywordType.KEYWORD),
        STATIC((Integer)124, "STATIC", "static", EnumSet.of(TokenType.MODIFIER), KeywordType.KEYWORD),
        TRANSIENT((Integer)125, "TRANSIENT", "transient", EnumSet.of(TokenType.MODIFIER, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        SYNCHRONIZED((Integer)126, "SYNCHRONIZED", "synchronized", EnumSet.of(TokenType.MODIFIER), KeywordType.KEYWORD),
        NATIVE((Integer)127, "NATIVE", "native", EnumSet.of(TokenType.MODIFIER), KeywordType.KEYWORD),
        FINAL((Integer)128, "FINAL", "final", EnumSet.of(TokenType.MODIFIER), KeywordType.KEYWORD),
        VOLATILE((Integer)129, "VOLATILE", "volatile", EnumSet.of(TokenType.MODIFIER), KeywordType.KEYWORD),
        ABSTRACT((Integer)130, "ABSTRACT", "abstract", EnumSet.of(TokenType.MODIFIER), KeywordType.KEYWORD),
        TRANSITIVE((Integer)131, "TRANSITIVE", "transitive", EnumSet.of(TokenType.MODIFIER, TokenType.CLASS_NAME), KeywordType.KEYWORD),
        OPEN((Integer)132, "OPEN", "open", EnumSet.of(TokenType.MODIFIER, TokenType.CLASS_NAME), KeywordType.KEYWORD),
        AT_SIGN((Integer)133, "AT", "@", EnumSet.of(TokenType.PUNCTUATION), KeywordType.VALUE),
        SEMICOLON((Integer)134, "SEMICOLON", ";", EnumSet.of(TokenType.PUNCTUATION), KeywordType.VALUE),
        COLON((Integer)135, "COLON", ":", EnumSet.of(TokenType.PUNCTUATION), KeywordType.VALUE),
        QUESTIONMARK(136, "QUESTIONMARK", "?", EnumSet.of(TokenType.PUNCTUATION)),
        LBRACE((Integer)137, "LBRACE", "{", EnumSet.of(TokenType.PUNCTUATION), KeywordType.VALUE),
        RBRACE((Integer)138, "RBRACE", "}", EnumSet.of(TokenType.PUNCTUATION), KeywordType.VALUE),
        LPAREN(139, "LPAREN", "(", EnumSet.of(TokenType.PUNCTUATION)),
        RPAREN(140, "RPAREN", ")", EnumSet.of(TokenType.PUNCTUATION)),
        LSQBRACKET(141, "LSQBRACKET", "[", EnumSet.of(TokenType.PUNCTUATION)),
        RSQBRACKET(142, "RSQBRACKET", "]", EnumSet.of(TokenType.PUNCTUATION)),
        ESCAPED_COLON(201, "ESCCOLON", "\\:", EnumSet.of(TokenType.PUNCTUATION)),
        ESCAPED_ATSIGH(202, "ESCATSIGH", "\\@", EnumSet.of(TokenType.PUNCTUATION)),
        ESCAPED_BACKSLASH(203, "ESCBACKSLASH", "\\\\", EnumSet.of(TokenType.PUNCTUATION)),
        ERROR(145, "ERROR", "error", EnumSet.of(TokenType.MODIFIER, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        COMMENT(146, "COMMENT", "comment", EnumSet.of(TokenType.MODIFIER, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        TYPE(147, "TYPE", "type", EnumSet.of(TokenType.MODIFIER, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        LENGTH(148, "LENGTH", "length", EnumSet.of(TokenType.DECLARATION, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        INLINERETURN(149, "INLINERETURN", "inline-return", EnumSet.of(TokenType.MODIFIER)),
        INLINEMETHOD(150, "INLINEMETHOD", "inline-method", EnumSet.of(TokenType.MODIFIER)),
        INLINENEWINSTANCE(151, "INLINENEWINSTANCE", "inline-new", EnumSet.of(TokenType.MODIFIER)),
        METHODREF((Integer)152, "METHODREF", "Method", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        FIELDREF((Integer)153, "FIELD", "Field", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        STACK((Integer)154, "STACK", "stack", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        LOCAL((Integer)155, "LOCAL", "locals", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        CPINDEX(156, "CPINDEX", "CPINDEX", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        CPNAME(157, "CPNAME", "CPName", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        SIGN(158, "SIGN", "SIGN", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME)),
        BITS((Integer)159, "BITS", "bits", EnumSet.of(TokenType.MISC, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        INF(160, "INF", "Inf", "Infinity", EnumSet.of(TokenType.MISC, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        NAN((Integer)161, "NAN", "NaN", EnumSet.of(TokenType.MISC, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        INNERCLASS((Integer)162, "INNERCLASS", "InnerClass", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        OF((Integer)163, "OF", "of", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        SYNTHETIC((Integer)164, "SYNTHETIC", "synthetic", EnumSet.of(TokenType.MODIFIER, TokenType.JASM_IDENT, TokenType.CLASS_NAME), KeywordType.KEYWORD),
        STRICT((Integer)165, "STRICT", "strict", EnumSet.of(TokenType.MODIFIER, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        DEPRECATED((Integer)166, "DEPRECATED", "deprecated", EnumSet.of(TokenType.MODIFIER, TokenType.JASM_IDENT, TokenType.CLASS_NAME), KeywordType.KEYWORD),
        VERSION((Integer)167, "VERSION", "version", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME), KeywordType.KEYWORD),
        MODULE((Integer)168, "MODULE", "module", EnumSet.of(TokenType.DECLARATION, TokenType.CLASS_NAME), KeywordType.KEYWORD),
        ANNOTATION(169, "ANNOTATION", "@", EnumSet.of(TokenType.MISC)),
        PARAM_NAME(170, "PARAM_NAME", "#", EnumSet.of(TokenType.MISC)),
        VARARGS((Integer)171, "VARARGS", "varargs", EnumSet.of(TokenType.MODIFIER, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        BRIDGE((Integer)172, "BRIDGE", "bridge", EnumSet.of(TokenType.MODIFIER, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        BOOTSTRAPMETHOD((Integer)173, "BOOTSTRAPMETHOD", "BootstrapMethod", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        NESTHOST((Integer)174, "NESTHOST", "NestHost", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        SIGNATURE((Integer)175, "SIGNATURE", "Signature", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        NESTMEMBERS((Integer)176, "NESTMEMBERS", "NestMembers", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        RECORD((Integer)177, "RECORD", "Record", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        COMPONENT((Integer)178, "COMPONENT", "Component", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        PERMITTEDSUBCLASSES((Integer)179, "PERMITTEDSUBCLASSES", "PermittedSubclasses", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        SOURCEFILE((Integer)180, "SOURCEFILE", "SourceFile", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        SOURCEDEBUGEXTENSION((Integer)181, "SOURCEDEBUGEXTENSION", "SourceDebugExtension", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        REQUIRES((Integer)182, "REQUIRES", "requires", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME), KeywordType.KEYWORD),
        EXPORTS((Integer)183, "EXPORTS", "exports", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME), KeywordType.KEYWORD),
        TO((Integer)184, "TO", "to", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME), KeywordType.KEYWORD),
        USES((Integer)185, "USES", "uses", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME), KeywordType.KEYWORD),
        PROVIDES((Integer)186, "PROVIDES", "provides", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME), KeywordType.KEYWORD),
        WITH((Integer)187, "WITH", "with", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME), KeywordType.KEYWORD),
        OPENS((Integer)188, "OPENS", "opens", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME), KeywordType.KEYWORD),
        ARRAY_TYPEPATH((Integer)190, TypeAnnotationTypes.EPathKind.ARRAY.parseKey(), TypeAnnotationTypes.EPathKind.ARRAY.parseKey(), EnumSet.of(TokenType.TYPE_PATH_KIND, TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        INNER_TYPE_TYPEPATH((Integer)191, TypeAnnotationTypes.EPathKind.INNER_TYPE.parseKey(), TypeAnnotationTypes.EPathKind.INNER_TYPE.parseKey(), EnumSet.of(TokenType.TYPE_PATH_KIND, TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        WILDCARD_TYPEPATH((Integer)192, TypeAnnotationTypes.EPathKind.WILDCARD.parseKey(), TypeAnnotationTypes.EPathKind.WILDCARD.parseKey(), EnumSet.of(TokenType.TYPE_PATH_KIND, TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        TYPE_ARGUMENT_TYPEPATH((Integer)193, TypeAnnotationTypes.EPathKind.TYPE_ARGUMENT.parseKey(), TypeAnnotationTypes.EPathKind.TYPE_ARGUMENT.parseKey(), EnumSet.of(TokenType.TYPE_PATH_KIND, TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        VALUE((Integer)200, "VALUE", "value", EnumSet.of(TokenType.MODIFIER, TokenType.CLASS_NAME, TokenType.MODULE_NAME, TokenType.JASM_IDENT), KeywordType.KEYWORD),
        PERMITS_VALUE((Integer)201, "PERMITS_VALUE", "permits_value", EnumSet.of(TokenType.MODIFIER, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD),
        PRIMITIVE((Integer)202, "PRIMITIVE", "primitive", EnumSet.of(TokenType.MODIFIER, TokenType.CLASS_NAME, TokenType.MODULE_NAME, TokenType.JASM_IDENT), KeywordType.KEYWORD),
        PRELOAD((Integer)203, "PRELOAD", "Preload", EnumSet.of(TokenType.DECLARATION, TokenType.JASM_IDENT, TokenType.CLASS_NAME, TokenType.MODULE_NAME), KeywordType.KEYWORD);

        static final EnumSet<Token> ALL_TOKENS;
        private final Integer value;
        private final String printValue;
        private final String parseKey;
        private final String alias;
        private final EnumSet<TokenType> tokenType;
        private final KeywordType key_type;

        public static Optional<Token> get(String parseKey, KeywordType keywordType) {
            return ALL_TOKENS.stream().filter(t -> t.key_type == keywordType).filter(t -> t.parseKey.equals(parseKey) || t.alias != null && t.alias.equals(parseKey)).findFirst();
        }

        public boolean in(Token ... tokens) {
            return tokens == null ? false : Arrays.asList(tokens).contains((Object)this);
        }

        private Token(Integer val, String print, String parseKey, EnumSet<TokenType> tokenType) {
            this(val, print, parseKey, null, tokenType, KeywordType.TOKEN);
        }

        private Token(Integer val, String print, String parseKey, String als, EnumSet<TokenType> tokenType) {
            this(val, print, parseKey, als, tokenType, KeywordType.TOKEN);
        }

        private Token(Integer val, String print, String parseKey, EnumSet<TokenType> tokenType, KeywordType ktype) {
            this(val, print, parseKey, null, tokenType, ktype);
        }

        private Token(Integer val, String print, String parseKey, String als, EnumSet<TokenType> tokenType, KeywordType ktype) {
            this.value = val;
            this.printValue = print;
            this.parseKey = parseKey;
            this.tokenType = tokenType;
            this.key_type = ktype;
            this.alias = als;
        }

        public String printValue() {
            return this.printValue;
        }

        public String parseKey() {
            return this.parseKey;
        }

        public int value() {
            return this.value;
        }

        public boolean isPossibleJasmIdentifier() {
            return this.tokenType.contains((Object)TokenType.JASM_IDENT);
        }

        public boolean isPossibleModuleName() {
            return this.tokenType.contains((Object)TokenType.MODULE_NAME);
        }

        public boolean isPossibleClassName() {
            return this.tokenType.contains((Object)TokenType.CLASS_NAME);
        }

        public boolean possibleTypePathKind() {
            return this.tokenType.contains((Object)TokenType.TYPE_PATH_KIND);
        }

        public String toString() {
            return "<" + this.printValue + "> [" + this.value + "]";
        }

        static {
            ALL_TOKENS = EnumSet.allOf(Token.class);
        }
    }

    public static enum AnnotationType {
        Visible("@+"),
        Invisible("@-"),
        VisibleType("@T+"),
        InvisibleType("@T-");

        private final String jasmPrefix;

        private AnnotationType(String jasmPrefix) {
            this.jasmPrefix = jasmPrefix;
        }

        public static boolean isAnnotationToken(String str) {
            return str.startsWith(AnnotationType.Invisible.jasmPrefix) || str.startsWith(AnnotationType.Visible.jasmPrefix);
        }

        public static boolean isTypeAnnotationToken(String str) {
            return str.startsWith(AnnotationType.InvisibleType.jasmPrefix) || str.startsWith(AnnotationType.VisibleType.jasmPrefix);
        }

        public static boolean isAnnotation(String str) {
            return str.startsWith("@");
        }

        public static boolean isInvisibleAnnotationToken(String str) {
            return str.endsWith("-");
        }
    }

    public static enum TokenType {
        MODIFIER(1, "Modifier"),
        OPERATOR(2, "Operator"),
        VALUE(3, "Value"),
        TYPE(4, "Type"),
        EXPRESSION(5, "Expression"),
        STATEMENT(6, "Statement"),
        DECLARATION(7, "Declaration"),
        PUNCTUATION(8, "Punctuation"),
        SPECIAL(9, "Special"),
        JASM(10, "Jasm"),
        MISC(11, "Misc"),
        JASM_IDENT(12, "Jasm identifier"),
        MODULE_NAME(13, "Module Name"),
        TYPE_PATH_KIND(14, "Type path kind"),
        CLASS_NAME(15, "Class Name");

        private final Integer value;
        private final String printValue;

        private TokenType(Integer value, String printValue) {
            this.value = value;
            this.printValue = printValue;
        }

        public String printValue() {
            return this.printValue;
        }
    }
}

