/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstValue;
import org.openjdk.asmtools.jasm.DataWriter;
import org.openjdk.asmtools.jasm.FieldType;

class LocVarData
implements DataWriter {
    private final short index;
    FieldType fieldType;
    private short start_pc;
    private short length;
    private ConstCell nameCell;
    private ConstCell descriptorCell;

    public LocVarData(short index, short curPC, ConstCell nameCell, ConstCell descriptorCell) {
        this.index = index;
        this.start_pc = curPC;
        this.nameCell = nameCell;
        this.descriptorCell = descriptorCell;
        this.fieldType = FieldType.getFieldType(((String)((ConstValue)descriptorCell.ref).value).charAt(0));
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public int getSlotsCount() {
        return this.getFieldType() == null ? 0 : this.fieldType.getSlotsCount();
    }

    public short getIndex() {
        return this.index;
    }

    @Override
    public int getLength() {
        return 10;
    }

    public void setLength(int CurrentPC) {
        this.length = (short)(CurrentPC - this.start_pc);
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeShort(this.start_pc);
        out.writeShort(this.length);
        out.writeShort(this.nameCell.cpIndex);
        out.writeShort(this.descriptorCell.cpIndex);
        out.writeShort(this.index);
    }

    public void setStartPc(short start_pc) {
        this.start_pc = start_pc;
    }
}

