/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.PatternSyntaxException;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.common.inputs.FileInput;
import org.openjdk.asmtools.common.inputs.ToolInput;
import org.openjdk.asmtools.common.outputs.PrintWriterOutput;
import org.openjdk.asmtools.common.outputs.StdoutOutput;
import org.openjdk.asmtools.common.outputs.ToolOutput;
import org.openjdk.asmtools.common.outputs.log.DualOutputStreamOutput;
import org.openjdk.asmtools.common.outputs.log.DualStreamToolOutput;
import org.openjdk.asmtools.common.outputs.log.StderrLog;
import org.openjdk.asmtools.common.structure.CFVersion;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.JasmEnvironment;
import org.openjdk.asmtools.jasm.JasmTool;
import org.openjdk.asmtools.jasm.Parser;
import org.openjdk.asmtools.util.ProductInfo;

public class Main
extends JasmTool {
    private final CFVersion cfv = new CFVersion();
    private boolean noWriteFlag = false;
    private int byteLimit = 0;
    private boolean debugScanner = false;
    private boolean debugMembers = false;
    private boolean debugCP = false;
    private boolean debugAnnot = false;
    private boolean debugInstr = false;

    public Main(ToolOutput toolOutput, String ... argv) {
        super(toolOutput);
        this.parseArgs(argv);
    }

    public Main(ToolOutput toolOutput, DualStreamToolOutput log, String ... argv) {
        super(toolOutput, log);
        this.parseArgs(argv);
    }

    public Main(ToolOutput toolOutput, DualStreamToolOutput log, ToolInput toolInput, String ... argv) {
        super(toolOutput, log);
        if (toolInput != null) {
            this.fileList.add(toolInput);
        }
        this.parseArgs(argv);
    }

    public Main(ToolOutput toolOutput, DualStreamToolOutput log, ToolInput ... toolInputs) {
        super(toolOutput, log);
        Collections.addAll(this.fileList, toolInputs);
    }

    public Main(ToolOutput toolOutput, DualStreamToolOutput log, ToolInput toolInput) {
        super(toolOutput, log);
        this.fileList.add(toolInput);
    }

    @Deprecated
    public Main(PrintWriter ref, String toolName) {
        super(new PrintWriterOutput(ref));
    }

    @Deprecated
    public Main(PrintStream out, String toolName) {
        this(new PrintWriter(out), toolName);
    }

    public static void main(String ... argv) {
        Main compiler = new Main((ToolOutput)new StdoutOutput(), (DualStreamToolOutput)new StderrLog(), argv);
        System.exit(compiler.compile());
    }

    public synchronized boolean compile(String ... argv) {
        this.parseArgs(argv);
        return this.compile() == 0;
    }

    public synchronized int compile() {
        int rc = 0;
        try {
            for (ToolInput inputFileName : this.fileList) {
                ((JasmEnvironment)this.environment).setInputFile(inputFileName);
                Parser parser = new Parser((JasmEnvironment)this.environment, this.cfv);
                parser.setDebugFlags(this.debugScanner, this.debugMembers, this.debugCP, this.debugAnnot, this.debugInstr);
                parser.parseFile();
                if (((JasmEnvironment)this.environment).getErrorCount() <= 0L) {
                    ClassData[] clsData;
                    if (this.noWriteFlag) continue;
                    for (ClassData cd : clsData = parser.getClassesData()) {
                        String fqn = cd.myClassName;
                        ((JasmEnvironment)this.environment).getToolOutput().startClass(fqn, Optional.of(cd.fileExtension), this.environment);
                        if (this.byteLimit > 0) {
                            cd.setByteLimit(this.byteLimit);
                        }
                        cd.write(((JasmEnvironment)this.environment).getToolOutput());
                        ((JasmEnvironment)this.environment).getToolOutput().finishClass(fqn);
                    }
                    if (!((JasmEnvironment)this.environment).hasMessages()) continue;
                    rc += ((JasmEnvironment)this.environment).flush(true);
                    continue;
                }
                break;
            }
        }
        catch (IOException | Error | URISyntaxException exception) {
            ((JasmEnvironment)this.environment).printException(exception);
            ++rc;
        }
        catch (Throwable exception) {
            ((JasmEnvironment)this.environment).printException(exception);
            ((JasmEnvironment)this.environment).error(exception);
        }
        if (((JasmEnvironment)this.environment).hasMessages()) {
            rc += ((JasmEnvironment)this.environment).flush(true);
        }
        return rc;
    }

    @Override
    public void usage() {
        ((JasmEnvironment)this.environment).flush(false);
        ((JasmEnvironment)this.environment).usage(List.of("info.usage", "info.opt.d", "info.opt.nowrite", "info.opt.nowarn", "info.opt.strict", "info.opt.cv", "info.opt.fixcv", "info.opt.fixcv.full", "info.opt.t", "info.opt.v", "info.opt.version"));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void parseArgs(String ... argv) {
        try {
            block49: for (i = 0; i < argv.length; ++i) {
                var4_5 = arg = argv[i];
                var5_6 = -1;
                switch (var4_5.hashCode()) {
                    case 1513: {
                        if (!var4_5.equals("-v")) break;
                        var5_6 = 0;
                        break;
                    }
                    case 1511: {
                        if (!var4_5.equals("-t")) break;
                        var5_6 = 1;
                        break;
                    }
                    case 390973750: {
                        if (!var4_5.equals("-strict")) break;
                        var5_6 = 2;
                        break;
                    }
                    case 243352116: {
                        if (!var4_5.equals("-nowarn")) break;
                        var5_6 = 3;
                        break;
                    }
                    case -1045520911: {
                        if (!var4_5.equals("-nowrite")) break;
                        var5_6 = 4;
                        break;
                    }
                    case 1468661771: {
                        if (!var4_5.equals("-version")) break;
                        var5_6 = 5;
                        break;
                    }
                    case 1495: {
                        if (!var4_5.equals("-d")) break;
                        var5_6 = 6;
                        break;
                    }
                    case 1440158: {
                        if (!var4_5.equals("-dls")) break;
                        var5_6 = 7;
                        break;
                    }
                    case 1499: {
                        if (!var4_5.equals("-h")) break;
                        var5_6 = 8;
                        break;
                    }
                    case 44757230: {
                        if (!var4_5.equals("-help")) break;
                        var5_6 = 9;
                        break;
                    }
                    case 1458: {
                        if (!var4_5.equals("-?")) break;
                        var5_6 = 10;
                        break;
                    }
                    case 1385757499: {
                        if (!var4_5.equals("-fixcv")) break;
                        var5_6 = 11;
                        break;
                    }
                    case 46432: {
                        if (!var4_5.equals("-cv")) break;
                        var5_6 = 12;
                        break;
                    }
                    case 1367613381: {
                        if (!var4_5.equals("-XdScanner")) break;
                        var5_6 = 13;
                        break;
                    }
                    case -125465613: {
                        if (!var4_5.equals("-XdMember")) break;
                        var5_6 = 14;
                        break;
                    }
                    case 44278310: {
                        if (!var4_5.equals("-XdCP")) break;
                        var5_6 = 15;
                        break;
                    }
                    case 546722419: {
                        if (!var4_5.equals("-XdInstr")) break;
                        var5_6 = 16;
                        break;
                    }
                    case 539329293: {
                        if (!var4_5.equals("-XdAnnot")) break;
                        var5_6 = 17;
                        break;
                    }
                    case 1372626664: {
                        if (!var4_5.equals("-XdAll")) break;
                        var5_6 = 18;
                        break;
                    }
                    case 578890594: {
                        if (!var4_5.equals("-Xdlimit")) break;
                        var5_6 = 19;
                        break;
                    }
                    case 45: {
                        if (!var4_5.equals("-")) break;
                        var5_6 = 20;
                    }
                }
                switch (var5_6) {
                    case 0: {
                        this.setVerboseFlag(true);
                        continue block49;
                    }
                    case 1: {
                        this.setVerboseFlag(true);
                        this.setTraceFlag(true);
                        continue block49;
                    }
                    case 2: {
                        ((JasmEnvironment)this.environment).setStrictWarningsOn();
                        continue block49;
                    }
                    case 3: {
                        ((JasmEnvironment)this.environment).setIgnoreWarningsOn();
                        continue block49;
                    }
                    case 4: {
                        this.noWriteFlag = true;
                        continue block49;
                    }
                    case 5: {
                        ((JasmEnvironment)this.environment).println(ProductInfo.FULL_VERSION, new Object[0]);
                        System.exit(0);
                        continue block49;
                    }
                    case 6: {
                        this.setDestDir(++i, argv);
                        continue block49;
                    }
                    case 7: {
                        ((JasmEnvironment)this.environment).setOutputs(new DualOutputStreamOutput());
                        continue block49;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        this.usage();
                        System.exit(0);
                        continue block49;
                    }
                    case 11: 
                    case 12: {
                        frozenCFV = arg.startsWith("-fix");
                        if (i + 1 >= argv.length) {
                            if (frozenCFV) {
                                ((JasmEnvironment)this.environment).error("err.fix_cv_requires_arg", new Object[0]);
                            } else {
                                ((JasmEnvironment)this.environment).error("err.cv_requires_arg", new Object[0]);
                            }
                            this.usage();
                            throw new IllegalArgumentException();
                        }
                        try {
                            cfvArg = argv[++i];
                            if (cfvArg.contains("-")) {
                                if (!frozenCFV) {
                                    throw new NumberFormatException();
                                }
                                versions = cfvArg.split("-", 2);
                                versionsThreshold = versions[0].split("[.:]+", 2);
                                versionsUpdate = versions[1].split("[.:]+", 2);
                                if (versionsThreshold.length != 2 || versionsUpdate.length != 2) {
                                    throw new NumberFormatException();
                                }
                                versionsPair = new Pair<Integer, Integer>(Integer.parseInt(versionsThreshold[0]), Integer.parseInt(versionsThreshold[1]));
                                if ((Integer)versionsPair.second > 65535 || (Integer)versionsPair.first > 65535) {
                                    throw new NumberFormatException();
                                }
                                this.cfv.setThreshold((Integer)versionsPair.first, (Integer)versionsPair.second);
                                versionsPair = new Pair<Integer, Integer>(Integer.parseInt(versionsUpdate[0]), Integer.parseInt(versionsUpdate[1]));
                                if ((Integer)versionsPair.second > 65535 || (Integer)versionsPair.first > 65535) {
                                    throw new NumberFormatException();
                                }
                                this.cfv.setVersion((Integer)versionsPair.first, (Integer)versionsPair.second).setByParameter(true).setFrozen(true);
                                ** break;
                            }
                            versions = cfvArg.split("[.:]+", 2);
                            if (versions.length == 2) {
                                versionsPair = new Pair<Integer, Integer>(Integer.parseInt(versions[0]), Integer.parseInt(versions[1]));
                                if ((Integer)versionsPair.second > 65535 || (Integer)versionsPair.first > 65535) {
                                    throw new NumberFormatException();
                                }
                                this.cfv.setVersion(Integer.parseInt(versions[0]), Integer.parseInt(versions[1])).setByParameter(true).setFrozen(frozenCFV);
                                ** break;
                            }
                            throw new NumberFormatException();
lbl162:
                            // 2 sources

                            continue block49;
                        }
                        catch (NumberFormatException | PatternSyntaxException exception) {
                            if (frozenCFV) {
                                ((JasmEnvironment)this.environment).error("err.invalid_threshold_major_minor_param", new Object[0]);
                            } else {
                                ((JasmEnvironment)this.environment).error("err.invalid_major_minor_param", new Object[0]);
                            }
                            this.usage();
                            throw new IllegalArgumentException();
                        }
                    }
                    case 13: {
                        this.debugScanner = true;
                        continue block49;
                    }
                    case 14: {
                        this.debugMembers = true;
                        continue block49;
                    }
                    case 15: {
                        this.debugCP = true;
                        continue block49;
                    }
                    case 16: {
                        this.debugInstr = true;
                        continue block49;
                    }
                    case 17: {
                        this.debugAnnot = true;
                        continue block49;
                    }
                    case 18: {
                        this.debugScanner = true;
                        this.debugMembers = true;
                        this.debugCP = true;
                        this.debugInstr = true;
                        this.debugAnnot = true;
                        continue block49;
                    }
                    case 19: {
                        if (i + 1 > argv.length) {
                            ((JasmEnvironment)this.environment).error("err.byte.limit", new Object[0]);
                            throw new IllegalArgumentException();
                        }
                        try {
                            this.byteLimit = Integer.parseInt(argv[++i]);
                            continue block49;
                        }
                        catch (NumberFormatException e) {
                            ((JasmEnvironment)this.environment).error("err.byte.limit", new Object[0]);
                            throw new IllegalArgumentException();
                        }
                    }
                    case 20: {
                        this.addStdIn();
                        continue block49;
                    }
                    default: {
                        if (arg.startsWith("-")) {
                            ((JasmEnvironment)this.environment).error("err.invalid_option", new Object[]{arg});
                            this.usage();
                            throw new IllegalArgumentException();
                        }
                        this.fileList.add(new FileInput(argv[i]));
                    }
                }
            }
            if (this.fileList.isEmpty()) {
                this.usage();
                System.exit(1);
            }
        }
        catch (IllegalArgumentException iae) {
            if (((JasmEnvironment)this.environment).hasMessages()) {
                ((JasmEnvironment)this.environment).flush(false);
            }
            System.exit(1);
        }
    }
}

