/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.openjdk.asmtools.common.CompilerConstants;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.common.structure.EModifier;
import org.openjdk.asmtools.jasm.AnnotationData;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.CodeAttr;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.DataVectorAttr;
import org.openjdk.asmtools.jasm.DataWriter;
import org.openjdk.asmtools.jasm.DefaultAnnotationAttr;
import org.openjdk.asmtools.jasm.Indexer;
import org.openjdk.asmtools.jasm.JasmEnvironment;
import org.openjdk.asmtools.jasm.MemberData;
import org.openjdk.asmtools.jasm.Parser;

class MethodData
extends MemberData<JasmEnvironment> {
    protected ClassData classData;
    protected ConstCell<?> nameCell;
    protected ConstCell<?> sigCell;
    protected CodeAttr code;
    protected DataVectorAttr<ConstCell<?>> exceptions = null;
    protected DataVectorAttr<MethodParameterData> methodParameters = null;
    protected DataPArrayAttr<AnnotationData> pannotAttrVis = null;
    protected DataPArrayAttr<AnnotationData> pannotAttrInv = null;
    protected DefaultAnnotationAttr defaultAnnot = null;

    public MethodData(ClassData classData, int access, ConstCell<?> name, ConstCell<?> signature, ArrayList<ConstCell<?>> exc_table) {
        super(classData.pool, (JasmEnvironment)classData.getEnvironment(), access);
        this.classData = classData;
        this.nameCell = name;
        this.sigCell = signature;
        if (exc_table != null && !exc_table.isEmpty()) {
            this.exceptions = new DataVectorAttr(classData.pool, EAttribute.ATT_Exceptions, exc_table);
        }
        if (EModifier.hasPseudoMod(access)) {
            this.createPseudoMod();
        }
    }

    public void addMethodParameter(int totalParams, int paramNum, ConstCell<?> name, int access) {
        ((JasmEnvironment)this.getEnvironment()).traceln("addMethodParameter Param[" + paramNum + "] (name: " + name.toString() + ", Flags (" + access + ").", new Object[0]);
        if (this.methodParameters == null) {
            this.methodParameters = new DataVectorAttr(this.classData.pool, EAttribute.ATT_MethodParameters, true);
            for (int i = 0; i < totalParams; ++i) {
                this.methodParameters.add(new MethodParameterData(0, null));
            }
        }
        this.methodParameters.set(paramNum, new MethodParameterData(access, name));
    }

    public CodeAttr startCode(int paramCount, Indexer max_stack, Indexer max_locals) {
        this.code = new CodeAttr(this, paramCount, max_stack, max_locals);
        return this.code;
    }

    public void addDefaultAnnotation(DefaultAnnotationAttr data) {
        this.defaultAnnot = data;
    }

    public void addParamAnnotation(int totalParams, int paramNum, AnnotationData data) {
        if (!data.invisible) {
            if (this.pannotAttrVis == null) {
                this.pannotAttrVis = new DataPArrayAttr(this.classData.pool, EAttribute.ATT_RuntimeVisibleParameterAnnotations, totalParams);
            }
            this.pannotAttrVis.put(paramNum, data);
        } else {
            if (this.pannotAttrInv == null) {
                this.pannotAttrInv = new DataPArrayAttr(this.classData.pool, EAttribute.ATT_RuntimeInvisibleParameterAnnotations, totalParams);
            }
            this.pannotAttrInv.put(paramNum, data);
        }
    }

    @Override
    protected DataVector getAttrVector() {
        DataVector dv = this.getDataVector(new AttrData[]{this.exceptions, this.syntheticAttr, this.deprecatedAttr, this.signatureAttr, this.methodParameters, this.code, this.defaultAnnot});
        if (this.pannotAttrVis != null) {
            dv.add(this.pannotAttrVis);
        }
        if (this.pannotAttrInv != null) {
            dv.add(this.pannotAttrInv);
        }
        return dv;
    }

    public void write(CheckedDataOutputStream out) throws IOException, Parser.CompilerError {
        out.writeShort(this.access);
        out.writeShort(this.nameCell.cpIndex);
        out.writeShort(this.sigCell.cpIndex);
        this.getAttrVector().write(out);
    }

    public static class DataPArrayAttr<T extends DataWriter>
    extends AttrData
    implements CompilerConstants {
        TreeMap<Integer, ArrayList<T>> elements;
        int paramsTotal;

        public DataPArrayAttr(ConstantPool pool, EAttribute attribute, int paramsTotal, TreeMap<Integer, ArrayList<T>> elements) {
            super(pool, attribute);
            this.paramsTotal = paramsTotal;
            this.elements = elements;
        }

        public DataPArrayAttr(ConstantPool pool, EAttribute attribute, int paramsTotal) {
            this(pool, attribute, paramsTotal, new TreeMap<Integer, ArrayList<T>>());
        }

        public void put(int paramNum, T element) {
            ArrayList<Object> v = this.get(paramNum);
            if (v == null) {
                v = new ArrayList();
                this.elements.put(paramNum, v);
            }
            v.add(element);
        }

        public ArrayList<T> get(int paramNum) {
            return this.elements.get(paramNum);
        }

        @Override
        public int attrLength() {
            int length = 1;
            for (int i = 0; i < this.paramsTotal; ++i) {
                ArrayList<T> attrarray = this.get(i);
                if (attrarray != null) {
                    for (DataWriter item : attrarray) {
                        length += item.getLength();
                    }
                }
                length += 2;
            }
            return length;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            super.write(out);
            out.writeByte(this.paramsTotal);
            for (int i = 0; i < this.paramsTotal; ++i) {
                ArrayList<T> attrarray = this.get(i);
                if (attrarray != null) {
                    out.writeShort(attrarray.size());
                    for (DataWriter item : attrarray) {
                        item.write(out);
                    }
                    continue;
                }
                out.writeShort(0);
            }
        }
    }

    static class MethodParameterData
    implements DataWriter {
        int access;
        ConstCell name;

        public MethodParameterData(int access, ConstCell name) {
            this.access = access;
            this.name = name;
        }

        @Override
        public int getLength() {
            return 4;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.name == null ? 0 : this.name.cpIndex);
            out.writeShort(this.access);
        }
    }
}

