/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import org.openjdk.asmtools.jasm.JasmEnvironment;
import org.openjdk.asmtools.jasm.Parser;
import org.openjdk.asmtools.jasm.Scanner;

public class ParseBase {
    protected boolean debugFlag;
    protected Scanner scanner;
    protected Parser parser;
    protected JasmEnvironment environment;

    public void init(Parser parentParser) {
        this.environment = parentParser.environment;
        this.scanner = parentParser.scanner;
        this.parser = parentParser;
    }

    public void init(JasmEnvironment environment, Parser parser) {
        this.environment = environment;
        this.scanner = new Scanner(environment);
        this.parser = parser;
    }

    public void init(JasmEnvironment environment) {
        this.environment = environment;
    }

    public void setDebugFlag(boolean value) {
        this.debugFlag = value;
    }

    protected void traceMethodInfoLn() {
        this.traceMethodInfoLn(null);
    }

    protected void traceMethodInfoLn(String str) {
        if (this.debugFlag) {
            StackTraceElement elem = Thread.currentThread().getStackTrace()[str == null ? 3 : 2];
            String msg = String.format("%s::%s[%d]%s", elem.getClassName().substring(elem.getClassName().lastIndexOf(46) + 1), elem.getMethodName(), elem.getLineNumber(), str == null ? "" : " " + str);
            this.environment.traceln(msg, new Object[0]);
        }
    }
}

