/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openjdk.asmtools.asmutils.StringUtils;
import org.openjdk.asmtools.common.SyntaxError;
import org.openjdk.asmtools.common.structure.CFVersion;
import org.openjdk.asmtools.common.structure.ClassFileContext;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.common.structure.EModifier;
import org.openjdk.asmtools.common.structure.StackMap;
import org.openjdk.asmtools.jasm.AnnotationData;
import org.openjdk.asmtools.jasm.BootstrapMethodData;
import org.openjdk.asmtools.jasm.CPXAttr;
import org.openjdk.asmtools.jasm.Checker;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.ClassFileConst;
import org.openjdk.asmtools.jasm.CodeAttr;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstValue;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.DefaultAnnotationAttr;
import org.openjdk.asmtools.jasm.FieldData;
import org.openjdk.asmtools.jasm.FieldType;
import org.openjdk.asmtools.jasm.Indexer;
import org.openjdk.asmtools.jasm.JasmEnvironment;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.MethodData;
import org.openjdk.asmtools.jasm.ModuleAttr;
import org.openjdk.asmtools.jasm.NameInfo;
import org.openjdk.asmtools.jasm.ParseBase;
import org.openjdk.asmtools.jasm.ParserAnnotation;
import org.openjdk.asmtools.jasm.ParserCP;
import org.openjdk.asmtools.jasm.ParserInstr;
import org.openjdk.asmtools.jasm.RecordData;
import org.openjdk.asmtools.jasm.SourceDebugExtensionAttr;
import org.openjdk.asmtools.jasm.SourceFileAttr;
import org.openjdk.asmtools.jasm.StackMapData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.ModuleContent;

class Parser
extends ParseBase {
    private final ArrayList<ClassData> clsDataList = new ArrayList();
    private final ParserAnnotation annotParser;
    private final ParserCP cpParser;
    private final ParserInstr instrParser;
    protected ConstantPool pool = null;
    ClassData classData = null;
    CFVersion currentCFV;
    CodeAttr curCodeAttr;
    private String pkg = null;
    private String pkgPrefix = "";
    private ArrayList<AnnotationData> pkgAnnttns = null;
    private ArrayList<AnnotationData> clsAnnttns = null;
    private ArrayList<AnnotationData> memberAnnttns = null;
    private boolean explicitCP = false;
    private ModuleAttr moduleAttribute;

    protected Parser(JasmEnvironment environment, CFVersion cfVersion) throws IOException {
        super.init(environment, this);
        this.cpParser = new ParserCP(this);
        this.annotParser = new ParserAnnotation(this);
        this.instrParser = new ParserInstr(this, this.cpParser);
        this.currentCFV = CFVersion.copyOf(cfVersion);
    }

    void setDebugFlags(boolean debugScanner, boolean debugMembers, boolean debugCP, boolean debugAnnot, boolean debugInstr) {
        this.setDebugFlag(debugMembers);
        this.scanner.setDebugFlag(debugScanner);
        this.cpParser.setDebugFlag(debugCP);
        this.annotParser.setDebugFlag(debugAnnot);
        this.instrParser.setDebugFlag(debugInstr);
    }

    String encodeClassString(String classname) {
        return "L" + classname + ";";
    }

    public int getPosition() {
        return this.environment.getPosition();
    }

    private void parseVersion() {
        if (this.scanner.token == JasmTokens.Token.VERSION) {
            this.scanner.scan();
            if (this.scanner.token == JasmTokens.Token.INTVAL) {
                int majorVersion = this.scanner.intValue;
                this.scanner.scan();
                if (this.scanner.token == JasmTokens.Token.COLON) {
                    this.scanner.scan();
                    if (this.scanner.token == JasmTokens.Token.INTVAL) {
                        int minorVersion = this.scanner.intValue;
                        this.classData.cfv.setFileVersion(majorVersion, minorVersion);
                        this.scanner.scan();
                        this.traceMethodInfoLn("parseVersion: " + this.classData.cfv.asString());
                        return;
                    }
                }
            }
        }
        this.environment.error(this.scanner.pos, "err.version.expected", new Object[0]);
        throw new SyntaxError();
    }

    String parseIdent() throws SyntaxError {
        String v = this.scanner.idValue;
        this.scanner.expect(JasmTokens.Token.IDENT);
        return v;
    }

    void parseLocVarDef() throws SyntaxError {
        int index = -1;
        int indexPosition = this.scanner.pos;
        if (this.scanner.token != JasmTokens.Token.INTVAL) {
            this.environment.error(indexPosition, "err.locvar.expected", index, this.curCodeAttr.max_locals.cpIndex);
            throw new SyntaxError();
        }
        index = this.scanner.intValue;
        if (!this.curCodeAttr.max_locals.inRange(index)) {
            this.environment.error(indexPosition, "err.locvar.wrong.index", index, this.curCodeAttr.max_locals.cpIndex - 1);
            throw new SyntaxError();
        }
        this.scanner.scan();
        ConstCell nameCell = this.parseName();
        this.scanner.expect(JasmTokens.Token.COLON);
        int descriptorPosition = this.scanner.pos;
        ConstCell descriptorCell = this.parseName();
        FieldType fieldType = FieldType.getFieldType(((String)((ConstValue)descriptorCell.ref).value).charAt(0));
        if (fieldType == null) {
            this.environment.error(descriptorPosition, "err.locvar.unknown.field.descriptor", index, ((ConstValue)descriptorCell.ref).value.toString());
            throw new SyntaxError();
        }
        this.curCodeAttr.LocVarDataDef(indexPosition, index, nameCell, descriptorCell);
    }

    Indexer parseLocVarRef() throws SyntaxError, IOException {
        if (this.scanner.token == JasmTokens.Token.INTVAL) {
            int index = this.scanner.intValue;
            this.scanner.scan();
            return new Indexer(index);
        }
        this.environment.error(this.scanner.pos, "err.locvar.expected", new Object[0]);
        throw new SyntaxError();
    }

    void parseLocVarEnd() throws SyntaxError, IOException {
        int position = this.scanner.pos;
        if (this.scanner.token != JasmTokens.Token.INTVAL) {
            this.environment.error(this.scanner.pos, "err.locvar.expected", new Object[0]);
            throw new SyntaxError();
        }
        int index = this.scanner.intValue;
        this.curCodeAttr.LocVarDataEnd((short)index, position);
        this.scanner.scan();
    }

    void parseMapItem(DataVector map) throws SyntaxError, IOException {
        StackMap.VerificationType itemVerificationType = StackMap.getVerificationType(this.scanner.intValue, Optional.empty());
        ClassFileConst.ConstType tag = null;
        ConstCell<ConstValue<?>> arg = null;
        JasmTokens.Token token = this.scanner.token;
        int iValue = this.scanner.intValue;
        String sValue = this.scanner.stringValue;
        this.scanner.scan();
        switch (token) {
            case INTVAL: {
                break;
            }
            case CLASS: {
                itemVerificationType = StackMap.VerificationType.ITEM_Object;
                tag = ClassFileConst.ConstType.CONSTANT_CLASS;
                break;
            }
            case CPINDEX: {
                itemVerificationType = StackMap.VerificationType.ITEM_Object;
                arg = this.pool.getCell(iValue);
                break;
            }
            case IDENT: {
                itemVerificationType = StackMap.getVerificationType(sValue);
                tag = ClassFileConst.tag(sValue);
                if (itemVerificationType != null) {
                    if (tag == null || this.scanner.token == JasmTokens.Token.SEMICOLON || this.scanner.token == JasmTokens.Token.COMMA) break;
                    itemVerificationType = StackMap.VerificationType.ITEM_Object;
                    break;
                }
                if (tag != null) {
                    itemVerificationType = StackMap.VerificationType.ITEM_Object;
                    break;
                }
            }
            default: {
                itemVerificationType = StackMap.VerificationType.ITEM_Bogus;
                this.environment.error("err.itemtype.expected", "<" + token.printValue() + ">");
            }
        }
        switch (itemVerificationType) {
            case ITEM_Object: {
                if (arg == null) {
                    arg = this.pool.findCell(this.cpParser.parseConstValue(tag));
                }
                map.addElement(new StackMapData.StackMapItemTaggedPointer(itemVerificationType, arg));
                break;
            }
            case ITEM_NewObject: {
                arg = this.instrParser.parseLabelRef();
                map.addElement(new StackMapData.StackMapItemTaggedPointer(itemVerificationType, arg));
                break;
            }
            default: {
                map.addElement(new StackMapData.StackMapItemTagged(itemVerificationType));
            }
        }
    }

    ConstCell parseName() throws SyntaxError {
        this.traceMethodInfoLn();
        if (this.scanner.token == JasmTokens.Token.CPINDEX) {
            int cpx = this.scanner.intValue;
            this.scanner.scan();
            return this.pool.getCell(cpx);
        }
        if (this.scanner.token == JasmTokens.Token.STRINGVAL) {
            String v = this.scanner.stringValue;
            this.scanner.scan();
            return this.pool.findUTF8Cell(v);
        }
        if (this.scanner.token.isPossibleClassName()) {
            String v = this.scanner.idValue;
            this.scanner.scan();
            return this.pool.findUTF8Cell(v);
        }
        this.environment.error(this.scanner.pos, "err.name.expected", "\"" + this.scanner.token + "\"");
        throw new SyntaxError();
    }

    ConstCell parseMethodHandle(ClassFileConst.SubTag subtag) throws SyntaxError {
        ConstCell<ConstValue<?>> refCell;
        switch (subtag) {
            case REF_GETFIELD: 
            case REF_GETSTATIC: 
            case REF_PUTFIELD: 
            case REF_PUTSTATIC: {
                refCell = this.pool.findCell(this.cpParser.parseConstValue(ClassFileConst.ConstType.CONSTANT_FIELDREF));
                break;
            }
            case REF_INVOKEVIRTUAL: 
            case REF_NEWINVOKESPECIAL: {
                this.cpParser.setExitImmediately(true);
                refCell = this.cpParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_METHODREF, ClassFileConst.ConstType.CONSTANT_INTERFACEMETHODREF);
                this.cpParser.setExitImmediately(false);
                this.checkReferenceIndex(this.getPosition(), ClassFileConst.ConstType.CONSTANT_METHODREF, null);
                break;
            }
            case REF_INVOKESTATIC: 
            case REF_INVOKESPECIAL: {
                ClassFileConst.ConstType ctype01 = ClassFileConst.ConstType.CONSTANT_METHODREF;
                ClassFileConst.ConstType ctype02 = ClassFileConst.ConstType.CONSTANT_INTERFACEMETHODREF;
                if (this.classData.cfv.major_version() >= 52 && EModifier.isInterface(this.classData.access)) {
                    ctype01 = ClassFileConst.ConstType.CONSTANT_INTERFACEMETHODREF;
                    ctype02 = ClassFileConst.ConstType.CONSTANT_METHODREF;
                }
                this.cpParser.setExitImmediately(true);
                refCell = this.cpParser.parseConstRef(ctype01, ctype02);
                this.cpParser.setExitImmediately(false);
                this.checkReferenceIndex(this.getPosition(), ctype01, ctype02);
                break;
            }
            case REF_INVOKEINTERFACE: {
                this.cpParser.setExitImmediately(true);
                refCell = this.cpParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_INTERFACEMETHODREF, ClassFileConst.ConstType.CONSTANT_METHODREF);
                this.cpParser.setExitImmediately(false);
                this.checkReferenceIndex(this.getPosition(), ClassFileConst.ConstType.CONSTANT_INTERFACEMETHODREF, null);
                break;
            }
            default: {
                throw new SyntaxError();
            }
        }
        return refCell;
    }

    private void checkReferenceIndex(int position, ClassFileConst.ConstType defaultTag, ClassFileConst.ConstType defaultTag2) {
        if (!this.scanner.token.in(JasmTokens.Token.COLON, JasmTokens.Token.SEMICOLON, JasmTokens.Token.COMMA)) {
            if (defaultTag2 != null) {
                this.environment.error(position, "err.wrong.tag2", defaultTag.parseKey(), defaultTag2.parseKey());
            } else {
                this.environment.error(position, "err.wrong.tag", defaultTag.parseKey());
            }
            throw new SyntaxError().setFatal();
        }
    }

    ClassFileConst.SubTag parseSubtag() throws SyntaxError {
        ClassFileConst.SubTag subtag;
        switch (this.scanner.token) {
            case IDENT: {
                ClassFileConst.SubTag subTag = ClassFileConst.subTag(this.scanner.stringValue);
                break;
            }
            case INTVAL: {
                ClassFileConst.SubTag subTag = ClassFileConst.subTag(this.scanner.intValue);
                break;
            }
            default: {
                ClassFileConst.SubTag subTag = subtag = null;
            }
        }
        if (subtag == null) {
            this.environment.error("err.subtag.expected", new Object[0]);
            throw new SyntaxError();
        }
        this.scanner.scan();
        return subtag;
    }

    ConstCell parseConstantPackageInfo() throws SyntaxError {
        if (this.scanner.token == JasmTokens.Token.CPINDEX) {
            int cpx = this.scanner.intValue;
            this.scanner.scan();
            return this.pool.getCell(cpx);
        }
        if (this.scanner.token == JasmTokens.Token.STRINGVAL || this.scanner.token.isPossibleClassName()) {
            String packageName = this.scanner.stringValue;
            this.scanner.scan();
            return this.pool.findPackageCell(packageName);
        }
        this.throwSyntaxError("err.package.name.expected");
        return null;
    }

    ConstCell parseConstantModuleInfo() throws SyntaxError {
        if (this.scanner.token == JasmTokens.Token.CPINDEX) {
            int cpx = this.scanner.intValue;
            this.scanner.scan();
            return this.pool.getCell(cpx);
        }
        if (this.scanner.token == JasmTokens.Token.STRINGVAL || this.scanner.token.isPossibleModuleName()) {
            String moduleName = this.scanner.stringValue;
            this.scanner.scan();
            return this.pool.findModuleCell(moduleName);
        }
        this.throwSyntaxError("err.module.name.expected");
        return null;
    }

    ConstCell parseConstantClassInfo(boolean uncond) throws SyntaxError {
        if (this.scanner.token == JasmTokens.Token.CPINDEX) {
            int cpx = this.scanner.intValue;
            this.scanner.scan();
            return this.pool.getCell(cpx);
        }
        if (this.scanner.token == JasmTokens.Token.STRINGVAL || this.scanner.token.isPossibleClassName()) {
            String value = this.scanner.stringValue;
            this.scanner.scan();
            value = this.prependPackage(value, uncond);
            return this.pool.findUTF8Cell(value);
        }
        this.throwSyntaxError("err.class.name.expected");
        return null;
    }

    private void throwSyntaxError(String msgId) throws SyntaxError {
        ClassFileConst.ConstType key = ClassFileConst.tag(this.scanner.token.value());
        this.environment.traceln("Unrecognized token %s: %s", this.scanner.token.toString(), key == null ? "null" : key.parseKey());
        this.environment.error(this.scanner.prevPos, msgId, "\"" + this.scanner.token.parseKey() + "\"");
        throw new SyntaxError();
    }

    private String prependPackage(String className, boolean uncond) {
        if (!(!uncond && this.scanner.token != JasmTokens.Token.FIELD || ((String)className).contains("/") || ((String)className).contains("["))) {
            className = this.pkgPrefix + (String)className;
        }
        return className;
    }

    Indexer parseInt(String opCode, int size) throws SyntaxError, IOException {
        if (this.scanner.token == JasmTokens.Token.BITS) {
            this.scanner.scan();
        }
        if (this.scanner.token != JasmTokens.Token.INTVAL) {
            this.environment.error(this.scanner.pos, "err.int.expected", new Object[0]);
            throw new SyntaxError();
        }
        int arg = this.scanner.intValue * this.scanner.sign;
        switch (size) {
            case 1: {
                if (arg <= 255 && arg >= -128) break;
                this.environment.error(this.scanner.pos, "err.value.large", opCode, arg, "1 byte");
                throw new SyntaxError();
            }
            case 2: {
                if (arg <= 65535 && arg >= Short.MIN_VALUE) break;
                this.environment.error(this.scanner.pos, "err.value.large", opCode, arg, "2 bytes");
                throw new SyntaxError();
            }
            default: {
                throw new InternalError("parseInt(" + size + ")");
            }
        }
        this.scanner.scan();
        return new Indexer(arg);
    }

    Indexer parseUInt(int size) throws SyntaxError, IOException {
        if (this.scanner.token != JasmTokens.Token.INTVAL) {
            this.environment.error(this.scanner.pos, "err.int.expected", new Object[0]);
            throw new SyntaxError();
        }
        if (this.scanner.sign == -1) {
            this.environment.error(this.scanner.pos, "err.neg.forbidden", new Object[0]);
            throw new SyntaxError();
        }
        int arg = this.scanner.intValue;
        switch (size) {
            case 1: {
                if (arg <= 255) break;
                this.environment.error(this.scanner.pos, "err.value.large", "ubyte", arg, "1 byte");
                throw new SyntaxError();
            }
            case 2: {
                if (arg <= 65535) break;
                this.environment.error(this.scanner.pos, "err.value.large", "ushort", arg, "2 bytes");
                throw new SyntaxError();
            }
            default: {
                throw new InternalError("parseUInt(" + size + ")");
            }
        }
        this.scanner.scan();
        return new Indexer(arg);
    }

    private void parseConstDef() {
        while (true) {
            if (this.scanner.token != JasmTokens.Token.CPINDEX) {
                this.environment.error("err.const.def.expected", new Object[0]);
                throw new SyntaxError();
            }
            int cpx = this.scanner.intValue;
            this.scanner.scan();
            this.scanner.expect(JasmTokens.Token.ASSIGN);
            this.traceMethodInfoLn("\ncpIndex: " + cpx);
            this.pool.setCell(cpx, this.cpParser.parseConstRef(null));
            if (this.scanner.token != JasmTokens.Token.COMMA) {
                this.scanner.expect(JasmTokens.Token.SEMICOLON);
                return;
            }
            this.scanner.scan();
        }
    }

    private int scanModifier(int mod) throws SyntaxError {
        while (true) {
            int nextmod = 0;
            switch (this.scanner.token) {
                case PUBLIC: {
                    nextmod = EModifier.ACC_PUBLIC.getFlag();
                    break;
                }
                case PRIVATE: {
                    nextmod = EModifier.ACC_PRIVATE.getFlag();
                    break;
                }
                case PROTECTED: {
                    nextmod = EModifier.ACC_PROTECTED.getFlag();
                    break;
                }
                case STATIC: {
                    nextmod = EModifier.ACC_STATIC.getFlag();
                    break;
                }
                case FINAL: {
                    nextmod = EModifier.ACC_FINAL.getFlag();
                    break;
                }
                case SYNCHRONIZED: {
                    nextmod = EModifier.ACC_SYNCHRONIZED.getFlag();
                    break;
                }
                case SUPER: {
                    nextmod = EModifier.ACC_SUPER.getFlag();
                    break;
                }
                case VOLATILE: {
                    nextmod = EModifier.ACC_VOLATILE.getFlag();
                    break;
                }
                case BRIDGE: {
                    nextmod = EModifier.ACC_BRIDGE.getFlag();
                    break;
                }
                case TRANSIENT: {
                    nextmod = EModifier.ACC_TRANSIENT.getFlag();
                    break;
                }
                case VARARGS: {
                    nextmod = EModifier.ACC_VARARGS.getFlag();
                    break;
                }
                case NATIVE: {
                    nextmod = EModifier.ACC_NATIVE.getFlag();
                    break;
                }
                case INTERFACE: {
                    nextmod = EModifier.ACC_INTERFACE.getFlag();
                    break;
                }
                case ABSTRACT: {
                    nextmod = EModifier.ACC_ABSTRACT.getFlag();
                    break;
                }
                case STRICT: {
                    nextmod = EModifier.ACC_STRICT.getFlag();
                    break;
                }
                case ENUM: {
                    nextmod = EModifier.ACC_ENUM.getFlag();
                    break;
                }
                case SYNTHETIC: {
                    nextmod = EModifier.ACC_SYNTHETIC.getFlag();
                    break;
                }
                case ANNOTATION_ACCESS: {
                    nextmod = EModifier.ACC_ANNOTATION.getFlag();
                    break;
                }
                case DEPRECATED: {
                    nextmod = EModifier.DEPRECATED_ATTRIBUTE.getFlag();
                    break;
                }
                case MANDATED: {
                    nextmod = EModifier.ACC_MANDATED.getFlag();
                    break;
                }
                case VALUE: {
                    nextmod = EModifier.ACC_VALUE.getFlag();
                    break;
                }
                case PERMITS_VALUE: {
                    nextmod = EModifier.ACC_PERMITS_VALUE.getFlag();
                    break;
                }
                case PRIMITIVE: {
                    nextmod = EModifier.ACC_PRIMITIVE.getFlag();
                    break;
                }
                default: {
                    return nextmod;
                }
            }
            int prevpos = this.scanner.pos;
            this.scanner.scan();
            if ((mod & nextmod) == 0) {
                return nextmod;
            }
            this.environment.warning(prevpos, "warn.repeated.modifier", new Object[0]);
        }
    }

    int scanModifiers() throws SyntaxError {
        int mod = 0;
        int nextmod;
        while ((nextmod = this.scanModifier(mod)) != 0) {
            mod |= nextmod;
        }
        return mod;
    }

    private void parseField(int mod) throws SyntaxError {
        this.traceMethodInfoLn("Begin");
        Checker.checkFieldModifiers(this.classData, mod, this.scanner.prevPos);
        while (true) {
            ConstCell nameCell = this.parseName();
            this.scanner.expect(JasmTokens.Token.COLON);
            ConstCell typeCell = this.parseName();
            FieldData fld = this.classData.addField(mod, nameCell, typeCell);
            if (this.memberAnnttns != null) {
                fld.addAnnotations(this.memberAnnttns);
            }
            if (this.scanner.token == JasmTokens.Token.COLON) {
                this.scanner.scan();
                ConstCell signatureCell = this.parseName();
                fld.setSignatureAttr(signatureCell);
            }
            if (this.scanner.token == JasmTokens.Token.ASSIGN) {
                this.scanner.scan();
                fld.SetInitialValue(this.cpParser.parseConstRef(null));
            }
            this.traceMethodInfoLn("Field: " + fld);
            if (this.scanner.token != JasmTokens.Token.COMMA) {
                this.scanner.expect(JasmTokens.Token.SEMICOLON);
                return;
            }
            this.scanner.scan();
        }
    }

    private int countParams(ConstCell sigCell) throws SyntaxError {
        String sig;
        try {
            ConstantPool.ConstValue_UTF8 strConst = (ConstantPool.ConstValue_UTF8)sigCell.ref;
            sig = (String)strConst.value;
        }
        catch (ClassCastException | NullPointerException e) {
            return 0;
        }
        int siglen = sig.length();
        int k = 0;
        int loccnt = 0;
        int errparam = 0;
        boolean arraytype = false;
        if (k < siglen) {
            if (sig.charAt(k) != '(') {
                errparam = 1;
            } else {
                block9: for (k = 1; k < siglen; ++k) {
                    switch (sig.charAt(k)) {
                        case ')': {
                            if (arraytype) {
                                errparam = 2;
                                break block9;
                            }
                            return loccnt;
                        }
                        case '[': {
                            arraytype = true;
                            continue block9;
                        }
                        case 'B': 
                        case 'C': 
                        case 'F': 
                        case 'I': 
                        case 'S': 
                        case 'Z': {
                            ++loccnt;
                            arraytype = false;
                            continue block9;
                        }
                        case 'D': 
                        case 'J': {
                            ++loccnt;
                            if (arraytype) {
                                arraytype = false;
                                continue block9;
                            }
                            ++loccnt;
                            continue block9;
                        }
                        case 'L': 
                        case 'Q': {
                            while (true) {
                                if (k >= siglen) {
                                    errparam = 3;
                                    break block9;
                                }
                                if (sig.charAt(k) == ';') break;
                                ++k;
                            }
                            ++loccnt;
                            arraytype = false;
                            continue block9;
                        }
                        default: {
                            errparam = 4;
                            break block9;
                        }
                    }
                }
            }
        }
        this.environment.error(this.scanner.pos, "err.msig.malformed", Integer.toString(k), Integer.toString(errparam));
        return loccnt;
    }

    private void parseMethod(int mod) throws SyntaxError, IOException {
        this.traceMethodInfoLn("Begin");
        int scannerPosition = this.scanner.prevPos;
        ConstCell nameCell = this.parseName();
        ConstantPool.ConstValue_UTF8 strConst = (ConstantPool.ConstValue_UTF8)nameCell.ref;
        String name = (String)strConst.value;
        boolean is_clinit = name.equals("<clinit>");
        boolean is_init = name.equals("<init>") && !EModifier.isStatic(mod);
        DefaultAnnotationAttr defAnnot = null;
        Checker.checkMethodModifiers(this.classData, mod, scannerPosition, is_init, is_clinit);
        this.scanner.expect(JasmTokens.Token.COLON);
        ConstCell typeCell = this.parseName();
        int paramCount = this.countParams(typeCell);
        if (!EModifier.isStatic(mod) && !is_clinit) {
            ++paramCount;
        }
        if (paramCount > 255) {
            this.environment.warning(this.scanner.pos, "warn.msig.more255", Integer.toString(paramCount));
        }
        ConstCell signatureCell = null;
        if (this.scanner.token == JasmTokens.Token.COLON) {
            this.scanner.scan();
            signatureCell = this.parseName();
        }
        ArrayList exc_table = null;
        if (this.scanner.token == JasmTokens.Token.THROWS) {
            this.scanner.scan();
            exc_table = new ArrayList();
            while (true) {
                scannerPosition = this.scanner.pos;
                ConstCell<?> exc = this.cpParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_CLASS);
                if (exc_table.contains(exc)) {
                    this.environment.warning(scannerPosition, "warn.exc.repeated", new Object[0]);
                } else {
                    exc_table.add(exc);
                    this.environment.traceln("THROWS:" + exc.cpIndex, new Object[0]);
                }
                if (this.scanner.token != JasmTokens.Token.COMMA) break;
                this.scanner.scan();
            }
        }
        if (this.scanner.token == JasmTokens.Token.DEFAULT) {
            defAnnot = this.annotParser.parseDefaultAnnotation();
        }
        MethodData curMethod = this.classData.StartMethod(mod, nameCell, typeCell, exc_table);
        if (signatureCell != null) {
            curMethod.setSignatureAttr(signatureCell);
        }
        Indexer max_stack = null;
        Indexer max_locals = null;
        if (this.scanner.token == JasmTokens.Token.STACK) {
            this.scanner.scan();
            max_stack = this.parseUInt(2);
        }
        if (this.scanner.token == JasmTokens.Token.LOCAL) {
            this.scanner.scan();
            max_locals = this.parseUInt(2);
        }
        if (this.scanner.token == JasmTokens.Token.INTVAL) {
            this.annotParser.parseParamAnnots(paramCount, curMethod);
        }
        if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
            if (max_stack != null || max_locals != null) {
                this.environment.error("err.token.expected", JasmTokens.Token.LBRACE.parseKey());
            }
            this.scanner.scan();
        } else {
            this.scanner.expect(JasmTokens.Token.LBRACE);
            this.curCodeAttr = curMethod.startCode(paramCount, max_stack, max_locals);
            while (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
                this.instrParser.parseInstr();
                if (this.scanner.token == JasmTokens.Token.RBRACE) break;
                if (this.scanner.token == JasmTokens.Token.ANNOTATION) {
                    this.curCodeAttr.addAnnotations(this.annotParser.scanAnnotations());
                    break;
                }
                this.scanner.expect(JasmTokens.Token.SEMICOLON);
            }
            this.curCodeAttr.endCode();
            this.scanner.expect(JasmTokens.Token.RBRACE);
        }
        if (defAnnot != null) {
            curMethod.addDefaultAnnotation(defAnnot);
        }
        if (this.memberAnnttns != null) {
            curMethod.addAnnotations(this.memberAnnttns);
        }
        this.classData.EndMethod();
        this.traceMethodInfoLn("End of the method " + curMethod);
    }

    private void parseCPXBootstrapMethod() throws SyntaxError {
        ArrayList bsm_args;
        ConstCell MHCell;
        if (this.scanner.token == JasmTokens.Token.CPINDEX) {
            int cpx = this.scanner.intValue;
            MHCell = this.pool.getCell(cpx);
            this.scanner.scan();
            bsm_args = new ArrayList(256);
            while (this.scanner.token != JasmTokens.Token.SEMICOLON) {
                if (this.scanner.token != JasmTokens.Token.CPINDEX) {
                    this.environment.error(this.scanner.pos, "err.invalid.bootstrapmethod", new Object[0]);
                    throw new SyntaxError();
                }
                bsm_args.add(this.pool.getCell(this.scanner.intValue));
                this.scanner.scan();
            }
        } else {
            this.environment.error(this.scanner.pos, "err.invalid.bootstrapmethod", new Object[0]);
            throw new SyntaxError();
        }
        BootstrapMethodData bsmData = new BootstrapMethodData(MHCell, bsm_args);
        this.classData.addBootstrapMethod(bsmData);
    }

    private void parseClassSignature() throws SyntaxError {
        this.traceMethodInfoLn("Begin");
        ConstCell signatureCell = this.parseName();
        this.traceMethodInfoLn("Signature: " + signatureCell);
        this.classData.setSignatureAttr(signatureCell);
    }

    private void parseClassRef(Consumer<ConstCell<?>> consumer) {
        this.traceMethodInfoLn("Begin");
        if (this.scanner.token == JasmTokens.Token.COLON) {
            this.scanner.scan();
        }
        ConstCell<?> nm = this.cpParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_CLASS, null, true);
        consumer.accept(nm);
    }

    private void parseSourceFile() throws SyntaxError {
        String sourceName;
        ConstCell cell;
        this.traceMethodInfoLn("Begin");
        String cpSourceFile = null;
        if (this.pool.findUTF8Cell(EAttribute.ATT_SourceFile.parseKey()) != null && (cell = this.pool.lookupUTF8Cell(arg_0 -> Parser.lambda$parseSourceFile$0(sourceName = this.environment.getSourceName(), arg_0))) != null) {
            cpSourceFile = (String)((ConstValue)cell.ref).value;
        }
        ConstCell sourceFileCell = this.parseName();
        if (sourceFileCell.ref == null && sourceFileCell.cpIndex != -1) {
            this.environment.error(this.scanner.prevPos, "err.wrong.sourcefile.ref", new Object[0]);
            throw new SyntaxError();
        }
        this.traceMethodInfoLn("Source File: " + sourceFileCell);
        if (cpSourceFile != null && !cpSourceFile.equals(((ConstValue)sourceFileCell.ref).value)) {
            this.environment.warning(this.scanner.prevPos, "warn.extra.attribute", EAttribute.ATT_SourceFile.parseKey(), ((ConstValue)sourceFileCell.ref).value);
        }
        this.classData.setSourceFileAttr(sourceFileCell);
    }

    private void parseSourceDebugExtension() throws SyntaxError {
        this.traceMethodInfoLn("Begin");
        SourceDebugExtensionAttr sourceDebugExtensionAttr = this.classData.setSourceDebugExtensionAttr();
        boolean prevSemicolonParsed = true;
        this.scanner.expect(JasmTokens.Token.LBRACE);
        while (true) {
            switch (this.scanner.token) {
                case INTVAL: 
                case BYTEVAL: 
                case SHORT: {
                    try {
                        sourceDebugExtensionAttr.append(this.scanner.intValue);
                    }
                    catch (IllegalArgumentException ex) {
                        this.environment.error(this.scanner.pos, "err.token.expected", JasmTokens.Token.STRINGVAL.parseKey());
                        throw new SyntaxError();
                    }
                    prevSemicolonParsed = false;
                    break;
                }
                case STRINGVAL: {
                    if (!prevSemicolonParsed) {
                        this.environment.error(this.scanner.pos, "err.token.expected", JasmTokens.Token.SEMICOLON.parseKey());
                        throw new SyntaxError();
                    }
                    try {
                        sourceDebugExtensionAttr.append(this.scanner.stringValue);
                    }
                    catch (IllegalArgumentException ex) {
                        this.environment.error(this.scanner.pos, "err.token.expected", JasmTokens.Token.BYTEVAL.parseKey());
                        throw new SyntaxError();
                    }
                    prevSemicolonParsed = false;
                    break;
                }
                case SEMICOLON: {
                    if (prevSemicolonParsed) {
                        this.environment.error(this.scanner.pos, "err.token.expected", sourceDebugExtensionAttr.type == SourceDebugExtensionAttr.Type.BYTE ? JasmTokens.Token.BYTEVAL.parseKey() : JasmTokens.Token.STRINGVAL.parseKey());
                        throw new SyntaxError();
                    }
                    prevSemicolonParsed = true;
                    break;
                }
                case RBRACE: {
                    if (!prevSemicolonParsed) {
                        this.environment.error(this.scanner.pos, "err.token.expected", JasmTokens.Token.SEMICOLON.parseKey());
                        throw new SyntaxError();
                    }
                    if (sourceDebugExtensionAttr.isEmpty()) {
                        this.environment.warning(this.scanner.pos, "warn.empty.debug.extension", new Object[0]);
                    }
                    this.scanner.scan();
                    return;
                }
                default: {
                    if (prevSemicolonParsed) {
                        this.environment.error(this.scanner.pos, "err.one.of.two.token.expected", JasmTokens.Token.STRINGVAL.parseKey(), JasmTokens.Token.RBRACE.parseKey());
                    } else {
                        this.environment.error(this.scanner.pos, "err.token.expected", JasmTokens.Token.SEMICOLON.parseKey());
                    }
                    throw new SyntaxError();
                }
            }
            this.scanner.scan();
        }
    }

    private void parseNestHost() throws SyntaxError {
        this.traceMethodInfoLn("Begin");
        ConstCell cell = this.parseConstantClassInfo(true);
        if (!cell.getType().oneOf(ClassFileConst.ConstType.CONSTANT_UTF8, ClassFileConst.ConstType.CONSTANT_CLASS)) {
            this.throwSyntaxError("err.class.name.expected");
        }
        this.classData.addNestHost(cell);
        this.traceMethodInfoLn("NestHost: class " + cell);
        this.scanner.expect(JasmTokens.Token.SEMICOLON);
    }

    private void parseClasses(Consumer<ArrayList<ConstCell>> classesConsumer) throws SyntaxError {
        ArrayList<ConstCell> classes = new ArrayList<ConstCell>();
        this.traceMethodInfoLn("Begin");
        while (true) {
            ConstCell cell = this.parseConstantClassInfo(true);
            if (!cell.getType().oneOf(ClassFileConst.ConstType.CONSTANT_UTF8, ClassFileConst.ConstType.CONSTANT_CLASS)) {
                this.throwSyntaxError("err.class.name.expected");
            }
            classes.add(cell);
            this.traceMethodInfoLn("Added cell: " + cell);
            if (this.scanner.token != JasmTokens.Token.COMMA) {
                this.scanner.expect(JasmTokens.Token.SEMICOLON);
                classesConsumer.accept(classes);
                return;
            }
            this.scanner.scan();
        }
    }

    private void parseRecord() throws SyntaxError {
        this.traceMethodInfoLn("Begin");
        this.scanner.expect(JasmTokens.Token.LBRACE);
        ArrayList<AnnotationData> componentAnntts = null;
        boolean grouped = false;
        RecordData rd = this.classData.setRecord(this.scanner.pos);
        while (true) {
            if (this.scanner.token == JasmTokens.Token.RBRACE) {
                if (rd.isEmpty()) {
                    this.environment.warning(this.scanner.pos, "warn.no.components.in.record.attribute", new Object[0]);
                    this.classData.rejectRecord();
                } else if (grouped) {
                    this.environment.error(this.scanner.pos, "err.grouped.component.expected", new Object[0]);
                }
                break;
            }
            ConstCell signatureCell = null;
            if (this.scanner.token == JasmTokens.Token.ANNOTATION) {
                componentAnntts = this.annotParser.scanAnnotations();
            }
            this.scanner.expect(JasmTokens.Token.COMPONENT);
            ConstCell nameCell = this.parseName();
            this.scanner.expect(JasmTokens.Token.COLON);
            ConstCell descCell = this.parseName();
            if (this.scanner.token == JasmTokens.Token.COLON) {
                this.scanner.scan();
                signatureCell = this.parseName();
            }
            rd.addComponent(nameCell, descCell, signatureCell, componentAnntts);
            switch (this.scanner.token) {
                case COMMA: {
                    grouped = true;
                    break;
                }
                case SEMICOLON: {
                    grouped = false;
                    componentAnntts = null;
                    break;
                }
                default: {
                    this.environment.error(this.scanner.pos, "err.one.of.two.token.expected", "<" + JasmTokens.Token.SEMICOLON.printValue() + ">", "<" + JasmTokens.Token.COMMA.printValue() + ">");
                }
            }
            this.scanner.scan();
        }
        this.scanner.scan();
        this.traceMethodInfoLn("End");
    }

    private void parseInnerClass(int mod) throws SyntaxError, IOException {
        this.traceMethodInfoLn("Begin");
        Checker.checkInnerClassModifiers(this.classData, mod, this.scanner.pos);
        ConstCell innerClass = null;
        ConstCell outerClass = null;
        if (this.scanner.token == JasmTokens.Token.CLASS) {
            ConstCell nameCell = this.pool.getCell(0);
            this.parseInnerClass_s2(mod, nameCell, innerClass, outerClass);
        } else if (this.scanner.token == JasmTokens.Token.IDENT && this.scanner.checkTokenIdent()) {
            ConstCell nameCell = this.parseName();
            this.parseInnerClass_s1(mod, nameCell, innerClass, outerClass);
        } else if (this.scanner.token == JasmTokens.Token.CPINDEX) {
            int cpx = this.scanner.intValue;
            ConstCell nameCell = this.pool.getCell(cpx);
            Object nameCellValue = nameCell.ref;
            if (nameCellValue instanceof ConstantPool.ConstValue_UTF8) {
                this.scanner.scan();
                this.parseInnerClass_s1(mod, nameCell, innerClass, outerClass);
            } else {
                nameCell = this.pool.getCell(0);
                this.parseInnerClass_s2(mod, nameCell, innerClass, outerClass);
            }
        } else if (this.scanner.token.isPossibleJasmIdentifier()) {
            ConstCell nameCell = this.pool.findUTF8Cell(this.scanner.token.parseKey());
            this.scanner.scan();
            this.parseInnerClass_s1(mod, nameCell, innerClass, outerClass);
        } else {
            this.pic_error();
        }
        this.traceMethodInfoLn("End");
    }

    private void parseInnerClass_s1(int mod, ConstCell nameCell, ConstCell innerClass, ConstCell outerClass) throws IOException {
        if (this.scanner.token == JasmTokens.Token.ASSIGN) {
            this.scanner.scan();
            this.parseInnerClass_s2(mod, nameCell, innerClass, outerClass);
        } else {
            this.pic_error();
        }
    }

    private void parseInnerClass_s2(int mod, ConstCell nameCell, ConstCell innerClass, ConstCell outerClass) throws IOException {
        if (this.scanner.token == JasmTokens.Token.CPINDEX || this.scanner.token == JasmTokens.Token.CLASS) {
            if (this.scanner.token == JasmTokens.Token.CPINDEX) {
                innerClass = this.cpParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_CLASS);
            }
            if (this.scanner.token == JasmTokens.Token.CLASS) {
                this.scanner.scan();
                innerClass = this.cpParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_CLASS, null, true);
            }
            if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
                outerClass = this.pool.getCell(0);
                this.pic_tracecreate(mod, nameCell, innerClass, outerClass);
                this.classData.addInnerClass(mod, nameCell, innerClass, outerClass);
            } else if (this.scanner.token == JasmTokens.Token.OF) {
                this.parseInnerClass_s3(mod, nameCell, innerClass, outerClass);
            } else {
                this.pic_error();
            }
        } else {
            this.pic_error();
        }
    }

    private void parseInnerClass_s3(int mod, ConstCell nameCell, ConstCell innerClass, ConstCell outerClass) throws IOException {
        this.scanner.scan();
        if (this.scanner.token == JasmTokens.Token.CLASS || this.scanner.token == JasmTokens.Token.CPINDEX) {
            if (this.scanner.token == JasmTokens.Token.CLASS) {
                this.scanner.scan();
                outerClass = this.cpParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_CLASS, null, true);
            }
            if (this.scanner.token == JasmTokens.Token.CPINDEX) {
                outerClass = this.cpParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_CLASS);
            }
            if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
                this.pic_tracecreate(mod, nameCell, innerClass, outerClass);
                this.classData.addInnerClass(mod, nameCell, innerClass, outerClass);
            } else {
                this.pic_error();
            }
        } else {
            this.pic_error();
        }
    }

    private void pic_tracecreate(int mod, ConstCell nameCell, ConstCell innerClass, ConstCell outerClass) {
        Object value;
        this.traceMethodInfoLn("Creating InnerClass:");
        this.environment.trace("[" + EModifier.asNames(mod, ClassFileContext.INNER_CLASS) + "], ", new Object[0]);
        if (nameCell != this.pool.getCell(0) && (value = nameCell.ref) != null) {
            this.environment.trace(value + " =\n\t\t", new Object[0]);
        }
        ConstantPool.ConstValue_Cell ici_val = (ConstantPool.ConstValue_Cell)innerClass.ref;
        ConstCell ici_ascii = (ConstCell)ici_val.value;
        if (ici_ascii.ref == null) {
            this.environment.trace("<#cpx-unresolved> ", new Object[0]);
        } else if (((ConstValue)ici_ascii.ref).value == null) {
            this.environment.trace("<#cpx-0> ", new Object[0]);
        } else {
            this.environment.trace(((ConstValue)ici_ascii.ref).value + " ", new Object[0]);
        }
        if (outerClass != this.pool.getCell(0) && outerClass.cpIndex != 0) {
            ConstantPool.ConstValue_Cell oci_val = (ConstantPool.ConstValue_Cell)outerClass.ref;
            ConstCell oci_ascii = (ConstCell)oci_val.value;
            if (oci_ascii.ref == null) {
                this.environment.trace("\n\t\tof <#cpx-unresolved>  ", new Object[0]);
            } else {
                ConstantPool.ConstValue_UTF8 cval = (ConstantPool.ConstValue_UTF8)oci_ascii.ref;
                if (cval.value == null) {
                    this.environment.trace("\n\t\tof <#cpx-0>  ", new Object[0]);
                } else {
                    this.environment.trace("\n\t\tof " + (String)cval.value, new Object[0]);
                }
            }
        }
        this.environment.trace("\n", new Object[0]);
    }

    private void pic_error() {
        this.environment.error(this.scanner.pos, "err.invalid.innerclass", new Object[0]);
        throw new SyntaxError();
    }

    private void match(JasmTokens.Token open, JasmTokens.Token close) throws IOException {
        int depth = 1;
        while (true) {
            this.scanner.scan();
            if (this.scanner.token == open) {
                ++depth;
                continue;
            }
            if (this.scanner.token == close) {
                if (--depth != 0) continue;
                return;
            }
            if (this.scanner.token == JasmTokens.Token.EOF) break;
        }
        this.environment.error(this.scanner.pos, "err.unbalanced.paren", new Object[0]);
    }

    private void recoverField() throws SyntaxError, IOException {
        block7: while (true) {
            switch (this.scanner.token) {
                case PUBLIC: 
                case PRIVATE: 
                case PROTECTED: 
                case STATIC: 
                case FINAL: 
                case SYNCHRONIZED: 
                case VOLATILE: 
                case TRANSIENT: 
                case NATIVE: 
                case ABSTRACT: 
                case ANNOTATION_ACCESS: 
                case EOF: {
                    return;
                }
                case LBRACE: {
                    this.match(JasmTokens.Token.LBRACE, JasmTokens.Token.RBRACE);
                    this.scanner.scan();
                    continue block7;
                }
                case LPAREN: {
                    this.match(JasmTokens.Token.LPAREN, JasmTokens.Token.RPAREN);
                    this.scanner.scan();
                    continue block7;
                }
                case LSQBRACKET: {
                    this.match(JasmTokens.Token.LSQBRACKET, JasmTokens.Token.RSQBRACKET);
                    this.scanner.scan();
                    continue block7;
                }
                case CLASS: 
                case INTERFACE: 
                case RBRACE: 
                case IMPORT: 
                case PACKAGE: {
                    this.endClass();
                    this.traceMethodInfoLn(String.format("scanner position %d", this.scanner.pos));
                    throw new SyntaxError().setFatal();
                }
            }
            this.scanner.scan();
        }
    }

    private void parseClass(int mod) throws IOException {
        int posa = this.scanner.pos;
        this.traceMethodInfoLn("Begin");
        Checker.checkClassModifiers(mod, this.scanner);
        if (this.clsAnnttns != null) {
            this.classData.addAnnotations(this.clsAnnttns);
        }
        if (this.scanner.token == JasmTokens.Token.CLASS) {
            this.scanner.scan();
        } else if (this.scanner.token == JasmTokens.Token.ANNOTATION) {
            this.scanner.scan();
            if (this.scanner.token == JasmTokens.Token.INTERFACE) {
                mod |= EModifier.ACC_ANNOTATION.getFlag() | EModifier.ACC_INTERFACE.getFlag();
                this.scanner.scan();
            } else {
                this.environment.error(this.scanner.prevPos, "err.one.of.two.token.expected", JasmTokens.Token.ANNOTATION.parseKey(), JasmTokens.Token.INTERFACE.parseKey());
                throw new SyntaxError();
            }
        }
        ConstCell<?> nm = this.cpParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_CLASS, null, true);
        if (this.scanner.token == JasmTokens.Token.FIELD) {
            this.scanner.scan();
            String fileExtension = switch (this.scanner.token) {
                case JasmTokens.Token.CLASS, JasmTokens.Token.STRINGVAL -> this.scanner.stringValue;
                case JasmTokens.Token.IDENT -> this.scanner.idValue;
                default -> {
                    this.environment.error(this.scanner.pos, "err.name.expected", "\"" + this.scanner.token.parseKey() + "\"");
                    throw new SyntaxError();
                }
            };
            this.scanner.scan();
            this.classData.fileExtension = "." + fileExtension;
        } else {
            if (this.scanner.token == JasmTokens.Token.MODULE) {
                this.environment.error(this.scanner.prevPos, "err.token.expected", "\"" + JasmTokens.Token.OPEN.parseKey() + "\"");
                throw new SyntaxError();
            }
            if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
                this.scanner.scan();
            } else if (this.scanner.token == JasmTokens.Token.COLON) {
                this.scanner.scan();
                this.parseClassSignature();
            }
        }
        ConstCell<?> sup = null;
        if (this.scanner.token == JasmTokens.Token.EXTENDS) {
            this.scanner.scan();
            sup = this.cpParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_CLASS, null, true);
            while (this.scanner.token == JasmTokens.Token.COMMA) {
                this.scanner.scan();
                this.environment.warning(posa, "warn.multiple.inherit", new Object[0]);
                sup = this.cpParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_CLASS, null, true);
            }
        }
        ArrayList<Indexer> impl = new ArrayList<Indexer>();
        if (this.scanner.token == JasmTokens.Token.IMPLEMENTS) {
            do {
                this.scanner.scan();
                ConstCell<?> intf = this.cpParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_CLASS, null, true);
                if (impl.contains(intf)) {
                    this.environment.warning(posa, "warn.intf.repeated", intf);
                    continue;
                }
                impl.add(intf);
            } while (this.scanner.token == JasmTokens.Token.COMMA);
        }
        if (this.scanner.token == JasmTokens.Token.LBRACE) {
            if (!this.classData.cfv.isSet() && !this.classData.cfv.isSetByParameter()) {
                this.classData.cfv.initClassDefaultVersion();
                this.environment.warning(this.scanner.prevPos, "warn.default.cfv", this.classData.cfv.asString());
            }
        } else if (this.classData.cfv.isSet() && this.classData.cfv.isSetByParameter() && this.classData.cfv.isFrozen()) {
            int minor = this.classData.cfv.minor_version();
            int major = this.classData.cfv.major_version();
            String version = this.classData.cfv.asString();
            String option = this.classData.cfv.isThresholdSet() ? this.classData.cfv.asThresholdString() : this.classData.cfv.asString();
            this.parseVersion();
            if (this.classData.cfv.isSetByParameter() && (major == this.classData.cfv.major_version() || minor == this.classData.cfv.minor_version())) {
                this.environment.warning(this.scanner.prevPos, "warn.isset.cfv", version, option);
            }
        } else {
            this.parseVersion();
        }
        this.scanner.expect(JasmTokens.Token.LBRACE);
        this.classData.init(mod, nm, sup, impl);
        block10: while (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
            switch (this.scanner.token) {
                case SEMICOLON: {
                    this.scanner.scan();
                    continue block10;
                }
                case CONST: {
                    this.scanner.scan();
                    this.parseConstDef();
                    this.explicitCP = true;
                    continue block10;
                }
            }
            this.parseClassMembers();
        }
        this.scanner.expect(JasmTokens.Token.RBRACE);
        this.endClass();
    }

    private NameInfo parseTypeName() throws IOException {
        Object name = "";
        String field = "";
        int cpIndex = 0;
        if (this.scanner.token == JasmTokens.Token.IDENT) {
            while (true) {
                if (!this.scanner.token.isPossibleClassName()) {
                    this.environment.error(this.scanner.pos, "err.name.expected", "\"" + this.scanner.token.parseKey() + "\"");
                    throw new SyntaxError();
                }
                name = (String)name + field + this.scanner.idValue;
                this.scanner.scan();
                if (this.scanner.token == JasmTokens.Token.FIELD) {
                    this.environment.warning(this.scanner.pos, "warn.dot.will.be.converted", new Object[0]);
                    field = "/";
                    this.scanner.scan();
                    continue;
                }
                break;
            }
        } else if (this.scanner.token == JasmTokens.Token.CPINDEX) {
            cpIndex = this.scanner.intValue;
            this.scanner.scan();
        }
        return new NameInfo(cpIndex, (String)name);
    }

    private NameInfo parseModuleName() throws IOException {
        String field = "";
        NameInfo nameInfo = new NameInfo();
        if (this.scanner.token == JasmTokens.Token.IDENT) {
            while (true) {
                if (!this.scanner.token.isPossibleModuleName()) {
                    this.environment.error(this.scanner.pos, "err.module.name.expected", "\"" + this.scanner.token.parseKey() + "\"");
                    throw new SyntaxError().setFatal();
                }
                nameInfo.setName(nameInfo.name() + field + this.scanner.idValue);
                this.scanner.scanModuleStatement();
                if (this.scanner.token == JasmTokens.Token.FIELD) {
                    field = Character.toString((char)this.scanner.token.value());
                    this.scanner.scanModuleStatement();
                    continue;
                }
                break;
            }
        } else if (this.scanner.token == JasmTokens.Token.CPINDEX) {
            nameInfo.setCpIndex(this.scanner.intValue);
            this.scanner.scan();
        } else {
            this.environment.error(this.scanner.pos, "err.module.name.expected", "\"" + this.scanner.token.parseKey() + "\"");
            throw new SyntaxError().setFatal();
        }
        return nameInfo;
    }

    private void parseModule(int mod) throws IOException {
        this.traceMethodInfoLn("Begin");
        if (mod != 0) {
            this.environment.warning(this.scanner.pos, "warn.modifiers.ignored", EModifier.asNames(mod, ClassFileContext.MODULE));
        }
        if (this.clsAnnttns != null) {
            this.classData.addAnnotations(this.clsAnnttns);
        }
        this.moduleAttribute = new ModuleAttr(this.classData);
        if (this.scanner.token == JasmTokens.Token.OPEN) {
            this.moduleAttribute.openModule();
            this.scanner.scan();
        }
        if (this.scanner.token != JasmTokens.Token.MODULE) {
            this.environment.error(this.scanner.pos, "err.token.expected", JasmTokens.Token.MODULE.parseKey());
            throw new SyntaxError().setFatal();
        }
        this.scanner.scanModuleStatement();
        NameInfo moduleNameInfo = this.parseModuleName();
        if (moduleNameInfo.isEmpty()) {
            this.environment.error(this.scanner.pos, "err.name.expected", "\"" + this.scanner.token + "\"");
            throw new SyntaxError().setFatal();
        }
        if (moduleNameInfo.cpIndex() != 0) {
            this.moduleAttribute.setModuleNameCpIndex(moduleNameInfo.cpIndex());
        } else {
            this.moduleAttribute.setModuleName(moduleNameInfo.name());
        }
        if (this.scanner.token == JasmTokens.Token.LBRACE) {
            this.classData.cfv.initModuleDefaultVersion();
            this.environment.warning(this.scanner.pos, "warn.default.cfv", this.classData.cfv.asString());
        } else {
            this.parseVersion();
        }
        this.scanner.expect(JasmTokens.Token.LBRACE);
        this.classData.initAsModule();
        block9: while (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
            switch (this.scanner.token) {
                case CONST: {
                    this.scanner.scan();
                    this.parseConstDef();
                    this.explicitCP = true;
                    continue block9;
                }
                case REQUIRES: {
                    this.scanRequires(this.moduleAttribute.requires);
                    continue block9;
                }
                case EXPORTS: {
                    this.scanStatement(this.moduleAttribute.exports, this::parseTypeName, this::parseModuleName, JasmTokens.Token.TO, true, "err.exports.expected");
                    continue block9;
                }
                case OPENS: {
                    this.scanStatement(this.moduleAttribute.opens, this::parseTypeName, this::parseModuleName, JasmTokens.Token.TO, true, "err.opens.expected");
                    continue block9;
                }
                case PROVIDES: {
                    this.scanStatement(this.moduleAttribute.provides, this::parseTypeName, this::parseTypeName, JasmTokens.Token.WITH, false, "err.provides.expected");
                    continue block9;
                }
                case USES: {
                    this.scanStatement(this.moduleAttribute.uses, "err.uses.expected");
                    continue block9;
                }
                case SEMICOLON: {
                    this.scanner.scan();
                    continue block9;
                }
            }
            this.environment.error(this.scanner.pos, "err.module.statement.expected", new Object[0]);
            throw new SyntaxError().setFatal();
        }
        this.scanner.expect(JasmTokens.Token.RBRACE);
        this.endModule();
    }

    private void scanRequires(Consumer<ModuleContent.Dependence> action) throws IOException {
        int flags = 0;
        NameInfo moduleNameInfo = new NameInfo();
        this.scanner.scanModuleStatement();
        block7: while (this.scanner.token != JasmTokens.Token.SEMICOLON) {
            switch (this.scanner.token) {
                case STATIC: {
                    if (EModifier.isStaticPhase(flags) || !moduleNameInfo.isEmpty()) {
                        this.environment.error(this.scanner.pos, "err.requires.expected", new Object[0]);
                        throw new SyntaxError().setFatal();
                    }
                    flags |= EModifier.ACC_STATIC_PHASE.getFlag();
                    break;
                }
                case TRANSITIVE: {
                    if (EModifier.isTransitive(flags) || !moduleNameInfo.isEmpty()) {
                        this.environment.error(this.scanner.pos, "err.requires.expected", new Object[0]);
                        throw new SyntaxError().setFatal();
                    }
                    flags |= EModifier.ACC_TRANSITIVE.getFlag();
                    break;
                }
                case SYNTHETIC: {
                    if (EModifier.isSynthetic(flags) || !moduleNameInfo.isEmpty()) {
                        this.environment.error(this.scanner.pos, "err.requires.expected", new Object[0]);
                        throw new SyntaxError().setFatal();
                    }
                    flags |= EModifier.ACC_SYNTHETIC.getFlag();
                    break;
                }
                case MANDATED: {
                    if (EModifier.isMandated(flags) || !moduleNameInfo.isEmpty()) {
                        this.environment.error(this.scanner.pos, "err.requires.expected", new Object[0]);
                        throw new SyntaxError().setFatal();
                    }
                    flags |= EModifier.ACC_MANDATED.getFlag();
                    break;
                }
                case CPINDEX: 
                case IDENT: {
                    if (!moduleNameInfo.isEmpty()) {
                        this.environment.error(this.scanner.pos, "err.requires.expected", new Object[0]);
                        throw new SyntaxError().setFatal();
                    }
                    moduleNameInfo = this.parseModuleName();
                    continue block7;
                }
                default: {
                    this.environment.error(this.scanner.pos, "err.requires.expected", new Object[0]);
                    throw new SyntaxError().setFatal();
                }
            }
            this.scanner.scanModuleStatement();
        }
        if (moduleNameInfo.isEmpty()) {
            this.environment.error(this.scanner.pos, "err.requires.expected", new Object[0]);
            throw new SyntaxError().setFatal();
        }
        action.accept(new ModuleContent.Dependence(moduleNameInfo.cpIndex(), moduleNameInfo.name(), flags, null));
        this.scanner.scanModuleStatement();
    }

    private <T extends ModuleContent.TargetType> void scanStatement(BiConsumer<T, Set<ModuleContent.TargetType>> action, NameSupplier source, NameSupplier target, JasmTokens.Token startList, boolean emptyListAllowed, String err) throws IOException {
        boolean isProvidesStatement = startList == JasmTokens.Token.WITH;
        int flags = 0;
        NameInfo typeNameInfo = new NameInfo();
        HashSet<Object> nameInfos = new HashSet();
        this.scanner.scan();
        block6: while (this.scanner.token != JasmTokens.Token.SEMICOLON) {
            switch (this.scanner.token) {
                case SYNTHETIC: {
                    if (EModifier.isSynthetic(flags) || !typeNameInfo.isEmpty() || isProvidesStatement) {
                        this.environment.error(this.scanner.pos, err, new Object[0]);
                        throw new SyntaxError().setFatal();
                    }
                    flags |= EModifier.ACC_SYNTHETIC.getFlag();
                    break;
                }
                case MANDATED: {
                    if (EModifier.isMandated(flags) || !typeNameInfo.isEmpty() || isProvidesStatement) {
                        this.environment.error(this.scanner.pos, err, new Object[0]);
                        throw new SyntaxError().setFatal();
                    }
                    flags |= EModifier.ACC_MANDATED.getFlag();
                    break;
                }
                case CPINDEX: 
                case IDENT: {
                    if (!typeNameInfo.isEmpty()) {
                        this.environment.error(this.scanner.pos, err, new Object[0]);
                        throw new SyntaxError().setFatal();
                    }
                    typeNameInfo = source.get();
                    continue block6;
                }
                case TO: 
                case WITH: {
                    nameInfos = this.scanList(isProvidesStatement ? () -> this.scanner.scan() : () -> this.scanner.scanModuleStatement(), target, err, false);
                    continue block6;
                }
                default: {
                    this.environment.error(this.scanner.pos, err, new Object[0]);
                    throw new SyntaxError().setFatal();
                }
            }
            if (isProvidesStatement) {
                this.scanner.scan();
                continue;
            }
            this.scanner.scanModuleStatement();
        }
        if (typeNameInfo.isEmpty() || nameInfos.isEmpty() && !emptyListAllowed) {
            this.environment.error(this.scanner.pos, err, new Object[0]);
            throw new SyntaxError().setFatal();
        }
        if (isProvidesStatement) {
            Set classes = nameInfos.stream().map(nameInfo -> new ModuleContent.TargetType(ConstantPool.TAG.CONSTANT_CLASS, nameInfo.cpIndex(), nameInfo.name())).collect(Collectors.toSet());
            action.accept(new ModuleContent.FlaggedTargetType(ConstantPool.TAG.CONSTANT_CLASS, typeNameInfo.cpIndex(), typeNameInfo.name(), flags, ClassFileContext.MODULE), classes);
        } else {
            Set modules = nameInfos.stream().map(nameInfo -> new ModuleContent.TargetType(ConstantPool.TAG.CONSTANT_MODULE, nameInfo.cpIndex(), nameInfo.name())).collect(Collectors.toSet());
            action.accept(new ModuleContent.FlaggedTargetType(ConstantPool.TAG.CONSTANT_PACKAGE, typeNameInfo.cpIndex(), typeNameInfo.name(), flags, ClassFileContext.MODULE), modules);
        }
        this.scanner.scan();
    }

    private void scanStatement(Consumer<ModuleContent.TargetType> action, String err) throws IOException {
        HashSet<NameInfo> nameInfos = this.scanList(() -> this.scanner.scan(), this::parseTypeName, err, true);
        if (nameInfos.size() != 1) {
            this.environment.error(this.scanner.pos, err, new Object[0]);
            throw new SyntaxError().setFatal();
        }
        nameInfos.forEach(nameInfo -> action.accept(new ModuleContent.TargetType(ConstantPool.TAG.CONSTANT_CLASS, nameInfo.cpIndex(), nameInfo.name())));
        this.scanner.scan();
    }

    private HashSet<NameInfo> scanList(Method scanMethod, NameSupplier target, String err, boolean onlyOneElement) throws IOException {
        HashSet<NameInfo> nameInfos = new HashSet<NameInfo>();
        boolean comma = false;
        boolean first = true;
        scanMethod.call();
        block4: while (this.scanner.token != JasmTokens.Token.SEMICOLON) {
            switch (this.scanner.token) {
                case COMMA: {
                    if (comma || first || onlyOneElement) {
                        this.environment.error(this.scanner.pos, err, new Object[0]);
                        throw new SyntaxError().setFatal();
                    }
                    comma = true;
                    break;
                }
                case CPINDEX: 
                case IDENT: {
                    if (!first && !comma) {
                        this.environment.error(this.scanner.pos, err, new Object[0]);
                        throw new SyntaxError().setFatal();
                    }
                    nameInfos.add(target.get());
                    comma = false;
                    first = false;
                    continue block4;
                }
                default: {
                    this.environment.error(this.scanner.pos, err, new Object[0]);
                    throw new SyntaxError().setFatal();
                }
            }
            this.scanner.scan();
        }
        if (nameInfos.isEmpty() || comma) {
            this.environment.error(this.scanner.pos, err, new Object[0]);
            throw new SyntaxError().setFatal();
        }
        return nameInfos;
    }

    private void parseClassMembers() throws IOException {
        this.traceMethodInfoLn("Begin");
        if (this.scanner.token == JasmTokens.Token.ANNOTATION) {
            this.memberAnnttns = this.annotParser.scanAnnotations();
        }
        int mod = this.scanModifiers();
        try {
            switch (this.scanner.token) {
                case FIELDREF: {
                    this.scanner.scan();
                    this.parseField(mod);
                    break;
                }
                case METHODREF: {
                    this.scanner.scan();
                    this.parseMethod(mod);
                    break;
                }
                case INNERCLASS: {
                    this.scanner.scan();
                    this.parseInnerClass(mod);
                    break;
                }
                case BOOTSTRAPMETHOD: {
                    this.scanner.scan();
                    this.parseCPXBootstrapMethod();
                    break;
                }
                case SIGNATURE: {
                    if (this.classData.signatureAttr != null) {
                        this.environment.error(this.scanner.pos, "err.extra.attribute", JasmTokens.Token.SIGNATURE.parseKey(), "ClassData");
                        throw new SyntaxError();
                    }
                    this.scanner.scan();
                    this.parseClassSignature();
                    this.scanner.expect(JasmTokens.Token.SEMICOLON);
                    break;
                }
                case THIS_CLASS: {
                    this.scanner.scan();
                    this.parseClassRef(constCell -> this.classData.coreClasses.this_class(ClassData.CoreClasses.PLACE.CLASSFILE, (ConstCell<?>)constCell));
                    this.scanner.expect(JasmTokens.Token.SEMICOLON);
                    break;
                }
                case SUPER_CLASS: {
                    this.scanner.scan();
                    this.parseClassRef(constCell -> this.classData.coreClasses.super_class(ClassData.CoreClasses.PLACE.CLASSFILE, (ConstCell<?>)constCell));
                    this.scanner.expect(JasmTokens.Token.SEMICOLON);
                    break;
                }
                case SOURCEFILE: {
                    if (this.classData.sourceFileAttr != null) {
                        this.environment.error(this.scanner.pos, "err.extra.attribute", JasmTokens.Token.SOURCEFILE.parseKey(), "ClassData");
                        throw new SyntaxError();
                    }
                    this.scanner.scan();
                    this.parseSourceFile();
                    this.scanner.expect(JasmTokens.Token.SEMICOLON);
                    break;
                }
                case SOURCEDEBUGEXTENSION: {
                    if (this.classData.sourceDebugExtensionAttr != null) {
                        this.environment.error(this.scanner.pos, "err.extra.attribute", JasmTokens.Token.SOURCEDEBUGEXTENSION.parseKey(), "ClassData");
                        throw new SyntaxError();
                    }
                    this.scanner.scan();
                    this.parseSourceDebugExtension();
                    break;
                }
                case NESTHOST: {
                    if (this.classData.nestHostAttributeExists()) {
                        this.environment.error(this.scanner.pos, "err.extra.attribute", JasmTokens.Token.NESTHOST.parseKey(), "ClassData");
                        throw new SyntaxError();
                    }
                    if (this.classData.nestMembersAttributesExist()) {
                        this.environment.error(this.scanner.pos, "err.both.nesthost.nestmembers.found", new Object[0]);
                        throw new SyntaxError();
                    }
                    this.scanner.scan();
                    this.parseNestHost();
                    break;
                }
                case NESTMEMBERS: {
                    if (this.classData.nestMembersAttributesExist()) {
                        this.environment.error(this.scanner.pos, "err.extra.attribute", JasmTokens.Token.NESTMEMBERS.parseKey(), "ClassData");
                        throw new SyntaxError();
                    }
                    if (this.classData.nestHostAttributeExists()) {
                        this.environment.error(this.scanner.pos, "err.both.nesthost.nestmembers.found", new Object[0]);
                        throw new SyntaxError();
                    }
                    this.scanner.scan();
                    this.parseClasses(list -> this.classData.addNestMembers((List<ConstCell>)list));
                    break;
                }
                case PERMITTEDSUBCLASSES: {
                    if (this.classData.nestMembersAttributesExist()) {
                        this.environment.error(this.scanner.pos, "err.extra.attribute", JasmTokens.Token.PERMITTEDSUBCLASSES.parseKey(), "ClassData");
                        throw new SyntaxError();
                    }
                    this.scanner.scan();
                    this.parseClasses(list -> this.classData.addPermittedSubclasses((List<ConstCell>)list));
                    break;
                }
                case RECORD: {
                    if (this.classData.recordAttributeExists()) {
                        this.environment.error(this.scanner.pos, "err.extra.attribute", JasmTokens.Token.RECORD.parseKey(), "ClassData");
                        throw new SyntaxError();
                    }
                    this.scanner.scan();
                    this.parseRecord();
                    break;
                }
                case PRELOAD: {
                    if (this.classData.preloadAttributeExists()) {
                        this.environment.error(this.scanner.pos, "err.extra.attribute", JasmTokens.Token.PRELOAD.parseKey(), "ClassData");
                        throw new SyntaxError();
                    }
                    this.scanner.scan();
                    this.parseClasses(list -> this.classData.addPreloads((List<ConstCell>)list));
                    break;
                }
                default: {
                    this.environment.error(this.scanner.pos, "err.field.expected", new Object[0]);
                    throw new SyntaxError().setFatal();
                }
            }
        }
        catch (SyntaxError e) {
            if (!e.isFatal()) {
                this.recoverField();
            }
            throw new SyntaxError().setFatal();
        }
        this.traceMethodInfoLn("End");
        this.memberAnnttns = null;
    }

    private void recoverFile() throws IOException {
        block7: while (true) {
            this.environment.traceln("recoverFile: scanner.token=" + this.scanner.token, new Object[0]);
            switch (this.scanner.token) {
                case CLASS: 
                case INTERFACE: {
                    return;
                }
                case LBRACE: {
                    this.match(JasmTokens.Token.LBRACE, JasmTokens.Token.RBRACE);
                    this.scanner.scan();
                    continue block7;
                }
                case LPAREN: {
                    this.match(JasmTokens.Token.LPAREN, JasmTokens.Token.RPAREN);
                    this.scanner.scan();
                    continue block7;
                }
                case LSQBRACKET: {
                    this.match(JasmTokens.Token.LSQBRACKET, JasmTokens.Token.RSQBRACKET);
                    this.scanner.scan();
                    continue block7;
                }
                case EOF: {
                    return;
                }
            }
            this.scanner.scan();
        }
    }

    private void endClass() {
        if (this.explicitCP) {
            this.pool.fixRefsInPool();
            this.classData.relinkBootstrapMethods();
            if (this.classData.sourceFileAttr == null) {
                String sourceFileName = this.environment.getSimpleInputFileName();
                String sourceName = this.environment.getSourceName();
                this.classData.sourceFileAttr = new SourceFileAttr(this.classData.pool, sourceFileName).updateIfFound(this.classData.pool, name -> name.contains(sourceName) && StringUtils.contains.apply((String)name, List.of(".java", ".jcod", ".jasm", ".class")) != false);
            }
        } else if (this.classData.sourceFileAttr == null) {
            this.classData.sourceFileAttr = new CPXAttr(this.pool, EAttribute.ATT_SourceFile, this.pool.findUTF8Cell(this.environment.getSimpleInputFileName()));
        }
        this.classData.endClass();
        this.clsDataList.add(this.classData);
        this.initializeClassData();
    }

    private void endPackageInfo() {
        if (this.explicitCP) {
            this.pool.fixRefsInPool();
            if (this.classData.sourceFileAttr == null) {
                String sourceName = this.environment.getSimpleInputFileName();
                this.classData.sourceFileAttr = new SourceFileAttr(this.classData.pool, sourceName).updateIfFound(this.classData.pool, name -> name.contains("package-info."));
            }
        } else if (this.classData.sourceFileAttr == null) {
            this.classData.sourceFileAttr = new CPXAttr(this.pool, EAttribute.ATT_SourceFile, this.pool.findUTF8Cell(this.environment.getSimpleInputFileName()));
        }
        this.classData.endPackageInfo();
        this.clsDataList.add(this.classData);
        this.classData = null;
    }

    private void endModule() {
        if (this.explicitCP) {
            this.pool.fixRefsInPool();
            if (this.classData.sourceFileAttr == null) {
                String sourceName = this.environment.getSimpleInputFileName();
                this.classData.sourceFileAttr = new SourceFileAttr(this.classData.pool, sourceName).updateIfFound(this.classData.pool, name -> name.contains("module-info."));
            }
        } else if (this.classData.sourceFileAttr == null) {
            this.classData.sourceFileAttr = new CPXAttr(this.pool, EAttribute.ATT_SourceFile, this.pool.findUTF8Cell(this.environment.getSimpleInputFileName()));
        }
        this.classData.endModule(this.moduleAttribute);
        this.clsDataList.add(this.classData);
        this.classData = null;
    }

    final ClassData[] getClassesData() {
        return this.clsDataList.toArray(new ClassData[0]);
    }

    private void parseJasmPackages() throws IOException {
        if (this.scanner.token.in(JasmTokens.Token.CONST, JasmTokens.Token.ANNOTATION, JasmTokens.Token.PACKAGE)) {
            boolean scanNext = true;
            try {
                block8: while (this.scanner.token != JasmTokens.Token.EOF && scanNext) {
                    switch (this.scanner.token) {
                        case CONST: {
                            this.scanner.scan();
                            this.parseConstDef();
                            this.explicitCP = true;
                            continue block8;
                        }
                        case SEMICOLON: {
                            this.scanner.scan();
                            continue block8;
                        }
                        case ANNOTATION: {
                            this.pkgAnnttns = this.annotParser.scanAnnotations();
                            continue block8;
                        }
                        case PACKAGE: {
                            this.scanner.scan();
                            int where = this.scanner.pos;
                            String id = this.parseIdent();
                            if (this.scanner.token != JasmTokens.Token.SEMICOLON) {
                                this.parseVersion();
                                this.scanner.expect(JasmTokens.Token.SEMICOLON);
                            }
                            if (this.pkg == null) {
                                this.pkg = id;
                                this.pkgPrefix = id + "/";
                            } else {
                                this.environment.error(where, "err.package.repeated", new Object[0]);
                            }
                            this.traceMethodInfoLn("{PARSED} package-prefix: \"" + this.pkgPrefix + "\"");
                        }
                    }
                    scanNext = false;
                }
            }
            catch (SyntaxError e) {
                this.recoverFile();
            }
            while (this.scanner.token == JasmTokens.Token.SEMICOLON) {
                this.scanner.scan();
            }
            if (this.scanner.token == JasmTokens.Token.EOF) {
                this.environment.traceln("Scanner:  EOF", new Object[0]);
                String sourceName = this.environment.getSimpleInputFileName();
                if (sourceName.contains("package-info")) {
                    this.environment.traceln("Creating \"package-info.jasm\": package: " + this.pkg + " " + this.classData.cfv.asString(), new Object[0]);
                    int mod = EModifier.ACC_INTERFACE.getFlag() | EModifier.ACC_ABSTRACT.getFlag();
                    if (this.classData.cfv.major_version() > 49) {
                        mod |= EModifier.SYNTHETIC_ATTRIBUTE.getFlag();
                    }
                    this.classData.initAsPackageInfo(mod, this.pkgPrefix + "package-info");
                    if (this.pkgAnnttns != null) {
                        this.classData.addAnnotations(this.pkgAnnttns);
                    }
                    this.endPackageInfo();
                }
                return;
            }
            if (this.pkg == null && this.pkgAnnttns != null) {
                this.clsAnnttns = this.pkgAnnttns;
                this.pkgAnnttns = null;
            }
        }
    }

    void parseFile() {
        try {
            this.initializeClassData();
            this.parseJasmPackages();
            block9: while (this.scanner.token != JasmTokens.Token.EOF) {
                try {
                    int mod;
                    block18: {
                        block17: {
                            if (this.scanner.token == JasmTokens.Token.ANNOTATION) {
                                this.clsAnnttns = this.annotParser.scanAnnotations();
                            }
                            if ((mod = this.scanModifiers()) != 0) break block17;
                            switch (this.scanner.token) {
                                case CLASS: 
                                case CPINDEX: 
                                case IDENT: 
                                case INTERFACE: 
                                case STRINGVAL: 
                                case OPEN: 
                                case MODULE: {
                                    break block18;
                                }
                                case SEMICOLON: {
                                    this.scanner.scan();
                                    continue block9;
                                }
                                default: {
                                    this.environment.error(this.scanner.pos, "err.toplevel.expected", new Object[0]);
                                    throw new SyntaxError();
                                }
                            }
                        }
                        if (EModifier.isInterface(mod) && this.scanner.token != JasmTokens.Token.CLASS) {
                            mod |= EModifier.ACC_ABSTRACT.getFlag();
                        }
                    }
                    if (this.scanner.token == JasmTokens.Token.MODULE || this.scanner.token == JasmTokens.Token.OPEN) {
                        this.parseModule(mod);
                    } else {
                        this.parseClass(mod);
                    }
                    this.clsAnnttns = null;
                }
                catch (SyntaxError e) {
                    this.environment.traceln("^^^^^^^ Syntax Error ^^^^^^^^^^^^", new Object[0]);
                    if (this.scanner.environment.getVerboseFlag()) {
                        e.printStackTrace();
                    }
                    if (!e.isFatal()) {
                        this.recoverFile();
                    }
                    break;
                }
            }
        }
        catch (IOException e) {
            this.environment.error(this.scanner.pos, "io.exception", this.environment.getSimpleInputFileName());
        }
        catch (Error er) {
            er.printStackTrace();
        }
    }

    private void initializeClassData() {
        this.classData = new ClassData(this.environment, CFVersion.copyOf(this.currentCFV));
        this.pool = this.classData.pool;
    }

    private static /* synthetic */ Boolean lambda$parseSourceFile$0(String sourceName, String name) {
        return name.contains(sourceName) && StringUtils.contains.apply(name, List.of(".java", ".jcod", ".jasm", ".class")) != false;
    }

    @FunctionalInterface
    static interface NameSupplier {
        public NameInfo get() throws IOException;
    }

    @FunctionalInterface
    static interface Method {
        public void call() throws IOException;
    }

    static class CompilerError
    extends Error {
        CompilerError(String message) {
            super(message);
        }
    }
}

