/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.util.ArrayList;
import java.util.function.BiFunction;
import org.openjdk.asmtools.common.SyntaxError;
import org.openjdk.asmtools.jasm.BootstrapMethodData;
import org.openjdk.asmtools.jasm.CPTagVisitor;
import org.openjdk.asmtools.jasm.ClassFileConst;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstValue;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.ParseBase;
import org.openjdk.asmtools.jasm.Parser;

public class ParserCP
extends ParseBase {
    private final ParserCPVisitor pConstVstr;
    private boolean exitImmediately = false;
    private int lbrace = 0;

    protected ParserCP(Parser parentParser) {
        super.init(parentParser);
        this.pConstVstr = new ParserCPVisitor();
    }

    public void setExitImmediately(boolean exitImmediately) {
        this.exitImmediately = exitImmediately;
    }

    protected ConstValue<?> parseConstValue(ClassFileConst.ConstType tag) throws SyntaxError {
        return this.pConstVstr.visitExcept(tag);
    }

    protected ConstValue<?> parseTagConstValue(ClassFileConst.ConstType defaultTag) throws SyntaxError {
        return this.parseTagConstValue(defaultTag, null, false);
    }

    private ClassFileConst.ConstType scanConstByID(boolean ignoreKeywords) {
        ClassFileConst.ConstType tag = null;
        if (!ignoreKeywords) {
            tag = ClassFileConst.tag(this.scanner.idValue);
        }
        this.traceMethodInfoLn(String.format("\t\tTag: %s ", tag == null ? "<not found>" : tag));
        return tag;
    }

    private ClassFileConst.ConstType scanConstPrimVal() throws SyntaxError {
        return switch (this.scanner.token) {
            case JasmTokens.Token.BYTE -> ClassFileConst.ConstType.CONSTANT_INTEGER_BYTE;
            case JasmTokens.Token.CHAR -> ClassFileConst.ConstType.CONSTANT_INTEGER_CHAR;
            case JasmTokens.Token.DOUBLEVAL -> ClassFileConst.ConstType.CONSTANT_DOUBLE;
            case JasmTokens.Token.FLOATVAL -> ClassFileConst.ConstType.CONSTANT_FLOAT;
            case JasmTokens.Token.LONGVAL -> ClassFileConst.ConstType.CONSTANT_LONG;
            case JasmTokens.Token.INTVAL -> ClassFileConst.ConstType.CONSTANT_INTEGER;
            case JasmTokens.Token.SHORT -> ClassFileConst.ConstType.CONSTANT_INTEGER_SHORT;
            case JasmTokens.Token.BOOLEAN -> ClassFileConst.ConstType.CONSTANT_INTEGER_BOOLEAN;
            case JasmTokens.Token.STRINGVAL, JasmTokens.Token.BITS, JasmTokens.Token.IDENT -> ClassFileConst.ConstType.CONSTANT_STRING;
            default -> {
                this.environment.error(this.scanner.pos, "err.value.expected", this.scanner.token.printValue());
                throw new SyntaxError();
            }
        };
    }

    private void checkWrongTag(ClassFileConst.ConstType tag, ClassFileConst.ConstType defaultTag, ClassFileConst.ConstType default2Tag) throws SyntaxError {
        if (defaultTag != null && tag != defaultTag) {
            if (default2Tag == null) {
                if (this.exitImmediately) {
                    this.environment.error(this.scanner.pos, "err.wrong.tag", defaultTag.parseKey());
                    throw new SyntaxError().setFatal();
                }
                this.environment.warning(this.scanner.pos, "warn.wrong.tag", defaultTag.parseKey());
            } else if (tag != default2Tag) {
                if (this.exitImmediately) {
                    this.environment.error(this.scanner.pos, "err.wrong.tag2", defaultTag.parseKey(), default2Tag.parseKey());
                    throw new SyntaxError().setFatal();
                }
                this.environment.warning(this.scanner.pos, "warn.wrong.tag2", defaultTag.parseKey(), default2Tag.parseKey());
            }
        }
    }

    protected ConstValue<?> parseTagConstValue(ClassFileConst.ConstType defaultTag, ClassFileConst.ConstType default2Tag, boolean ignoreKeywords) throws SyntaxError {
        this.traceMethodInfoLn(String.format("\t<< DefaultTag: %s 2nd DefaultTag: %s IgnoreKeyword?: %b", defaultTag == null ? "<none>" : defaultTag, default2Tag == null ? "<none>" : default2Tag, ignoreKeywords));
        ClassFileConst.ConstType tag = this.scanConstByID(ignoreKeywords);
        this.traceMethodInfoLn(String.format("\tResult Tag: %s >>", new Object[]{tag}));
        if (tag == null) {
            tag = defaultTag == null ? this.scanConstPrimVal() : defaultTag;
        } else {
            this.checkWrongTag(tag, defaultTag, default2Tag);
            this.scanner.scan();
        }
        return this.parseConstValue(tag);
    }

    protected ConstCell<?> parseConstRef(ClassFileConst.ConstType defaultTag) throws SyntaxError {
        return this.parseConstRef(defaultTag, null, false);
    }

    protected ConstCell<?> parseConstRef(ClassFileConst.ConstType defaultTag, ClassFileConst.ConstType default2Tag) throws SyntaxError {
        return this.parseConstRef(defaultTag, default2Tag, false);
    }

    protected ConstCell<?> parseConstRef(ClassFileConst.ConstType defaultTag, ClassFileConst.ConstType default2Tag, boolean ignoreKeywords) throws SyntaxError {
        if (this.scanner.token == JasmTokens.Token.CPINDEX) {
            int cpx = this.scanner.intValue;
            this.scanner.scan();
            return this.parser.pool.getCell(cpx);
        }
        ConstValue<?> ref = this.parseTagConstValue(defaultTag, default2Tag, ignoreKeywords);
        return this.parser.pool.findCell(ref);
    }

    class ParserCPVisitor
    extends CPTagVisitor<ConstValue<?>> {
        private SyntaxError syntaxError;

        ParserCPVisitor() {
        }

        public ConstValue<?> visitExcept(ClassFileConst.ConstType tag) throws SyntaxError {
            this.syntaxError = null;
            ParserCP.this.traceMethodInfoLn();
            ConstValue ret = (ConstValue)this.visit(tag);
            if (this.syntaxError != null) {
                throw this.syntaxError;
            }
            return ret;
        }

        @Override
        public ConstValue<?> visitUTF8() {
            ParserCP.this.traceMethodInfoLn();
            try {
                ParserCP.this.scanner.expect(JasmTokens.Token.STRINGVAL);
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return new ConstantPool.ConstValue_UTF8(ParserCP.this.scanner.stringValue);
        }

        @Override
        public ConstValue<?> visitInteger(ClassFileConst.ConstType tag) {
            ParserCP.this.traceMethodInfoLn();
            int v = 0;
            try {
                if (ParserCP.this.scanner.token == JasmTokens.Token.BITS) {
                    ParserCP.this.scanner.scan();
                    ParserCP.this.scanner.inBits = true;
                }
                v = ParserCP.this.scanner.intValue * ParserCP.this.scanner.sign;
                ParserCP.this.scanner.expect(JasmTokens.Token.INTVAL);
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return new ConstantPool.ConstValue_Integer(tag, v);
        }

        @Override
        public ConstValue<?> visitLong() {
            ParserCP.this.traceMethodInfoLn();
            ConstantPool.ConstValue_Long valueLong = null;
            try {
                if (ParserCP.this.scanner.token == JasmTokens.Token.BITS) {
                    ParserCP.this.scanner.scan();
                    ParserCP.this.scanner.inBits = true;
                }
                valueLong = new ConstantPool.ConstValue_Long((switch (ParserCP.this.scanner.token) {
                    case JasmTokens.Token.INTVAL -> ParserCP.this.scanner.intValue;
                    case JasmTokens.Token.LONGVAL -> ParserCP.this.scanner.longValue;
                    default -> {
                        ParserCP.this.environment.error(ParserCP.this.scanner.prevPos, "err.token.expected", "Integer");
                        throw new SyntaxError();
                    }
                }) * (long)ParserCP.this.scanner.sign);
                ParserCP.this.scanner.scan();
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return valueLong;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstValue<?> visitFloat() {
            ParserCP.this.traceMethodInfoLn();
            ConstantPool.ConstValue_Float valueFloat = null;
            try {
                int v;
                block13: {
                    float f;
                    ParserCP.this.scanner.inBits = false;
                    if (ParserCP.this.scanner.token == JasmTokens.Token.BITS) {
                        ParserCP.this.scanner.scan();
                        ParserCP.this.scanner.inBits = true;
                    }
                    switch (ParserCP.this.scanner.token) {
                        case INTVAL: {
                            if (ParserCP.this.scanner.inBits) {
                                v = ParserCP.this.scanner.intValue;
                                break block13;
                            } else {
                                f = ParserCP.this.scanner.intValue;
                                break;
                            }
                        }
                        case FLOATVAL: {
                            f = ParserCP.this.scanner.floatValue;
                            break;
                        }
                        case DOUBLEVAL: {
                            f = (float)ParserCP.this.scanner.doubleValue;
                            break;
                        }
                        case INF: {
                            f = Float.POSITIVE_INFINITY;
                            break;
                        }
                        case NAN: {
                            f = Float.NaN;
                            break;
                        }
                        default: {
                            ParserCP.this.environment.traceln("token=" + ParserCP.this.scanner.token, new Object[0]);
                            ParserCP.this.environment.error(ParserCP.this.scanner.pos, "err.token.expected", "<Float>");
                            throw new SyntaxError();
                        }
                    }
                    v = Float.floatToIntBits(f);
                }
                if (ParserCP.this.scanner.sign == -1) {
                    v ^= Integer.MIN_VALUE;
                }
                valueFloat = new ConstantPool.ConstValue_Float(v);
                ParserCP.this.scanner.scan();
                return valueFloat;
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return valueFloat;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstValue<?> visitDouble() {
            ParserCP.this.traceMethodInfoLn();
            ConstantPool.ConstValue_Double valueDouble = null;
            try {
                long v;
                block16: {
                    double d;
                    if (ParserCP.this.scanner.token == JasmTokens.Token.BITS) {
                        ParserCP.this.scanner.scan();
                        ParserCP.this.scanner.inBits = true;
                    }
                    switch (ParserCP.this.scanner.token) {
                        case INTVAL: {
                            if (ParserCP.this.scanner.inBits) {
                                v = ParserCP.this.scanner.intValue;
                                break block16;
                            } else {
                                d = ParserCP.this.scanner.intValue;
                                break;
                            }
                        }
                        case LONGVAL: {
                            if (ParserCP.this.scanner.inBits) {
                                v = ParserCP.this.scanner.longValue;
                                break block16;
                            } else {
                                d = ParserCP.this.scanner.longValue;
                                break;
                            }
                        }
                        case FLOATVAL: {
                            d = ParserCP.this.scanner.floatValue;
                            break;
                        }
                        case DOUBLEVAL: {
                            d = ParserCP.this.scanner.doubleValue;
                            break;
                        }
                        case INF: {
                            d = Double.POSITIVE_INFINITY;
                            break;
                        }
                        case NAN: {
                            d = Double.NaN;
                            break;
                        }
                        default: {
                            ParserCP.this.environment.error(ParserCP.this.scanner.pos, "err.token.expected", "Double");
                            throw new SyntaxError();
                        }
                    }
                    v = Double.doubleToLongBits(d);
                }
                if (ParserCP.this.scanner.sign == -1) {
                    v ^= Long.MIN_VALUE;
                }
                valueDouble = new ConstantPool.ConstValue_Double(v);
                ParserCP.this.scanner.scan();
                return valueDouble;
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return valueDouble;
        }

        private ConstCell<?> visitName() {
            ParserCP.this.traceMethodInfoLn();
            ConstCell obj = null;
            try {
                obj = ParserCP.this.parser.parseName();
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return obj;
        }

        @Override
        public ConstValue<?> visitMethodType() {
            ParserCP.this.traceMethodInfoLn();
            ConstantPool.ConstValue_MethodType obj = null;
            ConstCell<ConstantPool.ConstValue_UTF8> cell = this.visitName();
            if (this.syntaxError == null) {
                obj = new ConstantPool.ConstValue_MethodType(cell);
            }
            return obj;
        }

        @Override
        public ConstValue<?> visitString() {
            ParserCP.this.traceMethodInfoLn();
            ConstantPool.ConstValue_String obj = null;
            ConstCell<ConstantPool.ConstValue_UTF8> cell = this.visitName();
            if (this.syntaxError == null) {
                obj = new ConstantPool.ConstValue_String(cell);
            }
            return obj;
        }

        @Override
        public ConstValue<?> visitClass() {
            ParserCP.this.traceMethodInfoLn();
            ConstantPool.ConstValue_Class obj = null;
            try {
                ConstCell cell = ParserCP.this.parser.parseConstantClassInfo(true);
                obj = new ConstantPool.ConstValue_Class(cell);
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return obj;
        }

        @Override
        public ConstValue<?> visitPackage() {
            ParserCP.this.traceMethodInfoLn();
            ConstantPool.ConstValue_Package obj = null;
            try {
                ConstCell cell = ParserCP.this.parser.parseConstantPackageInfo();
                obj = new ConstantPool.ConstValue_Package(cell);
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return obj;
        }

        @Override
        public ConstValue<?> visitModule() {
            ParserCP.this.traceMethodInfoLn();
            ConstantPool.ConstValue_Module obj = null;
            try {
                ConstCell cell = ParserCP.this.parser.parseConstantModuleInfo();
                obj = new ConstantPool.ConstValue_Module(cell);
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return obj;
        }

        @Override
        public ConstValue<?> visitMethodHandle() {
            ParserCP.this.traceMethodInfoLn();
            ConstantPool.ConstValue_MethodHandle obj = null;
            try {
                ConstCell refCell;
                ClassFileConst.SubTag subTag;
                if (ParserCP.this.scanner.token == JasmTokens.Token.INTVAL) {
                    subTag = ClassFileConst.subTag(ParserCP.this.scanner.intValue);
                    ParserCP.this.scanner.scan();
                    ParserCP.this.scanner.expect(JasmTokens.Token.COLON);
                    if (ParserCP.this.scanner.token == JasmTokens.Token.CPINDEX) {
                        int cpx = ParserCP.this.scanner.intValue;
                        refCell = ParserCP.this.parser.pool.getCell(cpx);
                        ParserCP.this.scanner.scan();
                    } else {
                        refCell = ParserCP.this.parser.parseMethodHandle(subTag);
                    }
                } else {
                    subTag = ParserCP.this.parser.parseSubtag();
                    ParserCP.this.scanner.expect(JasmTokens.Token.COLON);
                    if (ParserCP.this.scanner.token == JasmTokens.Token.CPINDEX) {
                        int cpx = ParserCP.this.scanner.intValue;
                        refCell = ParserCP.this.parser.pool.getCell(cpx);
                        ParserCP.this.scanner.scan();
                    } else {
                        refCell = ParserCP.this.parser.parseMethodHandle(subTag);
                    }
                }
                obj = new ConstantPool.ConstValue_MethodHandle(subTag, refCell);
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return obj;
        }

        private <T extends ConstantPool.ConstValue_Pair<ConstantPool.ConstValue_Class, ConstantPool.ConstValue_NameAndType>> T visitMember(ClassFileConst.ConstType tag) {
            ParserCP.this.traceMethodInfoLn();
            ConstantPool.ConstValue_Pair constValue = null;
            try {
                ConstCell NapeCell;
                ConstCell NameCell;
                ConstCell<Object> ClassCell;
                JasmTokens.Token prevToken = ParserCP.this.scanner.token;
                ConstCell firstName = ParserCP.this.parser.parseConstantClassInfo(false);
                if (ParserCP.this.scanner.token == JasmTokens.Token.FIELD) {
                    ParserCP.this.scanner.scan();
                    ClassCell = prevToken == JasmTokens.Token.CPINDEX ? firstName : ParserCP.this.parser.pool.findCell(ClassFileConst.ConstType.CONSTANT_CLASS, firstName);
                    NameCell = ParserCP.this.parser.parseName();
                } else {
                    ClassCell = ParserCP.this.parser.classData.coreClasses.this_class().isSet() || ParserCP.this.parser.classData.coreClasses.this_class().ref == null ? ParserCP.this.parser.classData.coreClasses.this_class() : ParserCP.this.parser.pool.findCell((ConstantPool.ConstValue_Class)ParserCP.this.parser.classData.coreClasses.this_class().ref);
                    NameCell = firstName;
                }
                if (ParserCP.this.scanner.token == JasmTokens.Token.COLON) {
                    ParserCP.this.scanner.scan();
                    NapeCell = ParserCP.this.parser.pool.findCell(ClassFileConst.ConstType.CONSTANT_NAMEANDTYPE, NameCell, ParserCP.this.parser.parseName());
                } else {
                    NapeCell = NameCell;
                }
                switch (tag) {
                    case CONSTANT_INTERFACEMETHODREF: {
                        constValue = new ConstantPool.ConstValue_InterfaceMethodRef(ClassCell, NapeCell);
                        break;
                    }
                    case CONSTANT_METHODREF: {
                        constValue = new ConstantPool.ConstValue_MethodRef(ClassCell, NapeCell);
                        break;
                    }
                    case CONSTANT_FIELDREF: {
                        constValue = new ConstantPool.ConstValue_FieldRef(ClassCell, NapeCell);
                    }
                }
                if (constValue == null) {
                    ParserCP.this.environment.error("err.invalid.type", tag.printVal());
                    throw new SyntaxError().setFatal();
                }
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return (T)constValue;
        }

        @Override
        public ConstValue<?> visitField() {
            ParserCP.this.traceMethodInfoLn();
            return this.visitMember(ClassFileConst.ConstType.CONSTANT_FIELDREF);
        }

        @Override
        public ConstValue<?> visitMethod() {
            ParserCP.this.traceMethodInfoLn();
            return this.visitMember(ClassFileConst.ConstType.CONSTANT_METHODREF);
        }

        @Override
        public ConstValue<?> visitInterfaceMethod() {
            ParserCP.this.traceMethodInfoLn();
            return this.visitMember(ClassFileConst.ConstType.CONSTANT_INTERFACEMETHODREF);
        }

        @Override
        public ConstValue<?> visitNameAndType() {
            ParserCP.this.traceMethodInfoLn();
            ConstantPool.ConstValue_NameAndType obj = null;
            try {
                ConstCell NameCell = ParserCP.this.parser.parseName();
                ParserCP.this.scanner.expect(JasmTokens.Token.COLON);
                ConstCell TypeCell = ParserCP.this.parser.parseName();
                obj = new ConstantPool.ConstValue_NameAndType(NameCell, TypeCell);
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return obj;
        }

        @Override
        public ConstantPool.ConstValue_InvokeDynamic visitInvokeDynamic() {
            ParserCP.this.traceMethodInfoLn();
            BiFunction<BootstrapMethodData, ConstCell, ConstantPool.ConstValue_InvokeDynamic> ctor = ConstantPool.ConstValue_InvokeDynamic::new;
            return this.visitBsm(ctor);
        }

        @Override
        public ConstantPool.ConstValue_Dynamic visitDynamic() {
            ParserCP.this.traceMethodInfoLn();
            BiFunction<BootstrapMethodData, ConstCell, ConstantPool.ConstValue_Dynamic> ctor = ConstantPool.ConstValue_Dynamic::new;
            return this.visitBsm(ctor);
        }

        private <E extends ConstantPool.ConstValue_BootstrapMethod> E visitBsm(BiFunction<BootstrapMethodData, ConstCell<?>, E> ctor) {
            ConstantPool.ConstValue_BootstrapMethod obj = null;
            try {
                if (ParserCP.this.scanner.token == JasmTokens.Token.INTVAL) {
                    int bsmIndex = ParserCP.this.scanner.intValue;
                    ParserCP.this.scanner.scan();
                    ParserCP.this.scanner.expect(JasmTokens.Token.COLON);
                    if (ParserCP.this.scanner.token != JasmTokens.Token.CPINDEX) {
                        ParserCP.this.environment.traceln("token=" + ParserCP.this.scanner.token, new Object[0]);
                        ParserCP.this.environment.error(ParserCP.this.scanner.pos, "err.token.expected", "<CPINDEX>");
                        throw new SyntaxError();
                    }
                    int cpx = ParserCP.this.scanner.intValue;
                    ParserCP.this.scanner.scan();
                    BootstrapMethodData bsmData = new BootstrapMethodData(bsmIndex);
                    obj = (ConstantPool.ConstValue_BootstrapMethod)ctor.apply(bsmData, ParserCP.this.parser.pool.getCell(cpx));
                } else {
                    ConstCell<ConstValue<?>> MHCell = ParserCP.this.parser.pool.findCell(ParserCP.this.parseConstValue(ClassFileConst.ConstType.CONSTANT_METHODHANDLE));
                    ParserCP.this.scanner.expect(JasmTokens.Token.COLON);
                    ConstCell<ConstValue<?>> NapeCell = ParserCP.this.parser.pool.findCell(ParserCP.this.parseConstValue(ClassFileConst.ConstType.CONSTANT_NAMEANDTYPE));
                    if (ParserCP.this.scanner.token == JasmTokens.Token.LBRACE) {
                        ++ParserCP.this.lbrace;
                        ParserCP.this.scanner.scan();
                    }
                    ArrayList bsm_args = new ArrayList(256);
                    while (true) {
                        if (ParserCP.this.lbrace > 0) {
                            if (ParserCP.this.scanner.token == JasmTokens.Token.RBRACE) {
                                --ParserCP.this.lbrace;
                                ParserCP.this.scanner.scan();
                                break;
                            }
                            if (ParserCP.this.scanner.token == JasmTokens.Token.SEMICOLON) {
                                ParserCP.this.scanner.expect(JasmTokens.Token.RBRACE);
                            }
                        } else if (ParserCP.this.scanner.token == JasmTokens.Token.SEMICOLON) break;
                        if (ParserCP.this.scanner.token == JasmTokens.Token.COMMA) {
                            ParserCP.this.scanner.scan();
                        }
                        bsm_args.add(ParserCP.this.parseConstRef(null));
                    }
                    if (ParserCP.this.lbrace == 0) {
                        ParserCP.this.scanner.check(JasmTokens.Token.SEMICOLON);
                    }
                    BootstrapMethodData bsmData = new BootstrapMethodData(MHCell, bsm_args);
                    ParserCP.this.parser.classData.addBootstrapMethod(bsmData);
                    obj = (ConstantPool.ConstValue_BootstrapMethod)ctor.apply(bsmData, NapeCell);
                }
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return (E)obj;
        }
    }
}

