/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.common.structure.EModifier;
import org.openjdk.asmtools.jasm.AnnotationData;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.FieldData;
import org.openjdk.asmtools.jasm.MemberData;
import org.openjdk.asmtools.jasm.Parser;

public class RecordData
extends AttrData {
    private ClassData classData;
    private List<ComponentData> components = new ArrayList<ComponentData>();

    public RecordData(ClassData classData) {
        super(classData.pool, EAttribute.ATT_Record);
        this.classData = classData;
    }

    public void addComponent(ConstCell nameCell, ConstCell descCell, ConstCell signature, ArrayList<AnnotationData> annotations) {
        FieldData fd = this.classData.addFieldIfAbsent(EModifier.getFlags(EModifier.ACC_MANDATED, EModifier.ACC_PRIVATE, EModifier.ACC_FINAL), nameCell, descCell);
        ComponentData cd = new ComponentData(this.classData, fd);
        if (annotations != null) {
            cd.addAnnotations(annotations);
        }
        if (signature != null) {
            cd.setSignatureAttr(signature);
        }
        this.components.add(cd);
    }

    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        super.write(out);
        out.writeShort(this.components.size());
        for (ComponentData cd : this.components) {
            cd.write(out);
        }
    }

    @Override
    public int attrLength() {
        int compsLength = this.components.stream().mapToInt(c -> c.getLength()).sum();
        return 2 + compsLength;
    }

    class ComponentData
    extends MemberData {
        private ClassData classData;
        private FieldData field;

        public ComponentData(ClassData classData, FieldData field) {
            super(classData.pool, classData.getEnvironment());
            this.classData = classData;
            this.field = field;
        }

        protected DataVector getAttrVector() {
            return this.classData.getDataVector(new AttrData[]{this.signatureAttr});
        }

        public void write(CheckedDataOutputStream out) throws IOException, Parser.CompilerError {
            out.writeShort(((ConstCell)((Pair)this.field.getNameDesc().value).first).cpIndex);
            out.writeShort(((ConstCell)((Pair)this.field.getNameDesc().value).second).cpIndex);
            DataVector attrs = this.getAttrVector();
            attrs.write(out);
        }

        public int getLength() {
            return 4 + this.getAttrVector().getLength();
        }
    }
}

