/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.Objects;
import org.openjdk.asmtools.common.CompilerLogger;
import org.openjdk.asmtools.common.structure.StackMap;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.DataWriter;
import org.openjdk.asmtools.jasm.Indexer;
import org.openjdk.asmtools.jasm.JasmEnvironment;

public class StackMapData
implements DataWriter {
    boolean hasStackMapTable = false;
    DataVector<? extends Indexer> localsMap;
    DataVector<? extends Indexer> stackMap;
    JasmEnvironment environment;
    private int pc;
    private int scannerPosition = 0;
    private int offset;
    private int frameTypeTag;
    private String stackFrameType = null;

    StackMapData(JasmEnvironment environment) {
        this.environment = environment;
    }

    StackMapData setOffset(StackMapData prevFrame) {
        this.offset = prevFrame == null ? this.pc : this.pc - prevFrame.pc - 1;
        return this;
    }

    StackMapData setStackFrameType(String stackFrameType) {
        Objects.requireNonNull(stackFrameType, () -> ((CompilerLogger)this.environment.getLogger()).getResourceString("err.obj.is.null", "String stackFrameType"));
        this.stackFrameType = stackFrameType;
        this.frameTypeTag = StackMap.getFrameTypeTag(stackFrameType);
        if (!StackMap.isValidFrameType(this.frameTypeTag)) {
            this.environment.error(this.scannerPosition, "err.invalid.stack.frame.type", stackFrameType);
        }
        return this;
    }

    StackMapData setIsStackMapTable(boolean hasStackMapTable) {
        this.hasStackMapTable = hasStackMapTable;
        return this;
    }

    StackMapData setPC(int pc) {
        this.pc = pc;
        return this;
    }

    StackMapData setScannerPosition(int scannerPosition) {
        this.scannerPosition = scannerPosition;
        return this;
    }

    boolean isSet() {
        return this.stackFrameType != null;
    }

    @Override
    public int getLength() {
        int length = 0;
        StackMap.FrameType frameType = StackMap.FrameType.FULL_FRAME;
        if (this.hasStackMapTable) {
            if (this.stackFrameType != null) {
                frameType = StackMap.stackMapFrameType(this.frameTypeTag);
            }
            ++length;
        }
        switch (frameType) {
            case SAME_FRAME: {
                break;
            }
            case SAME_LOCALS_1_STACK_ITEM_FRAME: {
                length += this.stackMap.getLength() - 2;
                break;
            }
            case SAME_LOCALS_1_STACK_ITEM_EXTENDED_FRAME: {
                length += this.stackMap.getLength();
                break;
            }
            case CHOP_1_FRAME: 
            case CHOP_2_FRAME: 
            case CHOP_3_FRAME: 
            case SAME_FRAME_EX: {
                length += 2;
                break;
            }
            case APPEND_FRAME: {
                length += 2 + (this.localsMap == null ? 0 : this.localsMap.getLength() - 2);
                break;
            }
            case FULL_FRAME: {
                length += 2;
                length += this.localsMap == null ? 2 : this.localsMap.getLength();
                length += this.stackMap == null ? 2 : this.stackMap.getLength();
                break;
            }
        }
        return length;
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        StackMap.FrameType frameType = StackMap.FrameType.FULL_FRAME;
        if (this.hasStackMapTable && this.stackFrameType != null) {
            frameType = StackMap.stackMapFrameType(this.frameTypeTag);
        }
        switch (frameType) {
            case SAME_FRAME: {
                if (!StackMap.FrameType.SAME_FRAME.inRange(this.offset)) {
                    this.environment.error(this.scannerPosition, "err.invalid.offset.frame.type", this.offset, frameType.printName());
                    break;
                }
                out.writeByte(this.offset);
                break;
            }
            case SAME_LOCALS_1_STACK_ITEM_FRAME: {
                if (this.stackMap == null) {
                    this.environment.error(this.scannerPosition, "err.no.stack.map", frameType.printName());
                    break;
                }
                if (this.stackMap.elements.size() != 1) {
                    this.environment.error(this.scannerPosition, "err.should.be.only.one.stack.map.element", frameType.printName());
                    break;
                }
                if (this.offset >= 64) {
                    this.environment.error(this.scannerPosition, "err.invalid.offset.frame.type", this.offset, frameType.printName());
                }
                out.writeByte(frameType.fromTag() + this.offset);
                this.stackMap.writeElements(out);
                break;
            }
            case SAME_LOCALS_1_STACK_ITEM_EXTENDED_FRAME: {
                if (this.stackMap == null) {
                    this.environment.error(this.scannerPosition, "err.no.locals.map", frameType.printName());
                    break;
                }
                if (this.stackMap.elements.size() != 1) {
                    this.environment.error(this.scannerPosition, "err.should.be.only.one.stack.map.element", frameType.printName());
                    break;
                }
                out.writeByte(frameType.fromTag());
                out.writeShort(this.offset);
                this.stackMap.writeElements(out);
                break;
            }
            case CHOP_1_FRAME: 
            case CHOP_2_FRAME: 
            case CHOP_3_FRAME: 
            case SAME_FRAME_EX: {
                boolean error = false;
                if (this.stackMap != null) {
                    this.environment.error(this.scannerPosition, "err.unexpected.stack.maps", frameType.printName());
                    error = true;
                }
                if (this.localsMap != null) {
                    this.environment.error(this.scannerPosition, "err.unexpected.locals.maps", frameType.printName());
                    error = true;
                }
                if (error) break;
                out.writeByte(frameType.fromTag());
                out.writeShort(this.offset);
                break;
            }
            case APPEND_FRAME: {
                if (this.localsMap == null) {
                    this.environment.error(this.scannerPosition, "err.no.locals.map", frameType.printName());
                    break;
                }
                if (this.localsMap.elements.size() > 3) {
                    this.environment.error(this.scannerPosition, "err.more.locals.map.elements", new Object[0]);
                    break;
                }
                out.writeByte(frameType.fromTag() + this.localsMap.elements.size() - 1);
                out.writeShort(this.offset);
                this.localsMap.writeElements(out);
                break;
            }
            case FULL_FRAME: {
                if (this.hasStackMapTable) {
                    out.writeByte(frameType.fromTag());
                    out.writeShort(this.offset);
                } else {
                    out.writeShort(this.pc);
                }
                if (this.localsMap == null) {
                    out.writeShort(0);
                } else {
                    this.localsMap.write(out);
                }
                if (this.stackMap == null) {
                    out.writeShort(0);
                    break;
                }
                this.stackMap.write(out);
                break;
            }
            default: {
                this.environment.error(this.scannerPosition, "invalid.stack.frame.verificationType", frameType.tagName());
            }
        }
    }

    public static class StackMapItemTaggedPointer
    implements DataWriter {
        StackMap.VerificationType itemVerificationType;
        Indexer arg;

        StackMapItemTaggedPointer(StackMap.VerificationType itemVerificationType, Indexer arg) {
            this.itemVerificationType = itemVerificationType;
            this.arg = arg;
        }

        @Override
        public int getLength() {
            return 3;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(this.itemVerificationType.tag());
            out.writeShort(this.arg.cpIndex);
        }
    }

    public static class StackMapItemTagged
    implements DataWriter {
        StackMap.VerificationType itemVerificationType;

        StackMapItemTagged(StackMap.VerificationType itemVerificationType) {
            this.itemVerificationType = itemVerificationType;
        }

        @Override
        public int getLength() {
            return 1;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(this.itemVerificationType.tag());
        }
    }
}

