/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.Indexer;
import org.openjdk.asmtools.jasm.JasmEnvironment;

class SwitchTable {
    Indexer defLabel = null;
    ArrayList<Indexer> labels = new ArrayList();
    ArrayList<Integer> keys = new ArrayList();
    Indexer[] resLabels;
    int high;
    int low;
    int pc;
    int pad;
    JasmEnvironment environment;

    SwitchTable(JasmEnvironment environment) {
        this.environment = environment;
    }

    void addEntry(int key, Indexer label) {
        this.keys.add(key);
        this.labels.add(label);
    }

    int calcLookupSwitch(int pc) {
        this.pc = pc;
        this.pad = 3 - pc & 3;
        int len = 1 + this.pad + (this.keys.size() + 1) * 8;
        if (this.defLabel == null) {
            this.defLabel = new Indexer(pc + len);
        }
        return len;
    }

    void writeLookupSwitch(CheckedDataOutputStream out) throws IOException {
        int k;
        this.environment.traceln("  writeLookupSwitch: pc=" + this.pc + " pad=" + this.pad + " deflabel=" + this.defLabel.cpIndex, new Object[0]);
        for (k = 0; k < this.pad; ++k) {
            out.writeByte(0);
        }
        out.writeInt(this.defLabel.cpIndex - this.pc);
        out.writeInt(this.keys.size());
        for (k = 0; k < this.keys.size(); ++k) {
            out.writeInt(this.keys.get(k));
            out.writeInt(this.labels.get((int)k).cpIndex - this.pc);
        }
    }

    int recalcTableSwitch(int pc) {
        int k;
        int numpairs = this.keys.size();
        int high1 = Integer.MIN_VALUE;
        int low1 = Integer.MAX_VALUE;
        int numslots = 0;
        if (numpairs > 0) {
            for (k = 0; k < numpairs; ++k) {
                int key = this.keys.get(k);
                if (key > high1) {
                    high1 = key;
                }
                if (key >= low1) continue;
                low1 = key;
            }
            numslots = high1 - low1 + 1;
        }
        this.environment.traceln("  recalcTableSwitch: low=" + low1 + " high=" + high1, new Object[0]);
        this.pc = pc;
        this.pad = 3 - pc & 3;
        int len = 1 + this.pad + (numslots + 3) * 4;
        if (this.defLabel == null) {
            this.defLabel = new Indexer(pc + len);
        }
        Indexer[] resLabels1 = new Indexer[numslots];
        for (k = 0; k < numslots; ++k) {
            resLabels1[k] = this.defLabel;
        }
        for (k = 0; k < numpairs; ++k) {
            this.environment.traceln("   keys.data[" + k + "]=" + this.keys.get(k), new Object[0]);
            resLabels1[this.keys.get((int)k).intValue() - low1] = this.labels.get(k);
        }
        this.resLabels = resLabels1;
        this.labels = null;
        this.keys = null;
        this.high = high1;
        this.low = low1;
        return len;
    }

    void writeTableSwitch(CheckedDataOutputStream out) throws IOException {
        int k;
        for (k = 0; k < this.pad; ++k) {
            out.writeByte(0);
        }
        out.writeInt(this.defLabel.cpIndex - this.pc);
        out.writeInt(this.low);
        out.writeInt(this.high);
        for (k = 0; k < this.resLabels.length; ++k) {
            out.writeInt(this.resLabels[k].cpIndex - this.pc);
        }
    }
}

