/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

public class TypeAnnotationTypes {
    public static EPathKind getPathKind(int i) {
        return EPathKind.values()[i];
    }

    public static enum EPathKind {
        ARRAY(0),
        INNER_TYPE(1),
        WILDCARD(2),
        TYPE_ARGUMENT(3);

        private final int tag;
        public static final int maxLen = 3;

        private EPathKind(int tag) {
            this.tag = tag;
        }

        public int tag() {
            return this.tag;
        }

        public String parseKey() {
            return this.toString();
        }

        static EPathKind getPathKind(String token) {
            for (EPathKind pk : EPathKind.values()) {
                if (!pk.parseKey().equals(token)) continue;
                return pk;
            }
            return null;
        }
    }

    public static class TypeAnnotationTargetVisitor {
        public final void visit(ETargetType tt) {
            switch (tt) {
                case class_type_param: 
                case meth_type_param: {
                    this.visit_type_param_target(tt);
                    break;
                }
                case class_exts_impls: {
                    this.visit_supertype_target(tt);
                    break;
                }
                case class_type_param_bnds: 
                case meth_type_param_bnds: {
                    this.visit_typeparam_bound_target(tt);
                    break;
                }
                case field: 
                case meth_ret_type: 
                case meth_receiver: {
                    this.visit_empty_target(tt);
                    break;
                }
                case meth_formal_param: {
                    this.visit_methodformalparam_target(tt);
                    break;
                }
                case throws_type: {
                    this.visit_throws_target(tt);
                    break;
                }
                case local_var: 
                case resource_var: {
                    this.visit_localvar_target(tt);
                    break;
                }
                case exception_param: {
                    this.visit_catch_target(tt);
                    break;
                }
                case type_test: 
                case obj_creat: 
                case constr_ref_receiver: 
                case meth_ref_receiver: {
                    this.visit_offset_target(tt);
                    break;
                }
                case cast: 
                case constr_invoc_typearg: 
                case meth_invoc_typearg: 
                case constr_ref_typearg: 
                case meth_ref_typearg: {
                    this.visit_typearg_target(tt);
                }
            }
        }

        public void visit_type_param_target(ETargetType tt) {
        }

        public void visit_supertype_target(ETargetType tt) {
        }

        public void visit_typeparam_bound_target(ETargetType tt) {
        }

        public void visit_empty_target(ETargetType tt) {
        }

        public void visit_methodformalparam_target(ETargetType tt) {
        }

        public void visit_throws_target(ETargetType tt) {
        }

        public void visit_localvar_target(ETargetType tt) {
        }

        public void visit_catch_target(ETargetType tt) {
        }

        public void visit_offset_target(ETargetType tt) {
        }

        public void visit_typearg_target(ETargetType tt) {
        }
    }

    public static enum ETargetType {
        class_type_param(0, "CLASS_TYPE_PARAMETER", ETargetInfo.TYPEPARAM, "class/interface type parameter"),
        meth_type_param(1, "METHOD_TYPE_PARAMETER", ETargetInfo.TYPEPARAM, "method/constructor type parameter"),
        class_exts_impls(16, "CLASS_EXTENDS", ETargetInfo.SUPERTYPE, "class extends/implements"),
        class_type_param_bnds(17, "CLASS_TYPE_PARAMETER_BOUND", ETargetInfo.TYPEPARAM_BOUND, "class/interface type parameter bounds"),
        meth_type_param_bnds(18, "METHOD_TYPE_PARAMETER_BOUND", ETargetInfo.TYPEPARAM_BOUND, "method/constructor type parameter bounds"),
        field(19, "FIELD", ETargetInfo.EMPTY, "field"),
        meth_ret_type(20, "METHOD_RETURN", ETargetInfo.EMPTY, "method return type"),
        meth_receiver(21, "METHOD_RECEIVER", ETargetInfo.EMPTY, "method receiver"),
        meth_formal_param(22, "METHOD_FORMAL_PARAMETER", ETargetInfo.METHODPARAM, "method formal parameter type"),
        throws_type(23, "THROWS", ETargetInfo.EXCEPTION, "exception type in throws"),
        local_var(64, "LOCAL_VARIABLE", ETargetInfo.LOCALVAR, "local variable"),
        resource_var(65, "RESOURCE_VARIABLE", ETargetInfo.LOCALVAR, "resource variable"),
        exception_param(66, "EXCEPTION_PARAM", ETargetInfo.CATCH, "exception parameter"),
        type_test(67, "INSTANCEOF", ETargetInfo.OFFSET, "type test (instanceof)"),
        obj_creat(68, "NEW", ETargetInfo.OFFSET, "object creation (new)"),
        constr_ref_receiver(69, "CONSTRUCTOR_REFERENCE_RECEIVER", ETargetInfo.OFFSET, "constructor reference receiver"),
        meth_ref_receiver(70, "METHOD_REFERENCE_RECEIVER", ETargetInfo.OFFSET, "method reference receiver"),
        cast(71, "CAST", ETargetInfo.TYPEARG, "cast"),
        constr_invoc_typearg(72, "CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT", ETargetInfo.TYPEARG, "type argument in constructor call"),
        meth_invoc_typearg(73, "METHOD_INVOCATION_TYPE_ARGUMENT", ETargetInfo.TYPEARG, "type argument in method call"),
        constr_ref_typearg(74, "CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT", ETargetInfo.TYPEARG, "type argument in constructor reference"),
        meth_ref_typearg(75, "METHOD_REFERENCE_TYPE_ARGUMENT", ETargetInfo.TYPEARG, "type argument in method reference");

        public static final int maxTag = 154;
        public static final int maxLen = 36;
        public final int value;
        private final String parseKey;
        private final ETargetInfo targetInfo;
        private final String printVal;

        private ETargetType(int val, String parse, ETargetInfo targetInfo, String printVal) {
            this.value = val;
            this.parseKey = parse;
            this.targetInfo = targetInfo;
            this.printVal = printVal;
        }

        public String parseKey() {
            return this.parseKey;
        }

        public ETargetInfo targetInfo() {
            return this.targetInfo;
        }

        public String _toPrintString() {
            return this.parseKey;
        }

        public String toString() {
            return String.format("%s[%#x]", this.parseKey, this.value);
        }

        public static ETargetType getTargetType(int typeCode) {
            for (ETargetType type : ETargetType.values()) {
                if (type.value != typeCode) continue;
                return type;
            }
            return null;
        }

        public static ETargetType getTargetType(String typeName) {
            for (ETargetType type : ETargetType.values()) {
                if (!type.parseKey.equals(typeName)) continue;
                return type;
            }
            return null;
        }
    }

    public static enum ETargetInfo {
        TYPEPARAM("TYPEPARAM", "type_parameter"),
        SUPERTYPE("SUPERTYPE", "supertype"),
        TYPEPARAM_BOUND("TYPEPARAM_BOUND", "type_parameter_bound"),
        EMPTY("EMPTY", "empty"),
        METHODPARAM("METHODPARAM", "formal_parameter"),
        EXCEPTION("EXCEPTION", "throws"),
        LOCALVAR("LOCALVAR", "localvar"),
        CATCH("CATCH", "catch"),
        OFFSET("OFFSET", "offset"),
        TYPEARG("TYPEARG", "type_argument");

        private final String parseKey;
        private final String printValue;

        private ETargetInfo(String parse, String printValue) {
            this.parseKey = parse;
            this.printValue = printValue;
        }

        public String parseKey() {
            return this.parseKey;
        }

        public String printValue() {
            return this.printValue;
        }
    }

    public static class TypePathEntry {
        private final EPathKind kind;
        private final int typeArgumentIndex;

        public TypePathEntry(int kind, int typeArgumentIndex) {
            this.kind = TypeAnnotationTypes.getPathKind(kind);
            this.typeArgumentIndex = typeArgumentIndex;
        }

        public TypePathEntry(EPathKind kind, int typeArgumentIndex) {
            this.kind = kind;
            this.typeArgumentIndex = typeArgumentIndex;
        }

        public int getTypePathKind() {
            return this.kind.tag();
        }

        public int getTypeArgumentIndex() {
            return this.typeArgumentIndex;
        }

        public String toString() {
            return this.kind.parseKey() + (String)(this.kind.tag == 3 ? "{" + this.typeArgumentIndex + "}" : "");
        }
    }
}

