/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jcoder;

import java.io.PrintWriter;
import java.util.HashMap;
import org.openjdk.asmtools.common.structure.StackMap;

public class JcodTokens {
    protected static final int MaxTokens = 172;
    private static HashMap<Integer, Token> TagToTokens = new HashMap(172);
    private static HashMap<String, Token> SymbolToTokens = new HashMap(172);
    private static HashMap<String, Token> ParsekeyToTokens = new HashMap(172);
    protected static final int MaxKeywords = 40;
    private static HashMap<Integer, Token> TagToKeywords = new HashMap(40);
    private static HashMap<String, Token> SymbolToKeywords = new HashMap(40);
    private static HashMap<String, Token> ParsekeyToKeywords = new HashMap(40);
    private static HashMap<String, ConstType> NameToConstantType;
    private static HashMap<Integer, ConstType> ConstantTypes;

    private static void registerToken(Token tk) {
        if (tk.key_type == KeywordType.KEYWORD) {
            TagToKeywords.put(tk.value, tk);
            SymbolToKeywords.put(tk.printval, tk);
            if (tk.parsekey != null) {
                ParsekeyToKeywords.put(tk.parsekey, tk);
            }
        }
        TagToTokens.put(tk.value, tk);
        SymbolToTokens.put(tk.printval, tk);
        ParsekeyToTokens.put(tk.printval, tk);
    }

    public static Token token(int tk) {
        return TagToTokens.get(tk);
    }

    public static Token keyword_token(int tk) {
        return TagToKeywords.get(tk);
    }

    public static Token token(String parsekey) {
        return ParsekeyToTokens.get(parsekey);
    }

    public static Token keyword_token(String parsekey) {
        return ParsekeyToKeywords.get(parsekey);
    }

    public static Token token_ID(String ID) {
        return ParsekeyToTokens.get(ID);
    }

    public static Token keyword_token_ID(String ID) {
        return ParsekeyToKeywords.get(ID);
    }

    public static String keywordName(int token) {
        String retval = "";
        if (token > TagToTokens.size()) {
            retval = null;
        } else {
            Token tk = JcodTokens.keyword_token(token);
            if (tk != null) {
                retval = tk.parsekey;
            }
        }
        return retval;
    }

    public static Token keyword_token_ident(String idValue) {
        Token kwd = JcodTokens.keyword_token(idValue);
        if (kwd == null) {
            kwd = Token.IDENT;
        }
        return kwd;
    }

    public static int keyword_token_int(String idValue) {
        return JcodTokens.keyword_token_ident(idValue).value();
    }

    public static ConstType constType(int i) {
        return ConstantTypes.get(i);
    }

    public static ConstType constType(String parsekey) {
        return NameToConstantType.get(parsekey);
    }

    private static void registerConstantType(ConstType tt) {
        NameToConstantType.put(tt.parseKey, tt);
        if (tt.alias != null) {
            NameToConstantType.put(tt.alias, tt);
        }
        ConstantTypes.put(tt.value, tt);
    }

    public static int constValue(String stringValue) {
        ConstType constType = JcodTokens.constType(stringValue);
        return constType != null ? constType.value() : StackMap.VerificationType.getByParseKey(stringValue).tag().intValue();
    }

    static {
        for (Token token : Token.values()) {
            JcodTokens.registerToken(token);
        }
        SymbolToKeywords.put(Token.INTVAL.printval(), Token.INTVAL);
        ParsekeyToKeywords.put(Token.INTVAL.parsekey(), Token.INTVAL);
        SymbolToKeywords.put(Token.STRINGVAL.printval(), Token.STRINGVAL);
        ParsekeyToKeywords.put(Token.STRINGVAL.parsekey(), Token.STRINGVAL);
        NameToConstantType = new HashMap(20);
        ConstantTypes = new HashMap(20);
        for (Enum enum_ : ConstType.values()) {
            JcodTokens.registerConstantType((ConstType)enum_);
        }
    }

    public static enum Token {
        EOF(-1, "EOF", "EOF", TokenType.MISC),
        IDENT(60, "IDENT", "IDENT", TokenType.VALUE),
        LONGSTRINGVAL(61, "LONGSTRINGVAL", "LONGSTRING", TokenType.VALUE),
        INTVAL(65, "INTVAL", "INT", TokenType.VALUE),
        LONGVAL(66, "LONGVAL", "LONG", TokenType.VALUE),
        STRINGVAL(69, "STRINGVAL", "STRING", TokenType.VALUE),
        CLASS(70, "CLASS", "class", TokenType.KEYWORDS, KeywordType.KEYWORD),
        INTERFACE(71, "INTERFACE", "interface", TokenType.KEYWORDS, KeywordType.KEYWORD),
        DIV(72, "DIV", "div", TokenType.KEYWORDS),
        EQ(73, "EQ", "eq", TokenType.KEYWORDS),
        ASSIGN(74, "ASSIGN", "assign", TokenType.KEYWORDS),
        MODULE(75, "MODULE", "module", TokenType.KEYWORDS, KeywordType.KEYWORD),
        COLON(134, "COLON", ":", TokenType.PUNCTUATION),
        SEMICOLON(135, "SEMICOLON", ";", TokenType.PUNCTUATION, KeywordType.KEYWORD),
        COMMA(0, "COMMA", ",", TokenType.PUNCTUATION, KeywordType.KEYWORD),
        LBRACE(138, "LBRACE", "{", TokenType.PUNCTUATION, KeywordType.KEYWORD),
        RBRACE(139, "RBRACE", "}", TokenType.PUNCTUATION, KeywordType.KEYWORD),
        LPAREN(140, "LPAREN", "(", TokenType.PUNCTUATION, KeywordType.KEYWORD),
        RPAREN(141, "RPAREN", ")", TokenType.PUNCTUATION, KeywordType.KEYWORD),
        LSQBRACKET(142, "LSQBRACKET", "[", TokenType.PUNCTUATION, KeywordType.KEYWORD),
        RSQBRACKET(143, "RSQBRACKET", "]", TokenType.PUNCTUATION, KeywordType.KEYWORD),
        BYTEINDEX(156, "BYTEINDEX", "b", TokenType.JDEC, KeywordType.KEYWORD),
        SHORTINDEX(157, "SHORTINDEX", "s", TokenType.JDEC, KeywordType.KEYWORD),
        ATTR(158, "ATTR", "Attr", TokenType.JDEC, KeywordType.KEYWORD),
        BYTES(159, "BYTES", "Bytes", TokenType.JDEC, KeywordType.KEYWORD),
        MACRO(160, "MACRO", "Attr", TokenType.JDEC),
        COMP(161, "COMP", "Component", TokenType.JDEC, KeywordType.KEYWORD),
        FILE(162, "FILE", "file", TokenType.JDEC, KeywordType.KEYWORD),
        ZEROINDEX(163, "ZEROINDEX", "z", TokenType.STACKMAP, KeywordType.KEYWORD);

        private Integer value;
        private String printval;
        private String parsekey;
        private TokenType tk_type;
        private KeywordType key_type;

        private Token(Integer val, String print, String op) {
            this.init(val, print, op, TokenType.VALUE, KeywordType.TOKEN);
        }

        private Token(Integer val, String print, String op, TokenType tt) {
            this.init(val, print, op, tt, KeywordType.TOKEN);
        }

        private Token(Integer val, String print, String op, TokenType tt, KeywordType kt) {
            this.init(val, print, op, tt, kt);
        }

        private void init(Integer val, String print, String op, TokenType tt, KeywordType kt) {
            this.value = val;
            this.printval = print;
            this.parsekey = op;
            this.tk_type = tt;
            this.key_type = kt;
        }

        public String printval() {
            return this.printval;
        }

        public String parsekey() {
            return this.parsekey;
        }

        public int value() {
            return this.value;
        }

        public String toString() {
            return "<" + this.printval + "> [" + this.value + "]";
        }
    }

    public static enum KeywordType {
        TOKEN(0, "TOKEN"),
        KEYWORD(3, "KEYWORD");

        private final Integer value;
        private final String printval;

        private KeywordType(Integer val, String print) {
            this.value = val;
            this.printval = print;
        }

        public String printval() {
            return this.printval;
        }
    }

    public static enum ConstType {
        CONSTANT_UTF8(1, "CONSTANT_UTF8", "Asciz", "Utf8"),
        CONSTANT_UNICODE(2, "CONSTANT_UNICODE", ""),
        CONSTANT_INTEGER(3, "CONSTANT_INTEGER", "int", "u4"),
        CONSTANT_FLOAT(4, "CONSTANT_FLOAT", "float"),
        CONSTANT_LONG(5, "CONSTANT_LONG", "long"),
        CONSTANT_DOUBLE(6, "CONSTANT_DOUBLE", "double"),
        CONSTANT_CLASS(7, "CONSTANT_CLASS", "class"),
        CONSTANT_STRING(8, "CONSTANT_STRING", "String"),
        CONSTANT_FIELD(9, "CONSTANT_FIELD", "Field"),
        CONSTANT_METHOD(10, "CONSTANT_METHOD", "Method"),
        CONSTANT_INTERFACEMETHOD(11, "CONSTANT_INTERFACEMETHOD", "InterfaceMethod"),
        CONSTANT_NAMEANDTYPE(12, "CONSTANT_NAMEANDTYPE", "NameAndType"),
        CONSTANT_JAVACARD_PACKAGE(13, "CONSTANT_PACKAGE", "package"),
        CONSTANT_METHODHANDLE(15, "CONSTANT_METHODHANDLE", "MethodHandle"),
        CONSTANT_METHODTYPE(16, "CONSTANT_METHODTYPE", "MethodType"),
        CONSTANT_DYNAMIC(17, "CONSTANT_DYNAMIC", "Dynamic"),
        CONSTANT_INVOKEDYNAMIC(18, "CONSTANT_INVOKEDYNAMIC", "InvokeDynamic"),
        CONSTANT_MODULE(19, "CONSTANT_MODULE", "Module"),
        CONSTANT_MODULE_PACKAGE(20, "CONSTANT_PACKAGE", "Package");

        public static final int maxTag = 20;
        private final int value;
        private final String parseKey;
        private final String printVal;
        private final String alias;

        private ConstType(int val, String print, String parse) {
            this.value = val;
            this.parseKey = parse;
            this.printVal = print;
            this.alias = null;
        }

        private ConstType(int val, String print, String parse, String als) {
            this.value = val;
            this.parseKey = parse;
            this.printVal = print;
            this.alias = als;
        }

        public int value() {
            return this.value;
        }

        public String parseKey() {
            return this.parseKey;
        }

        public String printval() {
            return this.printVal;
        }

        public void print(PrintWriter out) {
            out.print(this.parseKey);
        }

        public String toString() {
            return "<" + this.printVal + "> [" + this.value + "]";
        }
    }

    public static enum TokenType {
        VALUE(0, "Value"),
        KEYWORDS(1, "Keywords"),
        PUNCTUATION(2, "Punctuation"),
        JDEC(3, "JDec"),
        STACKMAP(4, "StackMap"),
        MISC(5, "Misc");

        private final Integer value;
        private final String printVal;

        private TokenType(Integer val, String printVal) {
            this.value = val;
            this.printVal = printVal;
        }

        public String printVal() {
            return this.printVal;
        }
    }
}

