/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jcoder;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.Stack;
import org.openjdk.asmtools.common.SyntaxError;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jcoder.ByteBuffer;
import org.openjdk.asmtools.jcoder.JcodTokens;
import org.openjdk.asmtools.jcoder.JcoderEnvironment;
import org.openjdk.asmtools.jcoder.Scanner;

class Jcoder {
    protected JcoderEnvironment environment;
    protected Scanner scanner;
    private final ArrayList<ByteBuffer> Classes = new ArrayList();
    private ByteBuffer buf;
    private DataOutputStream bufstream;
    private int depth = 0;
    private String tabStr = "";
    private final Context context;

    Jcoder(JcoderEnvironment environment, HashMap<String, String> macros) throws IOException {
        this.scanner = new Scanner(environment, macros);
        this.environment = environment;
        this.context = new Context();
    }

    private void expect(JcodTokens.Token t) throws SyntaxError, IOException {
        if (this.scanner.token != t) {
            this.environment.traceln("expect:" + t + " instead of " + this.scanner.token, new Object[0]);
            if (t == JcodTokens.Token.IDENT) {
                this.environment.error(this.scanner.pos, "err.identifier.expected", new Object[0]);
            } else {
                this.environment.error(this.scanner.pos, "err.token.expected", t.toString());
            }
            throw new SyntaxError();
        }
        this.scanner.scan();
    }

    private void recoverField() throws SyntaxError, IOException {
        block6: while (true) {
            switch (this.scanner.token) {
                case LBRACE: {
                    this.scanner.match(JcodTokens.Token.LBRACE, JcodTokens.Token.RBRACE);
                    this.scanner.scan();
                    continue block6;
                }
                case LPAREN: {
                    this.scanner.match(JcodTokens.Token.LPAREN, JcodTokens.Token.RPAREN);
                    this.scanner.scan();
                    continue block6;
                }
                case LSQBRACKET: {
                    this.scanner.match(JcodTokens.Token.LSQBRACKET, JcodTokens.Token.RSQBRACKET);
                    this.scanner.scan();
                    continue block6;
                }
                case RBRACE: 
                case EOF: 
                case INTERFACE: 
                case CLASS: {
                    throw new SyntaxError();
                }
            }
            this.scanner.scan();
        }
    }

    private void parseArray() throws IOException {
        int num_expected;
        this.scanner.scan();
        int length0 = this.buf.length;
        int pos0 = this.scanner.pos;
        if (this.scanner.token == JcodTokens.Token.INTVAL) {
            num_expected = this.scanner.intValue;
            this.scanner.scan();
        } else {
            num_expected = -1;
        }
        this.expect(JcodTokens.Token.RSQBRACKET);
        int numSize = switch (this.scanner.token) {
            case JcodTokens.Token.BYTEINDEX -> {
                this.scanner.scan();
                yield 1;
            }
            case JcodTokens.Token.SHORTINDEX -> {
                this.scanner.scan();
                yield 2;
            }
            case JcodTokens.Token.ZEROINDEX -> {
                this.scanner.scan();
                yield 0;
            }
            default -> 2;
        };
        this.buf.append(num_expected, numSize);
        int num_present = this.parseStruct();
        if (num_expected == -1) {
            this.environment.trace(" buf.writeAt(" + length0 + ", " + num_present + ", " + numSize + ");  ", new Object[0]);
            if (numSize > 0) {
                this.buf.writeAt(length0, num_present, numSize);
            }
        } else if (num_expected != num_present) {
            if (this.context.isConstantPool() && num_expected == num_present + 1) {
                return;
            }
            this.environment.warning(pos0, "warn.array.wronglength", num_expected, num_present);
        }
    }

    private void parseByteArray() throws IOException {
        int len_expected;
        this.scanner.scan();
        this.expect(JcodTokens.Token.LSQBRACKET);
        int length0 = this.buf.length;
        int pos0 = this.scanner.pos;
        if (this.scanner.token == JcodTokens.Token.INTVAL) {
            len_expected = this.scanner.intValue;
            this.scanner.scan();
        } else {
            len_expected = -1;
        }
        this.expect(JcodTokens.Token.RSQBRACKET);
        int lenSize = switch (this.scanner.token) {
            case JcodTokens.Token.BYTEINDEX -> {
                this.scanner.scan();
                yield 1;
            }
            case JcodTokens.Token.SHORTINDEX -> {
                this.scanner.scan();
                yield 2;
            }
            case JcodTokens.Token.ZEROINDEX -> {
                this.scanner.scan();
                yield 0;
            }
            default -> 4;
        };
        if (lenSize > 0) {
            this.buf.append(len_expected, lenSize);
        }
        int length1 = this.buf.length;
        this.parseStruct();
        int len_present = this.buf.length - length1;
        if (len_expected == -1) {
            this.environment.trace(" buf.writeAt(" + length0 + ", " + len_present + ", " + lenSize + ");  ", new Object[0]);
            if (lenSize > 0) {
                this.buf.writeAt(length0, len_present, lenSize);
            }
        } else if (len_expected != len_present) {
            this.environment.warning(pos0, "warn.array.wronglength", len_expected, len_present);
        }
    }

    private void parseAttr() throws IOException {
        int len_expected;
        this.scanner.scan();
        this.expect(JcodTokens.Token.LPAREN);
        if (this.scanner.token != JcodTokens.Token.INTVAL) {
            this.environment.error(this.scanner.pos, "err.attrname.expected", new Object[0]);
            throw new SyntaxError();
        }
        int cpx = this.scanner.intValue;
        this.scanner.scan();
        this.buf.append(cpx, 2);
        int pos0 = this.scanner.pos;
        int length0 = this.buf.length;
        if (this.scanner.token == JcodTokens.Token.COMMA) {
            this.scanner.scan();
            len_expected = this.scanner.intValue;
            this.expect(JcodTokens.Token.INTVAL);
        } else {
            len_expected = -1;
        }
        this.buf.append(len_expected, 4);
        this.expect(JcodTokens.Token.RPAREN);
        this.parseStruct();
        int len_present = this.buf.length - (length0 + 4);
        if (len_expected == -1) {
            this.buf.writeAt(length0, len_present, 4);
        } else if (len_expected != len_present) {
            this.environment.warning(pos0, "warn.attr.wronglength", len_expected, len_present);
        }
    }

    private void parseComp() throws IOException {
        int len_expected;
        this.scanner.scan();
        this.expect(JcodTokens.Token.LPAREN);
        int tag = this.scanner.intValue;
        this.expect(JcodTokens.Token.INTVAL);
        this.buf.append(tag, 1);
        int pos0 = this.scanner.pos;
        int length0 = this.buf.length;
        if (this.scanner.token == JcodTokens.Token.COMMA) {
            this.scanner.scan();
            len_expected = this.scanner.intValue;
            this.expect(JcodTokens.Token.INTVAL);
        } else {
            len_expected = -1;
        }
        this.buf.append(len_expected, 2);
        this.expect(JcodTokens.Token.RPAREN);
        this.parseStruct();
        int len_present = this.buf.length - (length0 + 2);
        if (len_expected == -1) {
            this.buf.writeAt(length0, len_present, 2);
        } else if (len_expected != len_present) {
            this.environment.warning(pos0, "warn.attr.wronglength", len_expected, len_present);
        }
    }

    private void adjustDepth(boolean up) {
        if (up) {
            ++this.depth;
            this.context.update();
            this.scanner.setDebugCP(this.context.isConstantPool());
        } else {
            --this.depth;
            this.context.exit();
        }
        int tabAmt = 4;
        int len = this.depth * tabAmt;
        this.tabStr = " ".repeat(Math.max(0, len));
    }

    private int parseStruct() throws IOException {
        int scanedCFV = 0;
        int minor = 0;
        int major = 0;
        this.adjustDepth(true);
        this.environment.traceln(" ", new Object[0]);
        this.environment.traceln(this.tabStr + "MapStruct { <" + this.context + "> ", new Object[0]);
        this.expect(JcodTokens.Token.LBRACE);
        int num = 0;
        int addElem = 0;
        block16: while (true) {
            try {
                switch (this.scanner.token) {
                    case COMMA: {
                        this.scanner.scan();
                        continue block16;
                    }
                    case SEMICOLON: {
                        ++num;
                        addElem = 0;
                        this.scanner.scan();
                        continue block16;
                    }
                    case CLASS: {
                        this.scanner.addConstDebug(JcodTokens.ConstType.CONSTANT_CLASS);
                        this.environment.trace("class ", new Object[0]);
                        this.scanner.longValue = JcodTokens.ConstType.CONSTANT_CLASS.value();
                        this.scanner.intSize = 1;
                    }
                    case INTVAL: {
                        this.environment.trace("int [" + this.scanner.longValue + "] ", new Object[0]);
                        if (this.scanner.longValue == 3405691582L && this.environment.cfv.isSetByParameter()) {
                            ++scanedCFV;
                        } else if (scanedCFV > 0) {
                            if (scanedCFV == 1) {
                                ++scanedCFV;
                                minor = this.scanner.intValue;
                                this.scanner.scan();
                                continue block16;
                            }
                            scanedCFV = 0;
                            major = this.scanner.intValue;
                            this.environment.trace(" Got file version: " + major + ":" + minor, new Object[0]);
                            this.environment.cfv.setFileVersion((short)major, (short)minor);
                            this.buf.append(this.environment.cfv.minor_version(), this.scanner.intSize);
                            this.buf.append(this.environment.cfv.major_version(), this.scanner.intSize);
                            this.scanner.scan();
                            addElem = 1;
                            continue block16;
                        }
                        this.buf.append(this.scanner.longValue, this.scanner.intSize);
                        this.scanner.scan();
                        addElem = 1;
                        continue block16;
                    }
                    case STRINGVAL: {
                        this.parseUTF();
                        ++num;
                        addElem = 0;
                        continue block16;
                    }
                    case LONGSTRINGVAL: {
                        this.scanner.scan();
                        this.environment.traceln(this.tabStr + "LongString [\"" + Arrays.toString(this.scanner.longStringValue.data) + "\"] ", new Object[0]);
                        this.buf.write(this.scanner.longStringValue.data, 0, this.scanner.longStringValue.length);
                        addElem = 1;
                        continue block16;
                    }
                    case LBRACE: {
                        this.parseStruct();
                        addElem = 1;
                        continue block16;
                    }
                    case LSQBRACKET: {
                        this.parseArray();
                        addElem = 1;
                        continue block16;
                    }
                    case BYTES: {
                        this.environment.trace("bytes ", new Object[0]);
                        this.parseByteArray();
                        addElem = 1;
                        continue block16;
                    }
                    case ATTR: {
                        this.environment.trace("attr ", new Object[0]);
                        this.parseAttr();
                        addElem = 1;
                        continue block16;
                    }
                    case COMP: {
                        this.environment.trace("comp ", new Object[0]);
                        this.parseComp();
                        addElem = 1;
                        continue block16;
                    }
                    case RBRACE: {
                        this.scanner.scan();
                        this.environment.traceln(System.lineSeparator() + this.tabStr + "} // MapStruct  <" + this.context + "> ]", new Object[0]);
                        this.adjustDepth(false);
                        return num + addElem;
                    }
                }
                this.environment.traceln("unexp token=" + this.scanner.token, new Object[0]);
                this.environment.traceln("   scanner.stringval = \"" + this.scanner.stringValue + "\"", new Object[0]);
                this.environment.error(this.scanner.pos, "err.element.expected", new Object[0]);
                throw new SyntaxError();
            }
            catch (SyntaxError e) {
                this.recoverField();
                continue;
            }
            break;
        }
    }

    String decodeText(String input, String encoding) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(input.getBytes()), Charset.forName(encoding))).readLine();
    }

    private void parseUTF() throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean prevSemicolonParsed = true;
        block4: while (true) {
            switch (this.scanner.token) {
                case STRINGVAL: {
                    if (!prevSemicolonParsed) {
                        this.environment.error(this.scanner.pos, "err.token.expected", JasmTokens.Token.SEMICOLON.parseKey());
                        throw new SyntaxError();
                    }
                    this.scanner.scan();
                    this.scanner.addConstDebug(JcodTokens.ConstType.CONSTANT_UTF8);
                    this.environment.traceln(this.tabStr + "UTF8 [\"" + this.scanner.stringValue + "\"] ", new Object[0]);
                    sb.append(this.scanner.stringValue);
                    prevSemicolonParsed = false;
                    continue block4;
                }
                case SEMICOLON: {
                    if (prevSemicolonParsed) {
                        this.environment.error(this.scanner.pos, "err.token.expected", JasmTokens.Token.STRINGVAL.parseKey());
                        throw new SyntaxError();
                    }
                    prevSemicolonParsed = true;
                    this.scanner.scan();
                    continue block4;
                }
            }
            break;
        }
        if (!prevSemicolonParsed) {
            this.environment.error(this.scanner.pos, "err.token.expected", JasmTokens.Token.SEMICOLON.parseKey());
            throw new SyntaxError();
        }
        this.bufstream.writeUTF(sb.toString());
    }

    private void recoverFile() throws IOException {
        block6: while (true) {
            switch (this.scanner.token) {
                case EOF: 
                case INTERFACE: 
                case CLASS: {
                    return;
                }
                case LBRACE: {
                    this.scanner.match(JcodTokens.Token.LBRACE, JcodTokens.Token.RBRACE);
                    this.scanner.scan();
                    continue block6;
                }
                case LPAREN: {
                    this.scanner.match(JcodTokens.Token.LPAREN, JcodTokens.Token.RPAREN);
                    this.scanner.scan();
                    continue block6;
                }
                case LSQBRACKET: {
                    this.scanner.match(JcodTokens.Token.LSQBRACKET, JcodTokens.Token.RSQBRACKET);
                    this.scanner.scan();
                    continue block6;
                }
            }
            this.scanner.scan();
        }
    }

    private void parseModule() throws IOException {
        this.scanner.skipTill(123);
        this.buf = new ByteBuffer();
        this.bufstream = new DataOutputStream(this.buf);
        this.buf.myname = "module-info.class";
        this.scanner.scan();
        this.environment.traceln("starting " + this.buf.myname, new Object[0]);
        this.parseClause();
        this.environment.traceln("ending " + this.buf.myname, new Object[0]);
    }

    private void parseClass(JcodTokens.Token prev) throws IOException {
        this.scanner.scan();
        this.buf = new ByteBuffer();
        this.bufstream = new DataOutputStream(this.buf);
        switch (this.scanner.token) {
            case BYTEINDEX: 
            case SHORTINDEX: 
            case BYTES: 
            case ATTR: 
            case COMP: 
            case MACRO: 
            case FILE: 
            case IDENT: {
                if (prev == JcodTokens.Token.FILE) {
                    this.buf.myname = this.scanner.stringValue;
                    break;
                }
                this.buf.myname = this.scanner.stringValue + ".class";
                break;
            }
            case STRINGVAL: {
                this.buf.myname = this.scanner.stringValue;
                break;
            }
            default: {
                this.environment.error(this.scanner.prevPos, "err.name.expected", "\"" + this.scanner.token.parsekey() + "\"");
                throw new SyntaxError();
            }
        }
        this.scanner.scan();
        this.environment.traceln("starting class " + this.buf.myname, new Object[0]);
        this.parseClause();
        this.environment.traceln("ending class " + this.buf.myname, new Object[0]);
    }

    private void parseClause() throws IOException {
        switch (this.scanner.token) {
            case LBRACE: {
                this.parseStruct();
                break;
            }
            case LSQBRACKET: {
                this.parseArray();
                break;
            }
            case BYTES: {
                this.parseByteArray();
                break;
            }
            case ATTR: {
                this.parseAttr();
                break;
            }
            case COMP: {
                this.parseComp();
                break;
            }
            default: {
                this.environment.error(this.scanner.pos, "err.struct.expected", new Object[0]);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parseFile() {
        this.environment.traceln("PARSER", new Object[0]);
        this.context.init();
        if (this.scanner.token == JcodTokens.Token.EOF) {
            this.environment.error("err.file.empty", this.environment.getSimpleInputFileName());
            return;
        }
        try {
            block9: while (this.scanner.token != JcodTokens.Token.EOF) {
                try {
                    switch (this.scanner.token) {
                        case INTERFACE: 
                        case CLASS: 
                        case FILE: 
                        case MODULE: {
                            JcodTokens.Token t = this.scanner.token;
                            if (t == JcodTokens.Token.MODULE) {
                                this.parseModule();
                            } else {
                                this.parseClass(t);
                            }
                            this.Classes.add(this.buf);
                            continue block9;
                        }
                        case SEMICOLON: {
                            this.scanner.scan();
                            continue block9;
                        }
                        case EOF: {
                            return;
                        }
                    }
                    this.environment.traceln("unexpected token=" + this.scanner.token, new Object[0]);
                    this.environment.error(this.scanner.pos, "err.toplevel.expected", new Object[0]);
                    throw new SyntaxError();
                }
                catch (SyntaxError e) {
                    String msg = e.getMessage();
                    this.environment.traceln("SyntaxError " + (msg == null ? "" : msg), new Object[0]);
                    this.environment.printException(e);
                    this.recoverFile();
                }
            }
            return;
        }
        catch (IOException e) {
            this.environment.error(this.scanner.pos, "err.io.exception", this.environment.getSimpleInputFileName());
        }
    }

    public void write(ByteBuffer cls) throws IOException {
        String myname = cls.myname;
        if (myname == null) {
            this.environment.error("err.cannot.write", new Object[0]);
            return;
        }
        this.environment.traceln("writing " + myname, new Object[0]);
        BufferedOutputStream out = new BufferedOutputStream(this.environment.getToolOutput().getDataOutputStream());
        out.write(cls.data, 0, cls.length);
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write() throws IOException {
        for (ByteBuffer cls : this.Classes) {
            this.environment.getToolOutput().startClass(cls.myname, Optional.empty(), this.environment);
            this.write(cls);
            this.environment.getToolOutput().finishClass(cls.myname);
        }
    }

    public static class Context {
        Stack<ContextVal> stack = new Stack();
        private boolean hasCP;
        private boolean hasMethods;
        private boolean hasInterfaces;
        private boolean hasFields;

        Context() {
            this.init();
        }

        boolean isConstantPool() {
            return !this.stack.empty() && this.stack.peek().tag == ContextTag.CONSTANTPOOL;
        }

        public void init() {
            this.stack.removeAllElements();
            this.hasCP = false;
            this.hasMethods = false;
            this.hasInterfaces = false;
            this.hasFields = false;
        }

        void update() {
            if (this.stack.empty()) {
                this.stack.push(new ContextVal(ContextTag.CLASS));
                return;
            }
            ContextVal currentCtx = this.stack.peek();
            switch (currentCtx.tag) {
                case CLASS: {
                    if (!this.hasCP) {
                        this.stack.push(new ContextVal(ContextTag.CONSTANTPOOL));
                        this.hasCP = true;
                        break;
                    }
                    if (!this.hasInterfaces) {
                        this.stack.push(new ContextVal(ContextTag.INTERFACES));
                        this.hasInterfaces = true;
                        break;
                    }
                    if (!this.hasFields) {
                        this.stack.push(new ContextVal(ContextTag.FIELDS));
                        this.hasFields = true;
                        break;
                    }
                    if (!this.hasMethods) {
                        this.stack.push(new ContextVal(ContextTag.METHODS));
                        this.hasMethods = true;
                        break;
                    }
                    ++currentCtx.compCount;
                    this.stack.push(new ContextVal(ContextTag.ATTRIBUTE, currentCtx));
                    break;
                }
                case INTERFACES: {
                    ++currentCtx.compCount;
                    this.stack.push(new ContextVal(ContextTag.INTERFACE, currentCtx));
                    break;
                }
                case FIELDS: {
                    ++currentCtx.compCount;
                    this.stack.push(new ContextVal(ContextTag.FIELD, currentCtx));
                    break;
                }
                case METHODS: {
                    ++currentCtx.compCount;
                    this.stack.push(new ContextVal(ContextTag.METHOD, currentCtx));
                    break;
                }
                case FIELD: 
                case METHOD: 
                case ATTRIBUTE: {
                    ++currentCtx.compCount;
                    this.stack.push(new ContextVal(ContextTag.ATTRIBUTE, currentCtx));
                }
            }
        }

        void exit() {
            if (!this.stack.isEmpty()) {
                this.stack.pop();
            }
        }

        public String toString() {
            if (this.stack.isEmpty()) {
                return "";
            }
            ContextVal currentCtx = this.stack.peek();
            Object retval = currentCtx.tag.printval();
            switch (currentCtx.tag) {
                case FIELD: 
                case METHOD: 
                case ATTRIBUTE: 
                case INTERFACE: {
                    if (currentCtx.owner == null) break;
                    retval = (String)retval + "[" + currentCtx.owner.compCount + "]";
                }
            }
            return retval;
        }
    }

    private static class ContextVal {
        public ContextTag tag;
        int compCount;
        ContextVal owner;

        ContextVal(ContextTag tg) {
            this.tag = tg;
            this.compCount = 0;
            this.owner = null;
        }

        ContextVal(ContextTag tg, ContextVal ownr) {
            this.tag = tg;
            this.compCount = 0;
            this.owner = ownr;
        }
    }

    private static enum ContextTag {
        NULL(""),
        CLASS("Class"),
        CONSTANTPOOL("Constant-Pool"),
        INTERFACES("Interfaces"),
        INTERFACE("Interface"),
        METHODS("Methods"),
        METHOD("Method"),
        FIELDS("Fields"),
        FIELD("Field"),
        ATTRIBUTE("Attribute");

        private final String printValue;

        private ContextTag(String value) {
            this.printValue = value;
        }

        public String printval() {
            return this.printValue;
        }
    }
}

