/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdec;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Optional;
import org.openjdk.asmtools.Main;
import org.openjdk.asmtools.asmutils.StringUtils;
import org.openjdk.asmtools.common.DecompilerLogger;
import org.openjdk.asmtools.common.FormatError;
import org.openjdk.asmtools.common.outputs.ToolOutput;
import org.openjdk.asmtools.common.structure.ClassFileContext;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.common.structure.EModifier;
import org.openjdk.asmtools.common.structure.StackMap;
import org.openjdk.asmtools.jasm.ClassFileConst;
import org.openjdk.asmtools.jasm.TypeAnnotationTypes;
import org.openjdk.asmtools.jcoder.JcodTokens;
import org.openjdk.asmtools.jdec.JdecEnvironment;
import org.openjdk.asmtools.jdec.NestedByteArrayInputStream;

class ClassData {
    private static final int COMMENT_OFFSET = 32;
    private static final String INDENT_STRING = "  ";
    private static final int INDENT_LENGTH = "  ".length();
    private final NestedByteArrayInputStream arrayInputStream;
    private final DataInputStream inputStream;
    protected JdecEnvironment environment;
    private byte[] types;
    private Object[] cpool;
    private int CPlen;
    private int[] cpe_pos;
    private String entityType = "";
    private String entityName = "";
    private int indent = 0;

    ClassData(JdecEnvironment environment) throws IOException, URISyntaxException {
        this.environment = environment;
        try (DataInputStream dis = environment.getInputFile().getDataInputStream(Optional.empty());){
            byte[] buf = new byte[dis.available()];
            if (dis.read(buf) <= 0) {
                throw new FormatError((DecompilerLogger)environment.getLogger(), "err.file.empty", environment.getSimpleInputFileName());
            }
            this.arrayInputStream = new NestedByteArrayInputStream(buf);
            this.inputStream = new DataInputStream(this.arrayInputStream);
        }
    }

    private String toHex(long val, int width) {
        StringBuilder s = new StringBuilder();
        for (int i = width * 2 - 1; i >= 0; --i) {
            s.append(StringUtils.hexTable[(int)(val >> 4 * i) & 0xF]);
        }
        return "0x" + s;
    }

    private String toHex(long val) {
        int width;
        for (width = 8; width > 0 && val >> (width - 1) * 8 == 0L; --width) {
        }
        return this.toHex(val, width);
    }

    private void printByteHex(int b) {
        this.environment.print(StringUtils.hexTable[b >> 4 & 0xF]);
        this.environment.print(StringUtils.hexTable[b & 0xF]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printBytes(DataInputStream in, int len, boolean printSeparately) throws IOException {
        int i;
        int BYTES_IN_LINE = printSeparately ? 4 : 8;
        try {
            for (i = 0; i < len; ++i) {
                if (i % BYTES_IN_LINE == 0) {
                    this.out_print(printSeparately ? "" : "0x");
                }
                if (printSeparately) {
                    this.environment.print("0x", new Object[0]);
                }
                this.printByteHex(in.readByte());
                if (printSeparately) {
                    if (i % BYTES_IN_LINE == BYTES_IN_LINE - 1) {
                        this.environment.println(";", new Object[0]);
                        continue;
                    }
                    if (i + 1 == len) continue;
                    this.environment.print(" ", new Object[0]);
                    continue;
                }
                if (i % BYTES_IN_LINE != BYTES_IN_LINE - 1) continue;
                this.environment.println(";", new Object[0]);
            }
        }
        finally {
            if (len % 8 != 0) {
                if (i > 0) {
                    this.environment.println(";", new Object[0]);
                } else {
                    this.out_println(";");
                }
            }
        }
    }

    private void printUtf8String(DataInputStream in, int len) throws IOException {
        int CHARS_IN_LINE = 78;
        StringUtils.readUtf8String(in, len, 78).forEach(s -> this.environment.println(this.getOutString("") + s, new Object[0]));
    }

    private void printRestOfBytes() {
        int i = 0;
        while (true) {
            try {
                byte b = this.inputStream.readByte();
                if (i % 8 == 0) {
                    this.out_print("0x");
                }
                this.printByteHex(b);
                if (i % 8 == 7) {
                    this.environment.println(";", new Object[0]);
                }
            }
            catch (IOException e) {
                return;
            }
            ++i;
        }
    }

    private void printUtf8InfoIndex(int index, String indexName) {
        String name = (String)this.cpool[index];
        this.out_print("#" + index + "; // ");
        if (this.environment.printDetailsFlag) {
            this.environment.println(String.format("%-16s", indexName) + " : " + name, new Object[0]);
        } else {
            this.environment.println(indexName, new Object[0]);
        }
    }

    private void out_begin(String s) {
        this.environment.println(this.getOutString(s), new Object[0]);
        ++this.indent;
    }

    private void out_print(String s) {
        this.environment.print(this.getOutString(s), new Object[0]);
    }

    private void out_println(String s) {
        this.environment.println(this.getOutString(s), new Object[0]);
    }

    private String getOutString(String s) {
        s = this.formatComments(s, this.indent);
        return StringUtils.repeat(INDENT_STRING, this.indent) + s;
    }

    private void out_end(String s) {
        s = this.formatComments(s, this.indent - 1);
        this.environment.println(StringUtils.repeat(INDENT_STRING, --this.indent) + s, new Object[0]);
    }

    private String startArray(int length) {
        return "[" + (this.environment.printDetailsFlag ? Integer.toString(length) : "") + "]";
    }

    private void startArrayCmt(int length, String comment) {
        this.out_begin(this.startArray(length) + String.format(" {%s", comment == null ? "" : " // " + comment));
    }

    private void startArrayCmtB(int length, String comment) {
        this.out_begin(this.startArray(length) + String.format("b {%s", comment == null ? "" : " // " + comment));
    }

    private void readCP(DataInputStream in) throws IOException {
        int length;
        this.CPlen = length = in.readUnsignedShort();
        this.environment.traceln("jdec.trace.CP_len", length);
        this.types = new byte[length];
        this.cpool = new Object[length];
        this.cpe_pos = new int[length];
        block12: for (int i = 1; i < length; ++i) {
            this.cpe_pos[i] = this.arrayInputStream.getPos();
            byte btag = in.readByte();
            this.environment.traceln("jdec.trace.CP_entry", i, btag);
            this.types[i] = btag;
            ClassFileConst.ConstType tg = ClassFileConst.tag(btag);
            switch (tg) {
                case CONSTANT_UTF8: {
                    this.cpool[i] = in.readUTF();
                    continue block12;
                }
                case CONSTANT_INTEGER: {
                    int v1 = in.readInt();
                    this.cpool[i] = v1;
                    continue block12;
                }
                case CONSTANT_FLOAT: {
                    int v1 = Float.floatToIntBits(in.readFloat());
                    this.cpool[i] = v1;
                    continue block12;
                }
                case CONSTANT_LONG: {
                    long lv = in.readLong();
                    this.cpool[i] = lv;
                    ++i;
                    continue block12;
                }
                case CONSTANT_DOUBLE: {
                    long lv = Double.doubleToLongBits(in.readDouble());
                    this.cpool[i] = lv;
                    ++i;
                    continue block12;
                }
                case CONSTANT_CLASS: 
                case CONSTANT_STRING: 
                case CONSTANT_MODULE: 
                case CONSTANT_PACKAGE: {
                    int v1 = in.readUnsignedShort();
                    this.cpool[i] = v1;
                    continue block12;
                }
                case CONSTANT_INTERFACEMETHODREF: 
                case CONSTANT_FIELDREF: 
                case CONSTANT_METHODREF: 
                case CONSTANT_NAMEANDTYPE: {
                    this.cpool[i] = "#" + in.readUnsignedShort() + " #" + in.readUnsignedShort();
                    continue block12;
                }
                case CONSTANT_DYNAMIC: 
                case CONSTANT_INVOKEDYNAMIC: {
                    this.cpool[i] = in.readUnsignedShort() + "s #" + in.readUnsignedShort();
                    continue block12;
                }
                case CONSTANT_METHODHANDLE: {
                    this.cpool[i] = in.readUnsignedByte() + "b #" + in.readUnsignedShort();
                    continue block12;
                }
                case CONSTANT_METHODTYPE: {
                    this.cpool[i] = "#" + in.readUnsignedShort();
                    continue block12;
                }
                default: {
                    this.CPlen = i;
                    this.printCP();
                    this.out_println(this.toHex(btag, 1) + "; // invalid constant type: " + btag + " for element " + i);
                    throw new ClassFormatError();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printCP() {
        int length = this.CPlen;
        this.startArrayCmt(length, "Constant Pool");
        this.out_println("; // first element is empty");
        try {
            int size;
            for (int i = 1; i < length; i += size) {
                Object valstr;
                size = 1;
                byte btag = this.types[i];
                ClassFileConst.ConstType tg = ClassFileConst.tag(btag);
                int pos = this.cpe_pos[i];
                if (tg == null) {
                    throw new Error("Can't get a tg representing the type of Constant in the Constant Pool at: " + i);
                }
                String tagstr = tg.parseKey();
                switch (tg) {
                    case CONSTANT_UTF8: {
                        tagstr = "Utf8";
                        valstr = StringUtils.Utf8ToString((String)this.cpool[i], "\"");
                        break;
                    }
                    case CONSTANT_INTEGER: 
                    case CONSTANT_FLOAT: {
                        int v1 = (Integer)this.cpool[i];
                        valstr = this.toHex(v1, 4);
                        break;
                    }
                    case CONSTANT_LONG: 
                    case CONSTANT_DOUBLE: {
                        long lv = (Long)this.cpool[i];
                        valstr = this.toHex(lv, 8) + ";";
                        size = 2;
                        break;
                    }
                    case CONSTANT_CLASS: 
                    case CONSTANT_STRING: 
                    case CONSTANT_MODULE: 
                    case CONSTANT_PACKAGE: {
                        int v1 = (Integer)this.cpool[i];
                        valstr = "#" + v1;
                        break;
                    }
                    case CONSTANT_INTERFACEMETHODREF: 
                    case CONSTANT_FIELDREF: 
                    case CONSTANT_METHODREF: 
                    case CONSTANT_NAMEANDTYPE: 
                    case CONSTANT_DYNAMIC: 
                    case CONSTANT_INVOKEDYNAMIC: 
                    case CONSTANT_METHODHANDLE: 
                    case CONSTANT_METHODTYPE: {
                        valstr = (String)this.cpool[i];
                        break;
                    }
                    default: {
                        throw new Error("invalid constant type: " + btag);
                    }
                }
                this.out_print(tagstr + " " + (String)valstr + "; // #" + i);
                if (this.environment.printDetailsFlag) {
                    this.out_println(" at " + this.toHex(pos));
                    continue;
                }
                this.environment.println();
            }
            this.out_end("}" + (this.environment.printDetailsFlag ? " // end of Constant Pool" : ""));
            this.environment.println();
        }
        catch (Throwable throwable) {
            this.out_end("}" + (this.environment.printDetailsFlag ? " // end of Constant Pool" : ""));
            this.environment.println();
            throw throwable;
        }
    }

    private String getModuleName() {
        int idx = 0;
        String name = "";
        for (int i = 1; i < this.types.length; ++i) {
            if (this.types[i] != ClassFileConst.ConstType.CONSTANT_MODULE.getTag()) continue;
            idx = i;
            break;
        }
        if (idx != 0) {
            try {
                name = StringUtils.Utf8ToString((String)this.cpool[(Integer)this.cpool[idx]], new String[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return name;
    }

    private String getStringPos() {
        return " at " + this.toHex(this.arrayInputStream.getPos());
    }

    private String getCommentPosCond() {
        if (this.environment.printDetailsFlag) {
            return " // " + this.getStringPos();
        }
        return "";
    }

    private void decodeCPXAttr(DataInputStream in, int len, String attrname) throws IOException {
        this.decodeCPXAttrM(in, len, attrname, 1);
    }

    private void decodeCPXAttrM(DataInputStream in, int len, String attrName, int expectedIndices) throws IOException {
        if (len != expectedIndices * 2) {
            this.out_println("// == invalid length of " + attrName + " attr: " + len + " (should be " + expectedIndices * 2 + ") ==");
            this.printBytes(in, len, false);
        } else {
            StringBuilder outputString = new StringBuilder();
            for (int k = 1; k <= expectedIndices; ++k) {
                outputString.append("#").append(in.readUnsignedShort()).append("; ");
                if (k % 16 != 0) continue;
                this.out_println(outputString.toString().replaceAll("\\s+$", ""));
                outputString = new StringBuilder();
            }
            if (outputString.length() > 0) {
                this.out_println(outputString.toString().replaceAll("\\s+$", ""));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStackMap(DataInputStream in, int elementsNum) throws IOException {
        StringBuilder sb = new StringBuilder(20);
        int num = elementsNum > 0 ? elementsNum : in.readUnsignedShort();
        sb.append(this.startArray(num)).append(elementsNum > 0 ? "z" : "").append('{');
        try {
            for (int k = 0; k < num; ++k) {
                int maptype = in.readUnsignedByte();
                StackMap.VerificationType verificationType = StackMap.getVerificationType(maptype, Optional.of(s -> this.environment.printErrorLn((String)s, new Object[0])));
                if (this.environment.printDetailsFlag) {
                    maptypeImg = maptype + "b";
                } else {
                    try {
                        maptypeImg = verificationType.parseKey();
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        maptypeImg = "/* BAD TYPE: */ " + maptype + "b";
                    }
                }
                Object maptypeImg = switch (verificationType) {
                    case StackMap.VerificationType.ITEM_Object, StackMap.VerificationType.ITEM_NewObject -> (String)maptypeImg + "," + in.readUnsignedShort();
                    case StackMap.VerificationType.ITEM_UNKNOWN -> maptype + "b";
                };
                sb.append((String)maptypeImg);
                if (k >= num - 1) continue;
                sb.append("; ");
            }
        }
        finally {
            sb.append('}');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeTargetTypeAndRefInfo(DataInputStream in) throws IOException {
        int i;
        int tt = in.readUnsignedByte();
        TypeAnnotationTypes.ETargetType targetType = TypeAnnotationTypes.ETargetType.getTargetType(tt);
        if (targetType == null) {
            throw new Error("Type annotation: invalid target_type(u1) " + tt);
        }
        TypeAnnotationTypes.ETargetInfo targetInfo = targetType.targetInfo();
        this.out_println(this.toHex(tt, 1) + ";  //  target_type: " + targetType.parseKey());
        switch (targetInfo) {
            case TYPEPARAM: {
                this.out_println(this.toHex(in.readUnsignedByte(), 1) + ";  //  param_index");
                break;
            }
            case SUPERTYPE: {
                this.out_println(this.toHex(in.readUnsignedShort(), 2) + ";  //  type_index");
                break;
            }
            case TYPEPARAM_BOUND: {
                this.out_println(this.toHex(in.readUnsignedByte(), 1) + ";  //  param_index");
                this.out_println(this.toHex(in.readUnsignedByte(), 1) + ";  //  bound_index");
                break;
            }
            case EMPTY: {
                break;
            }
            case METHODPARAM: {
                this.out_println(this.toHex(in.readUnsignedByte(), 1) + ";  //  parameter_index");
                break;
            }
            case EXCEPTION: {
                this.out_println(in.readUnsignedShort() + ";  //  type_index");
                break;
            }
            case LOCALVAR: {
                int lv_num = in.readUnsignedShort();
                this.startArrayCmt(lv_num, "local_variables");
                try {
                    for (i = 0; i < lv_num; ++i) {
                        this.out_println(in.readUnsignedShort() + " " + in.readUnsignedShort() + " " + in.readUnsignedShort() + ";" + this.getCommentPosCond());
                    }
                    break;
                }
                finally {
                    this.out_end("}");
                }
            }
            case CATCH: {
                this.out_println(in.readUnsignedShort() + ";  //  exception_table_index");
                break;
            }
            case OFFSET: {
                this.out_println(in.readUnsignedShort() + ";  //  offset");
                break;
            }
            case TYPEARG: {
                this.out_println(in.readUnsignedShort() + ";  //  offset");
                this.out_println(this.toHex(in.readUnsignedByte(), 1) + ";  //  type_index");
                break;
            }
            default: {
                this.out_println(this.toHex(tt, 1) + "; // invalid target_info: " + tt);
                throw new ClassFormatError();
            }
        }
        int path_length = in.readUnsignedByte();
        this.startArrayCmtB(path_length, "type_paths");
        try {
            for (i = 0; i < path_length; ++i) {
                this.out_println("{ " + this.toHex(in.readUnsignedByte(), 1) + "; " + this.toHex(in.readUnsignedByte(), 1) + "; } // type_path[" + i + "]");
            }
        }
        finally {
            this.out_end("}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeElementValue(DataInputStream in, ToolOutput out) throws IOException {
        this.out_begin("{  //  element_value");
        try {
            char tg = (char)in.readByte();
            ClassFileConst.AnnotationElementType tag = ClassFileConst.getAnnotationElementType(tg);
            if (tag != ClassFileConst.AnnotationElementType.AE_UNKNOWN) {
                this.out_println("'" + tg + "';");
            }
            switch (tag) {
                case AE_BYTE: 
                case AE_CHAR: 
                case AE_DOUBLE: 
                case AE_FLOAT: 
                case AE_INT: 
                case AE_LONG: 
                case AE_SHORT: 
                case AE_BOOLEAN: 
                case AE_STRING: {
                    this.decodeCPXAttr(in, 2, "const_value_index");
                    return;
                }
                case AE_ENUM: {
                    this.out_begin("{  //  enum_const_value");
                    this.decodeCPXAttr(in, 2, "type_name_index");
                    this.decodeCPXAttr(in, 2, "const_name_index");
                    this.out_end("}  //  enum_const_value");
                    return;
                }
                case AE_CLASS: {
                    this.decodeCPXAttr(in, 2, "class_info_index");
                    return;
                }
                case AE_ANNOTATION: {
                    this.decodeAnnotation(in, out);
                    return;
                }
                case AE_ARRAY: {
                    int ev_num = in.readUnsignedShort();
                    this.startArrayCmt(ev_num, "array_value");
                    try {
                        int i = 0;
                        while (i < ev_num) {
                            this.decodeElementValue(in, out);
                            if (i < ev_num - 1) {
                                this.out_println(";");
                            }
                            ++i;
                        }
                        return;
                    }
                    finally {
                        this.out_end("}  //  array_value");
                    }
                }
                case AE_UNKNOWN: {
                    String msg = "invalid element_value" + (String)(this.isPrintableChar(tg) ? " tag type : " + tg : "??");
                    this.out_println(this.toHex(tg, 1) + "; // " + msg);
                    throw new ClassFormatError(msg);
                }
            }
            return;
        }
        finally {
            this.out_end("}  //  element_value");
        }
    }

    public boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeAnnotation(DataInputStream in, ToolOutput out) throws IOException {
        this.out_begin("{  //  annotation");
        try {
            this.decodeCPXAttr(in, 2, "field descriptor");
            int evp_num = in.readUnsignedShort();
            this.decodeElementValuePairs(evp_num, in, out);
        }
        finally {
            this.out_end("}  //  annotation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeElementValuePairs(int count, DataInputStream in, ToolOutput out) throws IOException {
        this.startArrayCmt(count, "element_value_pairs");
        try {
            for (int i = 0; i < count; ++i) {
                this.out_begin("{  //  element value pair");
                try {
                    this.decodeCPXAttr(in, 2, "name of the annotation type element");
                    this.decodeElementValue(in, out);
                    continue;
                }
                finally {
                    this.out_end("}  //  element value pair");
                    if (i < count - 1) {
                        this.out_println(";");
                    }
                }
            }
        }
        finally {
            this.out_end("}  //  element_value_pairs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeInfo(DataInputStream in, ToolOutput out, String elementName, boolean hasAccessFlag) throws IOException {
        this.out_begin("{  // " + elementName + (this.environment.printDetailsFlag ? this.getStringPos() : ""));
        try {
            if (hasAccessFlag) {
                this.out_println(this.toHex(in.readShort(), 2) + "; // access");
            }
            this.printUtf8InfoIndex(in.readUnsignedShort(), "name_index");
            this.printUtf8InfoIndex(in.readUnsignedShort(), "descriptor_index");
            this.decodeAttrs(in, out);
        }
        finally {
            this.out_end("}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeTypeAnnotation(DataInputStream in, ToolOutput out) throws IOException {
        this.out_begin("{  //  type_annotation");
        try {
            this.decodeTargetTypeAndRefInfo(in);
            this.decodeCPXAttr(in, 2, "field descriptor");
            int evp_num = in.readUnsignedShort();
            this.decodeElementValuePairs(evp_num, in, out);
        }
        finally {
            this.out_end("}  //  type_annotation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeBootstrapMethod(DataInputStream in) throws IOException {
        this.out_begin("{  //  bootstrap_method");
        try {
            this.out_println("#" + in.readUnsignedShort() + "; // bootstrap_method_ref");
            int bm_args_cnt = in.readUnsignedShort();
            this.startArrayCmt(bm_args_cnt, "bootstrap_arguments");
            try {
                for (int i = 0; i < bm_args_cnt; ++i) {
                    this.out_println("#" + in.readUnsignedShort() + ";" + this.getCommentPosCond());
                }
            }
            finally {
                this.out_end("}  //  bootstrap_arguments");
            }
        }
        finally {
            this.out_end("}  //  bootstrap_method");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decodeAttr(DataInputStream in, ToolOutput out) throws IOException {
        String posComment = this.getStringPos();
        int name_cpx = 0;
        String AttrName = "";
        try {
            name_cpx = in.readUnsignedShort();
            byte btag = this.types[name_cpx];
            ClassFileConst.ConstType tag = ClassFileConst.tag(btag);
            if (tag == ClassFileConst.ConstType.CONSTANT_UTF8) {
                AttrName = (String)this.cpool[name_cpx];
            }
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            this.environment.print(this.getOutString(""), new Object[0]);
            this.environment.println("// == %s ==", Main.sharedI18n.getString("main.error.wrong.bytes"));
        }
        EAttribute tg = EAttribute.get(AttrName);
        Object endingComment = AttrName.isEmpty() ? "#" + name_cpx : AttrName;
        int len = in.readInt();
        this.arrayInputStream.enter(len);
        try {
            if (this.environment.printDetailsFlag) {
                this.out_begin("Attr(#" + name_cpx + ", " + len + ") { // " + (String)endingComment + posComment);
            } else {
                this.out_begin("Attr(#" + name_cpx + ") { // " + (String)endingComment);
            }
            switch (tg) {
                case ATT_Code: {
                    this.out_println(in.readUnsignedShort() + "; // max_stack");
                    this.out_println(in.readUnsignedShort() + "; // max_locals");
                    int code_len = in.readInt();
                    this.out_begin("Bytes" + this.startArray(code_len) + "{");
                    try {
                        this.printBytes(in, code_len, false);
                    }
                    finally {
                        this.out_end("}");
                    }
                    int trap_num = in.readUnsignedShort();
                    this.startArrayCmt(trap_num, "Traps");
                    try {
                        for (int i = 0; i < trap_num; ++i) {
                            this.out_println(in.readUnsignedShort() + " " + in.readUnsignedShort() + " " + in.readUnsignedShort() + " " + in.readUnsignedShort() + ";" + this.getCommentPosCond());
                        }
                    }
                    finally {
                        this.out_end("} // end of Traps");
                    }
                    this.decodeAttrs(in, out);
                    return;
                }
                case ATT_Exceptions: {
                    int count = in.readUnsignedShort();
                    this.startArrayCmt(count, AttrName);
                    try {
                        for (int i = 0; i < count; ++i) {
                            this.out_println("#" + in.readUnsignedShort() + ";" + this.getCommentPosCond());
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_LineNumberTable: {
                    int ll_num = in.readUnsignedShort();
                    this.startArrayCmt(ll_num, "line_number_table");
                    try {
                        for (int i = 0; i < ll_num; ++i) {
                            this.out_println(in.readUnsignedShort() + INDENT_STRING + in.readUnsignedShort() + ";" + this.getCommentPosCond());
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_LocalVariableTable: 
                case ATT_LocalVariableTypeTable: {
                    int lvt_num = in.readUnsignedShort();
                    this.startArrayCmt(lvt_num, AttrName);
                    try {
                        for (int i = 0; i < lvt_num; ++i) {
                            this.out_println(in.readUnsignedShort() + " " + in.readUnsignedShort() + " " + in.readUnsignedShort() + " " + in.readUnsignedShort() + " " + in.readUnsignedShort() + ";" + this.getCommentPosCond());
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_InnerClasses: {
                    int ic_num = in.readUnsignedShort();
                    this.startArrayCmt(ic_num, "classes");
                    try {
                        for (int i = 0; i < ic_num; ++i) {
                            this.out_println("#" + in.readUnsignedShort() + " #" + in.readUnsignedShort() + " #" + in.readUnsignedShort() + " " + in.readUnsignedShort() + ";" + this.getCommentPosCond());
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_StackMap: {
                    int e_num = in.readUnsignedShort();
                    this.startArrayCmt(e_num, "");
                    try {
                        for (int k = 0; k < e_num; ++k) {
                            int start_pc = in.readUnsignedShort();
                            this.environment.println(String.format("%d, %s, %s;", start_pc, this.getStackMap(in, 0), this.getStackMap(in, 0)), new Object[0]);
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_StackMapTable: {
                    int et_num = in.readUnsignedShort();
                    this.startArrayCmt(et_num, "");
                    try {
                        block97: for (int k = 0; k < et_num; ++k) {
                            int frame_type = in.readUnsignedByte();
                            StackMap.FrameType ftype = StackMap.stackMapFrameType(frame_type);
                            switch (ftype) {
                                case SAME_FRAME: {
                                    this.out_println(frame_type + "b; // same_frame");
                                    continue block97;
                                }
                                case SAME_LOCALS_1_STACK_ITEM_FRAME: {
                                    this.out_println(String.format("%db, %s; // same_locals_1_stack_item_frame", frame_type, this.getStackMap(in, 1)));
                                    continue block97;
                                }
                                case SAME_LOCALS_1_STACK_ITEM_EXTENDED_FRAME: {
                                    int noffset = in.readUnsignedShort();
                                    this.out_println(String.format("%db, %d, %s; // same_locals_1_stack_item_frame_extended", frame_type, noffset, this.getStackMap(in, 1)));
                                    continue block97;
                                }
                                case CHOP_1_FRAME: 
                                case CHOP_2_FRAME: 
                                case CHOP_3_FRAME: {
                                    int coffset = in.readUnsignedShort();
                                    this.out_println(String.format("%db, %d; // chop_frame %d", frame_type, coffset, 251 - frame_type));
                                    continue block97;
                                }
                                case SAME_FRAME_EX: {
                                    int xoffset = in.readUnsignedShort();
                                    this.out_println(String.format("%db, %d; // same_frame_extended", frame_type, xoffset));
                                    continue block97;
                                }
                                case APPEND_FRAME: {
                                    int aoffset = in.readUnsignedShort();
                                    this.out_println(String.format("%db, %d, %s; // append_frame %d", frame_type, aoffset, this.getStackMap(in, frame_type - 251), frame_type - 251));
                                    continue block97;
                                }
                                case FULL_FRAME: {
                                    int foffset = in.readUnsignedShort();
                                    this.out_println(String.format("%db, %d, %s, %s; // full_frame", frame_type, foffset, this.getStackMap(in, 0), this.getStackMap(in, 0)));
                                }
                            }
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_EnclosingMethod: {
                    this.decodeCPXAttrM(in, len, AttrName, 2);
                    return;
                }
                case ATT_AnnotationDefault: {
                    this.decodeElementValue(in, out);
                    return;
                }
                case ATT_RuntimeInvisibleAnnotations: 
                case ATT_RuntimeVisibleAnnotations: {
                    int an_num = in.readUnsignedShort();
                    this.startArrayCmt(an_num, "annotations");
                    try {
                        for (int i = 0; i < an_num; ++i) {
                            this.decodeAnnotation(in, out);
                            if (i >= an_num - 1) continue;
                            this.out_println(";");
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_RuntimeInvisibleTypeAnnotations: 
                case ATT_RuntimeVisibleTypeAnnotations: {
                    int ant_num = in.readUnsignedShort();
                    this.startArrayCmt(ant_num, "annotations");
                    try {
                        for (int i = 0; i < ant_num; ++i) {
                            this.decodeTypeAnnotation(in, out);
                            if (i >= ant_num - 1) continue;
                            this.out_println(";");
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_RuntimeInvisibleParameterAnnotations: 
                case ATT_RuntimeVisibleParameterAnnotations: {
                    int pm_num = in.readUnsignedByte();
                    this.startArrayCmtB(pm_num, "parameters");
                    try {
                        for (int k = 0; k < pm_num; ++k) {
                            int anp_num = in.readUnsignedShort();
                            this.startArrayCmt(anp_num, "annotations");
                            try {
                                for (int i = 0; i < anp_num; ++i) {
                                    this.decodeAnnotation(in, out);
                                    if (k >= anp_num - 1) continue;
                                    this.out_println(";");
                                }
                            }
                            finally {
                                this.out_end("}");
                            }
                            if (k >= pm_num - 1) continue;
                            this.out_println(";");
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_BootstrapMethods: {
                    int bm_num = in.readUnsignedShort();
                    this.startArrayCmt(bm_num, "bootstrap_methods");
                    try {
                        for (int i = 0; i < bm_num; ++i) {
                            this.decodeBootstrapMethod(in);
                            if (i >= bm_num - 1) continue;
                            this.out_println(";");
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_Module: {
                    this.decodeModule(in);
                    return;
                }
                case ATT_TargetPlatform: {
                    this.decodeCPXAttrM(in, len, AttrName, 3);
                    return;
                }
                case ATT_ModulePackages: {
                    int p_num = in.readUnsignedShort();
                    this.startArrayCmt(p_num, null);
                    try {
                        this.decodeCPXAttrM(in, len - 2, AttrName, p_num);
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_MethodParameters: {
                    int pcount = in.readUnsignedByte();
                    this.startArrayCmtB(pcount, AttrName);
                    try {
                        for (int i = 0; i < pcount; ++i) {
                            this.out_println("#" + in.readUnsignedShort() + INDENT_STRING + this.toHex(in.readUnsignedShort(), 2) + ";" + this.getCommentPosCond());
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_Record: {
                    int ncomps = in.readUnsignedShort();
                    this.startArrayCmt(ncomps, "components");
                    try {
                        for (int i = 0; i < ncomps; ++i) {
                            this.decodeInfo(in, out, "component", false);
                            if (i >= ncomps - 1) continue;
                            this.out_println(";");
                        }
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_ConstantValue: 
                case ATT_Signature: 
                case ATT_SourceFile: {
                    this.decodeCPXAttr(in, len, AttrName);
                    return;
                }
                case ATT_NestHost: {
                    this.decodeTypes(in, 1);
                    return;
                }
                case ATT_NestMembers: 
                case ATT_PermittedSubclasses: 
                case ATT_Preload: {
                    int nsubtypes = in.readUnsignedShort();
                    this.startArrayCmt(nsubtypes, "classes");
                    try {
                        this.decodeTypes(in, nsubtypes);
                        return;
                    }
                    finally {
                        this.out_end("}");
                    }
                }
                case ATT_SourceDebugExtension: {
                    this.printUtf8String(in, len);
                    if (AttrName != null) return;
                    endingComment = "Attr(#" + name_cpx + ")";
                    return;
                }
                default: {
                    this.printBytes(in, len, true);
                    if (AttrName != null) return;
                    endingComment = "Attr(#" + name_cpx + ")";
                    return;
                }
            }
        }
        catch (EOFException e) {
            this.environment.println(this.getOutString("") + "// == The unexpected end of attribute array while parsing. ==", new Object[0]);
            return;
        }
        finally {
            int rest = this.arrayInputStream.available();
            if (rest > 0) {
                this.environment.println(this.getOutString("") + "// == The attribute array started at" + posComment + " has " + rest + " bytes more than expected. ==", new Object[0]);
                this.printBytes(in, rest, true);
            }
            this.out_end("} // end of " + (String)endingComment);
            this.arrayInputStream.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeModuleStatement(String statementName, DataInputStream in) throws IOException {
        int count = in.readUnsignedShort();
        this.startArrayCmt(count, statementName);
        try {
            for (int i = 0; i < count; ++i) {
                int index = in.readUnsignedShort();
                int nFlags = in.readUnsignedShort();
                String sComment = this.environment.printDetailsFlag ? String.format(" // [ %s ]", EModifier.asNames(nFlags, ClassFileContext.MODULE_DIRECTIVES)) : "";
                this.out_println(String.format("#%d %s%s", index, this.toHex(nFlags, 2), sComment));
                int exports_to_count = in.readUnsignedShort();
                this.startArrayCmt(exports_to_count, null);
                try {
                    for (int j = 0; j < exports_to_count; ++j) {
                        this.out_println("#" + in.readUnsignedShort() + ";");
                    }
                    continue;
                }
                finally {
                    this.out_end("};");
                }
            }
        }
        finally {
            this.out_end("} // of " + statementName);
            this.environment.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeModule(DataInputStream in) throws IOException {
        int i;
        int index = in.readUnsignedShort();
        this.entityName = (String)this.cpool[(Integer)this.cpool[index]];
        this.out_print("#" + index + "; // ");
        if (this.environment.printDetailsFlag) {
            this.environment.println(String.format("%-16s", "name_index") + " : " + this.entityName, new Object[0]);
        } else {
            this.environment.println("name_index", new Object[0]);
        }
        int moduleFlags = in.readUnsignedShort();
        this.out_println(String.format("%s; //flags%s", this.toHex(moduleFlags, 2), this.environment.printDetailsFlag ? EModifier.asNames(moduleFlags, ClassFileContext.MODULE_DIRECTIVES) + " " : ""));
        this.environment.println();
        int versionIndex = in.readUnsignedShort();
        this.out_println("#" + versionIndex + "; // version");
        int count = in.readUnsignedShort();
        this.startArrayCmt(count, "requires");
        try {
            for (i = 0; i < count; ++i) {
                index = in.readUnsignedShort();
                int nFlags = in.readUnsignedShort();
                versionIndex = in.readUnsignedShort();
                String sComment = this.environment.printDetailsFlag ? String.format(" // %s", EModifier.asNames(nFlags, ClassFileContext.MODULE_DIRECTIVES)) : "";
                this.out_println(String.format("#%d %s #%d;%s", index, this.toHex(nFlags, 2), versionIndex, sComment));
            }
        }
        finally {
            this.out_end("} // end of requires");
            this.environment.println();
        }
        this.decodeModuleStatement("exports", in);
        this.decodeModuleStatement("opens", in);
        count = in.readUnsignedShort();
        this.startArrayCmt(count, "uses");
        try {
            for (i = 0; i < count; ++i) {
                this.out_println("#" + in.readUnsignedShort() + ";");
            }
        }
        finally {
            this.out_end("} // end of uses");
            this.environment.println();
        }
        count = in.readUnsignedShort();
        this.startArrayCmt(count, "provides");
        try {
            for (i = 0; i < count; ++i) {
                this.out_println("#" + in.readUnsignedShort());
                int provides_with_count = in.readUnsignedShort();
                this.startArrayCmt(provides_with_count, null);
                try {
                    for (int j = 0; j < provides_with_count; ++j) {
                        this.out_println("#" + in.readUnsignedShort() + ";");
                    }
                    continue;
                }
                finally {
                    this.out_end("};");
                }
            }
        }
        finally {
            this.out_end("} // end of provides");
            this.environment.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeAttrs(DataInputStream in, ToolOutput out) throws IOException {
        int attr_num = in.readUnsignedShort();
        this.startArrayCmt(attr_num, "Attributes");
        try {
            for (int i = 0; i < attr_num; ++i) {
                this.decodeAttr(in, out);
                if (i + 1 >= attr_num) continue;
                this.out_println(";");
            }
        }
        finally {
            this.out_end("} // end of Attributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeMembers(DataInputStream in, ToolOutput out, String groupName, String elementName) throws IOException {
        int count = in.readUnsignedShort();
        this.environment.traceln(groupName + "=" + count, new Object[0]);
        this.startArrayCmt(count, groupName);
        try {
            for (int i = 0; i < count; ++i) {
                this.decodeInfo(in, out, elementName, true);
                if (i + 1 >= count) continue;
                this.out_println(";");
            }
        }
        finally {
            this.out_end("} // end of " + groupName);
            this.environment.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decodeClass() throws IOException {
        block23: {
            block21: {
                try {
                    int magic = this.inputStream.readInt();
                    int min_version = this.inputStream.readUnsignedShort();
                    int version = this.inputStream.readUnsignedShort();
                    this.readCP(this.inputStream);
                    short access = this.inputStream.readShort();
                    int this_cpx = this.inputStream.readUnsignedShort();
                    try {
                        this.entityName = (String)this.cpool[(Integer)this.cpool[this_cpx]];
                        this.environment.getToolOutput().startClass(this.entityName, Optional.of(".jcod"), this.environment);
                        if (this.entityName.equals("module-info")) {
                            this.entityType = "module";
                            this.entityName = this.getModuleName();
                        } else {
                            this.entityType = "class";
                        }
                        if (!(this.entityName.isEmpty() || JcodTokens.keyword_token_ident(this.entityName) == JcodTokens.Token.IDENT && JcodTokens.constValue(this.entityName) == -1)) {
                            this.out_begin(String.format("file \"%s.class\" {", this.entityName));
                        } else {
                            this.out_begin(String.format("%s %s {", this.entityType, this.entityName));
                        }
                    }
                    catch (Exception e) {
                        this.entityName = this.environment.getInputFile().getFileName();
                        this.environment.println("// " + e.getMessage() + " while accessing entityName", new Object[0]);
                        this.out_begin(String.format("%s %s { // source file name", this.entityType, this.entityName));
                    }
                    if (magic != -889275714) {
                        this.out_println(this.toHex(magic, 4) + "; // wrong magic: 0x" + Integer.toString(-889275714, 16) + " expected");
                    } else {
                        this.out_println(this.toHex(magic, 4) + ";");
                    }
                    this.out_println(min_version + "; // minor version");
                    this.out_println(version + "; // version");
                    this.printCP();
                    this.out_println(this.toHex(access, 2) + "; // access" + (String)(this.environment.printDetailsFlag ? " [ " + EModifier.asNames(access, ClassFileContext.CLASS) + " ]" : ""));
                    this.out_println("#" + this_cpx + "; // this_cpx");
                    int super_cpx = this.inputStream.readUnsignedShort();
                    this.out_println("#" + super_cpx + "; // super_cpx");
                    this.environment.traceln("jdec.trace.access_thisCpx_superCpx", access, this_cpx, super_cpx);
                    this.environment.println();
                    int numinterfaces = this.inputStream.readUnsignedShort();
                    this.environment.traceln("jdec.trace.numinterfaces", numinterfaces);
                    this.startArrayCmt(numinterfaces, "Interfaces");
                    try {
                        this.decodeTypes(this.inputStream, numinterfaces);
                    }
                    finally {
                        this.out_end("} // end of Interfaces");
                        this.environment.println();
                    }
                    this.decodeMembers(this.inputStream, this.environment.getToolOutput(), "Fields", "field");
                    this.decodeMembers(this.inputStream, this.environment.getToolOutput(), "Methods", "method");
                    this.decodeAttrs(this.inputStream, this.environment.getToolOutput());
                    if (!this.environment.printDetailsFlag) break block21;
                }
                catch (EOFException magic) {
                    if (this.environment.printDetailsFlag) {
                        this.out_end(String.format("} // end of %s %s", this.entityType, this.entityName));
                    } else {
                        this.out_end("}");
                    }
                    this.environment.getToolOutput().finishClass(this.entityName);
                }
                catch (ClassFormatError err) {
                    block25: {
                        block22: {
                            try {
                                String msg = err.getMessage();
                                this.environment.println("//------- ClassFormatError" + (String)(msg == null || msg.isEmpty() ? "" : ": " + msg), new Object[0]);
                                this.printRestOfBytes();
                                if (!this.environment.printDetailsFlag) break block22;
                            }
                            catch (Throwable throwable) {
                                if (this.environment.printDetailsFlag) {
                                    this.out_end(String.format("} // end of %s %s", this.entityType, this.entityName));
                                } else {
                                    this.out_end("}");
                                }
                                this.environment.getToolOutput().finishClass(this.entityName);
                                throw throwable;
                            }
                            this.out_end(String.format("} // end of %s %s", this.entityType, this.entityName));
                            break block25;
                        }
                        this.out_end("}");
                    }
                    this.environment.getToolOutput().finishClass(this.entityName);
                }
                this.out_end(String.format("} // end of %s %s", this.entityType, this.entityName));
                break block23;
            }
            this.out_end("}");
        }
        this.environment.getToolOutput().finishClass(this.entityName);
    }

    private void decodeTypes(DataInputStream in, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            int type_cpx = in.readUnsignedShort();
            this.environment.traceln("jdec.trace.type", i, type_cpx);
            String s = "#" + type_cpx + ";";
            if (this.environment.printDetailsFlag) {
                String name = (String)this.cpool[(Integer)this.cpool[type_cpx]];
                this.out_println(s + " // " + name + this.getStringPos());
                continue;
            }
            this.environment.println(s, new Object[0]);
        }
    }

    private String formatComments(String s, int shift) {
        String[] pair = s.split("//");
        if (pair.length != 2) {
            return s;
        }
        pair[0] = pair[0].trim();
        pair[1] = pair[1].trim();
        return pair[0] + StringUtils.repeat(" ", 32 - pair[0].length() - shift * INDENT_LENGTH) + " // " + pair[1];
    }
}

