/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdec;

import org.openjdk.asmtools.common.DecompilerLogger;
import org.openjdk.asmtools.common.Environment;
import org.openjdk.asmtools.common.outputs.ToolOutput;
import org.openjdk.asmtools.common.outputs.log.DualStreamToolOutput;

public class JdecEnvironment
extends Environment<DecompilerLogger> {
    protected boolean printDetailsFlag;
    private final ToolOutput toolOutput;

    private JdecEnvironment(Environment.Builder<JdecEnvironment, DecompilerLogger> builder) {
        super(builder);
        this.toolOutput = builder.toolOutput;
    }

    @Override
    public void printErrorLn(String format, Object ... args) {
        ((DecompilerLogger)this.getLogger()).printErrorLn(format, args);
    }

    public Environment setPrintDetailsFlag(boolean value) {
        this.printDetailsFlag = value;
        return this;
    }

    @Override
    public void println(String format, Object ... args) {
        this.getToolOutput().printlns(args == null || args.length == 0 ? format : String.format(format, args));
    }

    @Override
    public void println() {
        this.getToolOutput().printlns("");
    }

    @Override
    public void print(String format, Object ... args) {
        this.getToolOutput().prints(args == null || args.length == 0 ? format : String.format(format, args));
    }

    @Override
    public void print(char ch) {
        this.getToolOutput().prints(ch);
    }

    static class JDecBuilder
    extends Environment.Builder<JdecEnvironment, DecompilerLogger> {
        public JDecBuilder(ToolOutput toolOutput, DualStreamToolOutput log) {
            super(toolOutput, new DecompilerLogger("jdec", JdecEnvironment.class, log));
        }

        @Override
        public JdecEnvironment build() {
            return new JdecEnvironment((Environment.Builder<JdecEnvironment, DecompilerLogger>)this);
        }
    }
}

