/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdec;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.openjdk.asmtools.common.inputs.FileInput;
import org.openjdk.asmtools.common.inputs.ToolInput;
import org.openjdk.asmtools.common.outputs.EscapedPrintStreamOutput;
import org.openjdk.asmtools.common.outputs.StdoutOutput;
import org.openjdk.asmtools.common.outputs.ToolOutput;
import org.openjdk.asmtools.common.outputs.log.DualOutputStreamOutput;
import org.openjdk.asmtools.common.outputs.log.DualStreamToolOutput;
import org.openjdk.asmtools.common.outputs.log.StderrLog;
import org.openjdk.asmtools.jdec.ClassData;
import org.openjdk.asmtools.jdec.JdecEnvironment;
import org.openjdk.asmtools.jdec.JdecTool;
import org.openjdk.asmtools.util.ProductInfo;

public class Main
extends JdecTool {
    public Main(ToolOutput toolOutput, DualStreamToolOutput log, ToolInput ... toolInputs) {
        super(toolOutput, log);
        Collections.addAll(this.fileList, toolInputs);
    }

    public Main(ToolOutput toolOutput, DualStreamToolOutput log, ToolInput toolInput, String ... argv) {
        super(toolOutput, log);
        if (toolInput != null) {
            this.fileList.add(toolInput);
        }
        this.parseArgs(argv);
    }

    public Main(ToolOutput toolOutput, DualStreamToolOutput log, String ... argv) {
        this(toolOutput, log, (ToolInput)null, argv);
    }

    public Main(EscapedPrintStreamOutput toolOutput, String[] argv) {
        this((ToolOutput)toolOutput, (DualStreamToolOutput)new StderrLog(), argv);
    }

    public Main(ToolOutput toolOutput, DualStreamToolOutput log, ToolInput toolInput) {
        super(toolOutput, log);
        this.fileList.add(toolInput);
    }

    public static void main(String ... argv) {
        Main decoder = new Main(new StdoutOutput(), argv);
        System.exit(decoder.decode());
    }

    @Override
    public void usage() {
        ((JdecEnvironment)this.environment).usage(List.of("info.usage", "info.opt.d", "info.opt.g", "info.opt.v", "info.opt.version"));
    }

    @Override
    protected void parseArgs(String ... argv) {
        block21: for (int i = 0; i < argv.length; ++i) {
            String arg;
            switch (arg = argv[i]) {
                case "-g": {
                    this.setPrintDetails(true);
                    continue block21;
                }
                case "-v": {
                    ((JdecEnvironment)this.environment).setVerboseFlag(true);
                    continue block21;
                }
                case "-t": {
                    ((JdecEnvironment)this.environment).setVerboseFlag(true);
                    ((JdecEnvironment)this.environment).setTraceFlag(true);
                    continue block21;
                }
                case "-d": {
                    this.setDestDir(++i, argv);
                    continue block21;
                }
                case "-dls": {
                    ((JdecEnvironment)this.environment).setOutputs(new DualOutputStreamOutput());
                    continue block21;
                }
                case "-version": {
                    ((JdecEnvironment)this.environment).println(ProductInfo.FULL_VERSION, new Object[0]);
                    System.exit(0);
                }
                case "-h": 
                case "-help": {
                    this.usage();
                    System.exit(0);
                }
                case "-": {
                    this.addStdIn();
                    continue block21;
                }
                default: {
                    if (arg.startsWith("-")) {
                        ((JdecEnvironment)this.environment).error("err.invalid_option", arg);
                        this.usage();
                        System.exit(1);
                        continue block21;
                    }
                    this.fileList.add(new FileInput(arg));
                }
            }
        }
        if (this.fileList.isEmpty()) {
            this.usage();
            System.exit(1);
        }
    }

    public void setPrintDetails(boolean value) {
        ((JdecEnvironment)this.environment).setPrintDetailsFlag(value);
    }

    public synchronized boolean decode(String ... argv) {
        this.parseArgs(argv);
        return this.decode() == 0;
    }

    public synchronized int decode() {
        for (ToolInput inputFileName : this.fileList) {
            try {
                ((JdecEnvironment)this.environment).setInputFile(inputFileName);
                ClassData classData = new ClassData((JdecEnvironment)this.environment);
                classData.decodeClass();
                continue;
            }
            catch (FileNotFoundException fnf) {
                ((JdecEnvironment)this.environment).printException(fnf);
                ((JdecEnvironment)this.environment).error("err.not_found", inputFileName);
            }
            catch (IOException | ClassFormatError ioe) {
                ((JdecEnvironment)this.environment).printException(ioe);
                if (!((JdecEnvironment)this.environment).getVerboseFlag()) {
                    ((JdecEnvironment)this.environment).printErrorLn(ioe.getMessage(), new Object[0]);
                }
                ((JdecEnvironment)this.environment).error("err.fatal_error", inputFileName);
            }
            catch (Error error) {
                ((JdecEnvironment)this.environment).printException(error);
                ((JdecEnvironment)this.environment).error("err.fatal_error", inputFileName);
            }
            catch (Exception ex) {
                ((JdecEnvironment)this.environment).printException(ex);
                ((JdecEnvironment)this.environment).error("err.fatal_exception", inputFileName);
            }
            return 1;
        }
        return 0;
    }
}

