/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.openjdk.asmtools.jdis.AnnotationElement;
import org.openjdk.asmtools.jdis.MemberData;

public class AnnotationData<T extends MemberData>
extends MemberData {
    protected String visibleAnnotationToken = "@+";
    protected String invisibleAnnotationToken = "@-";
    protected String dataName = "AnnotationData";
    private final ArrayList<AnnotationElement> annotationElements = new ArrayList();
    private int type_cpx = 0;
    private final boolean invisible;

    public <T extends MemberData> AnnotationData(T data, boolean invisible) {
        super(data);
        this.invisible = invisible;
    }

    public void read(DataInputStream in) throws IOException {
        this.type_cpx = in.readShort();
        int elemValueLength = in.readShort();
        for (int i = 0; i < elemValueLength; ++i) {
            AnnotationElement<MemberData> elem = new AnnotationElement<MemberData>(this.data);
            elem.read(in, this.invisible);
            this.annotationElements.add(elem);
        }
    }

    @Override
    public void print() throws IOException {
        this.printHeader();
        this.printBody();
    }

    protected void printHeader() {
        String annotationName = this.pool.getString(this.type_cpx, index -> "#" + index);
        if ((annotationName.startsWith("L") || annotationName.startsWith("Q")) && annotationName.endsWith(";")) {
            annotationName = annotationName.substring(1, annotationName.length() - 1);
        }
        switch (this.getAnnotationElementState()) {
            case HAS_DEFAULT_VALUE: {
                this.print("default { ").print(this.invisible ? this.invisibleAnnotationToken : this.visibleAnnotationToken).print(annotationName);
                this.setCommentOffset(this.getCommentOffset() + "default { ".length());
                break;
            }
            case PARAMETER_ANNOTATION: 
            case INLINED_ELEMENT: {
                this.print(this.invisible ? this.invisibleAnnotationToken : this.visibleAnnotationToken).print(annotationName);
                break;
            }
            default: {
                this.printIndent(this.invisible ? this.invisibleAnnotationToken : this.visibleAnnotationToken).print(annotationName);
            }
        }
    }

    protected void printBody() throws IOException {
        if (this.isEmpty()) {
            this.print(" { }");
        } else {
            switch (this.getAnnotationElementState()) {
                case HAS_DEFAULT_VALUE: {
                    this.println(" {");
                    this.printBodyOfDefaultData();
                    this.print(" }");
                    break;
                }
                case INLINED_ELEMENT: {
                    this.incIndent().printIndentLn("{");
                    this.printBodyOfData();
                    this.printIndent("}").decIndent();
                    break;
                }
                default: {
                    this.println("{");
                    this.printBodyOfData();
                    this.printIndent("}");
                }
            }
        }
    }

    protected void printBodyOfDefaultData() throws IOException {
        int prefixLength = this.getCommentOffset();
        for (AnnotationElement annotationElement : this.annotationElements) {
            this.print(this.enlargedIndent(prefixLength));
            annotationElement.setElementState(MemberData.AnnotationElementState.RIGHT_OPERAND);
            annotationElement.print();
        }
    }

    protected void printBodyOfData() throws IOException {
        int i = 0;
        for (AnnotationElement annotationElement : this.annotationElements) {
            annotationElement.setCommentOffset(this.getCommentOffset()).setTheSame(this).incIndent();
            annotationElement.print();
            this.println(i++ < this.annotationElements.size() - 1 ? "," : "");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String annotationName = this.pool.getString(this.type_cpx, index -> "#" + index);
        if ((annotationName.startsWith("L") || annotationName.startsWith("Q")) && annotationName.endsWith(";")) {
            annotationName = annotationName.substring(1, annotationName.length() - 1);
        }
        sb.append(this.invisible ? this.invisibleAnnotationToken : this.visibleAnnotationToken);
        sb.append(annotationName).append("{");
        sb.append(this.annotationElements.stream().map(AnnotationElement::toString).collect(Collectors.joining(",")));
        return sb.append("}").toString();
    }

    public boolean isEmpty() {
        return this.annotationElements.isEmpty();
    }
}

