/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import org.openjdk.asmtools.jdis.JdisEnvironment;

public class AttrData {
    private boolean corrupted = false;
    private int name_cpx;
    private int length;
    private byte[] data;
    final JdisEnvironment environment;

    public AttrData(JdisEnvironment environment) {
        this.environment = environment;
    }

    public void read(int name_cpx, int attrLength, DataInputStream in) throws IOException {
        this.name_cpx = name_cpx;
        this.length = attrLength;
        try {
            this.data = new byte[attrLength];
            in.readFully(this.data);
            this.environment.traceln("AttrData:#%d length=%d", name_cpx, attrLength);
        }
        catch (ArrayIndexOutOfBoundsException | NegativeArraySizeException ex) {
            this.corrupted = true;
            this.environment.traceln("Corrupted AttrData:#%d length=%d", name_cpx, attrLength);
        }
    }

    public boolean isCorrupted() {
        return this.corrupted;
    }

    public AttrData setNameCpx(int name_cpx) {
        this.name_cpx = name_cpx;
        return this;
    }

    public AttrData setLength(int length) {
        this.length = length;
        return this;
    }

    public int getNameCpx() {
        return this.name_cpx;
    }

    public int getLength() {
        return this.length;
    }
}

