/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.Indenter;

public class BootstrapMethodData
extends Indenter {
    int bsmRef;
    ArrayList<Integer> bsmArguments;
    int numBsmArgs;

    public BootstrapMethodData(ClassData cls) {
        super(cls.toolOutput);
    }

    @Override
    public boolean isPrintable() {
        return this.printCPIndex && this.bsmArguments != null && !this.bsmArguments.isEmpty();
    }

    @Override
    public Indenter setCommentOffset(int commentOffset) {
        return this;
    }

    public void read(DataInputStream in) throws IOException {
        this.bsmRef = in.readUnsignedShort();
        this.numBsmArgs = in.readUnsignedShort();
        this.bsmArguments = new ArrayList(this.numBsmArgs);
        for (int i = 0; i < this.numBsmArgs; ++i) {
            this.bsmArguments.add(in.readUnsignedShort());
        }
    }

    @Override
    public void print() throws IOException {
        this.printIndent(JasmTokens.Token.BOOTSTRAPMETHOD.parseKey() + " #" + this.bsmRef);
        for (int i = 0; i < this.numBsmArgs; ++i) {
            this.print(" #" + this.bsmArguments.get(i));
        }
        this.println(";");
    }
}

